/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;

public class ZipInputStream
extends InputStream {
    private BaseInputStream is;

    public ZipInputStream(BaseInputStream baseInputStream) {
        this.is = baseInputStream;
    }

    @Override
    public int read() throws IOException {
        int n = this.is.read();
        if (n != -1) {
            this.is.getUnzipEngine().updateCRC(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 > 0 && this.is.getUnzipEngine() != null) {
            this.is.getUnzipEngine().updateCRC(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean bl) throws IOException {
        try {
            this.is.close();
            if (!bl && this.is.getUnzipEngine() != null) {
                this.is.getUnzipEngine().checkCRC();
            }
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }
}

