/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.Unzip;
import net.lingala.zip4j.util.Zip4jUtil;

public class FileHeader {
    private int signature;
    private int versionMadeBy;
    private int versionNeededToExtract;
    private byte[] generalPurposeFlag;
    private int compressionMethod;
    private int lastModFileTime;
    private long crc32 = 0L;
    private byte[] crcBuff;
    private long compressedSize;
    private long uncompressedSize = 0L;
    private int fileNameLength;
    private int extraFieldLength;
    private int fileCommentLength;
    private int diskNumberStart;
    private byte[] internalFileAttr;
    private byte[] externalFileAttr;
    private long offsetLocalHeader;
    private String fileName;
    private String fileComment;
    private boolean isDirectory;
    private boolean isEncrypted;
    private int encryptionMethod = -1;
    private char[] password;
    private boolean dataDescriptorExists;
    private Zip64ExtendedInfo zip64ExtendedInfo;
    private AESExtraDataRecord aesExtraDataRecord;
    private ArrayList extraDataRecords;
    private boolean fileNameUTF8Encoded;

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int n) {
        this.signature = n;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public void setVersionMadeBy(int n) {
        this.versionMadeBy = n;
    }

    public int getVersionNeededToExtract() {
        return this.versionNeededToExtract;
    }

    public void setVersionNeededToExtract(int n) {
        this.versionNeededToExtract = n;
    }

    public byte[] getGeneralPurposeFlag() {
        return this.generalPurposeFlag;
    }

    public void setGeneralPurposeFlag(byte[] byArray) {
        this.generalPurposeFlag = byArray;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(int n) {
        this.compressionMethod = n;
    }

    public int getLastModFileTime() {
        return this.lastModFileTime;
    }

    public void setLastModFileTime(int n) {
        this.lastModFileTime = n;
    }

    public long getCrc32() {
        return this.crc32 & 0xFFFFFFFFL;
    }

    public void setCrc32(long l) {
        this.crc32 = l;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long l) {
        this.compressedSize = l;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(long l) {
        this.uncompressedSize = l;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int n) {
        this.fileNameLength = n;
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public void setExtraFieldLength(int n) {
        this.extraFieldLength = n;
    }

    public int getFileCommentLength() {
        return this.fileCommentLength;
    }

    public void setFileCommentLength(int n) {
        this.fileCommentLength = n;
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public void setDiskNumberStart(int n) {
        this.diskNumberStart = n;
    }

    public byte[] getInternalFileAttr() {
        return this.internalFileAttr;
    }

    public void setInternalFileAttr(byte[] byArray) {
        this.internalFileAttr = byArray;
    }

    public byte[] getExternalFileAttr() {
        return this.externalFileAttr;
    }

    public void setExternalFileAttr(byte[] byArray) {
        this.externalFileAttr = byArray;
    }

    public long getOffsetLocalHeader() {
        return this.offsetLocalHeader;
    }

    public void setOffsetLocalHeader(long l) {
        this.offsetLocalHeader = l;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public void setFileComment(String string) {
        this.fileComment = string;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean bl) {
        this.isDirectory = bl;
    }

    public void extractFile(ZipModel zipModel, String string, ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        this.extractFile(zipModel, string, null, progressMonitor, bl);
    }

    public void extractFile(ZipModel zipModel, String string, UnzipParameters unzipParameters, ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        this.extractFile(zipModel, string, unzipParameters, null, progressMonitor, bl);
    }

    public void extractFile(ZipModel zipModel, String string, UnzipParameters unzipParameters, String string2, ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("input zipModel is null");
        }
        if (!Zip4jUtil.checkOutputFolder(string)) {
            throw new ZipException("Invalid output path");
        }
        if (this == null) {
            throw new ZipException("invalid file header");
        }
        Unzip unzip = new Unzip(zipModel);
        unzip.extractFile(this, string, unzipParameters, string2, progressMonitor, bl);
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean bl) {
        this.isEncrypted = bl;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(int n) {
        this.encryptionMethod = n;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public byte[] getCrcBuff() {
        return this.crcBuff;
    }

    public void setCrcBuff(byte[] byArray) {
        this.crcBuff = byArray;
    }

    public ArrayList getExtraDataRecords() {
        return this.extraDataRecords;
    }

    public void setExtraDataRecords(ArrayList arrayList) {
        this.extraDataRecords = arrayList;
    }

    public boolean isDataDescriptorExists() {
        return this.dataDescriptorExists;
    }

    public void setDataDescriptorExists(boolean bl) {
        this.dataDescriptorExists = bl;
    }

    public Zip64ExtendedInfo getZip64ExtendedInfo() {
        return this.zip64ExtendedInfo;
    }

    public void setZip64ExtendedInfo(Zip64ExtendedInfo zip64ExtendedInfo) {
        this.zip64ExtendedInfo = zip64ExtendedInfo;
    }

    public AESExtraDataRecord getAesExtraDataRecord() {
        return this.aesExtraDataRecord;
    }

    public void setAesExtraDataRecord(AESExtraDataRecord aESExtraDataRecord) {
        this.aesExtraDataRecord = aESExtraDataRecord;
    }

    public boolean isFileNameUTF8Encoded() {
        return this.fileNameUTF8Encoded;
    }

    public void setFileNameUTF8Encoded(boolean bl) {
        this.fileNameUTF8Encoded = bl;
    }
}

