/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.io.DeflaterOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.CRCUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipEngine {
    private ZipModel zipModel;

    public ZipEngine(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null in ZipEngine constructor");
        }
        this.zipModel = zipModel;
    }

    public void addFiles(final ArrayList arrayList, final ZipParameters zipParameters, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (arrayList == null || zipParameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (arrayList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        progressMonitor.setCurrentOperation(0);
        progressMonitor.setState(1);
        progressMonitor.setResult(1);
        if (bl) {
            progressMonitor.setTotalWork(this.calculateTotalWork(arrayList, zipParameters));
            progressMonitor.setFileName(((File)arrayList.get(0)).getAbsolutePath());
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ZipEngine.this.initAddFiles(arrayList, zipParameters, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initAddFiles(arrayList, zipParameters, progressMonitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initAddFiles(ArrayList arrayList, ZipParameters zipParameters, ProgressMonitor progressMonitor) throws ZipException {
        if (arrayList == null) throw new ZipException("one of the input parameters is null when adding files");
        if (zipParameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (arrayList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(this.createEndOfCentralDirectoryRecord());
        }
        CipherOutputStream cipherOutputStream = null;
        InputStream inputStream = null;
        try {
            this.checkParameters(zipParameters);
            this.removeFilesIfExists(arrayList, zipParameters, progressMonitor);
            boolean bl = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
            SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
            cipherOutputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
            if (bl) {
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    throw new ZipException("invalid end of central directory record");
                }
                splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            byte[] byArray = new byte[4096];
            int n = -1;
            int n2 = 0;
            while (true) {
                block47: {
                    block48: {
                        block45: {
                            block46: {
                                if (n2 >= arrayList.size()) break block45;
                                if (progressMonitor.isCancelAllTasks()) {
                                    progressMonitor.setResult(3);
                                    progressMonitor.setState(0);
                                    return;
                                }
                                ZipParameters zipParameters2 = (ZipParameters)zipParameters.clone();
                                progressMonitor.setFileName(((File)arrayList.get(n2)).getAbsolutePath());
                                if (!((File)arrayList.get(n2)).isDirectory()) {
                                    if (zipParameters2.isEncryptFiles() && zipParameters2.getEncryptionMethod() == 0) {
                                        progressMonitor.setCurrentOperation(3);
                                        zipParameters2.setSourceFileCRC((int)CRCUtil.computeFileCRC(((File)arrayList.get(n2)).getAbsolutePath(), progressMonitor));
                                        progressMonitor.setCurrentOperation(0);
                                        if (progressMonitor.isCancelAllTasks()) {
                                            progressMonitor.setResult(3);
                                            progressMonitor.setState(0);
                                            return;
                                        }
                                    }
                                    if (Zip4jUtil.getFileLengh((File)arrayList.get(n2)) == 0L) {
                                        zipParameters2.setCompressionMethod(0);
                                    }
                                }
                                ((DeflaterOutputStream)cipherOutputStream).putNextEntry((File)arrayList.get(n2), zipParameters2);
                                if (!((File)arrayList.get(n2)).isDirectory()) break block46;
                                ((DeflaterOutputStream)cipherOutputStream).closeEntry();
                                break block47;
                            }
                            inputStream = new FileInputStream((File)arrayList.get(n2));
                            break block48;
                        }
                        ((DeflaterOutputStream)cipherOutputStream).finish();
                        progressMonitor.endProgressMonitorSuccess();
                        return;
                    }
                    while ((n = inputStream.read(byArray)) != -1) {
                        if (progressMonitor.isCancelAllTasks()) {
                            progressMonitor.setResult(3);
                            progressMonitor.setState(0);
                            return;
                        }
                        ((ZipOutputStream)cipherOutputStream).write(byArray, 0, n);
                        progressMonitor.updateWorkCompleted(n);
                    }
                    ((DeflaterOutputStream)cipherOutputStream).closeEntry();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                ++n2;
            }
        }
        catch (ZipException zipException) {
            progressMonitor.endProgressMonitorError(zipException);
            throw zipException;
        }
        catch (Exception exception) {
            progressMonitor.endProgressMonitorError(exception);
            throw new ZipException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (cipherOutputStream != null) {
                try {
                    cipherOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addStreamToZip(InputStream inputStream, ZipParameters zipParameters) throws ZipException {
        if (inputStream == null || zipParameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        }
        CipherOutputStream cipherOutputStream = null;
        try {
            this.checkParameters(zipParameters);
            boolean bl = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
            SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
            cipherOutputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
            if (bl) {
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    throw new ZipException("invalid end of central directory record");
                }
                splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            byte[] byArray = new byte[4096];
            int n = -1;
            ((DeflaterOutputStream)cipherOutputStream).putNextEntry(null, zipParameters);
            if (!zipParameters.getFileNameInZip().endsWith("/") && !zipParameters.getFileNameInZip().endsWith("\\")) {
                while ((n = inputStream.read(byArray)) != -1) {
                    ((ZipOutputStream)cipherOutputStream).write(byArray, 0, n);
                }
            }
            ((DeflaterOutputStream)cipherOutputStream).closeEntry();
            ((DeflaterOutputStream)cipherOutputStream).finish();
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
        finally {
            if (cipherOutputStream != null) {
                try {
                    cipherOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addFolderToZip(File file, ZipParameters zipParameters, ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (file == null || zipParameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add folder to zip");
        }
        if (!Zip4jUtil.checkFileExists(file.getAbsolutePath())) {
            throw new ZipException("input folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input file is not a folder, user addFileToZip method to add files");
        }
        if (!Zip4jUtil.checkFileReadAccess(file.getAbsolutePath())) {
            throw new ZipException("cannot read folder: " + file.getAbsolutePath());
        }
        String string = null;
        string = zipParameters.isIncludeRootFolder() ? (file.getAbsolutePath() != null ? (file.getAbsoluteFile().getParentFile() != null ? file.getAbsoluteFile().getParentFile().getAbsolutePath() : "") : (file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : "")) : file.getAbsolutePath();
        zipParameters.setDefaultFolderPath(string);
        ArrayList<File> arrayList = Zip4jUtil.getFilesInDirectoryRec(file, zipParameters.isReadHiddenFiles());
        if (zipParameters.isIncludeRootFolder()) {
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
            }
            arrayList.add(file);
        }
        this.addFiles(arrayList, zipParameters, progressMonitor, bl);
    }

    private void checkParameters(ZipParameters zipParameters) throws ZipException {
        if (zipParameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (zipParameters.getCompressionMethod() != 0 && zipParameters.getCompressionMethod() != 8) {
            throw new ZipException("unsupported compression type");
        }
        if (zipParameters.getCompressionMethod() == 8 && zipParameters.getCompressionLevel() < 0 && zipParameters.getCompressionLevel() > 9) {
            throw new ZipException("invalid compression level. compression level dor deflate should be in the range of 0-9");
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() != 0 && zipParameters.getEncryptionMethod() != 99) {
                throw new ZipException("unsupported encryption method");
            }
            if (zipParameters.getPassword() == null || zipParameters.getPassword().length <= 0) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            zipParameters.setAesKeyStrength(-1);
            zipParameters.setEncryptionMethod(-1);
        }
    }

    private void removeFilesIfExists(ArrayList arrayList, ZipParameters zipParameters, ProgressMonitor progressMonitor) throws ZipException {
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                File file = (File)arrayList.get(i);
                String string = Zip4jUtil.getRelativeFileName(file.getAbsolutePath(), zipParameters.getRootFolderInZip(), zipParameters.getDefaultFolderPath());
                FileHeader fileHeader = Zip4jUtil.getFileHeader(this.zipModel, string);
                if (fileHeader == null) continue;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
                progressMonitor.setCurrentOperation(2);
                HashMap hashMap = archiveMaintainer.initRemoveZipFile(this.zipModel, fileHeader, progressMonitor);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(3);
                    progressMonitor.setState(0);
                    return;
                }
                progressMonitor.setCurrentOperation(0);
                if (randomAccessFile != null) continue;
                randomAccessFile = this.prepareFileOutputStream();
                if (hashMap == null || hashMap.get("offsetCentralDir") == null) continue;
                long l = -1L;
                try {
                    l = Long.parseLong((String)hashMap.get("offsetCentralDir"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ZipException("NumberFormatException while parsing offset central directory. Cannot update already existing file header");
                }
                catch (Exception exception) {
                    throw new ZipException("Error while parsing offset central directory. Cannot update already existing file header");
                }
                if (l < 0L) continue;
                randomAccessFile.seek(l);
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private RandomAccessFile prepareFileOutputStream() throws ZipException {
        String string = this.zipModel.getZipFile();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("invalid output path");
        }
        try {
            File file = new File(string);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            return new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
    }

    private EndCentralDirRecord createEndOfCentralDirectoryRecord() {
        EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
        endCentralDirRecord.setSignature(101010256L);
        endCentralDirRecord.setNoOfThisDisk(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDir(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(0);
        endCentralDirRecord.setOffsetOfStartOfCentralDir(0L);
        return endCentralDirRecord;
    }

    private long calculateTotalWork(ArrayList arrayList, ZipParameters zipParameters) throws ZipException {
        if (arrayList == null) {
            throw new ZipException("file list is null, cannot calculate total work");
        }
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            FileHeader fileHeader;
            if (!(arrayList.get(i) instanceof File) || !((File)arrayList.get(i)).exists()) continue;
            l = zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == 0 ? (l += Zip4jUtil.getFileLengh((File)arrayList.get(i)) * 2L) : (l += Zip4jUtil.getFileLengh((File)arrayList.get(i)));
            if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0 || (fileHeader = Zip4jUtil.getFileHeader(this.zipModel, string = Zip4jUtil.getRelativeFileName(((File)arrayList.get(i)).getAbsolutePath(), zipParameters.getRootFolderInZip(), zipParameters.getDefaultFolderPath()))) == null) continue;
            l += Zip4jUtil.getFileLengh(new File(this.zipModel.getZipFile())) - fileHeader.getCompressedSize();
        }
        return l;
    }
}

