/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.plugins.datatypes.delimited.DelimitedSerializationProperties;
import com.mirth.connect.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DelimitedReader
extends SAXParser {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private DelimitedSerializationProperties serializationProperties;
    private ArrayList<String> ungottenRecord;
    private String ungottenRawText;
    private String columnDelimiter = null;
    private String recordDelimiter = null;
    private String quoteToken = null;
    private String quoteEscapeToken = null;

    public DelimitedReader(DelimitedSerializationProperties serializationProperties) {
        this.serializationProperties = serializationProperties;
        this.updateColumnDelimiter();
        this.updateRecordDelimiter();
        this.updateQuoteToken();
        this.updateQuoteEscapeToken();
        this.ungottenRecord = null;
        this.ungottenRawText = null;
    }

    public void parse(InputSource input) throws SAXException, IOException {
        ArrayList<String> record;
        BufferedReader in = new BufferedReader(input.getCharacterStream());
        String documentHead = "delimited";
        ContentHandler contentHandler = this.getContentHandler();
        contentHandler.startDocument();
        contentHandler.startElement("", documentHead, "", null);
        int recordNo = 1;
        while ((record = this.getRecord(in, null)) != null) {
            if (this.serializationProperties.isNumberedRows()) {
                contentHandler.startElement("", "row" + recordNo, "", null);
            } else {
                contentHandler.startElement("", "row", "", null);
            }
            for (int i = 0; i < record.size(); ++i) {
                Object columnName = this.serializationProperties.getColumnNames() != null && i < this.serializationProperties.getColumnNames().length ? this.serializationProperties.getColumnNames()[i] : "column" + (i + 1);
                contentHandler.startElement("", (String)columnName, "", null);
                contentHandler.characters(record.get(i).toCharArray(), 0, record.get(i).length());
                contentHandler.endElement("", (String)columnName, "");
            }
            if (this.serializationProperties.isNumberedRows()) {
                contentHandler.endElement("", "row" + recordNo, "");
            } else {
                contentHandler.endElement("", "row", "");
            }
            ++recordNo;
        }
        contentHandler.endElement("", documentHead, "");
        contentHandler.endDocument();
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<String> getRecord(BufferedReader in, StringBuilder rawText) throws IOException {
        block15: {
            if (this.ungottenRecord != null) {
                tempRecord = this.ungottenRecord;
                this.ungottenRecord = null;
                rawText.append(this.ungottenRawText);
                this.ungottenRawText = null;
                return tempRecord;
            }
            ch = this.peekChar(in);
            if (ch == -1) {
                return null;
            }
            recDelim = this.recordDelimiter;
            lookAhead = "";
            record = new ArrayList<String>();
            if (this.serializationProperties.getColumnWidths() != null) {
                for (i = 0; i < this.serializationProperties.getColumnWidths().length; ++i) {
                    columnValue = new StringBuilder();
                    lookAhead = this.peekChars(in, recDelim.length());
                    for (j = 0; j < this.serializationProperties.getColumnWidths()[i] && !lookAhead.equals(recDelim) && (ch = this.getChar(in, rawText)) != -1; ++j) {
                        columnValue.append((char)ch);
                        lookAhead = this.peekChars(in, recDelim.length());
                    }
                    record.add(this.ltrim(columnValue.toString()));
                    if (ch == -1 || lookAhead.equals(recDelim)) break;
                }
                while (ch != -1 && !lookAhead.equals(recDelim)) {
                    ch = this.getChar(in, rawText);
                    lookAhead = this.peekChars(in, recDelim.length());
                }
                if (lookAhead.equals(recDelim)) {
                    for (i = 0; i < recDelim.length(); ++i) {
                        ch = this.getChar(in, rawText);
                    }
                }
            } else {
                colDelim = ",";
                if (StringUtils.isNotEmpty((CharSequence)this.columnDelimiter)) {
                    colDelim = this.columnDelimiter;
                }
                block4: while (true) {
                    columnValue = this.getColumnValue(in, rawText);
                    record.add(columnValue);
                    ch = this.peekChar(in);
                    if (ch == -1) {
                        ch = this.getChar(in, rawText);
                        break block15;
                    }
                    lookAhead = this.peekChars(in, recDelim.length());
                    if (lookAhead.equals(recDelim)) {
                        for (i = 0; i < recDelim.length(); ++i) {
                            ch = this.getChar(in, rawText);
                        }
                        break block15;
                    }
                    lookAhead = this.peekChars(in, colDelim.length());
                    if (!lookAhead.equals(colDelim)) continue;
                    i = 0;
lbl56:
                    // 2 sources

                    while (true) {
                        if (i < colDelim.length()) break block4;
                        continue block4;
                        break;
                    }
                    break;
                }
                ch = this.getChar(in, rawText);
                ++i;
                ** continue;
            }
        }
        return record;
    }

    public void ungetRecord(ArrayList<String> record, String rawText) {
        this.ungottenRecord = record;
        this.ungottenRawText = rawText;
    }

    private String getColumnValue(BufferedReader in, StringBuilder rawText) throws IOException {
        int ch = this.peekChar(in);
        if (ch == -1) {
            return "";
        }
        StringBuilder columnValue = new StringBuilder();
        String colDelim = ",";
        if (StringUtils.isNotEmpty((CharSequence)this.columnDelimiter)) {
            colDelim = this.columnDelimiter;
        }
        String recDelim = "\\n";
        if (StringUtils.isNotEmpty((CharSequence)this.recordDelimiter)) {
            recDelim = this.recordDelimiter;
        }
        String theQuoteToken = "\"";
        if (StringUtils.isNotEmpty((CharSequence)this.quoteToken)) {
            theQuoteToken = this.quoteToken;
        }
        String theQuoteEscapeToken = "\\";
        if (StringUtils.isNotEmpty((CharSequence)this.quoteEscapeToken)) {
            theQuoteEscapeToken = this.quoteEscapeToken;
        }
        boolean inQuote = false;
        String lookAhead = this.peekChars(in, theQuoteToken.length());
        if (!lookAhead.equals(theQuoteToken)) {
            while (!(lookAhead = this.peekChars(in, recDelim.length())).equals(recDelim) && !(lookAhead = this.peekChars(in, colDelim.length())).equals(colDelim) && (ch = this.getChar(in, rawText)) != -1) {
                columnValue.append((char)ch);
            }
        } else {
            int i;
            inQuote = true;
            for (i = 0; i < theQuoteToken.length(); ++i) {
                ch = this.getChar(in, rawText);
            }
            block2: while (true) {
                if (inQuote) {
                    if (this.serializationProperties.isEscapeWithDoubleQuote()) {
                        lookAhead = this.peekChars(in, theQuoteToken.length() * 2);
                        if (lookAhead.equals(theQuoteToken + theQuoteToken)) {
                            for (i = 0; i < theQuoteToken.length(); ++i) {
                                this.getChar(in, rawText);
                            }
                            i = 0;
                            while (true) {
                                if (i >= theQuoteToken.length()) continue block2;
                                ch = this.getChar(in, rawText);
                                columnValue.append((char)ch);
                                ++i;
                            }
                        }
                    } else {
                        lookAhead = this.peekChars(in, theQuoteEscapeToken.length() + theQuoteToken.length());
                        if (lookAhead.equals(theQuoteEscapeToken + theQuoteToken)) {
                            for (i = 0; i < theQuoteEscapeToken.length(); ++i) {
                                this.getChar(in, rawText);
                            }
                            i = 0;
                            while (true) {
                                if (i >= theQuoteToken.length()) continue block2;
                                ch = this.getChar(in, rawText);
                                columnValue.append((char)ch);
                                ++i;
                            }
                        }
                        lookAhead = this.peekChars(in, theQuoteEscapeToken.length() * 2);
                        if (lookAhead.equals(theQuoteEscapeToken + theQuoteEscapeToken)) {
                            for (i = 0; i < theQuoteEscapeToken.length(); ++i) {
                                this.getChar(in, rawText);
                            }
                            i = 0;
                            while (true) {
                                if (i >= theQuoteEscapeToken.length()) continue block2;
                                ch = this.getChar(in, rawText);
                                columnValue.append((char)ch);
                                ++i;
                            }
                        }
                    }
                }
                lookAhead = this.peekChars(in, theQuoteToken.length());
                if (inQuote && lookAhead.equals(theQuoteToken)) {
                    for (i = 0; i < theQuoteToken.length(); ++i) {
                        ch = this.getChar(in, rawText);
                    }
                    inQuote = false;
                    continue;
                }
                lookAhead = this.peekChars(in, recDelim.length());
                if (!inQuote && lookAhead.equals(recDelim)) break;
                lookAhead = this.peekChars(in, colDelim.length());
                if (!inQuote && lookAhead.equals(colDelim) || (ch = this.getChar(in, rawText)) == -1) break;
                columnValue.append((char)ch);
            }
        }
        return columnValue.toString();
    }

    private void updateColumnDelimiter() {
        if (this.columnDelimiter == null && StringUtils.isNotEmpty((CharSequence)this.serializationProperties.getColumnDelimiter())) {
            this.columnDelimiter = StringUtil.unescape((String)this.serializationProperties.getColumnDelimiter());
        }
    }

    private void updateRecordDelimiter() {
        if (this.recordDelimiter == null && StringUtils.isNotEmpty((CharSequence)this.serializationProperties.getRecordDelimiter())) {
            this.recordDelimiter = StringUtil.unescape((String)this.serializationProperties.getRecordDelimiter());
        }
    }

    private void updateQuoteToken() {
        if (this.quoteToken == null && StringUtils.isNotEmpty((CharSequence)this.serializationProperties.getQuoteToken())) {
            this.quoteToken = StringUtil.unescape((String)this.serializationProperties.getQuoteToken());
        }
    }

    private void updateQuoteEscapeToken() {
        if (this.quoteEscapeToken == null && StringUtils.isNotEmpty((CharSequence)this.serializationProperties.getQuoteEscapeToken())) {
            this.quoteEscapeToken = StringUtil.unescape((String)this.serializationProperties.getQuoteEscapeToken());
        }
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public String getQuoteToken() {
        return this.quoteToken;
    }

    public String getQuoteEscapeToken() {
        return this.quoteEscapeToken;
    }

    private int getNonIgnoredChar(BufferedReader in, boolean remark) throws IOException {
        int ch;
        if (this.serializationProperties.isIgnoreCR()) {
            while ((char)(ch = in.read()) == '\r') {
                if (!remark) continue;
                in.mark(1);
            }
        } else {
            ch = in.read();
        }
        return ch;
    }

    public int getChar(BufferedReader in, StringBuilder rawText) throws IOException {
        in.mark(1);
        int ch = this.getNonIgnoredChar(in, true);
        if (rawText != null && ch != -1) {
            rawText.append((char)ch);
        }
        return ch;
    }

    public int peekChar(BufferedReader in) throws IOException {
        in.mark(1);
        int ch = this.getNonIgnoredChar(in, true);
        in.reset();
        return ch;
    }

    public String peekChars(BufferedReader in, int n) throws IOException {
        int ch;
        in.mark(n + 64);
        StringBuilder result = new StringBuilder();
        while (n > 0 && (ch = this.getNonIgnoredChar(in, false)) != -1) {
            result.append((char)ch);
            --n;
        }
        in.reset();
        return result.toString();
    }

    private String ltrim(String s) {
        int i;
        if (s.length() == 0) {
            return s;
        }
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i == s.length() - 1) {
            return s;
        }
        if (i == -1) {
            return new String();
        }
        return s.substring(0, i + 1);
    }
}

