/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.RDR_RDR_ORDER;
import ca.uhn.hl7v2.model.v24.group.RDR_RDR_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDR_RDR_DEFINITION
extends AbstractGroup {
    public RDR_RDR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false, false);
            this.add(QRF.class, false, false, false);
            this.add(RDR_RDR_PATIENT.class, false, false, false);
            this.add(RDR_RDR_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDR_RDR_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public QRD getQRD() {
        QRD retVal = (QRD)this.getTyped("QRD", QRD.class);
        return retVal;
    }

    public QRF getQRF() {
        QRF retVal = (QRF)this.getTyped("QRF", QRF.class);
        return retVal;
    }

    public RDR_RDR_PATIENT getPATIENT() {
        RDR_RDR_PATIENT retVal = (RDR_RDR_PATIENT)this.getTyped("PATIENT", RDR_RDR_PATIENT.class);
        return retVal;
    }

    public RDR_RDR_ORDER getORDER() {
        RDR_RDR_ORDER retVal = (RDR_RDR_ORDER)this.getTyped("ORDER", RDR_RDR_ORDER.class);
        return retVal;
    }

    public RDR_RDR_ORDER getORDER(int rep) {
        RDR_RDR_ORDER retVal = (RDR_RDR_ORDER)this.getTyped("ORDER", rep, RDR_RDR_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RDR_RDR_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RDR_RDR_ORDER.class);
    }

    public void insertORDER(RDR_RDR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RDR_RDR_ORDER insertORDER(int rep) throws HL7Exception {
        return (RDR_RDR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RDR_RDR_ORDER removeORDER(int rep) throws HL7Exception {
        return (RDR_RDR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

