/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelSummary;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/channels")
@Tag(name="Channels")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface ChannelServletInterface
extends BaseServletInterface {
    @POST
    @Path(value="/")
    @Operation(summary="Creates a new channel.")
    @MirthOperation(name="createChannel", display="Create channel", permission="manageChannels")
    @Produces(value={"application/json", "text/plain"})
    public boolean createChannel(@Param(value="channel") @RequestBody(description="The Channel object to create.", required=true, content={@Content(mediaType="application/xml", schema=@Schema(implementation=Channel.class), examples={@ExampleObject(name="channel", ref="../apiexamples/channel_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Channel.class), examples={@ExampleObject(name="channel", ref="../apiexamples/channel_json")})}) Channel var1) throws ClientException;

    @GET
    @Path(value="/")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Operation(summary="Retrieve a list of all channels, or multiple channels by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelList", ref="../apiexamples/channel_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelList", ref="../apiexamples/channel_list_json")})})
    @MirthOperation(name="getChannels", display="Get channels", permission="viewChannels")
    public List<Channel> getChannels(@Param(value="channelIds") @Parameter(description="The IDs of the channels to retrieve. If absent, all channels will be retrieved.") @QueryParam(value="channelId") Set<String> var1, @Param(value="pollingOnly") @Parameter(description="If true, only channels with polling source connectors will be returned.") @QueryParam(value="pollingOnly") boolean var2, @Param(value="includeCodeTemplateLibraries") @Parameter(description="If true, code template libraries will be included in the channel.") @QueryParam(value="includeCodeTemplateLibraries") boolean var3) throws ClientException;

    @POST
    @Path(value="/_getChannels")
    @Operation(summary="Retrieve a list of all channels, or multiple channels by ID. This is a POST request alternative to GET /channels that may be used when there are too many channel IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel", ref="../apiexamples/channel_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel", ref="../apiexamples/channel_list_json")})})
    @MirthOperation(name="getChannels", display="Get channels", permission="viewChannels")
    public List<Channel> getChannelsPost(@Param(value="channelIds") @RequestBody(description="The IDs of the channels to retrieve. If absent, all channels will be retrieved.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="pollingOnly") @Parameter(description="If true, only channels with polling source connectors will be returned.") @QueryParam(value="pollingOnly") boolean var2, @Param(value="includeCodeTemplateLibraries") @Parameter(description="If true, code template libraries will be included in the channel.") @QueryParam(value="includeCodeTemplateLibraries") boolean var3) throws ClientException;

    @GET
    @Path(value="/{channelId}")
    @Operation(summary="Retrieve a single channel by ID.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel", ref="../apiexamples/channel_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel", ref="../apiexamples/channel_json")})})
    @MirthOperation(name="getChannel", display="Get channel", permission="viewChannels")
    public Channel getChannel(@Param(value="channelId") @Parameter(description="The ID of the channel to retrieve.", required=true) @PathParam(value="channelId") String var1, @Param(value="includeCodeTemplateLibraries") @Parameter(description="If true, code template libraries will be included in the channel.") @QueryParam(value="includeCodeTemplateLibraries") boolean var2) throws ClientException;

    @GET
    @Path(value="/{channelId}/connectorNames")
    @Operation(summary="Returns all connector names for a channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connectorNameMap", ref="../apiexamples/connector_name_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connectorNameMap", ref="../apiexamples/connector_name_map_json")})})
    @MirthOperation(name="getConnectorNames", display="Get connector names", permission="viewMessages", auditable=false)
    public Map<Integer, String> getConnectorNames(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1) throws ClientException;

    @GET
    @Path(value="/{channelId}/metaDataColumns")
    @Operation(summary="Returns all metadata columns for a channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="metadataColumnList", ref="../apiexamples/metadatacolumn_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="metadataColumnList", ref="../apiexamples/metadatacolumn_list_json")})})
    @MirthOperation(name="getMetaDataColumns", display="Get metadata columns", permission="viewMessages", auditable=false)
    public List<MetaDataColumn> getMetaDataColumns(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1) throws ClientException;

    @GET
    @Path(value="/idsAndNames")
    @Operation(summary="Returns a map of all channel IDs and names.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelNameMap", ref="../apiexamples/guid_to_name_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelNameMap", ref="../apiexamples/guid_to_name_map_json")})})
    @MirthOperation(name="getChannelIdsAndNames", display="Get channel IDs and names", permission="viewChannels", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, String> getChannelIdsAndNames() throws ClientException;

    @GET
    @Path(value="/portsInUse")
    @Operation(summary="Returns a list of all listener ports in use throughout the channels.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="ports_used", ref="../apiexamples/ports_used_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="ports_used", ref="../apiexamples/ports_used_json")})})
    @MirthOperation(name="getChannelPortsInUse", display="Get Ports In Use", permission="viewChannels", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<Ports> getChannelPortsInUse() throws ClientException;

    @POST
    @Path(value="/_getSummary")
    @Operation(summary="Returns a list of channel summaries, indicating to a client which channels have changed (been updated, deleted, undeployed, etc.). If a channel was modified, the entire Channel object will be returned.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelSummaryList", ref="../apiexamples/channel_summary_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelSummaryList", ref="../apiexamples/channel_summary_list_json")})})
    @MirthOperation(name="getChannelSummary", display="Get channel summary", permission="viewChannels", type=Operation.ExecuteType.ASYNC, auditable=false)
    public List<ChannelSummary> getChannelSummary(@Param(value="cachedChannels") @RequestBody(description="A map of ChannelHeader objects telling the server the state of the client-side channel cache.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="cachedChannels", ref="../apiexamples/channel_header_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="cachedChannels", ref="../apiexamples/channel_header_map_json")})}) Map<String, ChannelHeader> var1, @Param(value="ignoreNewChannels") @Parameter(description="If true, summaries will only be returned for channels in the map's entry set.", required=true) @QueryParam(value="ignoreNewChannels") boolean var2) throws ClientException;

    @POST
    @Path(value="/_setEnabled")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Enables/disables the specified channels. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="setChannelEnabled", display="Set channel enabled flag", permission="manageChannels")
    public void setChannelEnabled(@Param(value="channelIds") @Parameter(description="The IDs of the channels to enable/disable. If absent, all channels will be enabled/disabled.") @FormParam(value="channelId") Set<String> var1, @Param(value="enabled") @Parameter(description="Indicates whether the channels should be enabled or disabled.", required=true) @FormParam(value="enabled") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/enabled/{enabled}")
    @Operation(summary="Enables/disables the specified channel.")
    @MirthOperation(name="setChannelEnabled", display="Set channel enabled flag", permission="manageChannels")
    public void setChannelEnabled(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="enabled") @Parameter(description="The enabled flag (true/false) to set.", required=true) @PathParam(value="enabled") boolean var2) throws ClientException;

    @POST
    @Path(value="/_setInitialState")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Sets the initial state for the specified channels. (\"Try it Out\" only works when submitting an array containing one element for this endpoint, but the descriptions are valid. If you want to modify multiple items at once, please use another tool for testing.)")
    @MirthOperation(name="setChannelInitialState", display="Set channel initial state", permission="manageChannels")
    public void setChannelInitialState(@Param(value="channelIds") @Parameter(description="The IDs of the channels to modify initial states on. If absent, the initial state will be set on all channels.") @FormParam(value="channelId") Set<String> var1, @Param(value="initialState") @Parameter(description="The initial state of the channel.", required=true, schema=@Schema(allowableValues={"STARTED", "PAUSED", "STOPPED"}, type="string")) @FormParam(value="initialState") DeployedState var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/initialState/{initialState}")
    @Operation(summary="Sets the initial state for a single channel.")
    @MirthOperation(name="setChannelInitialState", display="Set channel initial state", permission="manageChannels")
    public void setChannelInitialState(@Param(value="channelId") @Parameter(description="The ID of the channel.", required=true) @PathParam(value="channelId") String var1, @Param(value="initialState") @Parameter(description="The initial state of the channel.", required=true, schema=@Schema(allowableValues={"STARTED", "PAUSED", "STOPPED"}, type="string")) @PathParam(value="initialState") DeployedState var2) throws ClientException;

    @PUT
    @Path(value="/{channelId}")
    @Operation(summary="Updates the specified channel.")
    @MirthOperation(name="updateChannel", display="Update channel", permission="manageChannels")
    @Produces(value={"application/json", "text/plain"})
    public boolean updateChannel(@Param(value="channelId") @Parameter(description="The ID of the channel to update.", required=true) @PathParam(value="channelId") String var1, @Param(value="channel") @RequestBody(description="The Channel object to update with.", required=true, content={@Content(mediaType="application/xml", schema=@Schema(implementation=Channel.class), examples={@ExampleObject(name="channel", ref="../apiexamples/channel_xml")}), @Content(mediaType="application/json", schema=@Schema(implementation=Channel.class), examples={@ExampleObject(name="channel", ref="../apiexamples/channel_json")})}) Channel var2, @Param(value="override") @Parameter(description="If true, the channel will be updated even if a different revision exists on the server.", schema=@Schema(defaultValue="false")) @QueryParam(value="override") boolean var3, @Param(value="startEdit") @Parameter(description="Date and time starting to edit this channel. Example: 1985-10-26T09:00:00.000-0700") @QueryParam(value="startEdit") String var4) throws ClientException;

    @DELETE
    @Path(value="/{channelId}")
    @Operation(summary="Removes the channel with the specified ID.")
    @MirthOperation(name="removeChannel", display="Remove channel", permission="manageChannels")
    public void removeChannel(@Param(value="channelId") @Parameter(description="The ID of the channel to remove.", required=true) @PathParam(value="channelId") String var1) throws ClientException;

    @DELETE
    @Path(value="/")
    @Operation(summary="Removes the channels with the specified IDs.")
    @MirthOperation(name="removeChannels", display="Remove channels", permission="manageChannels")
    public void removeChannels(@Param(value="channelIds") @Parameter(description="The IDs of the channels to remove.", required=true) @QueryParam(value="channelId") Set<String> var1) throws ClientException;

    @POST
    @Path(value="/_removeChannels")
    @Operation(summary="Removes the channels with the specified IDs. This is a POST request alternative to DELETE /channels that may be used when there are too many channel IDs to include in the query parameters.")
    @MirthOperation(name="removeChannels", display="Remove channels", permission="manageChannels")
    public void removeChannelsPost(@Param(value="channelIds") @RequestBody(description="The IDs of the channels to remove.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_json")})}) Set<String> var1) throws ClientException;
}

