/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.model.attachments.AttachmentHandlerType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

@XStreamAlias(value="channelProperties")
public class ChannelProperties
implements Serializable,
Migratable,
Purgable {
    private boolean clearGlobalChannelMap = true;
    private MessageStorageMode messageStorageMode = MessageStorageMode.DEVELOPMENT;
    private boolean encryptData = false;
    private boolean encryptAttachments = false;
    private boolean encryptCustomMetaData = false;
    private boolean removeContentOnCompletion;
    private boolean removeOnlyFilteredOnCompletion;
    private boolean removeAttachmentsOnCompletion;
    private DeployedState initialState = DeployedState.STARTED;
    private boolean storeAttachments = true;
    private List<MetaDataColumn> metaDataColumns = new ArrayList<MetaDataColumn>();
    private AttachmentHandlerProperties attachmentProperties = AttachmentHandlerType.NONE.getDefaultProperties();
    private Map<String, String> resourceIds = new LinkedHashMap<String, String>();

    public ChannelProperties() {
        this.resourceIds.put("Default Resource", "[Default Resource]");
    }

    public boolean isClearGlobalChannelMap() {
        return this.clearGlobalChannelMap;
    }

    public void setClearGlobalChannelMap(boolean clearGlobalChannelMap) {
        this.clearGlobalChannelMap = clearGlobalChannelMap;
    }

    public MessageStorageMode getMessageStorageMode() {
        return this.messageStorageMode;
    }

    public void setMessageStorageMode(MessageStorageMode messageStorageMode) {
        this.messageStorageMode = messageStorageMode;
    }

    public boolean isEncryptMessageContent() {
        return this.encryptData;
    }

    public void setEncryptMessageContent(boolean encryptData) {
        this.encryptData = encryptData;
    }

    public boolean isEncryptAttachments() {
        return this.encryptAttachments;
    }

    public void setEncryptAttachments(boolean encryptAttachments) {
        this.encryptAttachments = encryptAttachments;
    }

    public boolean isEncryptCustomMetaData() {
        return this.encryptCustomMetaData;
    }

    public void setEncryptCustomMetaData(boolean encryptCustomMetaData) {
        this.encryptCustomMetaData = encryptCustomMetaData;
    }

    public boolean isRemoveContentOnCompletion() {
        return this.removeContentOnCompletion;
    }

    public void setRemoveContentOnCompletion(boolean removeContentOnCompletion) {
        this.removeContentOnCompletion = removeContentOnCompletion;
    }

    public boolean isRemoveOnlyFilteredOnCompletion() {
        return this.removeOnlyFilteredOnCompletion;
    }

    public void setRemoveOnlyFilteredOnCompletion(boolean removeOnlyFilteredOnCompletion) {
        this.removeOnlyFilteredOnCompletion = removeOnlyFilteredOnCompletion;
    }

    public boolean isRemoveAttachmentsOnCompletion() {
        return this.removeAttachmentsOnCompletion;
    }

    public void setRemoveAttachmentsOnCompletion(boolean removeAttachmentsOnCompletion) {
        this.removeAttachmentsOnCompletion = removeAttachmentsOnCompletion;
    }

    public DeployedState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(DeployedState initialState) {
        this.initialState = initialState;
    }

    public boolean isStoreAttachments() {
        return this.storeAttachments;
    }

    public void setStoreAttachments(boolean storeAttachments) {
        this.storeAttachments = storeAttachments;
    }

    public List<MetaDataColumn> getMetaDataColumns() {
        return this.metaDataColumns;
    }

    public void setMetaDataColumns(List<MetaDataColumn> metaDataColumns) {
        this.metaDataColumns = metaDataColumns;
    }

    public AttachmentHandlerProperties getAttachmentProperties() {
        return this.attachmentProperties;
    }

    public void setAttachmentProperties(AttachmentHandlerProperties attachmentProperties) {
        this.attachmentProperties = attachmentProperties;
    }

    public Map<String, String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Map<String, String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
        DonkeyElement resourceIdsElement = element.addChildElement("resourceIds");
        resourceIdsElement.setAttribute("class", "linked-hash-set");
        resourceIdsElement.addChildElement("string", "Default Resource");
    }

    public void migrate3_3_0(DonkeyElement element) {
        element.addChildElementIfNotExists("removeOnlyFilteredOnCompletion", "false");
    }

    public void migrate3_4_0(DonkeyElement element) {
        DonkeyElement resourceIdsElement = element.getChildElement("resourceIds");
        List resourceIdsList = resourceIdsElement.getChildElements();
        resourceIdsElement.removeChildren();
        resourceIdsElement.setAttribute("class", "linked-hash-map");
        for (DonkeyElement resourceId : resourceIdsList) {
            DonkeyElement entry = resourceIdsElement.addChildElement("entry");
            String resourceIdText = resourceId.getTextContent();
            entry.addChildElement("string", resourceIdText);
            if (resourceIdText.equals("Default Resource")) {
                entry.addChildElement("string", "[Default Resource]");
                continue;
            }
            entry.addChildElement("string");
        }
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public void migrate4_6_0(DonkeyElement element) {
        DonkeyElement metaDataColumnsElement = element.getChildElement("metaDataColumns");
        if (metaDataColumnsElement != null) {
            for (DonkeyElement metaDataColumn : metaDataColumnsElement.getChildElements()) {
                DonkeyElement mappingNameElement = metaDataColumn.getChildElement("mappingName");
                if (mappingNameElement == null) continue;
                String mappingName = mappingNameElement.getTextContent();
                if ("mirth_type".equals(mappingName)) {
                    mappingNameElement.setTextContent("message_type");
                    continue;
                }
                if (!"mirth_source".equals(mappingName)) continue;
                mappingNameElement.setTextContent("message_source");
            }
        }
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("clearGlobalChannelMap", this.clearGlobalChannelMap);
        purgedProperties.put("messageStorageMode", (Object)this.messageStorageMode);
        purgedProperties.put("encryptData", this.encryptData);
        purgedProperties.put("encryptAttachments", this.encryptAttachments);
        purgedProperties.put("encryptCustomMetaData", this.encryptCustomMetaData);
        purgedProperties.put("removeContentOnCompletion", this.removeContentOnCompletion);
        purgedProperties.put("removeAttachmentsOnCompletion", this.removeAttachmentsOnCompletion);
        purgedProperties.put("initialState", this.initialState);
        purgedProperties.put("storeAttachments", this.storeAttachments);
        purgedProperties.put("metaDataColumns", PurgeUtil.purgeList(this.metaDataColumns));
        purgedProperties.put("attachmentProperties", this.attachmentProperties.getPurgedProperties());
        purgedProperties.put("resourceIdsCount", this.resourceIds.size());
        return purgedProperties;
    }
}

