/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.codetemplates;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.Cacheable;
import com.mirth.connect.model.codetemplates.BasicCodeTemplateProperties;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateFunctionDefinition;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.text.WordUtils;

@XStreamAlias(value="codeTemplate")
public class CodeTemplate
implements Serializable,
Migratable,
Purgable,
Cacheable<CodeTemplate> {
    public static final String DEFAULT_CODE = "/**\n\tModify the description here. Modify the function name and parameters as needed. One function per\n\ttemplate is recommended; create a new code template for each new function.\n\n\t@param {String} arg1 - arg1 description\n\t@return {String} return description\n*/\nfunction new_function1(arg1) {\n\t// TODO: Enter code here\n}";
    private String id;
    private String name;
    private Integer revision;
    private Calendar lastModified;
    private CodeTemplateContextSet contextSet;
    private CodeTemplateProperties properties;

    public CodeTemplate(String id) {
        this.id = id;
    }

    public CodeTemplate(String name, CodeTemplateProperties.CodeTemplateType type, CodeTemplateContextSet contextSet, String code, String description) {
        this(name, new BasicCodeTemplateProperties(type, code, description), contextSet);
    }

    public CodeTemplate(String name, CodeTemplateProperties.CodeTemplateType type, CodeTemplateContextSet contextSet, String code) {
        this(name, new BasicCodeTemplateProperties(type, code), contextSet);
    }

    public CodeTemplate(String name, CodeTemplateProperties properties, CodeTemplateContextSet contextSet) {
        this(UUID.randomUUID().toString());
        this.name = name;
        this.properties = properties;
        this.contextSet = contextSet;
    }

    public CodeTemplate(CodeTemplate codeTemplate) {
        this.id = codeTemplate.getId();
        this.name = codeTemplate.getName();
        this.revision = codeTemplate.getRevision();
        this.lastModified = codeTemplate.getLastModified();
        if (codeTemplate.getContextSet() != null) {
            this.contextSet = new CodeTemplateContextSet(codeTemplate.getContextSet());
        }
        if (codeTemplate.getProperties() != null) {
            this.properties = codeTemplate.getProperties().clone();
        }
    }

    public static CodeTemplate getDefaultCodeTemplate(String name) {
        return new CodeTemplate(name, CodeTemplateProperties.CodeTemplateType.FUNCTION, CodeTemplateContextSet.getConnectorContextSet(), DEFAULT_CODE);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public CodeTemplateProperties.CodeTemplateType getType() {
        return this.properties != null ? this.properties.getType() : null;
    }

    public boolean isAddToScripts() {
        return this.properties != null ? Boolean.valueOf(this.properties.getType() == CodeTemplateProperties.CodeTemplateType.FUNCTION || this.properties.getType() == CodeTemplateProperties.CodeTemplateType.COMPILED_CODE) : null;
    }

    public CodeTemplateContextSet getContextSet() {
        return this.contextSet;
    }

    public void setContextSet(CodeTemplateContextSet contextSet) {
        this.contextSet = contextSet;
    }

    public String getCode() {
        return this.properties != null ? this.properties.getCode() : null;
    }

    public CodeTemplateProperties getProperties() {
        return this.properties;
    }

    public void setProperties(CodeTemplateProperties properties) {
        this.properties = properties;
    }

    @Override
    public CodeTemplate cloneIfNeeded() {
        return new CodeTemplate(this);
    }

    public String getDescription() {
        return this.properties != null ? this.properties.getDescription() : null;
    }

    public CodeTemplateFunctionDefinition getFunctionDefinition() {
        return this.properties != null ? this.properties.getFunctionDefinition() : null;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
        element.addChildElement("revision", "1");
        try {
            element.addChildElementFromXml(ObjectXMLSerializer.getInstance().serialize(Calendar.getInstance())).setNodeName("lastModified");
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new SerializerException("Failed to migrate code template last modified date.", (Throwable)e);
        }
        String type = element.getChildElement("type").getTextContent();
        if (type.equals("CODE") || type.equals("VARIABLE")) {
            element.getChildElement("type").setTextContent("DRAG_AND_DROP_CODE");
        }
        DonkeyElement codeElement = element.getChildElement("code");
        String code = StringUtils.trim((String)codeElement.getTextContent());
        String toolTip = StringUtils.trim((String)element.removeChild("tooltip").getTextContent());
        if (StringUtils.isNotBlank((CharSequence)toolTip)) {
            if (code.startsWith("/**")) {
                int index = StringUtils.indexOfAnyBut((CharSequence)code.substring(1), (char[])new char[]{'*'}) + 1;
                StringBuilder builder = new StringBuilder(code.substring(0, index)).append("\n\t").append(WordUtils.wrap((String)toolTip, (int)100, (String)"\n\t", (boolean)false)).append('\n');
                String remaining = code.substring(index);
                if (StringUtils.indexOfAnyBut((CharSequence)remaining.trim(), (char[])new char[]{'*', '/'}) == 0) {
                    builder.append("\n\t");
                }
                code = builder.append(remaining).toString();
            } else {
                code = "/**\n\t" + WordUtils.wrap((String)toolTip, (int)100, (String)"\n\t", (boolean)false) + "\n*/\n" + code;
            }
            codeElement.setTextContent(code);
        }
        DonkeyElement contextSet = element.addChildElement("contextSet").addChildElement("delegate");
        switch (Integer.parseInt(element.removeChild("scope").getTextContent())) {
            case 0: 
            case 1: {
                contextSet.addChildElement("contextType", "GLOBAL_DEPLOY");
                contextSet.addChildElement("contextType", "GLOBAL_UNDEPLOY");
                contextSet.addChildElement("contextType", "GLOBAL_PREPROCESSOR");
            }
            case 2: {
                contextSet.addChildElement("contextType", "GLOBAL_POSTPROCESSOR");
                contextSet.addChildElement("contextType", "CHANNEL_DEPLOY");
                contextSet.addChildElement("contextType", "CHANNEL_UNDEPLOY");
                contextSet.addChildElement("contextType", "CHANNEL_PREPROCESSOR");
                contextSet.addChildElement("contextType", "CHANNEL_POSTPROCESSOR");
                contextSet.addChildElement("contextType", "CHANNEL_ATTACHMENT");
                contextSet.addChildElement("contextType", "CHANNEL_BATCH");
            }
            case 3: {
                contextSet.addChildElement("contextType", "SOURCE_RECEIVER");
                contextSet.addChildElement("contextType", "SOURCE_FILTER_TRANSFORMER");
                contextSet.addChildElement("contextType", "DESTINATION_FILTER_TRANSFORMER");
                contextSet.addChildElement("contextType", "DESTINATION_DISPATCHER");
                contextSet.addChildElement("contextType", "DESTINATION_RESPONSE_TRANSFORMER");
            }
        }
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
        DonkeyElement typeElement = element.removeChild("type");
        DonkeyElement codeElement = element.removeChild("code");
        if (typeElement != null && codeElement != null) {
            DonkeyElement propertiesElement = element.addChildElement("properties");
            propertiesElement.setAttribute("class", "com.mirth.connect.model.codetemplates.BasicCodeTemplateProperties");
            propertiesElement.addChildElement("type", typeElement.getTextContent());
            propertiesElement.addChildElement("code", codeElement.getTextContent());
        }
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.id);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("lastModified", this.lastModified);
        purgedProperties.put("contextSet", this.contextSet);
        CodeTemplateFunctionDefinition functionDefinition = this.getFunctionDefinition();
        purgedProperties.put("parameterCount", functionDefinition != null ? functionDefinition.getParameters().size() : 0);
        purgedProperties.put("properties", this.properties != null ? this.properties.getPurgedProperties() : null);
        return purgedProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("id=").append(this.id).append(", ");
        builder.append("name=").append(this.name).append(", ");
        builder.append("revision=").append(this.revision).append(", ");
        builder.append("lastModified=").append(this.lastModified).append(", ");
        builder.append("contextSet=").append(this.contextSet).append(", ");
        builder.append("properties=").append(this.properties).append(']');
        return builder.toString();
    }
}

