/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.util.MirthXmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLPrettyPrinter
implements ContentHandler {
    private Writer out;
    private int depth = 0;
    private boolean encodeEntities;

    public XMLPrettyPrinter(Writer out) {
        this.out = out;
    }

    public XMLPrettyPrinter(OutputStream out) {
        try {
            this.out = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Something is seriously wrong. Your VM does not support UTF-8 encoding!");
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.depth = 0;
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String name) throws SAXException {
        try {
            --this.depth;
            this.out.write("</");
            this.out.write(name);
            this.out.write(">");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        try {
            if (this.encodeEntities) {
                this.out.write(MirthXmlUtil.encode(text, start, length));
            } else {
                this.out.write(text, start, length);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.out.write("<?");
            this.out.write(target);
            this.out.write(" ");
            this.out.write(data);
            this.out.write("?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.endElement(localName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.out.write("<");
            this.out.write(localName);
            if (atts != null) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.out.write(" " + atts.getLocalName(i) + "=\"");
                    if (this.encodeEntities) {
                        this.out.write(MirthXmlUtil.encode(atts.getValue(i).toCharArray(), 0, atts.getValue(i).length()));
                    } else {
                        this.out.write(atts.getValue(i));
                    }
                    this.out.write("\"");
                }
            }
            this.out.write(">");
            ++this.depth;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public boolean isEncodeEntities() {
        return this.encodeEntities;
    }

    public void setEncodeEntities(boolean encodeEntities) {
        this.encodeEntities = encodeEntities;
    }
}

