/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util.messagewriter;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.util.FilenameUtils;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterArchive;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import com.mirth.connect.util.messagewriter.MessageWriterFile;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MessageWriterFactory {
    public static final String ARCHIVE_DATE_PATTERN = "yyyy-MM-dd-HH-mm-ss";
    private static MessageWriterFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageWriterFactory getInstance() {
        if (instance != null) return instance;
        Class<MessageWriterFactory> clazz = MessageWriterFactory.class;
        synchronized (MessageWriterFactory.class) {
            instance = new MessageWriterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MessageWriterFactory() {
    }

    public MessageWriter getMessageWriter(MessageWriterOptions options, Encryptor encryptor) throws MessageWriterException {
        String baseFolder = StringUtils.defaultString((String)options.getBaseFolder(), (String)System.getProperty("user.dir"));
        String rootFolder = FilenameUtils.getAbsolutePath(new File(baseFolder), options.getRootFolder());
        String filePattern = options.getFilePattern();
        if (filePattern.substring(0, 1).equals(Character.valueOf(IOUtils.DIR_SEPARATOR))) {
            filePattern = filePattern.substring(1);
        }
        MessageWriterFile fileWriter = new MessageWriterFile(rootFolder, filePattern, options.getContentType(), options.isDestinationContent(), options.isEncrypt(), encryptor);
        if (options.getArchiveFormat() == null) {
            return fileWriter;
        }
        if (options.getArchiveFileName() == null) {
            options.setArchiveFileName(new SimpleDateFormat(ARCHIVE_DATE_PATTERN).format(Calendar.getInstance().getTime()));
        }
        String tempFolder = rootFolder + IOUtils.DIR_SEPARATOR + "." + options.getArchiveFileName();
        FileUtils.deleteQuietly((File)new File(tempFolder));
        fileWriter.setPath(tempFolder);
        File archiveFile = new File(rootFolder + IOUtils.DIR_SEPARATOR + options.getArchiveFileName() + "." + this.getArchiveExtension(options.getArchiveFormat(), options.getCompressFormat()));
        String password = null;
        if (options.isPasswordEnabled()) {
            password = options.getPassword();
        }
        return new MessageWriterArchive(fileWriter, new File(tempFolder), archiveFile, options.getArchiveFormat(), options.getCompressFormat(), password, options.getEncryptionType());
    }

    private String getArchiveExtension(String archiver, String compressor) {
        if (compressor == null) {
            return archiver;
        }
        if (compressor.equals("bzip2")) {
            compressor = "bz2";
        }
        return archiver + "." + compressor;
    }
}

