/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.channel;

import com.mirth.connect.donkey.model.channel.MetaDataColumnException;
import com.mirth.connect.donkey.util.DateParser;
import java.math.BigDecimal;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.lang3.StringUtils;

public enum MetaDataColumnType {
    STRING,
    NUMBER,
    BOOLEAN,
    TIMESTAMP;

    private static final BigDecimal MAX_NUMBER_VALUE;

    public static MetaDataColumnType fromString(String columnType) {
        if (columnType.equals("STRING")) {
            return STRING;
        }
        if (columnType.equals("NUMBER")) {
            return NUMBER;
        }
        if (columnType.equals("BOOLEAN")) {
            return BOOLEAN;
        }
        if (columnType.equals("TIMESTAMP")) {
            return TIMESTAMP;
        }
        return null;
    }

    public static MetaDataColumnType fromSqlType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return STRING;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return NUMBER;
            }
            case -7: 
            case 1: 
            case 16: {
                return BOOLEAN;
            }
            case 91: 
            case 92: 
            case 93: {
                return TIMESTAMP;
            }
        }
        return null;
    }

    public Object castValue(Object value) throws MetaDataColumnException {
        if (value == null) {
            return null;
        }
        try {
            switch (this) {
                case BOOLEAN: {
                    return (Boolean)new BooleanConverter().convert(Boolean.class, value);
                }
                case NUMBER: {
                    BigDecimal number = (BigDecimal)new BigDecimalConverter().convert(BigDecimal.class, value);
                    if (number.compareTo(MAX_NUMBER_VALUE) >= 0) {
                        throw new Exception("Number " + String.valueOf(number) + " is greater than or equal to the maximum allowed value of 10^16.");
                    }
                    return number;
                }
                case STRING: {
                    String string = (String)new StringConverter().convert(String.class, value);
                    if (string.length() > 255) {
                        string = StringUtils.substring((String)string, (int)0, (int)255);
                    }
                    return string;
                }
                case TIMESTAMP: {
                    return new DateParser().parse(value.toString());
                }
            }
        }
        catch (Exception e) {
            throw new MetaDataColumnException(e);
        }
        throw new MetaDataColumnException("Unrecognized MetaDataColumnType");
    }

    static {
        MAX_NUMBER_VALUE = new BigDecimal(10000000000000000L);
    }
}

