/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.plugins.datapruner.DataPrunerController;
import com.mirth.connect.plugins.datapruner.DataPrunerException;
import com.mirth.connect.plugins.datapruner.DataPrunerServletInterface;
import com.mirth.connect.server.api.MirthServlet;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataPrunerServlet
extends MirthServlet
implements DataPrunerServletInterface {
    private static final DataPrunerController dataPrunerController = DataPrunerController.getInstance();
    private static final Logger logger = LogManager.getLogger(DataPrunerServlet.class);

    public DataPrunerServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "Data Pruner");
    }

    public Map<String, String> getStatusMap() {
        try {
            return dataPrunerController.getStatusMap();
        }
        catch (DataPrunerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Calendar start() {
        try {
            dataPrunerController.startPruner();
            return dataPrunerController.getPrunerStatus().getStartTime();
        }
        catch (DataPrunerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void stop() {
        try {
            dataPrunerController.stopPruner();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Stopped waiting for the data pruner to stop, due to a thread interruption.", (Throwable)e);
        }
        catch (DataPrunerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

