/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.oauth2;

import com.mirth.connect.connectors.http.DefaultHttpConfiguration;
import com.mirth.connect.connectors.http.HttpConfiguration;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.oauth2.OAuth2Authenticator;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;

public class OAuth2AuthenticatorProvider
extends AuthenticatorProvider {
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private HttpConfiguration configuration;

    public OAuth2AuthenticatorProvider(Connector connector, HttpAuthConnectorPluginProperties properties) {
        super(connector, properties);
        try {
            this.configuration = (HttpConfiguration)Class.forName(configurationController.getProperty("HTTP", "httpConfigurationClass")).newInstance();
        }
        catch (Exception e) {
            this.configuration = new DefaultHttpConfiguration();
        }
    }

    HttpConfiguration getHttpConfiguration() {
        return this.configuration;
    }

    @Override
    public Authenticator getAuthenticator() throws Exception {
        return new OAuth2Authenticator(this);
    }
}

