/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.IconButton;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.serverlog.ServerLogClient;
import com.mirth.connect.plugins.serverlog.ServerLogItem;
import com.mirth.connect.plugins.serverlog.ViewServerLogContentDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ServerLogPanel
extends JPanel {
    private static final String ID_COLUMN_HEADER = "Id";
    private static final String LOG_INFO_COLUMN_HEADER = "Log Information";
    private JPopupMenu rightclickPopup;
    private static final int PAUSED = 0;
    private static final int RESUMED = 1;
    private int state = 0;
    private int currentServerLogSize;
    private Preferences userPreferences;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private ServerLogClient serverLogClient;
    private IconButton clearLog;
    private JScrollPane jScrollPane1;
    private IconButton logSizeChange;
    private JLabel logSizeText;
    private JTextField logSizeTextField;
    private MirthTable logTable;
    private IconButton pauseResume;

    public ServerLogPanel(ServerLogClient serverLogClient) {
        this.serverLogClient = serverLogClient;
        this.initComponents();
        this.initLayouts();
        this.clearLog.setIcon((Icon)UIConstants.ICON_X);
        this.clearLog.setToolTipText("Clear Displayed Log");
        this.logSizeChange.setIcon((Icon)UIConstants.ICON_CHECK);
        this.logSizeChange.setToolTipText("Change Log Display Size");
        this.makeLogTextArea();
        this.logSizeTextField.setDocument((Document)new MirthFieldConstraints(2, false, false, true));
        this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
        this.currentServerLogSize = this.userPreferences.getInt("serverLogSize", 50);
        this.logSizeTextField.setText("" + this.currentServerLogSize);
    }

    public void initLayouts() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent((Component)this.pauseResume, -2, -1, -2).addGap(2, 2, 2).addComponent((Component)this.clearLog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.logSizeText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logSizeTextField, -2, 45, -2).addGap(2, 2, 2).addComponent((Component)this.logSizeChange, -2, -1, -2).addGap(2, 2, 2)).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 341, Short.MAX_VALUE).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.pauseResume, -2, -1, -2).addComponent((Component)this.clearLog, -2, -1, -2).addComponent((Component)this.logSizeChange, -2, -1, -2).addComponent(this.logSizeTextField, -2, -1, -2).addComponent(this.logSizeText))));
    }

    public void makeLogTextArea() {
        this.updateTable(null);
        this.logTable.setDoubleBuffered(true);
        this.logTable.setSelectionMode(0);
        this.logTable.getColumnExt((Object)ID_COLUMN_HEADER).setVisible(false);
        this.logTable.packTable(10);
        this.logTable.setRowHeight(20);
        this.logTable.setOpaque(true);
        this.logTable.setRowSelectionAllowed(true);
        this.logTable.setSortable(false);
        this.logTable.setFocusable(false);
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.setAutoResizeMode(4);
        this.createPopupMenu();
        this.jScrollPane1.setViewportView((Component)this.logTable);
        this.logTable.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                if (ServerLogPanel.this.logTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        new ViewServerLogContentDialog(ServerLogPanel.this.parent, String.valueOf(ServerLogPanel.this.logTable.getModel().getValueAt(ServerLogPanel.this.logTable.convertRowIndexToModel(ServerLogPanel.this.logTable.getSelectedRow()), 1)));
                    }
                }
            }
        });
    }

    public void createPopupMenu() {
        this.rightclickPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Pause Log");
        menuItem.setIcon(UIConstants.ICON_PAUSE);
        menuItem.addActionListener(new PauseResumeActionListener());
        this.rightclickPopup.add(menuItem);
        menuItem = new JMenuItem("Resume Log");
        menuItem.setIcon(UIConstants.ICON_RESUME);
        menuItem.addActionListener(new PauseResumeActionListener());
        this.rightclickPopup.add(menuItem);
        this.rightclickPopup.addSeparator();
        menuItem = new JMenuItem("Clear Log");
        menuItem.setIcon(UIConstants.ICON_X);
        menuItem.addActionListener(new ClearLogActionListener());
        this.rightclickPopup.add(menuItem);
        this.adjustPauseResumeButton();
        PopupListener popupListener = new PopupListener(this.rightclickPopup);
        this.jScrollPane1.addMouseListener(popupListener);
        this.logTable.addMouseListener((MouseListener)popupListener);
    }

    public synchronized void updateTable(LinkedList<ServerLogItem> serverLogs) {
        Object[][] tableData;
        if (serverLogs != null) {
            DashboardTablePlugin plugin;
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            String serverId = null;
            Iterator<Object> iterator = LoadedExtensions.getInstance().getDashboardTablePlugins().values().iterator();
            while (iterator.hasNext() && (serverId = (plugin = (DashboardTablePlugin)iterator.next()).getServerId()) == null) {
            }
            for (ServerLogItem item : serverLogs) {
                if (serverId != null && !serverId.equals(item.getServerId())) continue;
                dataList.add(new Object[]{item.getId(), item});
            }
            tableData = (Object[][])dataList.toArray((T[])new Object[dataList.size()][]);
        } else {
            tableData = new Object[0][2];
        }
        if (this.logTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.logTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.logTable = new MirthTable();
            this.logTable.setModel((TableModel)new RefreshTableModel(tableData, new String[]{ID_COLUMN_HEADER, LOG_INFO_COLUMN_HEADER}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false};
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.logTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    public boolean isPaused() {
        return this.state == 0;
    }

    public void adjustPauseResumeButton() {
        if (this.state == 1) {
            this.state = 0;
            this.pauseResume.setIcon((Icon)UIConstants.ICON_RESUME);
            this.pauseResume.setToolTipText("Resume Log");
            this.rightclickPopup.getComponent(0).setVisible(false);
            this.rightclickPopup.getComponent(1).setVisible(true);
        } else {
            this.state = 1;
            this.pauseResume.setIcon((Icon)UIConstants.ICON_PAUSE);
            this.pauseResume.setToolTipText("Pause Log");
            this.rightclickPopup.getComponent(0).setVisible(true);
            this.rightclickPopup.getComponent(1).setVisible(false);
        }
    }

    public int getCurrentServerLogSize() {
        return this.currentServerLogSize;
    }

    private void initComponents() {
        this.logSizeTextField = new JTextField();
        this.logSizeText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.logTable = null;
        this.clearLog = new IconButton();
        this.logSizeChange = new IconButton();
        this.pauseResume = new IconButton();
        this.logSizeTextField.setHorizontalAlignment(4);
        this.logSizeTextField.setMaximumSize(new Dimension(45, 19));
        this.logSizeTextField.setMinimumSize(new Dimension(45, 19));
        this.logSizeTextField.setPreferredSize(new Dimension(45, 19));
        this.logSizeText.setText("Log Size:");
        this.jScrollPane1.setViewportView((Component)this.logTable);
        this.clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLogPanel.this.clearLogActionPerformed(evt);
            }
        });
        this.logSizeChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLogPanel.this.logSizeChangeActionPerformed(evt);
            }
        });
        this.pauseResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLogPanel.this.pauseResumeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.pauseResume, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.clearLog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 316, Short.MAX_VALUE).addComponent(this.logSizeText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logSizeTextField, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.logSizeChange, -2, -1, -2).addGap(5, 5, 5)).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 335, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.clearLog, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.logSizeChange, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logSizeTextField, -2, -1, -2).addComponent(this.logSizeText))).addComponent((Component)this.pauseResume, -2, -1, -2))));
    }

    private void clearLogActionPerformed(ActionEvent evt) {
        this.serverLogClient.clearLog();
    }

    private void logSizeChangeActionPerformed(ActionEvent evt) {
        if (this.logSizeTextField.getText().length() == 0) {
            this.parent.alertWarning((Component)this, "Please enter a valid number.");
            return;
        }
        int newServerLogSize = Integer.parseInt(this.logSizeTextField.getText());
        if (newServerLogSize != this.currentServerLogSize) {
            if (newServerLogSize <= 0) {
                this.parent.alertWarning((Component)this, "Please enter a log size that is larger than 0.");
            } else {
                this.userPreferences.putInt("serverLogSize", newServerLogSize);
                this.currentServerLogSize = newServerLogSize;
                this.serverLogClient.resetServerLogSize(newServerLogSize);
            }
        }
    }

    private void pauseResumeActionPerformed(ActionEvent evt) {
        this.adjustPauseResumeButton();
    }

    class PauseResumeActionListener
    implements ActionListener {
        PauseResumeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerLogPanel.this.adjustPauseResumeButton();
        }
    }

    class ClearLogActionListener
    implements ActionListener {
        ClearLogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerLogPanel.this.serverLogClient.clearLog();
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

