/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.doc;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.doc.DocumentConnectorServletInterface;
import com.mirth.connect.connectors.doc.DocumentDispatcherProperties;
import com.mirth.connect.connectors.doc.PageSize;
import com.mirth.connect.connectors.doc.Unit;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DocumentWriter
extends ConnectorSettingsPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean pageSizeUpdating;
    private JLabel outputLabel;
    private JRadioButton outputFileRadioButton;
    private JRadioButton outputAttachmentRadioButton;
    private JRadioButton outputBothRadioButton;
    private JLabel directoryLabel;
    private JTextField directoryField;
    private JButton testConnectionButton;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel documentTypeLabel;
    private JRadioButton documentTypePDFRadio;
    private JRadioButton documentTypeRTFRadio;
    private JLabel encryptedLabel;
    private JRadioButton encryptedYesRadio;
    private JRadioButton encryptedNoRadio;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JLabel pageSizeLabel;
    private JTextField pageSizeWidthField;
    private JLabel pageSizeXLabel;
    private JTextField pageSizeHeightField;
    private JComboBox<Unit> pageSizeUnitComboBox;
    private JComboBox<PageSize> pageSizeComboBox;
    private JLabel templateLabel;
    private MirthRTextScrollPane templateTextArea;

    public DocumentWriter() {
        this.initComponents();
        this.initLayout();
    }

    public String getConnectorName() {
        return new DocumentDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        DocumentDispatcherProperties properties = new DocumentDispatcherProperties();
        properties.setHost(this.directoryField.getText().replace('\\', '/'));
        properties.setOutputPattern(this.fileNameField.getText());
        if (this.documentTypePDFRadio.isSelected()) {
            properties.setDocumentType("pdf");
        } else {
            properties.setDocumentType("rtf");
        }
        properties.setEncrypt(this.encryptedYesRadio.isSelected());
        String writeToOption = "FILE";
        if (this.outputAttachmentRadioButton.isSelected()) {
            writeToOption = "ATTACHMENT";
        } else if (this.outputBothRadioButton.isSelected()) {
            writeToOption = "BOTH";
        }
        properties.setOutput(writeToOption);
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setPageWidth(this.pageSizeWidthField.getText());
        properties.setPageHeight(this.pageSizeHeightField.getText());
        properties.setPageUnit((Unit)this.pageSizeUnitComboBox.getSelectedItem());
        properties.setTemplate(this.templateTextArea.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        DocumentDispatcherProperties props = (DocumentDispatcherProperties)properties;
        this.directoryField.setText(props.getHost());
        this.fileNameField.setText(props.getOutputPattern());
        if (props.isEncrypt()) {
            this.encryptedYesRadio.setSelected(true);
            this.encryptedYesActionPerformed();
        } else {
            this.encryptedNoRadio.setSelected(true);
            this.encryptedNoActionPerformed();
        }
        this.outputFileRadioButton.setSelected(true);
        String writeToOptions = props.getOutput();
        if (StringUtils.isNotBlank((CharSequence)writeToOptions)) {
            if (writeToOptions.equalsIgnoreCase("BOTH")) {
                this.outputBothRadioButton.setSelected(true);
            } else if (writeToOptions.equalsIgnoreCase("ATTACHMENT")) {
                this.outputAttachmentRadioButton.setSelected(true);
            }
            this.updateFileEnabled(!writeToOptions.equalsIgnoreCase("ATTACHMENT"));
        }
        if (props.getDocumentType().equals("pdf")) {
            this.documentTypePDFRadio.setSelected(true);
            this.documentTypePDFRadioActionPerformed();
        } else {
            this.documentTypeRTFRadio.setSelected(true);
            this.documentTypeRTFRadioActionPerformed();
        }
        this.passwordField.setText(props.getPassword());
        this.pageSizeUpdating = true;
        this.pageSizeWidthField.setText(props.getPageWidth());
        this.pageSizeWidthField.setCaretPosition(0);
        this.pageSizeHeightField.setText(props.getPageHeight());
        this.pageSizeHeightField.setCaretPosition(0);
        this.pageSizeUnitComboBox.setSelectedItem(props.getPageUnit());
        this.pageSizeUpdating = false;
        this.updatePageSizeComboBox();
        this.templateTextArea.setText(props.getTemplate());
    }

    public ConnectorProperties getDefaults() {
        return new DocumentDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        DocumentDispatcherProperties props = (DocumentDispatcherProperties)properties;
        boolean valid = true;
        if (!this.outputAttachmentRadioButton.isSelected() && props.getHost().length() == 0) {
            valid = false;
            if (highlight) {
                this.directoryField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!this.outputAttachmentRadioButton.isSelected() && props.getOutputPattern().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileNameField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getTemplate().length() == 0) {
            valid = false;
            if (highlight) {
                this.templateTextArea.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isEncrypt() && props.getPassword().length() == 0) {
            valid = false;
            if (highlight) {
                this.passwordField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getPageWidth()) || NumberUtils.toDouble((String)props.getPageWidth(), (double)1.0) <= 0.0) {
            valid = false;
            if (highlight) {
                this.pageSizeWidthField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getPageHeight()) || NumberUtils.toDouble((String)props.getPageHeight(), (double)1.0) <= 0.0) {
            valid = false;
            if (highlight) {
                this.pageSizeHeightField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.directoryField.setBackground(null);
        this.fileNameField.setBackground(null);
        this.templateTextArea.setBackground(null);
        this.passwordField.setBackground(null);
        this.pageSizeWidthField.setBackground(null);
        this.pageSizeHeightField.setBackground(null);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.outputLabel = new JLabel("Output:");
        ButtonGroup outputButtonGroup = new ButtonGroup();
        this.outputFileRadioButton = new MirthRadioButton("File");
        this.outputFileRadioButton.setBackground(this.getBackground());
        this.outputFileRadioButton.setToolTipText("Write the contents to a file.");
        this.outputFileRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.updateFileEnabled(true);
            }
        });
        outputButtonGroup.add(this.outputFileRadioButton);
        this.outputAttachmentRadioButton = new MirthRadioButton("Attachment");
        this.outputAttachmentRadioButton.setBackground(this.getBackground());
        this.outputAttachmentRadioButton.setToolTipText("<html>Write the contents to an attachment. The destination's response message will contain the<br>attachment Id and can be used in subsequent connectors to include the attachment.</html>");
        this.outputAttachmentRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.updateFileEnabled(false);
            }
        });
        outputButtonGroup.add(this.outputAttachmentRadioButton);
        this.outputBothRadioButton = new MirthRadioButton("Both");
        this.outputBothRadioButton.setBackground(this.getBackground());
        this.outputBothRadioButton.setToolTipText("<html>Write the contents to a file and an attachment. The destination's response message will contain<br>the attachment Id and can be used in subsequent connectors to include the attachment.</html>");
        this.outputBothRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.updateFileEnabled(true);
            }
        });
        outputButtonGroup.add(this.outputBothRadioButton);
        this.directoryLabel = new JLabel("Directory:");
        this.directoryField = new MirthTextField();
        this.directoryField.setToolTipText("The directory (folder) where the generated file should be written.");
        this.testConnectionButton = new JButton("Test Write");
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.testConnection();
            }
        });
        this.fileNameLabel = new JLabel("File Name:");
        this.fileNameField = new MirthTextField();
        this.fileNameField.setToolTipText("The file name to give to the generated file.");
        this.documentTypeLabel = new JLabel("Document Type:");
        ButtonGroup documentTypeButtonGroup = new ButtonGroup();
        this.documentTypePDFRadio = new MirthRadioButton("PDF");
        this.documentTypePDFRadio.setBackground(this.getBackground());
        this.documentTypePDFRadio.setToolTipText("The type of document to be created for each message.");
        this.documentTypePDFRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.documentTypePDFRadioActionPerformed();
            }
        });
        documentTypeButtonGroup.add(this.documentTypePDFRadio);
        this.documentTypeRTFRadio = new MirthRadioButton("RTF");
        this.documentTypeRTFRadio.setBackground(this.getBackground());
        this.documentTypeRTFRadio.setToolTipText("The type of document to be created for each message.");
        this.documentTypeRTFRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.documentTypeRTFRadioActionPerformed();
            }
        });
        documentTypeButtonGroup.add(this.documentTypeRTFRadio);
        this.encryptedLabel = new JLabel("Encrypted:");
        ButtonGroup encryptedButtonGroup = new ButtonGroup();
        this.encryptedYesRadio = new MirthRadioButton("Yes");
        this.encryptedYesRadio.setBackground(this.getBackground());
        this.encryptedYesRadio.setToolTipText("If Document Type PDF is selected, generated documents can optionally be encrypted.");
        this.encryptedYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.encryptedYesActionPerformed();
            }
        });
        encryptedButtonGroup.add(this.encryptedYesRadio);
        this.encryptedNoRadio = new MirthRadioButton("No");
        this.encryptedNoRadio.setBackground(this.getBackground());
        this.encryptedNoRadio.setToolTipText("If Document Type PDF is selected, generated documents can optionally be encrypted.");
        this.encryptedNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.encryptedNoActionPerformed();
            }
        });
        encryptedButtonGroup.add(this.encryptedNoRadio);
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.passwordField.setToolTipText("If Encrypted Yes is selected, enter the password to be used to later view the document here.");
        this.pageSizeLabel = new JLabel("Page Size:");
        this.pageSizeXLabel = new JLabel("\u00d7");
        DocumentListener pageSizeDocumentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                DocumentWriter.this.updatePageSizeComboBox();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                DocumentWriter.this.updatePageSizeComboBox();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                DocumentWriter.this.updatePageSizeComboBox();
            }
        };
        this.pageSizeWidthField = new MirthTextField();
        this.pageSizeWidthField.getDocument().addDocumentListener(pageSizeDocumentListener);
        this.pageSizeWidthField.setToolTipText("<html>The width of the page. The units for the width<br/>are determined by the drop-down menu to the right.<br/>When rendering PDFs, a minimum of 26mm is enforced.</html>");
        this.pageSizeHeightField = new MirthTextField();
        this.pageSizeHeightField.getDocument().addDocumentListener(pageSizeDocumentListener);
        this.pageSizeHeightField.setToolTipText("<html>The height of the page. The units for the height<br/>are determined by the drop-down menu to the right.<br/>When rendering PDFs, a minimum of 26mm is enforced.</html>");
        this.pageSizeUnitComboBox = new MirthComboBox();
        this.pageSizeUnitComboBox.setModel(new DefaultComboBoxModel<Unit>(Unit.values()));
        this.pageSizeUnitComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.updatePageSizeComboBox();
            }
        });
        this.pageSizeUnitComboBox.setToolTipText("The units to use for the page width and height.");
        this.pageSizeComboBox = new MirthComboBox();
        this.pageSizeComboBox.setModel(new DefaultComboBoxModel<PageSize>((PageSize[])ArrayUtils.subarray((Object[])PageSize.values(), (int)0, (int)(PageSize.values().length - 1))));
        this.pageSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentWriter.this.pageSizeComboBoxActionPerformed();
            }
        });
        this.pageSizeComboBox.setToolTipText("Select a standard page size to use, or enter a custom page size.");
        this.templateLabel = new JLabel("HTML Template:");
        this.templateTextArea = new MirthRTextScrollPane(ContextType.DESTINATION_DISPATCHER, false, "text/html", false);
        this.templateTextArea.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, gap 6", "[]12[]", "[]4[]6[]4[]4[]4[]6[]6[]"));
        this.add(this.outputLabel, "right");
        this.add(this.outputFileRadioButton, "split 3");
        this.add(this.outputAttachmentRadioButton);
        this.add(this.outputBothRadioButton);
        this.add(this.directoryLabel, "newline, right");
        this.add(this.directoryField, "w 200!, split 2");
        this.add(this.testConnectionButton, "gapbefore 6");
        this.add(this.fileNameLabel, "newline, right");
        this.add(this.fileNameField, "w 200!");
        this.add(this.documentTypeLabel, "newline, right");
        this.add(this.documentTypePDFRadio, "split 2");
        this.add(this.documentTypeRTFRadio);
        this.add(this.encryptedLabel, "newline, right");
        this.add(this.encryptedYesRadio, "split 2");
        this.add(this.encryptedNoRadio);
        this.add(this.passwordLabel, "newline, right");
        this.add(this.passwordField, "w 124!");
        this.add(this.pageSizeLabel, "newline, right");
        this.add(this.pageSizeWidthField, "w 54!, split 5");
        this.add(this.pageSizeXLabel);
        this.add(this.pageSizeHeightField, "w 54!");
        this.add(this.pageSizeUnitComboBox, "gapbefore 6");
        this.add(this.pageSizeComboBox, "gapbefore 6");
        this.add(this.templateLabel, "newline, right, top");
        this.add((Component)this.templateTextArea, "grow, push, w :500, h :150");
    }

    private void testConnection() {
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    DocumentWriter.this.parent.alertError((Component)DocumentWriter.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    DocumentWriter.this.parent.alertInformation((Component)DocumentWriter.this.parent, connectionTestResponse.getMessage());
                } else {
                    DocumentWriter.this.parent.alertWarning((Component)DocumentWriter.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((DocumentConnectorServletInterface)this.getServlet(DocumentConnectorServletInterface.class, "Testing file write...", "Error testing file write: ", handler)).testWrite(this.getChannelId(), this.getChannelName(), ((DocumentDispatcherProperties)this.getProperties()).getHost());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void updateFileEnabled(boolean enable) {
        this.fileNameLabel.setEnabled(enable);
        this.fileNameField.setEnabled(enable);
        this.directoryLabel.setEnabled(enable);
        this.directoryField.setEnabled(enable);
        this.testConnectionButton.setEnabled(enable);
    }

    private void documentTypePDFRadioActionPerformed() {
        if (this.encryptedYesRadio.isSelected()) {
            this.encryptedYesActionPerformed();
        } else {
            this.encryptedNoActionPerformed();
        }
        this.encryptedLabel.setEnabled(true);
        this.encryptedYesRadio.setEnabled(true);
        this.encryptedNoRadio.setEnabled(true);
    }

    private void documentTypeRTFRadioActionPerformed() {
        this.encryptedLabel.setEnabled(false);
        this.encryptedYesRadio.setEnabled(false);
        this.encryptedNoRadio.setEnabled(false);
        this.encryptedNoActionPerformed();
    }

    private void encryptedYesActionPerformed() {
        this.passwordLabel.setEnabled(true);
        this.passwordField.setEnabled(true);
    }

    private void encryptedNoActionPerformed() {
        this.passwordLabel.setEnabled(false);
        this.passwordField.setEnabled(false);
    }

    private void updatePageSizeComboBox() {
        if (this.pageSizeUpdating) {
            return;
        }
        this.pageSizeUpdating = true;
        try {
            double width = Double.parseDouble(this.pageSizeWidthField.getText());
            double height = Double.parseDouble(this.pageSizeHeightField.getText());
            Unit unit = (Unit)this.pageSizeUnitComboBox.getSelectedItem();
            PageSize matchingPageSize = null;
            for (PageSize pageSize : PageSize.values()) {
                if (pageSize == PageSize.CUSTOM || pageSize.getWidth(unit) != width || pageSize.getHeight(unit) != height) continue;
                matchingPageSize = pageSize;
                break;
            }
            if (matchingPageSize != null) {
                this.pageSizeComboBox.setModel(new DefaultComboBoxModel<PageSize>((PageSize[])ArrayUtils.subarray((Object[])PageSize.values(), (int)0, (int)(PageSize.values().length - 1))));
                this.pageSizeComboBox.setSelectedItem(matchingPageSize);
                this.pageSizeUpdating = false;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageSizeComboBox.setModel(new DefaultComboBoxModel<PageSize>(PageSize.values()));
        this.pageSizeComboBox.setSelectedItem(PageSize.CUSTOM);
        this.pageSizeUpdating = false;
    }

    private void pageSizeComboBoxActionPerformed() {
        if (this.pageSizeUpdating) {
            return;
        }
        this.pageSizeUpdating = true;
        PageSize pageSize = (PageSize)this.pageSizeComboBox.getSelectedItem();
        if (pageSize != PageSize.CUSTOM) {
            this.pageSizeComboBox.setModel(new DefaultComboBoxModel<PageSize>((PageSize[])ArrayUtils.subarray((Object[])PageSize.values(), (int)0, (int)(PageSize.values().length - 1))));
            this.pageSizeComboBox.setSelectedItem(pageSize);
            this.pageSizeWidthField.setText(String.valueOf(new BigDecimal(pageSize.getWidth()).setScale(2, RoundingMode.DOWN)));
            this.pageSizeWidthField.setCaretPosition(0);
            this.pageSizeHeightField.setText(String.valueOf(new BigDecimal(pageSize.getHeight()).setScale(2, RoundingMode.DOWN)));
            this.pageSizeHeightField.setCaretPosition(0);
            this.pageSizeUnitComboBox.setSelectedItem(pageSize.getUnit());
        }
        this.pageSizeUpdating = false;
    }
}

