/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final WbemcliUtil.WmiQuery<ComputerSystemProductProperty> IDENTIFYINGNUMBER_QUERY = new WbemcliUtil.WmiQuery<ComputerSystemProductProperty>("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class);
    private String systemSerialNumber = "";

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery<ComputerSystemProperty> computerSystemQuery = new WbemcliUtil.WmiQuery<ComputerSystemProperty>("Win32_ComputerSystem", ComputerSystemProperty.class);
        WbemcliUtil.WmiResult<ComputerSystemProperty> win32ComputerSystem = WmiUtil.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.setManufacturer(WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MANUFACTURER, 0));
            this.setModel(WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MODEL, 0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        WbemcliUtil.WmiResult<ComputerSystemProductProperty> identifyingNumber;
        if (!"".equals(this.systemSerialNumber)) {
            return this.systemSerialNumber;
        }
        WbemcliUtil.WmiQuery<BiosProperty> serialNumberQuery = new WbemcliUtil.WmiQuery<BiosProperty>("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult<BiosProperty> serialNumber = WmiUtil.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.systemSerialNumber = WmiUtil.getString(serialNumber, BiosProperty.SERIALNUMBER, 0);
        }
        if ("".equals(this.systemSerialNumber) && (identifyingNumber = WmiUtil.queryWMI(IDENTIFYINGNUMBER_QUERY)).getResultCount() > 0) {
            this.systemSerialNumber = WmiUtil.getString(identifyingNumber, ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        if ("".equals(this.systemSerialNumber)) {
            this.systemSerialNumber = "unknown";
        }
        return this.systemSerialNumber;
    }

    static enum ComputerSystemProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum BiosProperty {
        SERIALNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }
}

