/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.message;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.ErrorContent;
import com.mirth.connect.donkey.model.message.MapContent;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Status;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

@XStreamAlias(value="connectorMessage")
public class ConnectorMessage
implements Serializable {
    private long messageId;
    private int metaDataId;
    private String channelId;
    private String channelName;
    private String connectorName;
    private String serverId;
    private Calendar receivedDate;
    private Status status;
    private MessageContent raw;
    private MessageContent processedRaw;
    private MessageContent transformed;
    private MessageContent encoded;
    private MessageContent sent;
    private MessageContent response;
    private MessageContent responseTransformed;
    private MessageContent processedResponse;
    private MapContent sourceMapContent = new MapContent();
    private MapContent connectorMapContent = new MapContent();
    private MapContent channelMapContent = new MapContent();
    private MapContent responseMapContent = new MapContent();
    private Map<String, Object> metaDataMap = new HashMap<String, Object>();
    private ErrorContent processingErrorContent = new ErrorContent();
    private ErrorContent postProcessorErrorContent = new ErrorContent();
    private ErrorContent responseErrorContent = new ErrorContent();
    private int errorCode = 0;
    private int sendAttempts = 0;
    private Calendar sendDate;
    private Calendar responseDate;
    private int chainId;
    private int orderId;
    private transient ConnectorProperties sentProperties;
    private transient Integer queueBucket;
    private transient boolean attemptedFirst;
    private transient long dispatcherId;

    public ConnectorMessage() {
    }

    public ConnectorMessage(String channelId, String channelName, long messageId, int metaDataId, String serverId, Calendar receivedDate, Status status) {
        this.channelId = channelId;
        this.channelName = channelName;
        this.messageId = messageId;
        this.metaDataId = metaDataId;
        this.serverId = serverId;
        this.receivedDate = receivedDate;
        this.status = status;
    }

    public int getMetaDataId() {
        return this.metaDataId;
    }

    public void setMetaDataId(int metaDataId) {
        this.metaDataId = metaDataId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Calendar receivedDate) {
        this.receivedDate = receivedDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public MessageContent getMessageContent(ContentType contentType) {
        switch (contentType) {
            case RAW: {
                return this.raw;
            }
            case PROCESSED_RAW: {
                return this.processedRaw;
            }
            case TRANSFORMED: {
                return this.transformed;
            }
            case ENCODED: {
                return this.encoded;
            }
            case SENT: {
                return this.sent;
            }
            case RESPONSE: {
                return this.response;
            }
            case RESPONSE_TRANSFORMED: {
                return this.responseTransformed;
            }
            case PROCESSED_RESPONSE: {
                return this.processedResponse;
            }
        }
        return null;
    }

    public void setMessageContent(MessageContent messageContent) {
        switch (messageContent.getContentType()) {
            case RAW: {
                this.setRaw(messageContent);
                break;
            }
            case PROCESSED_RAW: {
                this.setProcessedRaw(messageContent);
                break;
            }
            case TRANSFORMED: {
                this.setTransformed(messageContent);
                break;
            }
            case ENCODED: {
                this.setEncoded(messageContent);
                break;
            }
            case SENT: {
                this.setSent(messageContent);
                break;
            }
            case RESPONSE: {
                this.setResponse(messageContent);
                break;
            }
            case RESPONSE_TRANSFORMED: {
                this.setResponseTransformed(messageContent);
                break;
            }
            case PROCESSED_RESPONSE: {
                this.setProcessedResponse(messageContent);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized content type: " + messageContent.getContentType().getContentTypeCode());
            }
        }
    }

    public MessageContent getRaw() {
        return this.raw;
    }

    public void setRaw(MessageContent messageContentRaw) {
        this.raw = messageContentRaw;
    }

    public MessageContent getProcessedRaw() {
        return this.processedRaw;
    }

    public void setProcessedRaw(MessageContent processedRaw) {
        this.processedRaw = processedRaw;
    }

    public MessageContent getTransformed() {
        return this.transformed;
    }

    public void setTransformed(MessageContent messageContentTransformed) {
        this.transformed = messageContentTransformed;
    }

    public MessageContent getEncoded() {
        return this.encoded;
    }

    public void setEncoded(MessageContent messageContentEncoded) {
        this.encoded = messageContentEncoded;
    }

    public MessageContent getSent() {
        return this.sent;
    }

    public void setSent(MessageContent messageContentSent) {
        this.sent = messageContentSent;
    }

    public MessageContent getResponse() {
        return this.response;
    }

    public void setResponse(MessageContent messageContentResponse) {
        this.response = messageContentResponse;
    }

    public MessageContent getResponseTransformed() {
        return this.responseTransformed;
    }

    public void setResponseTransformed(MessageContent responseTransformed) {
        this.responseTransformed = responseTransformed;
    }

    public MessageContent getProcessedResponse() {
        return this.processedResponse;
    }

    public void setProcessedResponse(MessageContent processedResponse) {
        this.processedResponse = processedResponse;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public MapContent getSourceMapContent() {
        return this.sourceMapContent;
    }

    public void setSourceMapContent(MapContent sourceMapContent) {
        this.sourceMapContent = sourceMapContent;
    }

    public MapContent getConnectorMapContent() {
        return this.connectorMapContent;
    }

    public void setConnectorMapContent(MapContent connectorMapContent) {
        this.connectorMapContent = connectorMapContent;
    }

    public MapContent getChannelMapContent() {
        return this.channelMapContent;
    }

    public void setChannelMapContent(MapContent channelMapContent) {
        this.channelMapContent = channelMapContent;
    }

    public MapContent getResponseMapContent() {
        return this.responseMapContent;
    }

    public void setResponseMapContent(MapContent responseMapContent) {
        this.responseMapContent = responseMapContent;
    }

    public Map<String, Object> getSourceMap() {
        return this.sourceMapContent.getMap();
    }

    public void setSourceMap(Map<String, Object> sourceMap) {
        this.sourceMapContent.setMap(sourceMap);
    }

    public Map<String, Object> getConnectorMap() {
        return this.connectorMapContent.getMap();
    }

    public void setConnectorMap(Map<String, Object> connectorMap) {
        this.connectorMapContent.setMap(connectorMap);
    }

    public Map<String, Object> getChannelMap() {
        return this.channelMapContent.getMap();
    }

    public void setChannelMap(Map<String, Object> channelMap) {
        this.channelMapContent.setMap(channelMap);
    }

    public Map<String, Object> getResponseMap() {
        return this.responseMapContent.getMap();
    }

    public void setResponseMap(Map<String, Object> responseMap) {
        this.responseMapContent.setMap(responseMap);
    }

    public Map<String, Object> getMetaDataMap() {
        return this.metaDataMap;
    }

    public void setMetaDataMap(Map<String, Object> metaDataMap) {
        this.metaDataMap = metaDataMap;
    }

    public ErrorContent getProcessingErrorContent() {
        return this.processingErrorContent;
    }

    public void setProcessingErrorContent(ErrorContent processingErrorContent) {
        this.processingErrorContent = processingErrorContent;
    }

    public ErrorContent getPostProcessorErrorContent() {
        return this.postProcessorErrorContent;
    }

    public void setPostProcessorErrorContent(ErrorContent postProcessorErrorContent) {
        this.postProcessorErrorContent = postProcessorErrorContent;
    }

    public ErrorContent getResponseErrorContent() {
        return this.responseErrorContent;
    }

    public void setResponseErrorContent(ErrorContent responseErrorContent) {
        this.responseErrorContent = responseErrorContent;
    }

    public String getProcessingError() {
        return this.processingErrorContent.getContent();
    }

    public void setProcessingError(String processingError) {
        this.processingErrorContent.setContent(processingError);
        this.updateErrorCode();
    }

    public String getPostProcessorError() {
        return this.postProcessorErrorContent.getContent();
    }

    public void setPostProcessorError(String postProcessorError) {
        this.postProcessorErrorContent.setContent(postProcessorError);
        this.updateErrorCode();
    }

    public String getResponseError() {
        return this.responseErrorContent.getContent();
    }

    public void setResponseError(String responseError) {
        this.responseErrorContent.setContent(responseError);
        this.updateErrorCode();
    }

    public boolean containsError(ContentType contentType) {
        int errorCode = contentType.getErrorCode();
        if (errorCode > 0) {
            return (this.errorCode & errorCode) == errorCode;
        }
        return false;
    }

    private void updateErrorCode() {
        this.errorCode = 0;
        if (this.getProcessingError() != null) {
            this.errorCode += ContentType.PROCESSING_ERROR.getErrorCode();
        }
        if (this.getPostProcessorError() != null) {
            this.errorCode += ContentType.POSTPROCESSOR_ERROR.getErrorCode();
        }
        if (this.getResponseError() != null) {
            this.errorCode += ContentType.RESPONSE_ERROR.getErrorCode();
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getSendAttempts() {
        return this.sendAttempts;
    }

    public void setSendAttempts(int sendAttempts) {
        this.sendAttempts = sendAttempts;
    }

    public Calendar getSendDate() {
        return this.sendDate;
    }

    public void setSendDate(Calendar sendDate) {
        this.sendDate = sendDate;
    }

    public Calendar getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(Calendar responseDate) {
        this.responseDate = responseDate;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public ConnectorProperties getSentProperties() {
        return this.sentProperties;
    }

    public void setSentProperties(ConnectorProperties sentProperties) {
        this.sentProperties = sentProperties;
    }

    public Integer getQueueBucket() {
        return this.queueBucket;
    }

    public void setQueueBucket(Integer queueBucket) {
        this.queueBucket = queueBucket;
    }

    public boolean isAttemptedFirst() {
        return this.attemptedFirst;
    }

    public void setAttemptedFirst(boolean attemptedFirst) {
        this.attemptedFirst = attemptedFirst;
    }

    public long getDispatcherId() {
        return this.dispatcherId;
    }

    public void setDispatcherId(long dispatcherId) {
        this.dispatcherId = dispatcherId;
    }

    public String toString() {
        return "message " + this.messageId + "-" + this.metaDataId + " (" + String.valueOf((Object)this.status) + ")";
    }
}

