/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.message;

import com.mirth.connect.donkey.model.message.attachment.Attachment;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawMessage
implements Serializable {
    private boolean overwrite;
    private boolean imported;
    private Long originalMessageId;
    private String rawData;
    private byte[] rawBytes;
    private Collection<Integer> destinationMetaDataIds;
    private Map<String, Object> sourceMap = new HashMap<String, Object>();
    private Boolean binary;
    private List<Attachment> attachments;

    public RawMessage(String rawData) {
        this(rawData, null);
    }

    public RawMessage(String rawData, Collection<Integer> destinationMetaDataIds) {
        this(rawData, destinationMetaDataIds, null);
    }

    public RawMessage(String rawData, Collection<Integer> destinationMetaDataIds, Map<String, Object> sourceMap) {
        this(rawData, destinationMetaDataIds, sourceMap, null);
    }

    public RawMessage(String rawData, Collection<Integer> destinationMetaDataIds, Map<String, Object> sourceMap, List<Attachment> attachments) {
        this.rawData = rawData;
        if (sourceMap != null) {
            this.setSourceMap(sourceMap);
        }
        this.destinationMetaDataIds = destinationMetaDataIds;
        this.binary = false;
        this.attachments = attachments;
    }

    public RawMessage(byte[] rawBytes) {
        this(rawBytes, null);
    }

    public RawMessage(byte[] rawBytes, Collection<Integer> destinationMetaDataIds) {
        this(rawBytes, destinationMetaDataIds, null);
    }

    public RawMessage(byte[] rawBytes, Collection<Integer> destinationMetaDataIds, Map<String, Object> sourceMap) {
        this(rawBytes, destinationMetaDataIds, sourceMap, null);
    }

    public RawMessage(byte[] rawBytes, Collection<Integer> destinationMetaDataIds, Map<String, Object> sourceMap, List<Attachment> attachments) {
        this.rawBytes = rawBytes;
        if (sourceMap != null) {
            this.setSourceMap(sourceMap);
        }
        this.destinationMetaDataIds = destinationMetaDataIds;
        this.binary = true;
        this.attachments = attachments;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public Long getOriginalMessageId() {
        return this.originalMessageId;
    }

    public void setOriginalMessageId(Long messageId) {
        this.originalMessageId = messageId;
    }

    public String getRawData() {
        return this.rawData == null ? "" : this.rawData;
    }

    public byte[] getRawBytes() {
        return this.rawBytes == null ? new byte[]{} : this.rawBytes;
    }

    public Collection<Integer> getDestinationMetaDataIds() {
        return this.destinationMetaDataIds;
    }

    public void setDestinationMetaDataIds(Collection<Integer> destinationMetaDataIds) {
        this.destinationMetaDataIds = destinationMetaDataIds;
    }

    public Map<String, Object> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<String, Object> sourceMap) {
        this.sourceMap = sourceMap;
    }

    public Boolean isBinary() {
        return this.binary;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void clearMessage() {
        this.rawBytes = null;
        this.rawData = null;
        this.attachments = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("overwrite=").append(this.overwrite).append(", ");
        builder.append("imported=").append(this.imported).append(", ");
        builder.append("originalMessageId=").append(this.originalMessageId).append(", ");
        builder.append("destinationMetaDataIds=").append(this.destinationMetaDataIds).append(", ");
        builder.append("binary=").append(this.binary).append(", ");
        builder.append("attachmentCount=").append(this.attachments != null ? this.attachments.size() : 0).append(']');
        return builder.toString();
    }
}

