/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util.purge;

import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.controllers.ChannelController;
import com.mirth.connect.donkey.util.purge.Purgable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PurgeUtil {
    public static Integer countLines(String data) {
        if (data == null) {
            return null;
        }
        return data.split("\r\n|\r|\n").length;
    }

    public static Integer countChars(String data) {
        if (data == null) {
            return null;
        }
        return data.length();
    }

    private static Map.Entry<?, ?> getPurgedEntry(Map.Entry<?, ?> originalEntry) {
        Object originalKey = originalEntry.getKey();
        Object originalValue = originalEntry.getValue();
        Object key = StringUtils.uncapitalize((String)originalKey.toString());
        Object value = originalValue;
        if (originalValue instanceof String[]) {
            key = (String)key + "Count";
            value = ArrayUtils.getLength(originalValue);
        } else if (originalValue instanceof ArrayList) {
            key = (String)key + "Count";
            value = ((ArrayList)originalValue).size();
        } else if (originalValue instanceof Map) {
            key = (String)key + "Count";
            value = ((Map)originalValue).size();
        } else {
            return null;
        }
        return new AbstractMap.SimpleEntry(key, value);
    }

    public static Map<?, ?> getPurgedMap(Map<?, ?> originalEntry) {
        HashMap purgedData = new HashMap();
        for (Map.Entry<?, ?> entry : originalEntry.entrySet()) {
            Map.Entry<?, ?> purgedEntry = PurgeUtil.getPurgedEntry(entry);
            if (purgedEntry == null) continue;
            purgedData.put(purgedEntry.getKey().toString(), purgedEntry.getValue());
        }
        return purgedData;
    }

    public static String getNumericValue(String data) {
        if (data == null) {
            return null;
        }
        String value = null;
        if (NumberUtils.isNumber((String)data)) {
            value = data;
        } else if (data.isEmpty()) {
            value = "";
        }
        return value;
    }

    public static List<Map<String, Object>> purgeList(List<?> originalList) {
        ArrayList<Map<String, Object>> purgedList = new ArrayList<Map<String, Object>>();
        for (Object object : originalList) {
            if (!(object instanceof Purgable)) continue;
            purgedList.add(((Purgable)object).getPurgedProperties());
        }
        return purgedList;
    }

    public static Map<Status, Long> getMessageStatistics(String channelId, Integer metaDataId) {
        ChannelController donkeyChannelController = ChannelController.getInstance();
        Statistics totalStats = donkeyChannelController.getTotalStatistics();
        Map<Status, Long> lifetimeStats = new HashMap<Status, Long>();
        if (totalStats != null) {
            lifetimeStats = totalStats.getConnectorStats(channelId, metaDataId);
        }
        return lifetimeStats;
    }
}

