/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server;

import com.google.inject.Inject;
import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.DBCPConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.HikariConnectionPool;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DonkeyConnectionPools {
    @Inject
    private static volatile DonkeyConnectionPools instance = null;
    private ConnectionPool connectionPool;
    private ConnectionPool readOnlyConnectionPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DonkeyConnectionPools getInstance() {
        DonkeyConnectionPools connectionPools = instance;
        if (connectionPools != null) return connectionPools;
        Class<DonkeyConnectionPools> clazz = DonkeyConnectionPools.class;
        synchronized (DonkeyConnectionPools.class) {
            connectionPools = instance;
            if (connectionPools != null) return connectionPools;
            instance = connectionPools = new DonkeyConnectionPools();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return connectionPools;
        }
    }

    DonkeyConnectionPools() {
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public ConnectionPool getReadOnlyConnectionPool() {
        return this.readOnlyConnectionPool;
    }

    public void init(Properties dbProperties) {
        block7: {
            try {
                int maxConnections;
                String database = dbProperties.getProperty("database");
                String driver = dbProperties.getProperty("database.driver");
                String url = dbProperties.getProperty("database.url");
                String username = dbProperties.getProperty("database.username");
                String password = dbProperties.getProperty("database.password");
                String pool = dbProperties.getProperty("database.pool");
                boolean jdbc4 = Boolean.parseBoolean(dbProperties.getProperty("database.jdbc4"));
                String testQuery = dbProperties.getProperty("database.test-query");
                try {
                    maxConnections = Integer.parseInt(dbProperties.getProperty("database.max-connections"));
                }
                catch (NumberFormatException e) {
                    throw new Exception("Failed to read the database.max-connections configuration property");
                }
                this.connectionPool = this.createConnectionPool(database, driver, url, username, password, pool, jdbc4, testQuery, maxConnections, false);
                boolean splitReadWrite = Boolean.parseBoolean(dbProperties.getProperty("database.enable-read-write-split"));
                if (splitReadWrite) {
                    int readOnlyMaxConnections;
                    String readOnlyDatabase = dbProperties.getProperty("database-readonly", database);
                    String readOnlyDriver = dbProperties.getProperty("database-readonly.driver", driver);
                    String readOnlyUrl = dbProperties.getProperty("database-readonly.url", url);
                    String readOnlyUsername = dbProperties.getProperty("database-readonly.username", username);
                    String readOnlyPassword = dbProperties.getProperty("database-readonly.password", password);
                    String readOnlyPool = dbProperties.getProperty("database-readonly.pool", pool);
                    boolean readOnlyJdbc4 = Boolean.parseBoolean(dbProperties.getProperty("database-readonly.jdbc4", dbProperties.getProperty("database.jdbc4")));
                    String readOnlyTestQuery = dbProperties.getProperty("database-readonly.test-query", testQuery);
                    try {
                        readOnlyMaxConnections = Integer.parseInt(dbProperties.getProperty("database-readonly.max-connections", dbProperties.getProperty("database.max-connections")));
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Failed to read the database-readonly.max-connections configuration property");
                    }
                    this.readOnlyConnectionPool = this.createConnectionPool(readOnlyDatabase, readOnlyDriver, readOnlyUrl, readOnlyUsername, readOnlyPassword, readOnlyPool, readOnlyJdbc4, readOnlyTestQuery, readOnlyMaxConnections, true);
                    break block7;
                }
                this.readOnlyConnectionPool = this.connectionPool;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ConnectionPool createConnectionPool(String database, String driver, String url, String username, String password, String pool, boolean jdbc4, String testQuery, int maxConnections, boolean readOnly) throws Exception {
        if (driver != null) {
            Class.forName(driver);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)pool, (CharSequence)"DBCP")) {
            return new DBCPConnectionPool(url, username, password, maxConnections, readOnly);
        }
        return new HikariConnectionPool(driver, url, username, password, maxConnections, jdbc4, testQuery, readOnly);
    }
}

