/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.event.DeployedStateEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.DeployException;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.HaltException;
import com.mirth.connect.donkey.server.PauseException;
import com.mirth.connect.donkey.server.ResumeException;
import com.mirth.connect.donkey.server.StartException;
import com.mirth.connect.donkey.server.StopException;
import com.mirth.connect.donkey.server.UndeployException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.ChannelProcessLock;
import com.mirth.connect.donkey.server.channel.DestinationChain;
import com.mirth.connect.donkey.server.channel.DestinationChainProvider;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.QueueHandler;
import com.mirth.connect.donkey.server.channel.RecoveryTask;
import com.mirth.connect.donkey.server.channel.ResponseSelector;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.channel.components.PostProcessor;
import com.mirth.connect.donkey.server.channel.components.PreProcessor;
import com.mirth.connect.donkey.server.controllers.ChannelController;
import com.mirth.connect.donkey.server.controllers.MessageController;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.event.DeployedStateEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.event.EventDispatcher;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.queue.ConnectorMessageQueueDataSource;
import com.mirth.connect.donkey.server.queue.DestinationQueue;
import com.mirth.connect.donkey.server.queue.SourceQueue;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.ThreadUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Channel
implements Runnable {
    private String channelId;
    private long localChannelId;
    private String name;
    private String serverId;
    private int revision;
    private Calendar deployDate;
    private Set<String> resourceIds;
    private String contextFactoryId;
    private DeployedState initialState;
    private DeployedState currentState = DeployedState.STOPPED;
    private StorageSettings storageSettings = new StorageSettings();
    private DonkeyDaoFactory daoFactory;
    private EventDispatcher eventDispatcher = Donkey.getInstance().getEventDispatcher();
    private Serializer serializer = Donkey.getInstance().getSerializer();
    private MessageMaps messageMaps;
    private AttachmentHandlerProvider attachmentHandlerProvider;
    private List<MetaDataColumn> metaDataColumns = new ArrayList<MetaDataColumn>();
    private SourceConnector sourceConnector;
    private int processingThreads;
    private SourceQueue sourceQueue;
    private Map<Long, Thread> queueThreads = new ConcurrentHashMap<Long, Thread>();
    private QueueHandler queueHandler;
    private PreProcessor preProcessor;
    private PostProcessor postProcessor;
    private List<DestinationChainProvider> destinationChainProviders = new ArrayList<DestinationChainProvider>();
    private ResponseSelector responseSelector;
    private DebugOptions debugOptions;
    public static Semaphore DELETE_PERMIT = new Semaphore(2, true);
    private ExecutorService channelExecutor;
    private Set<Thread> dispatchThreads = new HashSet<Thread>();
    private volatile boolean shuttingDown = false;
    private volatile boolean stopSourceQueue = false;
    private ChannelProcessLock processLock;
    private Lock removeContentLock = new ReentrantLock(true);
    private MessageController messageController = MessageController.getInstance();
    private Logger logger = LogManager.getLogger(this.getClass());

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public void setLocalChannelId(long localChannelId) {
        this.localChannelId = localChannelId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public Calendar getDeployDate() {
        return this.deployDate;
    }

    public void setDeployDate(Calendar deployedDate) {
        this.deployDate = deployedDate;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public String getContextFactoryId() {
        return this.contextFactoryId;
    }

    public void setContextFactoryId(String contextFactoryId) {
        this.contextFactoryId = contextFactoryId;
    }

    public DeployedState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(DeployedState initialState) {
        this.initialState = initialState;
    }

    public DeployedState getCurrentState() {
        return this.currentState;
    }

    public void updateCurrentState(DeployedState currentState) {
        this.currentState = currentState;
        this.eventDispatcher.dispatchEvent(new DeployedStateEvent(this.channelId, this.name, null, null, DeployedStateEventType.getTypeFromDeployedState(currentState)));
    }

    public StorageSettings getStorageSettings() {
        return this.storageSettings;
    }

    public void setStorageSettings(StorageSettings storageSettings) {
        this.storageSettings = storageSettings;
    }

    public DonkeyDaoFactory getDaoFactory() {
        return this.daoFactory;
    }

    public void setDaoFactory(DonkeyDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected Serializer getSerializer() {
        return this.serializer;
    }

    public MessageMaps getMessageMaps() {
        return this.messageMaps;
    }

    public void setMessageMaps(MessageMaps messageMaps) {
        this.messageMaps = messageMaps;
    }

    public AttachmentHandlerProvider getAttachmentHandlerProvider() {
        return this.attachmentHandlerProvider;
    }

    public void setAttachmentHandlerProvider(AttachmentHandlerProvider attachmentHandlerProvider) {
        this.attachmentHandlerProvider = attachmentHandlerProvider;
    }

    public List<MetaDataColumn> getMetaDataColumns() {
        return this.metaDataColumns;
    }

    public void setMetaDataColumns(List<MetaDataColumn> metaDataColumns) {
        this.metaDataColumns = metaDataColumns;
    }

    public SourceConnector getSourceConnector() {
        return this.sourceConnector;
    }

    public void setSourceConnector(SourceConnector sourceConnector) {
        this.sourceConnector = sourceConnector;
    }

    public int getProcessingThreads() {
        return this.processingThreads;
    }

    public SourceQueue getSourceQueue() {
        return this.sourceQueue;
    }

    public void setSourceQueue(SourceQueue sourceQueue) {
        this.sourceQueue = sourceQueue;
    }

    public QueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    public void setQueueHandler(QueueHandler queueHandler) {
        this.queueHandler = queueHandler;
    }

    public PreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public void setPreProcessor(PreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void addDestinationChainProvider(DestinationChainProvider chainProvider) {
        this.destinationChainProviders.add(chainProvider);
        chainProvider.setChainId(this.destinationChainProviders.size());
    }

    public List<DestinationChainProvider> getDestinationChainProviders() {
        return this.destinationChainProviders;
    }

    public ResponseSelector getResponseSelector() {
        return this.responseSelector;
    }

    public void setResponseSelector(ResponseSelector responseSelector) {
        this.responseSelector = responseSelector;
    }

    public ChannelProcessLock getProcessLock() {
        return this.processLock;
    }

    public void setProcessLock(ChannelProcessLock processLock) {
        this.processLock = processLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatchThread(Thread thread) {
        Set<Thread> set = this.dispatchThreads;
        synchronized (set) {
            this.dispatchThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDispatchThread(Thread thread) {
        Set<Thread> set = this.dispatchThreads;
        synchronized (set) {
            this.dispatchThreads.remove(thread);
        }
    }

    public boolean isActive() {
        return this.currentState != DeployedState.STOPPED && this.currentState != DeployedState.STOPPING;
    }

    public boolean isConfigurationValid() {
        if (this.channelId == null || this.daoFactory == null || this.sourceConnector == null || this.sourceConnector.getFilterTransformerExecutor() == null) {
            return false;
        }
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                if (chainProvider.getDestinationConnectors().get(metaDataId).getFilterTransformerExecutor() != null) continue;
                return false;
            }
        }
        return true;
    }

    public int getDestinationCount() {
        int numDestinations = 0;
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            numDestinations += chainProvider.getDestinationConnectors().size();
        }
        return numDestinations;
    }

    public DestinationConnector getDestinationConnector(int metaDataId) {
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            DestinationConnector destinationConnector = chainProvider.getDestinationConnectors().get(metaDataId);
            if (destinationConnector == null) continue;
            return destinationConnector;
        }
        return null;
    }

    public List<Integer> getMetaDataIds() {
        ArrayList<Integer> metaDataIds = new ArrayList<Integer>();
        metaDataIds.add(this.getSourceConnector().getMetaDataId());
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            metaDataIds.addAll(chainProvider.getMetaDataIds());
        }
        return metaDataIds;
    }

    public boolean isUsingDestinationQueues() {
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (DestinationConnector destinationConnector : chainProvider.getDestinationConnectors().values()) {
                if (!destinationConnector.isQueueEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateQueues() {
        this.sourceQueue.invalidate(true, false);
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                DestinationQueue queue = chainProvider.getDestinationConnectors().get(metaDataId).getQueue();
                Lock lock = queue.getInvalidationLock();
                lock.lock();
                try {
                    queue.invalidate(true, false);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public synchronized void deploy() throws DeployException {
        this.deploy(null);
    }

    public synchronized void debugDeploy(DebugOptions debugOptions) throws DeployException {
        this.deploy(debugOptions);
    }

    public synchronized void deploy(DebugOptions debugOptions) throws DeployException {
        if (!this.isConfigurationValid()) {
            throw new DeployException("Failed to deploy channel. The channel configuration is incomplete.");
        }
        ChannelController.getInstance().initChannelStorage(this.channelId);
        if (!(this.sourceConnector.isRespondAfterProcessing() || this.storageSettings.isEnabled() && this.storageSettings.isStoreRaw() && (this.storageSettings.isStoreMaps() || this.storageSettings.isRawDurable()))) {
            throw new DeployException("Failed to deploy channel " + this.name + " (" + this.channelId + "): the source connector has queueing enabled, but the current storage settings do not support queueing on the source connector.");
        }
        for (DestinationChainProvider destinationChainProvider : this.destinationChainProviders) {
            for (Integer n : destinationChainProvider.getMetaDataIds()) {
                DestinationConnector destinationConnector = destinationChainProvider.getDestinationConnectors().get(n);
                if (!destinationConnector.isQueueEnabled() || this.storageSettings.isEnabled() && this.storageSettings.isStoreSourceEncoded() && this.storageSettings.isStoreSent() && this.storageSettings.isStoreMaps()) continue;
                throw new DeployException("Failed to deploy channel " + this.name + " (" + this.channelId + "): one or more destination connectors have queueing enabled, but the current storage settings do not support queueing on destination connectors.");
            }
        }
        try {
            this.updateMetaDataColumns();
        }
        catch (SQLException e) {
            throw new DeployException("Failed to deploy channel " + this.name + " (" + this.channelId + "): Unable to update custom metadata columns.");
        }
        ArrayList<Integer> deployedMetaDataIds = new ArrayList<Integer>();
        try {
            if (this.responseSelector == null) {
                this.responseSelector = new ResponseSelector(this.sourceConnector.getInboundDataType());
            }
            if (this.queueHandler != null) {
                this.sourceQueue.setDataSource(this.queueHandler.createSourceQueueDataSource(this.sourceConnector, this.daoFactory));
            } else {
                this.sourceQueue.setDataSource(new ConnectorMessageQueueDataSource(this.channelId, this.serverId, 0, Status.RECEIVED, false, this.daoFactory));
            }
            this.sourceQueue.updateSize();
            deployedMetaDataIds.add(0);
            if (debugOptions != null) {
                this.sourceConnector.onDebugDeploy(debugOptions);
            } else {
                this.sourceConnector.onDeploy();
            }
            if (this.sourceConnector.getBatchAdaptorFactory() != null) {
                this.sourceConnector.getBatchAdaptorFactory().onDeploy();
            }
            for (DestinationChainProvider destinationChainProvider : this.destinationChainProviders) {
                destinationChainProvider.setDaoFactory(this.daoFactory);
                destinationChainProvider.setStorageSettings(this.storageSettings);
                for (Integer metaDataId : destinationChainProvider.getMetaDataIds()) {
                    DestinationConnector destinationConnector = destinationChainProvider.getDestinationConnectors().get(metaDataId);
                    destinationConnector.setDaoFactory(this.daoFactory);
                    destinationConnector.setStorageSettings(this.storageSettings);
                    if (this.queueHandler != null) {
                        destinationConnector.getQueue().setDataSource(this.queueHandler.createDestinationQueueDataSource(destinationConnector, this.daoFactory));
                    } else {
                        destinationConnector.getQueue().setDataSource(new ConnectorMessageQueueDataSource(this.getChannelId(), this.getServerId(), destinationConnector.getMetaDataId(), Status.QUEUED, destinationConnector.isQueueRotate(), this.daoFactory));
                    }
                    destinationConnector.getQueue().updateSize();
                    deployedMetaDataIds.add(metaDataId);
                    if (debugOptions != null) {
                        destinationConnector.onDebugDeploy(debugOptions);
                        continue;
                    }
                    destinationConnector.onDeploy();
                }
            }
            this.responseSelector.setNumDestinations(this.getDestinationCount());
        }
        catch (Throwable throwable) {
            for (Integer n : deployedMetaDataIds) {
                try {
                    this.undeployConnector(n);
                }
                catch (Exception exception) {}
            }
            throw new DeployException("Failed to deploy channel " + this.name + " (" + this.channelId + ").", throwable);
        }
        Statistics statistics = ChannelController.getInstance().getStatistics();
        HashMap<Integer, Map<Status, Long>> hashMap = new HashMap<Integer, Map<Status, Long>>();
        HashMap<Status, Long> hashMap2 = new HashMap<Status, Long>(statistics.getConnectorStats(this.channelId, 0));
        hashMap2.put(Status.QUEUED, Long.valueOf(this.sourceQueue.size()));
        hashMap.put(0, hashMap2);
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                HashMap<Status, Long> hashMap3 = new HashMap<Status, Long>(statistics.getConnectorStats(this.channelId, metaDataId));
                hashMap3.put(Status.QUEUED, Long.valueOf(chainProvider.getDestinationConnectors().get(metaDataId).getQueue().size()));
                hashMap.put(metaDataId, hashMap3);
            }
        }
        this.eventDispatcher.dispatchEvent(new DeployedStateEvent(this.channelId, this.name, null, null, DeployedStateEventType.DEPLOYED, hashMap));
    }

    public synchronized void undeploy() throws UndeployException {
        this.updateCurrentState(DeployedState.UNDEPLOYING);
        Throwable firstCause = null;
        ArrayList<Integer> deployedMetaDataIds = new ArrayList<Integer>();
        deployedMetaDataIds.add(0);
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                deployedMetaDataIds.add(metaDataId);
            }
        }
        for (Integer metaDataId : deployedMetaDataIds) {
            try {
                this.undeployConnector(metaDataId);
            }
            catch (Throwable t) {
                if (firstCause != null) continue;
                firstCause = t;
            }
        }
        if (firstCause != null) {
            throw new UndeployException("Failed to undeploy channel " + this.name + " (" + this.channelId + "): One or more connectors failed to undeploy.", firstCause);
        }
        this.eventDispatcher.dispatchEvent(new DeployedStateEvent(this.channelId, this.name, null, null, DeployedStateEventType.UNDEPLOYED));
    }

    private void undeployConnector(Integer metaDataId) throws Exception {
        try {
            if (metaDataId == 0) {
                if (this.sourceConnector != null) {
                    BatchAdaptorFactory batchAdaptorFactory = this.sourceConnector.getBatchAdaptorFactory();
                    if (batchAdaptorFactory != null) {
                        batchAdaptorFactory.onUndeploy();
                    }
                    this.sourceConnector.onUndeploy();
                }
            } else {
                DestinationConnector destinationConnector = this.getDestinationConnector(metaDataId);
                if (destinationConnector != null) {
                    destinationConnector.onUndeploy();
                }
            }
        }
        catch (Exception e) {
            if (metaDataId == 0) {
                this.logger.error("Error undeploying Source connector for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
            } else {
                this.logger.error("Error undeploying destination connector \"" + this.getDestinationConnector(metaDataId).getDestinationName() + "\" for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
            }
            throw e;
        }
    }

    public void startSourceQueue() {
        this.stopSourceQueue = false;
        if (this.queueHandler == null || this.queueHandler.canStartSourceQueue()) {
            this.sourceQueue.invalidate(true, true);
            if (!this.sourceConnector.isRespondAfterProcessing()) {
                this.queueThreads.clear();
                for (int i = 1; i <= this.processingThreads; ++i) {
                    Thread queueThread = new Thread(this);
                    queueThread.setName("Source Queue Thread " + i + " on " + this.name + " (" + this.channelId + ")");
                    queueThread.start();
                    this.queueThreads.put(queueThread.getId(), queueThread);
                }
            }
        }
    }

    public void stopSourceQueue() throws InterruptedException {
        this.stopSourceQueue = true;
        if (MapUtils.isNotEmpty(this.queueThreads)) {
            for (Thread queueThread : this.queueThreads.values()) {
                queueThread.join();
            }
            this.queueThreads.clear();
        }
    }

    public void haltSourceQueue() {
        if (MapUtils.isNotEmpty(this.queueThreads)) {
            for (Thread queueThread : this.queueThreads.values()) {
                queueThread.interrupt();
            }
        }
    }

    public synchronized void start(Set<Integer> connectorsToStart) throws StartException {
        if (this.currentState == DeployedState.DEPLOYING || this.currentState == DeployedState.STOPPED) {
            ArrayList<Integer> startedMetaDataIds = new ArrayList<Integer>();
            try {
                ThreadUtils.checkInterruptedStatus();
                this.updateCurrentState(DeployedState.STARTING);
                this.processLock.reset();
                this.removeContentLock = new ReentrantLock(true);
                this.dispatchThreads.clear();
                this.shuttingDown = false;
                this.processingThreads = ((SourceConnectorPropertiesInterface)((Object)this.sourceConnector.getConnectorProperties())).getSourceConnectorProperties().getProcessingThreads();
                if (this.processingThreads < 1) {
                    this.processingThreads = 1;
                }
                this.sourceQueue.invalidate(true, true);
                this.channelExecutor = Executors.newCachedThreadPool();
                for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
                    for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                        DestinationConnector destinationConnector = chainProvider.getDestinationConnectors().get(metaDataId);
                        if (destinationConnector.getCurrentState() != DeployedState.STOPPED || connectorsToStart != null && !connectorsToStart.contains(metaDataId)) continue;
                        startedMetaDataIds.add(metaDataId);
                        destinationConnector.start();
                    }
                }
                ThreadUtils.checkInterruptedStatus();
                try {
                    this.processUnfinishedMessages();
                }
                catch (InterruptedException e) {
                    this.logger.error("Startup recovery interrupted for channel " + this.name + " (" + this.channelId + ")", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    Throwable cause = e instanceof ExecutionException ? e.getCause() : e;
                    this.logger.error("Startup recovery failed for channel " + this.name + " (" + this.channelId + "): " + cause.getMessage(), cause);
                }
                ThreadUtils.checkInterruptedStatus();
                for (Integer metaDataId : startedMetaDataIds) {
                    this.getDestinationConnector(metaDataId).startQueue();
                }
                this.startSourceQueue();
                if (connectorsToStart == null || connectorsToStart.contains(0)) {
                    ThreadUtils.checkInterruptedStatus();
                    if (this.sourceConnector.getCurrentState() == DeployedState.STOPPED) {
                        startedMetaDataIds.add(0);
                        this.sourceConnector.start();
                    }
                    this.updateCurrentState(DeployedState.STARTED);
                }
                this.updateCurrentState(DeployedState.PAUSED);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw new StartException("Start channel task for " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                }
                try {
                    this.updateCurrentState(DeployedState.STOPPING);
                    this.stop(startedMetaDataIds);
                    this.updateCurrentState(DeployedState.STOPPED);
                }
                catch (Throwable t2) {
                    if (t2 instanceof InterruptedException) {
                        throw new StartException("Start channel task for " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                    }
                    this.updateCurrentState(DeployedState.STOPPED);
                }
                throw new StartException("Failed to start channel " + this.name + " (" + this.channelId + ").", t);
            }
        } else {
            this.logger.warn("Failed to start channel " + this.name + " (" + this.channelId + "): The channel is already running.");
        }
    }

    public synchronized void stop() throws StopException {
        if (this.currentState != DeployedState.STOPPED) {
            try {
                this.updateCurrentState(DeployedState.STOPPING);
                ArrayList<Integer> deployedMetaDataIds = new ArrayList<Integer>();
                deployedMetaDataIds.add(0);
                for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
                    for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                        deployedMetaDataIds.add(metaDataId);
                    }
                }
                this.stop(deployedMetaDataIds);
                this.updateCurrentState(DeployedState.STOPPED);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw new StopException("Stop channel task for " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                }
                throw new StopException("Failed to stop channel " + this.name + " (" + this.channelId + ").", t);
            }
        } else {
            this.logger.warn("Failed to stop channel " + this.name + " (" + this.channelId + "): The channel is already stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() throws HaltException {
        Collection<Runnable> tasks;
        if (this.channelExecutor != null) {
            tasks = this.channelExecutor.shutdownNow();
            for (Runnable task : tasks) {
                if (!(task instanceof Future)) continue;
                ((Future)((Object)task)).cancel(true);
            }
        }
        this.haltSourceQueue();
        tasks = this.dispatchThreads;
        synchronized (tasks) {
            this.shuttingDown = true;
            for (Thread thread : this.dispatchThreads) {
                thread.interrupt();
            }
        }
        ArrayList<Integer> deployedMetaDataIds = new ArrayList<Integer>();
        deployedMetaDataIds.add(0);
        for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
            for (Integer metaDataId : chainProvider.getMetaDataIds()) {
                deployedMetaDataIds.add(metaDataId);
            }
        }
        for (Integer metaDataId : deployedMetaDataIds) {
            try {
                this.haltConnector(metaDataId);
            }
            catch (Throwable throwable) {}
        }
        Channel channel = this;
        synchronized (channel) {
            if (this.currentState != DeployedState.STOPPED) {
                try {
                    this.updateCurrentState(DeployedState.STOPPING);
                    this.halt(deployedMetaDataIds);
                    this.updateCurrentState(DeployedState.STOPPED);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        throw new HaltException("Halt channel task for " + this.name + " (" + this.channelId + ") terminated by another halt notification.", t);
                    }
                    throw new HaltException("Failed to halt channel " + this.name + " (" + this.channelId + ").", t);
                }
            } else {
                this.logger.warn("Failed to stop channel " + this.name + " (" + this.channelId + "): The channel is already stopped.");
            }
        }
    }

    public synchronized void pause() throws PauseException {
        if (this.currentState == DeployedState.STARTED) {
            try {
                this.updateCurrentState(DeployedState.PAUSING);
                this.sourceConnector.stop();
                this.updateCurrentState(DeployedState.PAUSED);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw new PauseException("Pause channel task for " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                }
                throw new PauseException("Failed to pause channel " + this.name + " (" + this.channelId + ").", t);
            }
        } else if (this.currentState == DeployedState.PAUSED) {
            this.logger.warn("Failed to pause channel " + this.name + " (" + this.channelId + "): The channel is already paused.");
        } else {
            this.logger.warn("Failed to pause channel " + this.name + " (" + this.channelId + "): The channel is currently " + this.currentState.toString().toLowerCase() + " and cannot be paused.");
        }
    }

    public synchronized void resume() throws ResumeException {
        if (this.currentState == DeployedState.PAUSED) {
            try {
                this.updateCurrentState(DeployedState.STARTING);
                this.sourceConnector.start();
                this.updateCurrentState(DeployedState.STARTED);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw new ResumeException("Resume channel task for " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                }
                try {
                    this.updateCurrentState(DeployedState.PAUSING);
                    this.sourceConnector.stop();
                    this.updateCurrentState(DeployedState.PAUSED);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ResumeException("Failed to resume channel " + this.name + " (" + this.channelId + ").", t);
            }
        }
        this.logger.warn("Failed to resume channel " + this.name + " (" + this.channelId + "): The source connector is not currently paused.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAllMessages(boolean force, boolean clearStatistics) throws InterruptedException {
        boolean startChannelAfter = false;
        HashSet<Integer> startMetaDataIds = new HashSet<Integer>();
        if (this.currentState != DeployedState.STOPPED && force) {
            if (this.sourceConnector.getCurrentState() != DeployedState.STOPPED) {
                startMetaDataIds.add(0);
            }
            for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
                for (DestinationConnector destinationConnector : chainProvider.getDestinationConnectors().values()) {
                    if (destinationConnector.getCurrentState() == DeployedState.STOPPED) continue;
                    startMetaDataIds.add(destinationConnector.getMetaDataId());
                }
            }
            try {
                this.stop();
                startChannelAfter = true;
            }
            catch (StopException e) {
                this.logger.error("Failed to stop channel " + this.name + " (" + this.channelId + ") in order to remove all messages.", (Throwable)e);
                return;
            }
        }
        if (this.currentState == DeployedState.STOPPED) {
            DELETE_PERMIT.acquire();
            try {
                DonkeyDao dao = this.getDaoFactory().getDao();
                boolean commitSuccess = false;
                try {
                    this.logger.debug("Removing messages for channel " + this.name + " (" + this.channelId + ").");
                    dao.deleteAllMessages(this.channelId);
                    if (clearStatistics) {
                        this.logger.debug("Clearing statistics for channel " + this.name + " (" + this.channelId + ").");
                        Set<Status> statuses = Statistics.getTrackedStatuses();
                        dao.resetStatistics(this.channelId, null, statuses);
                        for (Integer metaDataId : this.getMetaDataIds()) {
                            dao.resetStatistics(this.channelId, metaDataId, statuses);
                        }
                    }
                    dao.commit();
                    commitSuccess = true;
                }
                finally {
                    if (dao != null) {
                        if (!commitSuccess) {
                            try {
                                dao.rollback();
                            }
                            catch (Exception exception) {}
                        }
                        dao.close();
                    }
                }
            }
            finally {
                DELETE_PERMIT.release();
            }
            this.invalidateQueues();
        }
        if (startChannelAfter) {
            try {
                this.logger.debug("Restarting channel " + this.name + " (" + this.channelId + ") after removing all messages");
                this.start(startMetaDataIds);
            }
            catch (StartException e) {
                this.logger.error("Failed to start channel " + this.name + " (" + this.channelId + ") after removing all messages.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(List<Integer> metaDataIds) throws Throwable {
        Throwable firstCause;
        block22: {
            block20: {
                this.stopSourceQueue = true;
                firstCause = null;
                ThreadUtils.checkInterruptedStatus();
                try {
                    this.sourceConnector.stopDebugging();
                }
                catch (Throwable t) {
                    this.logger.error("Error stopping debugging on Source connector for channel " + this.name + " (" + this.channelId + ").", t);
                    if (firstCause != null) break block20;
                    firstCause = t;
                }
            }
            for (Integer metaDataId : metaDataIds) {
                block21: {
                    try {
                        if (metaDataId > 0) {
                            this.getDestinationConnector(metaDataId).stopDebugging();
                        }
                    }
                    catch (Throwable t) {
                        this.logger.error("Error stopping debugging on destination connector \"" + this.getDestinationConnector(metaDataId).getDestinationName() + "\" for channel " + this.name + " (" + this.channelId + ").", t);
                        if (firstCause != null) break block21;
                        firstCause = t;
                    }
                }
                ThreadUtils.checkInterruptedStatus();
            }
            ThreadUtils.checkInterruptedStatus();
            try {
                this.sourceConnector.stop();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                this.logger.error("Error stopping Source connector for channel " + this.name + " (" + this.channelId + ").", t);
                if (firstCause != null) break block22;
                firstCause = t;
            }
        }
        ThreadUtils.checkInterruptedStatus();
        int timeout = 10;
        while (true) {
            Set<Thread> set = this.dispatchThreads;
            synchronized (set) {
                if (this.dispatchThreads.size() == 0) {
                    this.shuttingDown = true;
                    this.obtainAllProcessLockPermits();
                    this.releaseAllProcessLockPermits();
                    break;
                }
            }
            Thread.sleep(10L);
        }
        for (Integer metaDataId : metaDataIds) {
            block23: {
                try {
                    if (metaDataId > 0) {
                        this.getDestinationConnector(metaDataId).stop();
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.logger.error("Error stopping destination connector \"" + this.getDestinationConnector(metaDataId).getDestinationName() + "\" for channel " + this.name + " (" + this.channelId + ").", t);
                    if (firstCause != null) break block23;
                    firstCause = t;
                }
            }
            ThreadUtils.checkInterruptedStatus();
        }
        this.stopSourceQueue();
        this.channelExecutor.shutdown();
        if (firstCause != null) {
            this.updateCurrentState(DeployedState.STOPPED);
            throw firstCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void halt(List<Integer> metaDataIds) throws Throwable {
        this.stopSourceQueue = true;
        List<Runnable> tasks = this.channelExecutor.shutdownNow();
        for (Runnable runnable : tasks) {
            if (!(runnable instanceof Future)) continue;
            ((Future)((Object)runnable)).cancel(true);
        }
        this.haltSourceQueue();
        Set<Thread> set = this.dispatchThreads;
        synchronized (set) {
            this.shuttingDown = true;
            for (Thread thread : this.dispatchThreads) {
                thread.interrupt();
            }
        }
        Throwable firstCause = null;
        for (Integer metaDataId : metaDataIds) {
            try {
                this.haltConnector(metaDataId);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                if (t.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)t.getCause();
                }
                if (firstCause != null) continue;
                firstCause = t;
            }
        }
        int n = 10;
        while (true) {
            Set<Thread> set2 = this.dispatchThreads;
            synchronized (set2) {
                if (this.dispatchThreads.size() == 0) {
                    this.shuttingDown = true;
                    this.obtainAllProcessLockPermits();
                    this.releaseAllProcessLockPermits();
                    break;
                }
            }
            Thread.sleep(10L);
        }
        while (!this.channelExecutor.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
        }
        if (firstCause != null) {
            this.updateCurrentState(DeployedState.STOPPED);
            throw firstCause;
        }
    }

    public void startConnector(Integer metaDataId) throws StartException, ResumeException {
        if (metaDataId == 0) {
            this.resume();
        } else {
            DestinationConnector destinationConnector = this.getDestinationConnector(metaDataId);
            if (this.currentState == DeployedState.STARTED || this.currentState == DeployedState.PAUSED) {
                if (destinationConnector.getCurrentState() == DeployedState.STOPPED) {
                    try {
                        destinationConnector.start();
                        destinationConnector.startQueue();
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) {
                            throw new StartException("Start task for connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + ") terminated by halt notification.", t);
                        }
                        try {
                            destinationConnector.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new StartException("Failed to start connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + "). ", t);
                    }
                }
            } else {
                this.logger.error("Failed to start connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + "): The channel is not started or paused.");
            }
        }
    }

    public void stopConnector(Integer metaDataId) throws StopException, PauseException {
        if (metaDataId == 0) {
            this.pause();
        } else {
            DestinationConnector destinationConnector = this.getDestinationConnector(metaDataId);
            if (this.currentState == DeployedState.STARTED || this.currentState == DeployedState.PAUSED) {
                if (destinationConnector.getCurrentState() != DeployedState.STOPPED) {
                    if (destinationConnector.isQueueEnabled()) {
                        try {
                            destinationConnector.setForceQueue(true);
                            destinationConnector.stop();
                        }
                        catch (Throwable t) {
                            throw new StopException("Failed to stop connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + "). ", t);
                        }
                    } else {
                        this.logger.error("Failed to stop connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + "): Destination connectors must have queueing enabled to be stopped individually.");
                    }
                }
            } else {
                this.logger.error("Failed to stop connector " + destinationConnector.getDestinationName() + " for channel " + this.name + " (" + this.channelId + "): The channel is not started or paused.");
            }
        }
    }

    private void haltConnector(Integer metaDataId) throws ConnectorTaskException, InterruptedException {
        try {
            if (metaDataId == 0) {
                this.sourceConnector.halt();
            } else {
                this.getDestinationConnector(metaDataId).halt();
            }
        }
        catch (ConnectorTaskException e) {
            if (metaDataId == 0) {
                this.logger.error("Error halting Source connector for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
            } else {
                this.logger.error("Error halting destination connector \"" + this.getDestinationConnector(metaDataId).getDestinationName() + "\" for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DispatchResult dispatchRawMessage(RawMessage rawMessage, boolean batch) throws ChannelException {
        if (this.currentState == DeployedState.STOPPING && !batch || this.currentState == DeployedState.STOPPED) {
            throw new ChannelException(true);
        }
        Thread currentThread = Thread.currentThread();
        String originalThreadName = currentThread.getName();
        boolean lockAcquired = false;
        Long persistedMessageId = null;
        try {
            DispatchResult dispatchResult;
            String responseErrorMessage;
            Response response;
            Message processedMessage;
            boolean commitSuccess;
            DonkeyDao dao;
            block52: {
                Set<Thread> set = this.dispatchThreads;
                synchronized (set) {
                    if (this.shuttingDown) {
                        throw new ChannelException(true);
                    }
                    this.dispatchThreads.add(currentThread);
                }
                if (StringUtils.contains((CharSequence)originalThreadName, (CharSequence)this.channelId)) {
                    currentThread.setName("Channel Dispatch Thread < " + originalThreadName);
                } else {
                    currentThread.setName("Channel Dispatch Thread on " + this.name + " (" + this.channelId + ") < " + originalThreadName);
                }
                dao = null;
                commitSuccess = false;
                processedMessage = null;
                response = null;
                responseErrorMessage = null;
                dispatchResult = null;
                try {
                    this.obtainProcessLock();
                    lockAcquired = true;
                    dao = this.daoFactory.getDao();
                    ConnectorMessage sourceMessage = this.createAndStoreSourceMessage(dao, rawMessage);
                    ThreadUtils.checkInterruptedStatus();
                    if (this.sourceConnector.isRespondAfterProcessing()) {
                        dao.commit(this.storageSettings.isRawDurable());
                        commitSuccess = true;
                        persistedMessageId = sourceMessage.getMessageId();
                        dao.close();
                        this.markDeletedQueuedMessages(rawMessage, persistedMessageId);
                        processedMessage = this.process(sourceMessage, false);
                    } else {
                        SourceQueue sourceQueue = this.sourceQueue;
                        synchronized (sourceQueue) {
                            dao.commit(this.storageSettings.isRawDurable());
                            commitSuccess = true;
                            persistedMessageId = sourceMessage.getMessageId();
                            dao.close();
                            this.queue(sourceMessage);
                        }
                        this.markDeletedQueuedMessages(rawMessage, persistedMessageId);
                    }
                    if (!this.responseSelector.canRespond()) break block52;
                    try {
                        response = this.responseSelector.getResponse(sourceMessage, processedMessage);
                    }
                    catch (Exception e) {
                        responseErrorMessage = ExceptionUtils.getStackTrace((Throwable)e);
                    }
                }
                catch (RuntimeException e) {
                    try {
                        throw new ChannelException(true, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (lockAcquired && (!this.sourceConnector.isRespondAfterProcessing() || persistedMessageId == null || Thread.currentThread().isInterrupted())) {
                            this.releaseProcessLock();
                            lockAcquired = false;
                        }
                        if (dao != null && !dao.isClosed()) {
                            if (!commitSuccess) {
                                try {
                                    dao.rollback();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            dao.close();
                        }
                        if (persistedMessageId != null) {
                            dispatchResult = new DispatchResult(persistedMessageId, processedMessage, response, this.sourceConnector.isRespondAfterProcessing(), lockAcquired);
                            if (StringUtils.isNotBlank(responseErrorMessage)) {
                                dispatchResult.setResponseError(responseErrorMessage);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            if (lockAcquired && (!this.sourceConnector.isRespondAfterProcessing() || persistedMessageId == null || Thread.currentThread().isInterrupted())) {
                this.releaseProcessLock();
                lockAcquired = false;
            }
            if (dao != null && !dao.isClosed()) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception sourceMessage) {
                        // empty catch block
                    }
                }
                dao.close();
            }
            if (persistedMessageId != null) {
                dispatchResult = new DispatchResult(persistedMessageId, processedMessage, response, this.sourceConnector.isRespondAfterProcessing(), lockAcquired);
                if (StringUtils.isNotBlank((CharSequence)responseErrorMessage)) {
                    dispatchResult.setResponseError(responseErrorMessage);
                }
            }
            DispatchResult dispatchResult2 = dispatchResult;
            return dispatchResult2;
        }
        catch (InterruptedException e) {
            throw new ChannelException(true, (Throwable)e);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            ChannelException channelException = null;
            if (cause instanceof InterruptedException) {
                channelException = new ChannelException(true, cause);
            } else if (cause instanceof ChannelException) {
                this.logger.error("Runtime error in channel " + this.name + " (" + this.channelId + ").", cause);
                channelException = (ChannelException)cause;
            } else {
                this.logger.error("Error processing message in channel " + this.name + " (" + this.channelId + ").", t);
                channelException = new ChannelException(false, t);
            }
            if (persistedMessageId == null) {
                throw channelException;
            }
            DispatchResult dispatchResult = new DispatchResult(persistedMessageId, null, null, false, lockAcquired, channelException);
            return dispatchResult;
        }
        finally {
            Set<Thread> set = this.dispatchThreads;
            synchronized (set) {
                this.dispatchThreads.remove(currentThread);
            }
            currentThread.setName(originalThreadName);
        }
    }

    private void markDeletedQueuedMessages(RawMessage rawMessage, Long persistedMessageId) throws InterruptedException {
        if (rawMessage.isOverwrite() && rawMessage.getOriginalMessageId() != null) {
            for (Integer metaDataId : this.getMetaDataIds()) {
                if (metaDataId.equals(0)) continue;
                this.getDestinationConnector(metaDataId).getQueue().markAsDeleted(persistedMessageId);
            }
            for (Integer metaDataId : this.getMetaDataIds()) {
                if (metaDataId.equals(0)) continue;
                while (this.getDestinationConnector(metaDataId).getQueue().isCheckedOut(persistedMessageId)) {
                    Thread.sleep(100L);
                }
            }
        }
    }

    private ConnectorMessage createAndStoreSourceMessage(DonkeyDao dao, RawMessage rawMessage) throws ChannelException, InterruptedException {
        Calendar receivedDate;
        Long messageId;
        ThreadUtils.checkInterruptedStatus();
        if (rawMessage.isOverwrite() && rawMessage.getOriginalMessageId() != null) {
            messageId = rawMessage.getOriginalMessageId();
            HashSet<Integer> metaDataIds = new HashSet<Integer>();
            if (rawMessage.getDestinationMetaDataIds() != null) {
                metaDataIds.addAll(rawMessage.getDestinationMetaDataIds());
            } else {
                metaDataIds.addAll(this.getMetaDataIds());
            }
            metaDataIds.add(0);
            if (!rawMessage.isImported()) {
                dao.deleteMessageStatistics(this.channelId, messageId, metaDataIds);
            }
            dao.deleteMessageAttachments(this.channelId, messageId);
            dao.deleteConnectorMessages(this.channelId, messageId, metaDataIds);
            dao.resetMessage(this.channelId, messageId);
            receivedDate = Calendar.getInstance();
        } else {
            messageId = dao.getNextMessageId(this.channelId);
            receivedDate = Calendar.getInstance();
            Message message = new Message();
            message.setMessageId(messageId);
            message.setChannelId(this.channelId);
            message.setServerId(this.serverId);
            message.setReceivedDate(receivedDate);
            message.setOriginalId(rawMessage.getOriginalMessageId());
            dao.insertMessage(message);
        }
        ConnectorMessage sourceMessage = new ConnectorMessage(this.channelId, this.name, messageId, 0, this.serverId, receivedDate, Status.RECEIVED);
        sourceMessage.setConnectorName(this.sourceConnector.getSourceName());
        sourceMessage.setChainId(0);
        sourceMessage.setOrderId(0);
        sourceMessage.setRaw(new MessageContent(this.channelId, messageId, 0, ContentType.RAW, null, this.sourceConnector.getInboundDataType().getType(), false));
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        if (rawMessage.getSourceMap() != null) {
            Object batchIdObject;
            sourceMap.putAll(rawMessage.getSourceMap());
            if (sourceMap.containsKey("batchSequenceId") && (batchIdObject = sourceMap.get("batchSequenceId")) instanceof Integer && (Integer)batchIdObject == 1) {
                sourceMap.put("batchId", messageId);
            }
        }
        Collection<Integer> destinationMetaDataIds = rawMessage.getDestinationMetaDataIds();
        LinkedHashSet<Integer> destinationSet = new LinkedHashSet<Integer>();
        if (destinationMetaDataIds != null) {
            destinationSet.addAll(destinationMetaDataIds);
        } else {
            for (DestinationChainProvider chainProvider : this.destinationChainProviders) {
                destinationSet.addAll(chainProvider.getMetaDataIds());
            }
        }
        sourceMap.put("destinationSet", destinationSet);
        sourceMessage.setSourceMap(Collections.unmodifiableMap(sourceMap));
        if (CollectionUtils.isNotEmpty(rawMessage.getAttachments())) {
            for (Attachment attachment : rawMessage.getAttachments()) {
                ThreadUtils.checkInterruptedStatus();
                if (!this.storageSettings.isStoreAttachments()) continue;
                dao.insertMessageAttachment(this.channelId, messageId, attachment);
            }
            rawMessage.setAttachments(null);
        }
        if (this.attachmentHandlerProvider != null && this.attachmentHandlerProvider.canExtractAttachments()) {
            ThreadUtils.checkInterruptedStatus();
            AttachmentHandler attachmentHandler = this.attachmentHandlerProvider.getHandler();
            try {
                Attachment attachment;
                attachmentHandler.initialize(rawMessage, this);
                rawMessage.clearMessage();
                while ((attachment = attachmentHandler.nextAttachment()) != null) {
                    ThreadUtils.checkInterruptedStatus();
                    if (!this.storageSettings.isStoreAttachments()) continue;
                    dao.insertMessageAttachment(this.channelId, messageId, attachment);
                }
                String replacedMessage = attachmentHandler.shutdown();
                sourceMessage.getRaw().setContent(replacedMessage);
            }
            catch (AttachmentException e) {
                this.eventDispatcher.dispatchEvent(new ErrorEvent(this.channelId, null, messageId, ErrorEventType.ATTACHMENT_HANDLER, null, null, "Error processing attachments for channel " + this.channelId + ".", e));
                this.logger.error("Error processing attachments for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
                throw new ChannelException(false, (Throwable)e);
            }
        } else if (rawMessage.isBinary().booleanValue()) {
            ThreadUtils.checkInterruptedStatus();
            try {
                byte[] rawBytes = Base64Util.encodeBase64(rawMessage.getRawBytes());
                rawMessage.clearMessage();
                sourceMessage.getRaw().setContent(org.apache.commons.codec.binary.StringUtils.newStringUsAscii((byte[])rawBytes));
            }
            catch (IOException e) {
                this.logger.error("Error processing binary data for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
                throw new ChannelException(false, (Throwable)e);
            }
        } else {
            sourceMessage.getRaw().setContent(rawMessage.getRawData());
            rawMessage.clearMessage();
        }
        ThreadUtils.checkInterruptedStatus();
        dao.insertConnectorMessage(sourceMessage, this.storageSettings.isStoreMaps() || this.storageSettings.isRawDurable(), true);
        if (this.storageSettings.isStoreRaw()) {
            ThreadUtils.checkInterruptedStatus();
            dao.insertMessageContent(sourceMessage.getRaw());
        }
        return sourceMessage;
    }

    public void obtainProcessLock() throws InterruptedException {
        this.processLock.acquire();
    }

    public void releaseProcessLock() {
        this.processLock.release();
    }

    public void obtainAllProcessLockPermits() throws InterruptedException {
        this.processLock.acquireAll();
    }

    public void releaseAllProcessLockPermits() {
        this.processLock.releaseAll();
    }

    public void obtainRemoveContentLock() throws InterruptedException {
        this.removeContentLock.lockInterruptibly();
    }

    public void releaseRemoveContentLock() {
        this.removeContentLock.unlock();
    }

    protected void queue(ConnectorMessage sourceMessage) {
        this.sourceQueue.add(sourceMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message process(ConnectorMessage sourceMessage, boolean markAsProcessed) throws InterruptedException {
        ThreadUtils.checkInterruptedStatus();
        long messageId = sourceMessage.getMessageId();
        if (sourceMessage.getMetaDataId() != 0 || sourceMessage.getStatus() != Status.RECEIVED) {
            throw new RuntimeException("Received a source message with an invalid state");
        }
        Message finalMessage = new Message();
        finalMessage.setMessageId(messageId);
        finalMessage.setServerId(this.serverId);
        finalMessage.setChannelId(this.channelId);
        finalMessage.setReceivedDate(sourceMessage.getReceivedDate());
        finalMessage.getConnectorMessages().put(0, sourceMessage);
        String processedRawContent = null;
        ThreadUtils.checkInterruptedStatus();
        try {
            processedRawContent = this.preProcessor.doPreProcess(sourceMessage);
        }
        catch (DonkeyException e) {
            sourceMessage.setStatus(Status.ERROR);
            sourceMessage.setProcessingError(e.getFormattedError());
        }
        ThreadUtils.checkInterruptedStatus();
        DonkeyDao dao = this.daoFactory.getDao();
        boolean commitSuccess = false;
        try {
            if (sourceMessage.getStatus() == Status.ERROR) {
                dao.updateStatus(sourceMessage, Status.RECEIVED);
                if (StringUtils.isNotBlank((CharSequence)sourceMessage.getProcessingError())) {
                    dao.updateErrors(sourceMessage);
                }
                ThreadUtils.checkInterruptedStatus();
                dao.commit(this.storageSettings.isDurable());
                commitSuccess = true;
                dao.close();
                this.finishMessage(finalMessage, markAsProcessed);
                Message message = finalMessage;
                return message;
            }
            if (processedRawContent != null) {
                sourceMessage.setProcessedRaw(new MessageContent(this.channelId, messageId, 0, ContentType.PROCESSED_RAW, processedRawContent, this.sourceConnector.getInboundDataType().getType(), false));
            }
            try {
                this.sourceConnector.getFilterTransformerExecutor().processConnectorMessage(sourceMessage);
            }
            catch (DonkeyException e) {
                if (e instanceof MessageSerializerException) {
                    this.eventDispatcher.dispatchEvent(new ErrorEvent(this.channelId, 0, messageId, ErrorEventType.SERIALIZER, this.sourceConnector.getSourceName(), null, e.getMessage(), e));
                }
                sourceMessage.setStatus(Status.ERROR);
                sourceMessage.setProcessingError(e.getFormattedError());
            }
            dao.updateStatus(sourceMessage, Status.RECEIVED);
            this.sourceConnector.getMetaDataReplacer().setMetaDataMap(sourceMessage, this.metaDataColumns);
            if (!sourceMessage.getMetaDataMap().isEmpty() && this.storageSettings.isStoreCustomMetaData()) {
                ThreadUtils.checkInterruptedStatus();
                dao.insertMetaData(sourceMessage, this.metaDataColumns);
            }
            if (this.storageSettings.isStoreMaps()) {
                ThreadUtils.checkInterruptedStatus();
                dao.updateMaps(sourceMessage);
                dao.updateSourceMap(sourceMessage);
            }
            if (sourceMessage.getStatus() != Status.TRANSFORMED) {
                if (this.storageSettings.isStoreProcessedRaw() && sourceMessage.getProcessedRaw() != null) {
                    ThreadUtils.checkInterruptedStatus();
                    dao.insertMessageContent(sourceMessage.getProcessedRaw());
                }
                if (this.storageSettings.isStoreTransformed() && sourceMessage.getTransformed() != null) {
                    dao.insertMessageContent(sourceMessage.getTransformed());
                }
                if (StringUtils.isNotBlank((CharSequence)sourceMessage.getProcessingError())) {
                    dao.updateErrors(sourceMessage);
                }
                ThreadUtils.checkInterruptedStatus();
                dao.commit();
                commitSuccess = true;
                dao.close();
                this.finishMessage(finalMessage, markAsProcessed);
                Message e = finalMessage;
                return e;
            }
            boolean insertedContent = false;
            ThreadUtils.checkInterruptedStatus();
            if (this.storageSettings.isStoreProcessedRaw() && sourceMessage.getProcessedRaw() != null) {
                dao.batchInsertMessageContent(sourceMessage.getProcessedRaw());
                insertedContent = true;
            }
            if (this.storageSettings.isStoreTransformed() && sourceMessage.getTransformed() != null) {
                dao.batchInsertMessageContent(sourceMessage.getTransformed());
                insertedContent = true;
            }
            if (this.storageSettings.isStoreSourceEncoded() && sourceMessage.getEncoded() != null) {
                dao.batchInsertMessageContent(sourceMessage.getEncoded());
                insertedContent = true;
            }
            if (insertedContent) {
                dao.executeBatchInsertMessageContent(this.channelId);
            }
            HashMap<Integer, ConnectorMessage> destinationMessages = new HashMap<Integer, ConnectorMessage>();
            MessageContent sourceEncoded = sourceMessage.getEncoded();
            Collection metaDataIds = null;
            if (sourceMessage.getSourceMap().containsKey("destinationSet")) {
                metaDataIds = (Collection)sourceMessage.getSourceMap().get("destinationSet");
            }
            ArrayList<DestinationChain> destinationChains = new ArrayList<DestinationChain>();
            for (DestinationChainProvider message : this.destinationChainProviders) {
                DestinationChain chain = message.getChain();
                if (metaDataIds != null) {
                    ArrayList<Integer> enabledMetaDataIds = new ArrayList<Integer>();
                    for (Integer id : message.getMetaDataIds()) {
                        if (!metaDataIds.contains(id)) continue;
                        enabledMetaDataIds.add(id);
                    }
                    chain.setEnabledMetaDataIds(enabledMetaDataIds);
                }
                if (!chain.getEnabledMetaDataIds().isEmpty()) {
                    ThreadUtils.checkInterruptedStatus();
                    Integer metaDataId = chain.getEnabledMetaDataIds().get(0);
                    DestinationConnector destinationConnector = message.getDestinationConnectors().get(metaDataId);
                    MessageContent raw = new MessageContent(this.channelId, messageId, metaDataId, ContentType.RAW, sourceEncoded.getContent(), destinationConnector.getInboundDataType().getType(), sourceEncoded.isEncrypted());
                    ConnectorMessage message2 = new ConnectorMessage(this.channelId, this.name, messageId, metaDataId, this.serverId, Calendar.getInstance(), Status.RECEIVED);
                    message2.setConnectorName(destinationConnector.getDestinationName());
                    message2.setChainId(message.getChainId());
                    message2.setOrderId(destinationConnector.getOrderId());
                    message2.setSourceMap(sourceMessage.getSourceMap());
                    message2.setChannelMap(new HashMap<String, Object>(sourceMessage.getChannelMap()));
                    message2.setResponseMap(new HashMap<String, Object>(sourceMessage.getResponseMap()));
                    message2.setRaw(raw);
                    dao.insertConnectorMessage(message2, this.storageSettings.isStoreMaps(), true);
                    destinationMessages.put(metaDataId, message2);
                }
                destinationChains.add(chain);
            }
            ThreadUtils.checkInterruptedStatus();
            dao.commit();
            commitSuccess = true;
            dao.close();
            ArrayList<DestinationChain> enabledChains = new ArrayList<DestinationChain>();
            for (DestinationChain chain : destinationChains) {
                if (chain.getEnabledMetaDataIds().isEmpty()) continue;
                chain.setMessage((ConnectorMessage)destinationMessages.get(chain.getEnabledMetaDataIds().get(0)));
                enabledChains.add(chain);
            }
            if (!enabledChains.isEmpty()) {
                DestinationChain chain;
                ArrayList<Future<List<ConnectorMessage>>> arrayList = new ArrayList<Future<List<ConnectorMessage>>>();
                for (int i = 0; i <= enabledChains.size() - 2; ++i) {
                    try {
                        chain = (DestinationChain)enabledChains.get(i);
                        chain.setName("Destination Chain Thread " + (i + 1) + " on " + this.name + " (" + this.channelId + ")");
                        arrayList.add(this.channelExecutor.submit(chain));
                        continue;
                    }
                    catch (RejectedExecutionException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedException();
                    }
                }
                Object connectorMessages = null;
                try {
                    chain = (DestinationChain)enabledChains.get(enabledChains.size() - 1);
                    chain.setName("Destination Chain Thread " + enabledChains.size() + " on " + this.name + " (" + this.channelId + ")");
                    connectorMessages = chain.call();
                }
                catch (Throwable t) {
                    this.handleDestinationChainThrowable(t);
                }
                this.addConnectorMessages(finalMessage, sourceMessage, (List<ConnectorMessage>)connectorMessages);
                for (Future future : arrayList) {
                    connectorMessages = null;
                    try {
                        connectorMessages = (List)future.get();
                    }
                    catch (Exception e) {
                        this.handleDestinationChainThrowable(e);
                    }
                    this.addConnectorMessages(finalMessage, sourceMessage, (List<ConnectorMessage>)connectorMessages);
                }
            }
            this.finishMessage(finalMessage, markAsProcessed);
            Message message = finalMessage;
            return message;
        }
        finally {
            if (!dao.isClosed()) {
                if (dao != null && !commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    private void addConnectorMessages(Message finalMessage, ConnectorMessage sourceMessage, List<ConnectorMessage> connectorMessages) {
        if (connectorMessages != null) {
            for (ConnectorMessage connectorMessage : connectorMessages) {
                finalMessage.getConnectorMessages().put(connectorMessage.getMetaDataId(), connectorMessage);
                sourceMessage.getResponseMap().putAll(connectorMessage.getResponseMap());
            }
        }
    }

    private void handleDestinationChainThrowable(Throwable t) throws OutOfMemoryError, InterruptedException {
        Throwable cause = t instanceof ExecutionException ? t.getCause() : t;
        if (cause.getMessage() != null && cause.getMessage().contains("Java heap space")) {
            this.logger.error(cause.getMessage(), cause);
            throw new OutOfMemoryError();
        }
        if (cause instanceof CancellationException) {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw (InterruptedException)cause;
        }
        throw new RuntimeException(cause);
    }

    public void processUnfinishedMessages() throws Exception {
        this.channelExecutor.submit(new RecoveryTask(this)).get();
    }

    @Override
    public void run() {
        try {
            do {
                this.processSourceQueue(1000);
            } while (this.isActive() && !this.stopSourceQueue);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSourceQueue(int timeout) throws InterruptedException {
        ThreadUtils.checkInterruptedStatus();
        ConnectorMessage sourceMessage = this.sourceQueue.poll(timeout, TimeUnit.MILLISECONDS);
        try {
            while (sourceMessage != null && !this.stopSourceQueue) {
                try {
                    this.process(sourceMessage, true);
                    this.sourceQueue.finish(sourceMessage);
                }
                catch (Throwable t) {
                    ThreadUtils.checkInterruptedException(t);
                    this.logger.error("An error occurred in channel " + this.name + " (" + this.channelId + ") while processing message ID " + sourceMessage.getMessageId() + " from the source queue", t);
                    this.eventDispatcher.dispatchEvent(new ErrorEvent(this.channelId, 0, sourceMessage.getMessageId(), ErrorEventType.SOURCE_CONNECTOR, this.sourceConnector.getSourceName(), null, t.getMessage(), t));
                    this.sourceQueue.finish(sourceMessage);
                    this.sourceQueue.invalidate(false, false);
                    Thread.sleep(1000L);
                }
                sourceMessage = this.sourceQueue.poll();
            }
        }
        catch (Throwable t) {
            ThreadUtils.checkInterruptedException(t);
            this.logger.error("An error occurred in channel " + this.name + " (" + this.channelId + ") while polling from the source queue", t);
            this.eventDispatcher.dispatchEvent(new ErrorEvent(this.channelId, 0, null, ErrorEventType.SOURCE_CONNECTOR, this.sourceConnector.getSourceName(), null, t.getMessage(), t));
            Thread.sleep(1000L);
        }
        finally {
            if (sourceMessage != null) {
                this.sourceQueue.finish(sourceMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMessage(Message finalMessage, boolean markAsProcessed) throws InterruptedException {
        ThreadUtils.checkInterruptedStatus();
        Response response = null;
        boolean storePostProcessorError = false;
        ConnectorMessage sourceConnectorMessage = finalMessage.getConnectorMessages().get(0);
        try {
            response = this.postProcessor.doPostProcess(finalMessage);
        }
        catch (DonkeyException e) {
            sourceConnectorMessage.setPostProcessorError(e.getFormattedError());
            storePostProcessorError = true;
        }
        sourceConnectorMessage.getResponseMap().putAll(finalMessage.getMergedConnectorMessage().getResponseMap());
        if (response != null) {
            sourceConnectorMessage.getResponseMap().put("Postprocessor", response);
        }
        ThreadUtils.checkInterruptedStatus();
        DonkeyDao dao = null;
        boolean commitSuccess = false;
        try {
            if (storePostProcessorError) {
                dao = this.daoFactory.getDao();
                dao.updateErrors(sourceConnectorMessage);
            }
            if (markAsProcessed) {
                if (dao == null) {
                    dao = this.daoFactory.getDao();
                }
                if (this.storageSettings.isStoreMergedResponseMap()) {
                    ThreadUtils.checkInterruptedStatus();
                    dao.updateResponseMap(sourceConnectorMessage);
                }
                dao.markAsProcessed(this.channelId, finalMessage.getMessageId());
                finalMessage.setProcessed(true);
                if (!this.isUsingDestinationQueues()) {
                    this.removeContent(dao, finalMessage, finalMessage.getMessageId(), false, false);
                }
            }
            if (dao != null) {
                dao.commit(this.storageSettings.isDurable());
                commitSuccess = true;
            }
            if (markAsProcessed && this.isUsingDestinationQueues()) {
                this.removeContent(dao, finalMessage, finalMessage.getMessageId(), false, true);
            }
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContent(DonkeyDao dao, Message message, long messageId, boolean checkProcessed, boolean commit) {
        block24: {
            if (this.storageSettings.isEnabled() && (this.storageSettings.isRemoveContentOnCompletion() || this.storageSettings.isRemoveAttachmentsOnCompletion())) {
                if (commit) {
                    if (message != null) {
                        for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
                            int metaDataId = connectorMessage.getMetaDataId();
                            if (connectorMessage.getStatus() != Status.ERROR || metaDataId != 0 && this.getDestinationConnector(metaDataId).isQueueEnabled()) continue;
                            return;
                        }
                    }
                    try {
                        Map<Integer, Status> statusMap = dao.getConnectorMessageStatuses(this.channelId, messageId, checkProcessed);
                        HashSet<Status> statuses = new HashSet<Status>(statusMap.values());
                        if (!this.messageController.isMessageCompleted(statuses)) break block24;
                        HashSet<Integer> filteredMetaDataIds = null;
                        if (this.storageSettings.isRemoveContentOnCompletion() && this.storageSettings.isRemoveOnlyFilteredOnCompletion()) {
                            filteredMetaDataIds = new HashSet<Integer>();
                            for (Map.Entry<Integer, Status> entry : statusMap.entrySet()) {
                                if (entry.getValue().getStatusCode() != Status.FILTERED.getStatusCode()) continue;
                                filteredMetaDataIds.add(entry.getKey());
                            }
                        }
                        if (!this.storageSettings.isRemoveAttachmentsOnCompletion() && this.storageSettings.isRemoveOnlyFilteredOnCompletion() && filteredMetaDataIds.isEmpty()) break block24;
                        this.obtainRemoveContentLock();
                        try {
                            if (this.storageSettings.isRemoveContentOnCompletion()) {
                                if (this.storageSettings.isRemoveOnlyFilteredOnCompletion()) {
                                    if (!filteredMetaDataIds.isEmpty()) {
                                        dao.deleteMessageContentByMetaDataIds(this.channelId, messageId, filteredMetaDataIds);
                                    }
                                } else {
                                    dao.deleteMessageContent(this.channelId, messageId);
                                }
                            }
                            if (this.storageSettings.isRemoveAttachmentsOnCompletion()) {
                                dao.deleteMessageAttachments(this.channelId, messageId);
                            }
                            dao.commit();
                        }
                        finally {
                            this.releaseRemoveContentLock();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Error removing content for message " + messageId + " for channel " + this.name + " (" + this.channelId + ").", (Throwable)e);
                    }
                } else if (!commit && message != null && this.messageController.isMessageCompleted(message)) {
                    if (this.storageSettings.isRemoveContentOnCompletion()) {
                        if (this.storageSettings.isRemoveOnlyFilteredOnCompletion()) {
                            HashSet<Integer> filteredMetaDataIds = new HashSet<Integer>();
                            for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
                                if (connectorMessage.getStatus().getStatusCode() != Status.FILTERED.getStatusCode()) continue;
                                filteredMetaDataIds.add(connectorMessage.getMetaDataId());
                            }
                            if (!filteredMetaDataIds.isEmpty()) {
                                dao.deleteMessageContentByMetaDataIds(this.channelId, messageId, filteredMetaDataIds);
                            }
                        } else {
                            dao.deleteMessageContent(this.channelId, messageId);
                        }
                    }
                    if (this.storageSettings.isRemoveAttachmentsOnCompletion()) {
                        dao.deleteMessageAttachments(this.channelId, messageId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMessage(Message message) throws DonkeyException {
        DonkeyDao dao = null;
        boolean commitSuccess = false;
        try {
            dao = this.daoFactory.getDao();
            this.importMessage(message, dao);
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null && !commitSuccess) {
                try {
                    dao.rollback();
                }
                catch (Exception exception) {}
            }
            dao.close();
        }
    }

    public void importMessage(Message message, DonkeyDao dao) throws DonkeyException {
        if (message.getImportId() == null) {
            message.setImportId(message.getMessageId());
        }
        if (message.getImportChannelId() == null && !message.getChannelId().equals(this.channelId)) {
            message.setImportChannelId(message.getChannelId());
        }
        long messageId = dao.getNextMessageId(this.channelId);
        message.setMessageId(messageId);
        message.setChannelId(this.channelId);
        message.setServerId(this.serverId);
        message.setProcessed(true);
        dao.insertMessage(message);
        for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
            connectorMessage.setMessageId(messageId);
            connectorMessage.setChannelId(this.channelId);
            connectorMessage.setServerId(this.serverId);
            Status status = connectorMessage.getStatus();
            if (status != Status.FILTERED && status != Status.TRANSFORMED && status != Status.SENT && status != Status.ERROR) {
                connectorMessage.setStatus(Status.ERROR);
            }
            int metaDataId = connectorMessage.getMetaDataId();
            dao.insertConnectorMessage(connectorMessage, true, false);
            if (!connectorMessage.getMetaDataMap().isEmpty()) {
                dao.insertMetaData(connectorMessage, this.metaDataColumns);
            }
            for (ContentType contentType : ContentType.getMessageTypes()) {
                MessageContent messageContent = connectorMessage.getMessageContent(contentType);
                if (messageContent == null) continue;
                messageContent.setMessageId(messageId);
                messageContent.setChannelId(this.channelId);
            }
            if (this.storageSettings.isStoreRaw() && connectorMessage.getRaw() != null) {
                dao.insertMessageContent(connectorMessage.getRaw());
            }
            if (this.storageSettings.isStoreProcessedRaw() && connectorMessage.getProcessedRaw() != null) {
                dao.insertMessageContent(connectorMessage.getProcessedRaw());
            }
            if (this.storageSettings.isStoreTransformed() && connectorMessage.getTransformed() != null) {
                dao.insertMessageContent(connectorMessage.getTransformed());
            }
            if (this.storageSettings.isStoreSourceEncoded() && metaDataId == 0 && connectorMessage.getEncoded() != null) {
                dao.insertMessageContent(connectorMessage.getEncoded());
            }
            if (this.storageSettings.isStoreDestinationEncoded() && metaDataId > 0 && connectorMessage.getEncoded() != null) {
                dao.insertMessageContent(connectorMessage.getEncoded());
            }
            if (this.storageSettings.isStoreSent() && connectorMessage.getSent() != null) {
                dao.insertMessageContent(connectorMessage.getSent());
            }
            if (this.storageSettings.isStoreResponse() && connectorMessage.getResponse() != null) {
                dao.insertMessageContent(connectorMessage.getResponse());
            }
            if (this.storageSettings.isStoreResponseTransformed() && connectorMessage.getResponseTransformed() != null) {
                dao.insertMessageContent(connectorMessage.getResponseTransformed());
            }
            if (!this.storageSettings.isStoreProcessedResponse() || connectorMessage.getProcessedResponse() == null) continue;
            dao.insertMessageContent(connectorMessage.getProcessedResponse());
        }
        List<Attachment> attachments = message.getAttachments();
        if (CollectionUtils.isNotEmpty(attachments)) {
            for (Attachment attachment : attachments) {
                dao.insertMessageAttachment(this.channelId, messageId, attachment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaDataColumns() throws SQLException {
        DonkeyDao dao = this.daoFactory.getDao();
        boolean commitSuccess = false;
        try {
            HashMap<String, MetaDataColumnType> existingColumnsMap = new HashMap<String, MetaDataColumnType>();
            ArrayList<String> columnsToRemove = new ArrayList<String>();
            List<MetaDataColumn> existingColumns = dao.getMetaDataColumns(this.channelId);
            for (MetaDataColumn existingColumn : existingColumns) {
                existingColumnsMap.put(existingColumn.getName(), existingColumn.getType());
                columnsToRemove.add(existingColumn.getName());
            }
            for (MetaDataColumn column : this.metaDataColumns) {
                String columnName = column.getName();
                if (existingColumnsMap.containsKey(columnName)) {
                    if (existingColumnsMap.get(columnName) != column.getType()) {
                        dao.removeMetaDataColumn(this.channelId, columnName);
                        dao.addMetaDataColumn(this.channelId, column);
                    }
                } else {
                    dao.addMetaDataColumn(this.channelId, column);
                }
                columnsToRemove.remove(columnName);
            }
            for (String columnToRemove : columnsToRemove) {
                dao.removeMetaDataColumn(this.channelId, columnToRemove);
            }
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null && !commitSuccess) {
                try {
                    dao.rollback();
                }
                catch (Exception exception) {}
            }
            dao.close();
        }
    }
}

