/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.FilterTransformerExecutor;
import com.mirth.connect.donkey.server.message.DataType;
import java.util.Map;
import java.util.Set;

public abstract class Connector {
    protected Channel channel;
    private String channelId;
    private int metaDataId;
    private DataType inboundDataType;
    private DataType outboundDataType;
    private DeployedState currentState = DeployedState.STOPPED;
    private ConnectorProperties connectorProperties;
    private Map<String, Integer> destinationIdMap;
    private FilterTransformerExecutor filterTransformerExecutor;
    private Set<String> resourceIds;

    public abstract void onDeploy() throws ConnectorTaskException;

    public abstract void onUndeploy() throws ConnectorTaskException;

    public abstract void onStart() throws ConnectorTaskException;

    public abstract void onStop() throws ConnectorTaskException;

    public abstract void onHalt() throws ConnectorTaskException;

    public abstract void start() throws ConnectorTaskException, InterruptedException;

    public abstract void stop() throws ConnectorTaskException, InterruptedException;

    public abstract void halt() throws ConnectorTaskException, InterruptedException;

    public void onDebugDeploy(DebugOptions debugOptions) throws ConnectorTaskException {
        this.onDeploy();
    }

    public void stopDebugging() throws ConnectorTaskException {
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public int getMetaDataId() {
        return this.metaDataId;
    }

    public void setMetaDataId(int metaDataId) {
        this.metaDataId = metaDataId;
    }

    public DataType getInboundDataType() {
        return this.inboundDataType;
    }

    public void setInboundDataType(DataType inboundDataType) {
        this.inboundDataType = inboundDataType;
    }

    public DataType getOutboundDataType() {
        return this.outboundDataType;
    }

    public void setOutboundDataType(DataType outboundDataType) {
        this.outboundDataType = outboundDataType;
    }

    public DeployedState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(DeployedState currentState) {
        this.currentState = currentState;
    }

    public ConnectorProperties getConnectorProperties() {
        return this.connectorProperties;
    }

    public void setConnectorProperties(ConnectorProperties connectorProperties) {
        this.connectorProperties = connectorProperties;
    }

    public Map<String, Integer> getDestinationIdMap() {
        return this.destinationIdMap;
    }

    public void setDestinationIdMap(Map<String, Integer> destinationIdMap) {
        this.destinationIdMap = destinationIdMap;
    }

    public FilterTransformerExecutor getFilterTransformerExecutor() {
        return this.filterTransformerExecutor;
    }

    public void setFilterTransformerExecutor(FilterTransformerExecutor filterTransformerExecutor) {
        this.filterTransformerExecutor = filterTransformerExecutor;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    protected String getConfigurationClass() {
        return null;
    }
}

