/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.DestinationChainProvider;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.queue.DestinationQueue;
import com.mirth.connect.donkey.util.ThreadUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationChain
implements Callable<List<ConnectorMessage>> {
    private DestinationChainProvider chainProvider;
    private ConnectorMessage message;
    private List<Integer> enabledMetaDataIds = new ArrayList<Integer>();
    private Logger logger = LogManager.getLogger(this.getClass());
    private String name;

    public DestinationChain(DestinationChainProvider chainProvider) {
        this.chainProvider = chainProvider;
        this.enabledMetaDataIds = new ArrayList<Integer>(chainProvider.getMetaDataIds());
        this.name = "Destination Chain Thread on " + chainProvider.getChannelId();
    }

    public void setMessage(ConnectorMessage message) {
        this.message = message;
    }

    public List<Integer> getEnabledMetaDataIds() {
        return this.enabledMetaDataIds;
    }

    public void setEnabledMetaDataIds(List<Integer> enabledMetaDataIds) {
        this.enabledMetaDataIds = enabledMetaDataIds;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<ConnectorMessage> call() throws InterruptedException {
        String originalThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.name + " < " + originalThreadName);
            List<ConnectorMessage> list = this.doCall();
            return list;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConnectorMessage> doCall() throws InterruptedException {
        ArrayList<ConnectorMessage> messages = new ArrayList<ConnectorMessage>();
        ConnectorMessage message = this.message;
        int startMetaDataId = this.enabledMetaDataIds.indexOf(message.getMetaDataId());
        boolean stopChain = false;
        if (startMetaDataId == -1) {
            this.logger.error("The message's metadata ID for channel " + this.chainProvider.getChannelId() + " is not in the destination chain's list of enabled metadata IDs");
            return null;
        }
        for (int i = startMetaDataId; i < this.enabledMetaDataIds.size() && !stopChain; ++i) {
            ThreadUtils.checkInterruptedStatus();
            Integer metaDataId = this.enabledMetaDataIds.get(i);
            Integer nextMetaDataId = this.enabledMetaDataIds.size() > i + 1 ? this.enabledMetaDataIds.get(i + 1) : null;
            ConnectorMessage nextMessage = null;
            DestinationConnector destinationConnector = this.chainProvider.getDestinationConnectors().get(metaDataId);
            try (DonkeyDao dao = this.chainProvider.getDaoFactory().getDao();){
                block27: {
                    Status previousStatus = message.getStatus();
                    try {
                        switch (message.getStatus()) {
                            case RECEIVED: {
                                if (destinationConnector.willAttemptSend() || !destinationConnector.includeFilterTransformerInQueue()) {
                                    destinationConnector.transform(dao, message, previousStatus, true);
                                    if (message.getStatus() == Status.QUEUED) {
                                        String originalThreadName = Thread.currentThread().getName();
                                        try {
                                            Thread.currentThread().setName(destinationConnector.getConnectorProperties().getName() + " Process Thread on " + destinationConnector.getChannel().getName() + " (" + this.chainProvider.getChannelId() + "), " + destinationConnector.getDestinationName() + " (" + metaDataId + ")");
                                            destinationConnector.process(dao, message, previousStatus);
                                            break;
                                        }
                                        finally {
                                            Thread.currentThread().setName(originalThreadName);
                                        }
                                    }
                                    if (message.getStatus() == Status.ERROR && message.getSent() == null) {
                                        stopChain = true;
                                    }
                                    break;
                                }
                                destinationConnector.updateQueuedStatus(dao, message, previousStatus);
                                break;
                            }
                            case PENDING: {
                                this.chainProvider.getDestinationConnectors().get(metaDataId).processPendingConnectorMessage(dao, message);
                                break;
                            }
                            case SENT: {
                                break;
                            }
                            default: {
                                this.logger.error("Received a message with an invalid status in channel " + this.chainProvider.getChannelId() + ".");
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Error processing destination " + this.chainProvider.getDestinationConnectors().get(metaDataId).getDestinationName() + " for channel " + this.chainProvider.getChannelId() + ".", (Throwable)e);
                        stopChain = true;
                        dao.rollback();
                        message.setStatus(Status.ERROR);
                        message.setProcessingError(e.toString());
                        dao.updateStatus(message, previousStatus);
                        if (!StringUtils.isNotBlank((CharSequence)message.getProcessingError())) break block27;
                        dao.updateErrors(message);
                    }
                }
                if (nextMetaDataId != null && !stopChain) {
                    nextMessage = new ConnectorMessage(message.getChannelId(), message.getChannelName(), message.getMessageId(), nextMetaDataId, message.getServerId(), Calendar.getInstance(), Status.RECEIVED);
                    DestinationConnector nextDestinationConnector = this.chainProvider.getDestinationConnectors().get(nextMetaDataId);
                    nextMessage.setConnectorName(nextDestinationConnector.getDestinationName());
                    nextMessage.setChainId(this.chainProvider.getChainId());
                    nextMessage.setOrderId(nextDestinationConnector.getOrderId());
                    nextMessage.setSourceMap(message.getSourceMap());
                    nextMessage.setChannelMap(new HashMap<String, Object>(message.getChannelMap()));
                    nextMessage.setResponseMap(new HashMap<String, Object>(message.getResponseMap()));
                    nextMessage.setRaw(new MessageContent(message.getChannelId(), message.getMessageId(), nextMetaDataId, ContentType.RAW, message.getRaw().getContent(), nextDestinationConnector.getInboundDataType().getType(), message.getRaw().isEncrypted()));
                    ThreadUtils.checkInterruptedStatus();
                    dao.insertConnectorMessage(nextMessage, this.chainProvider.getStorageSettings().isStoreMaps(), true);
                }
                ThreadUtils.checkInterruptedStatus();
                if (message.getStatus() != Status.QUEUED) {
                    dao.commit(this.chainProvider.getStorageSettings().isDurable());
                } else {
                    DestinationQueue destinationQueue = destinationConnector.getQueue();
                    synchronized (destinationQueue) {
                        dao.commit(this.chainProvider.getStorageSettings().isDurable());
                        if (message.getStatus() == Status.QUEUED) {
                            destinationConnector.getQueue().add(message);
                        }
                    }
                }
                messages.add(message);
            }
            if (nextMetaDataId == null) continue;
            message = nextMessage;
        }
        return messages;
    }
}

