/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.FilterTransformerResult;
import com.mirth.connect.donkey.server.channel.components.FilterTransformer;
import com.mirth.connect.donkey.server.message.DataType;
import com.mirth.connect.donkey.util.ThreadUtils;

public class FilterTransformerExecutor {
    private DataType inbound;
    private DataType outbound;
    private FilterTransformer filterTransformer;

    public FilterTransformerExecutor(DataType inbound, DataType outbound) {
        this.inbound = inbound;
        this.outbound = outbound;
    }

    public DataType getInbound() {
        return this.inbound;
    }

    public void setInbound(DataType inbound) {
        this.inbound = inbound;
    }

    public DataType getOutbound() {
        return this.outbound;
    }

    public void setOutbound(DataType outbound) {
        this.outbound = outbound;
    }

    public FilterTransformer getFilterTransformer() {
        return this.filterTransformer;
    }

    public void setFilterTransformer(FilterTransformer filterTransformer) {
        this.filterTransformer = filterTransformer;
    }

    public void processConnectorMessage(ConnectorMessage connectorMessage) throws InterruptedException, DonkeyException {
        String encodedContent;
        ThreadUtils.checkInterruptedStatus();
        String content = connectorMessage.getProcessedRaw() == null ? connectorMessage.getRaw().getContent() : connectorMessage.getProcessedRaw().getContent();
        this.inbound.getSerializer().populateMetaData(content, connectorMessage.getConnectorMap());
        if (this.filterTransformer != null) {
            switch (this.inbound.getSerializationType()) {
                case RAW: {
                    break;
                }
                case JSON: {
                    this.setTransformedContent(connectorMessage, this.inbound.getSerializer().toJSON(content), this.inbound.getSerializationType());
                    break;
                }
                default: {
                    this.setTransformedContent(connectorMessage, this.inbound.getSerializer().toXML(content), this.inbound.getSerializationType());
                }
            }
            ThreadUtils.checkInterruptedStatus();
            FilterTransformerResult result = this.filterTransformer.doFilterTransform(connectorMessage);
            String transformedContent = result.getTransformedContent();
            this.setTransformedContent(connectorMessage, transformedContent, this.outbound.getSerializationType());
            if (result.isFiltered()) {
                connectorMessage.setStatus(Status.FILTERED);
                return;
            }
            ThreadUtils.checkInterruptedStatus();
            switch (this.outbound.getSerializationType()) {
                case RAW: {
                    encodedContent = transformedContent;
                    break;
                }
                case JSON: {
                    encodedContent = this.outbound.getSerializer().fromJSON(connectorMessage.getTransformed().getContent());
                    break;
                }
                default: {
                    encodedContent = this.outbound.getSerializer().fromXML(connectorMessage.getTransformed().getContent());
                    break;
                }
            }
        } else {
            String transformedContent = this.inbound.getSerializer().transformWithoutSerializing(content, this.outbound.getSerializer());
            encodedContent = transformedContent == null ? content : transformedContent;
        }
        connectorMessage.setEncoded(new MessageContent(connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.ENCODED, encodedContent, this.outbound.getType(), false));
        connectorMessage.setStatus(Status.TRANSFORMED);
    }

    private void setTransformedContent(ConnectorMessage connectorMessage, String transformedContent, SerializationType serializationType) {
        if (connectorMessage.getTransformed() == null) {
            connectorMessage.setTransformed(new MessageContent(connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.TRANSFORMED, transformedContent, serializationType.toString(), false));
        } else {
            connectorMessage.getTransformed().setDataType(serializationType.toString());
            connectorMessage.getTransformed().setContent(transformedContent);
        }
    }
}

