/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.server.channel.PollConnector;
import java.util.concurrent.locks.ReentrantLock;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class PollConnectorJob
implements InterruptableJob {
    private PollConnector pollConnector;
    private Thread thread;
    private ReentrantLock lock;

    public PollConnectorJob(PollConnector pollConnector, ReentrantLock lock) {
        this.lock = lock;
        this.pollConnector = pollConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block14: {
            boolean locked = false;
            if (!this.lock.isLocked()) {
                ReentrantLock reentrantLock = this.lock;
                synchronized (reentrantLock) {
                    if (!this.lock.isLocked()) {
                        this.lock.lock();
                        locked = true;
                    }
                }
            }
            if (locked) {
                try {
                    if (this.pollConnector.isTerminated()) break block14;
                    this.thread = Thread.currentThread();
                    String originalThreadName = this.thread.getName();
                    try {
                        this.thread.setName(this.pollConnector.getConnectorProperties().getName() + " Polling Thread on " + this.pollConnector.getChannel().getName() + " (" + this.pollConnector.getChannelId() + ") < " + originalThreadName);
                        this.pollConnector.poll();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        this.thread.setName(originalThreadName);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }
}

