/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.DestinationChain;
import com.mirth.connect.donkey.server.channel.DestinationChainProvider;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.ResponseSelector;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.util.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecoveryTask
implements Callable<Void> {
    private Channel channel;
    private Logger logger = LogManager.getLogger(this.getClass());

    public RecoveryTask(Channel channel) {
        this.channel = channel;
    }

    @Override
    public Void call() throws Exception {
        String originalThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("Recovery Task Thread on " + this.channel.getName() + " (" + this.channel.getChannelId() + ") < " + originalThreadName);
            Void void_ = this.doCall();
            return void_;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void doCall() throws Exception {
        StorageSettings storageSettings = this.channel.getStorageSettings();
        Long maxMessageId = null;
        long attemptedMessages = 0L;
        long recoveredMessages = 0L;
        int sourceBufferSize = 1;
        int unfinishedBufferSize = 10;
        int pendingBufferSize = 10;
        long sourceMinMessageId = 0L;
        long unfinishedMinMessageId = 0L;
        long pendingMinMessageId = 0L;
        boolean sourceComplete = false;
        boolean unfinishedComplete = false;
        boolean pendingComplete = false;
        LinkedList<ConnectorMessage> sourceConnectorMessages = new LinkedList<ConnectorMessage>();
        LinkedList<Message> unfinishedMessages = new LinkedList<Message>();
        LinkedList<Message> pendingMessages = new LinkedList<Message>();
        do {
            ThreadUtils.checkInterruptedStatus();
            try (DonkeyDao dao = this.channel.getDaoFactory().getDao();){
                if (maxMessageId == null) {
                    maxMessageId = dao.getMaxMessageId(this.channel.getChannelId());
                }
                if (!sourceComplete && sourceConnectorMessages.isEmpty()) {
                    sourceConnectorMessages.addAll(dao.getConnectorMessages(this.channel.getChannelId(), this.channel.getServerId(), 0, Status.RECEIVED, 0, sourceBufferSize, sourceMinMessageId, maxMessageId));
                    if (sourceConnectorMessages.isEmpty()) {
                        sourceComplete = true;
                    } else {
                        sourceBufferSize = 100;
                    }
                }
                if (!unfinishedComplete && unfinishedMessages.isEmpty()) {
                    unfinishedMessages.addAll(dao.getUnfinishedMessages(this.channel.getChannelId(), this.channel.getServerId(), unfinishedBufferSize, unfinishedMinMessageId));
                    if (unfinishedMessages.isEmpty()) {
                        unfinishedComplete = true;
                    }
                }
                if (!pendingComplete && pendingMessages.isEmpty()) {
                    pendingMessages.addAll(dao.getPendingConnectorMessages(this.channel.getChannelId(), this.channel.getServerId(), pendingBufferSize, pendingMinMessageId));
                    if (pendingMessages.isEmpty()) {
                        pendingComplete = true;
                    }
                }
            }
            ConnectorMessage sourceConnectorMessage = (ConnectorMessage)sourceConnectorMessages.peekFirst();
            Message unfinishedMessage = (Message)unfinishedMessages.peekFirst();
            Message pendingMessage = (Message)pendingMessages.peekFirst();
            if (!storageSettings.isMessageRecoveryEnabled()) {
                sourceComplete = true;
                unfinishedComplete = true;
                pendingComplete = true;
                if (unfinishedMessage == null && pendingMessage == null && (sourceConnectorMessage == null || !this.channel.getSourceConnector().isRespondAfterProcessing())) continue;
                this.logger.info("Incomplete messages found for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ") but message storage settings do not support recovery. Skipping recovery task.");
                continue;
            }
            Long messageId = null;
            try {
                if (!(sourceConnectorMessage == null || unfinishedMessage != null && sourceConnectorMessage.getMessageId() >= unfinishedMessage.getMessageId() || pendingMessage != null && sourceConnectorMessage.getMessageId() >= pendingMessage.getMessageId())) {
                    if (!this.channel.getSourceConnector().isRespondAfterProcessing() && unfinishedComplete && pendingComplete) {
                        sourceComplete = true;
                        continue;
                    }
                    messageId = sourceConnectorMessage.getMessageId();
                    sourceMinMessageId = ((ConnectorMessage)sourceConnectorMessages.pollFirst()).getMessageId() + 1L;
                    if (attemptedMessages++ == 0L) {
                        this.logger.info("Starting message recovery for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + "). Incomplete messages found in source queue.");
                    }
                    this.logger.debug("Recovering incomplete message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                    this.channel.process(sourceConnectorMessage, true);
                    this.channel.getSourceQueue().decrementSize();
                    this.logger.debug("Recovered incomplete message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                    ++recoveredMessages;
                    continue;
                }
                if (unfinishedMessage != null && (pendingMessage == null || unfinishedMessage.getMessageId() <= pendingMessage.getMessageId())) {
                    messageId = unfinishedMessage.getMessageId();
                    unfinishedMinMessageId = ((Message)unfinishedMessages.pollFirst()).getMessageId() + 1L;
                    if (pendingMessage != null && unfinishedMessage.getMessageId() == pendingMessage.getMessageId()) {
                        pendingMinMessageId = ((Message)pendingMessages.pollFirst()).getMessageId() + 1L;
                        pendingMessage = (Message)pendingMessages.peekFirst();
                    }
                    if (attemptedMessages++ == 0L) {
                        this.logger.info("Starting message recovery for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + "). Incomplete unfinished messages found.");
                    }
                    this.logger.debug("Recovering incomplete unfinished message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                    this.recoverUnfinishedMessage(unfinishedMessage);
                    this.logger.debug("Recovered incomplete unfinished message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                    ++recoveredMessages;
                    continue;
                }
                if (pendingMessage == null) continue;
                messageId = pendingMessage.getMessageId();
                pendingMinMessageId = ((Message)pendingMessages.pollFirst()).getMessageId() + 1L;
                if (attemptedMessages++ == 0L) {
                    this.logger.info("Starting message recovery for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + "). Incomplete pending ('P') messages found.");
                }
                this.logger.debug("Recovering incomplete pending message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                this.recoverPendingMessage(pendingMessage);
                this.logger.debug("Recovered incomplete pending message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                ++recoveredMessages;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Failed to recover message " + messageId + " for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + "): \n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        } while (!unfinishedComplete || !pendingComplete || !sourceComplete);
        if (attemptedMessages > 0L) {
            this.logger.info("Completed message recovery for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + "). Successfully recovered " + recoveredMessages + " out of " + attemptedMessages + " messages.");
        }
        return null;
    }

    private void recoverUnfinishedMessage(Message unfinishedMessage) throws InterruptedException {
        ConnectorMessage sourceMessage = unfinishedMessage.getConnectorMessages().get(0);
        Collection metaDataIds = null;
        if (sourceMessage.getSourceMap().containsKey("destinationSet")) {
            metaDataIds = (Collection)sourceMessage.getSourceMap().get("destinationSet");
        }
        block2: for (ConnectorMessage connectorMessage : unfinishedMessage.getConnectorMessages().values().toArray(new ConnectorMessage[unfinishedMessage.getConnectorMessages().size()])) {
            Integer metaDataId = connectorMessage.getMetaDataId();
            Status status = connectorMessage.getStatus();
            if (metaDataId == 0) continue;
            if (status == Status.RECEIVED || status == Status.PENDING) {
                for (DestinationChainProvider chainProvider : this.channel.getDestinationChainProviders()) {
                    List<Integer> chainMetaDataIds = chainProvider.getMetaDataIds();
                    if (!chainMetaDataIds.contains(metaDataId)) continue;
                    DestinationChain chain = chainProvider.getChain();
                    ArrayList<Integer> enabledMetaDataIds = new ArrayList<Integer>();
                    for (Integer id : chainMetaDataIds) {
                        if (metaDataIds != null && !metaDataIds.contains(id) || unfinishedMessage.getConnectorMessages().containsKey(id) && id != metaDataId) continue;
                        enabledMetaDataIds.add(id);
                    }
                    if (!enabledMetaDataIds.contains(metaDataId)) {
                        enabledMetaDataIds.add(metaDataId);
                    }
                    chain.setEnabledMetaDataIds(enabledMetaDataIds);
                    chain.setMessage(connectorMessage);
                    chain.setName("Recovery Task Destination Chain Thread on " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                    Object recoveredConnectorMessages = chain.call();
                    if (recoveredConnectorMessages == null) continue block2;
                    Iterator iterator = recoveredConnectorMessages.iterator();
                    while (iterator.hasNext()) {
                        ConnectorMessage recoveredConnectorMessage = (ConnectorMessage)iterator.next();
                        unfinishedMessage.getConnectorMessages().put(recoveredConnectorMessage.getMetaDataId(), recoveredConnectorMessage);
                        sourceMessage.getResponseMap().putAll(recoveredConnectorMessage.getResponseMap());
                    }
                    continue block2;
                }
                continue;
            }
            sourceMessage.getResponseMap().putAll(connectorMessage.getResponseMap());
        }
        ResponseSelector responseSelector = this.channel.getResponseSelector();
        this.channel.finishMessage(unfinishedMessage, !responseSelector.canRespond());
        if (responseSelector.canRespond()) {
            Response response = null;
            String responseErrorMessage = null;
            if (sourceMessage.getResponse() == null) {
                try {
                    response = responseSelector.getResponse(sourceMessage, unfinishedMessage);
                }
                catch (Exception e) {
                    responseErrorMessage = ExceptionUtils.getStackTrace((Throwable)e);
                }
            }
            DispatchResult dispatchResult = new DispatchResult(unfinishedMessage.getMessageId(), unfinishedMessage, response, true, false);
            if (StringUtils.isNotBlank((CharSequence)responseErrorMessage)) {
                dispatchResult.setResponseError(responseErrorMessage);
            }
            this.channel.getSourceConnector().handleRecoveredResponse(dispatchResult);
        }
    }

    private void recoverPendingMessage(Message pendingMessage) throws InterruptedException {
        block0: for (ConnectorMessage pendingConnectorMessage : pendingMessage.getConnectorMessages().values()) {
            Integer metaDataId = pendingConnectorMessage.getMetaDataId();
            for (DestinationChainProvider chainProvider : this.channel.getDestinationChainProviders()) {
                List<Integer> chainMetaDataIds = chainProvider.getMetaDataIds();
                if (!chainMetaDataIds.contains(metaDataId)) continue;
                DestinationChain chain = chainProvider.getChain();
                ArrayList<Integer> enabledMetaDataIds = new ArrayList<Integer>();
                enabledMetaDataIds.add(metaDataId);
                chain.setEnabledMetaDataIds(enabledMetaDataIds);
                chain.setMessage(pendingConnectorMessage);
                chain.setName("Recovery Task Destination Chain Thread on " + this.channel.getName() + " (" + this.channel.getChannelId() + ")");
                chain.call();
                continue block0;
            }
        }
    }
}

