/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.channel.components.ResponseTransformer;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.message.DataType;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.ThreadUtils;
import org.apache.commons.lang3.StringUtils;

public class ResponseTransformerExecutor {
    private DataType inbound;
    private DataType outbound;
    private ResponseTransformer responseTransformer;

    public ResponseTransformerExecutor(DataType inbound, DataType outbound) {
        this.inbound = inbound;
        this.outbound = outbound;
    }

    public DataType getInbound() {
        return this.inbound;
    }

    public void setInbound(DataType inbound) {
        this.inbound = inbound;
    }

    public DataType getOutbound() {
        return this.outbound;
    }

    public void setOutbound(DataType outbound) {
        this.outbound = outbound;
    }

    public ResponseTransformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public void setResponseTransformer(ResponseTransformer responseTransformer) {
        this.responseTransformer = responseTransformer;
    }

    public void runResponseTransformer(DonkeyDao dao, ConnectorMessage connectorMessage, Response response, boolean queueEnabled, StorageSettings storageSettings, Serializer serializer) throws InterruptedException, DonkeyException {
        String content;
        ThreadUtils.checkInterruptedStatus();
        if (this.isActive(response)) {
            boolean wasResponseTransformedNull = connectorMessage.getResponseTransformed() == null;
            String responseTransformedContent = null;
            switch (this.inbound.getSerializationType()) {
                case RAW: {
                    break;
                }
                case JSON: {
                    responseTransformedContent = this.inbound.getSerializer().toJSON(response.getMessage());
                    this.setResponseTransformedContent(connectorMessage, responseTransformedContent, this.inbound.getSerializationType());
                    break;
                }
                default: {
                    responseTransformedContent = this.inbound.getSerializer().toXML(response.getMessage());
                    this.setResponseTransformedContent(connectorMessage, responseTransformedContent, this.inbound.getSerializationType());
                }
            }
            try {
                responseTransformedContent = this.responseTransformer.doTransform(response, connectorMessage);
                this.setResponseTransformedContent(connectorMessage, responseTransformedContent, this.outbound.getSerializationType());
            }
            catch (DonkeyException e) {
                throw e;
            }
            finally {
                if (storageSettings.isStoreResponseTransformed()) {
                    ThreadUtils.checkInterruptedStatus();
                    if (connectorMessage.getResponseTransformed() != null) {
                        if (!wasResponseTransformedNull) {
                            dao.storeMessageContent(connectorMessage.getResponseTransformed());
                        } else {
                            dao.insertMessageContent(connectorMessage.getResponseTransformed());
                        }
                    }
                }
            }
            connectorMessage.setResponseError(response.fixStatus(queueEnabled));
            this.setProcessedResponse(dao, response, connectorMessage, switch (this.outbound.getSerializationType()) {
                case SerializationType.RAW -> responseTransformedContent;
                case SerializationType.JSON -> this.outbound.getSerializer().fromJSON(responseTransformedContent);
                default -> this.outbound.getSerializer().fromXML(responseTransformedContent);
            }, storageSettings, serializer);
        } else if (StringUtils.isNotEmpty((CharSequence)response.getMessage()) && (content = this.inbound.getSerializer().transformWithoutSerializing(response.getMessage(), this.outbound.getSerializer())) != null && !StringUtils.equals((CharSequence)response.getMessage(), (CharSequence)content)) {
            String processedResponseContent = content;
            this.setProcessedResponse(dao, response, connectorMessage, processedResponseContent, storageSettings, serializer);
        }
    }

    public boolean isActive(Response response) {
        return this.responseTransformer != null && (StringUtils.isNotEmpty((CharSequence)response.getMessage()) || this.inbound.getSerializationType() == SerializationType.RAW);
    }

    private void setResponseTransformedContent(ConnectorMessage connectorMessage, String transformedContent, SerializationType serializationType) {
        if (connectorMessage.getResponseTransformed() == null) {
            connectorMessage.setResponseTransformed(new MessageContent(connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.RESPONSE_TRANSFORMED, transformedContent, serializationType.toString(), false));
        } else {
            connectorMessage.getResponseTransformed().setDataType(serializationType.toString());
            connectorMessage.getResponseTransformed().setContent(transformedContent);
        }
    }

    private void setProcessedResponse(DonkeyDao dao, Response response, ConnectorMessage connectorMessage, String processedResponseContent, StorageSettings storageSettings, Serializer serializer) throws InterruptedException {
        response.setMessage(processedResponseContent);
        String responseString = serializer.serialize(response);
        MessageContent processedResponse = new MessageContent(connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.PROCESSED_RESPONSE, responseString, this.outbound.getType(), false);
        if (storageSettings.isStoreProcessedResponse()) {
            ThreadUtils.checkInterruptedStatus();
            if (connectorMessage.getProcessedResponse() != null) {
                dao.storeMessageContent(processedResponse);
            } else {
                dao.insertMessageContent(processedResponse);
            }
        }
        connectorMessage.setProcessedResponse(processedResponse);
    }
}

