/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.DeployedStateEventType;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.MetaDataReplacer;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.DeployedStateEvent;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptor;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.server.message.batch.SimpleResponseHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SourceConnector
extends Connector {
    private boolean respondAfterProcessing = true;
    private MetaDataReplacer metaDataReplacer;
    private BatchAdaptorFactory batchAdaptorFactory;
    private String sourceName = "Source";
    private Logger logger = LogManager.getLogger(this.getClass());

    public boolean isRespondAfterProcessing() {
        return this.respondAfterProcessing;
    }

    public void setRespondAfterProcessing(boolean respondAfterProcessing) {
        this.respondAfterProcessing = respondAfterProcessing;
    }

    public MetaDataReplacer getMetaDataReplacer() {
        return this.metaDataReplacer;
    }

    public void setMetaDataReplacer(MetaDataReplacer metaDataReplacer) {
        this.metaDataReplacer = metaDataReplacer;
    }

    public BatchAdaptorFactory getBatchAdaptorFactory() {
        return this.batchAdaptorFactory;
    }

    public void setBatchAdaptorFactory(BatchAdaptorFactory batchAdaptorFactory) {
        this.batchAdaptorFactory = batchAdaptorFactory;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void updateCurrentState(DeployedState currentState) {
        this.setCurrentState(currentState);
        this.channel.getEventDispatcher().dispatchEvent(new DeployedStateEvent(this.getChannelId(), this.channel.getName(), this.getMetaDataId(), this.sourceName, DeployedStateEventType.getTypeFromDeployedState(currentState)));
    }

    public boolean isProcessBatch() {
        return this.batchAdaptorFactory != null;
    }

    @Override
    public void start() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STARTING);
        if (this.isProcessBatch()) {
            this.batchAdaptorFactory.start();
        }
        this.onStart();
        this.updateCurrentState(DeployedState.STARTED);
    }

    @Override
    public void stop() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STOPPING);
        try {
            this.onStop();
            if (this.isProcessBatch()) {
                this.batchAdaptorFactory.stop();
            }
            this.updateCurrentState(DeployedState.STOPPED);
        }
        catch (Throwable t) {
            Throwable cause = t;
            if (cause instanceof ConnectorTaskException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            this.updateCurrentState(DeployedState.STOPPED);
            if (t instanceof ConnectorTaskException) {
                throw (ConnectorTaskException)t;
            }
            throw new ConnectorTaskException(t);
        }
    }

    @Override
    public void halt() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STOPPING);
        try {
            this.onHalt();
        }
        finally {
            this.channel.getEventDispatcher().dispatchEvent(new ConnectionStatusEvent(this.getChannelId(), this.getMetaDataId(), this.getSourceName(), ConnectionStatusEventType.IDLE));
            this.updateCurrentState(DeployedState.STOPPED);
        }
    }

    public DispatchResult dispatchRawMessage(RawMessage rawMessage) throws ChannelException {
        return this.dispatchRawMessage(rawMessage, false);
    }

    public DispatchResult dispatchRawMessage(RawMessage rawMessage, boolean force) throws ChannelException {
        if (!force && this.getCurrentState() == DeployedState.STOPPED) {
            ChannelException e = new ChannelException(true);
            this.logger.warn("Source connector is currently stopped for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ").", (Throwable)e);
            throw e;
        }
        return this.channel.dispatchRawMessage(rawMessage, false);
    }

    public Boolean dispatchBatchMessage(BatchRawMessage batchRawMessage, ResponseHandler responseHandler) throws BatchMessageException {
        return this.dispatchBatchMessage(batchRawMessage, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean dispatchBatchMessage(BatchRawMessage batchRawMessage, ResponseHandler responseHandler, Collection<Integer> destinationMetaDataIds) throws BatchMessageException {
        if (this.getCurrentState() == DeployedState.STOPPING) {
            return null;
        }
        if (this.getCurrentState() == DeployedState.STOPPED) {
            BatchMessageException e = new BatchMessageException();
            this.logger.warn("Source connector is currently stopped for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ").", (Throwable)e);
            throw e;
        }
        if (responseHandler == null) {
            responseHandler = new SimpleResponseHandler();
        }
        BatchAdaptor batchAdaptor = null;
        boolean messagesExist = false;
        if (!this.batchAdaptorFactory.startBatch()) return messagesExist;
        try {
            String message;
            responseHandler.setUseFirstResponse(this.batchAdaptorFactory.isUseFirstReponse());
            batchAdaptor = this.batchAdaptorFactory.createBatchAdaptor(batchRawMessage);
            Long batchSet = null;
            while ((message = batchAdaptor.getMessage()) != null) {
                messagesExist = true;
                HashMap<String, Object> sourceMap = new HashMap<String, Object>(batchRawMessage.getSourceMap());
                sourceMap.put("batchSequenceId", batchAdaptor.getBatchSequenceId());
                if (batchSet != null) {
                    sourceMap.put("batchId", batchSet);
                }
                if (batchAdaptor.isLookAhead()) {
                    sourceMap.put("batchComplete", batchAdaptor.isBatchComplete());
                }
                RawMessage rawMessage = new RawMessage(message, destinationMetaDataIds, sourceMap, batchRawMessage.getAttachments());
                DispatchResult dispatchResult = null;
                try {
                    dispatchResult = this.channel.dispatchRawMessage(rawMessage, true);
                    responseHandler.setDispatchResult(dispatchResult);
                    if (batchAdaptor.getBatchSequenceId() == 1) {
                        batchSet = dispatchResult.getMessageId();
                    }
                    batchRawMessage.setAttachments(null);
                    try {
                        responseHandler.responseProcess(batchAdaptor.getBatchSequenceId(), batchAdaptor.isBatchComplete());
                    }
                    catch (Exception e) {
                        throw new BatchMessageException("Failed to process response for batch message at message " + batchAdaptor.getBatchSequenceId(), e);
                    }
                    this.finishDispatch(dispatchResult);
                }
                catch (ChannelException e) {
                    try {
                        responseHandler.responseError(e);
                        throw new BatchMessageException("Failed to process batch message at message " + batchAdaptor.getBatchSequenceId(), e);
                    }
                    catch (Throwable throwable) {
                        this.finishDispatch(dispatchResult);
                        throw throwable;
                        return messagesExist;
                    }
                }
            }
        }
        finally {
            try {
                batchAdaptor.cleanup();
            }
            finally {
                this.batchAdaptorFactory.finishBatch();
            }
        }
    }

    public abstract void handleRecoveredResponse(DispatchResult var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDispatch(DispatchResult dispatchResult) {
        if (dispatchResult == null) {
            return;
        }
        try {
            boolean attemptedResponse = dispatchResult.isAttemptedResponse();
            String responseError = dispatchResult.getResponseError();
            Response selectedResponse = dispatchResult.getSelectedResponse();
            Message processedMessage = dispatchResult.getProcessedMessage();
            DonkeyDaoFactory daoFactory = this.channel.getDaoFactory();
            StorageSettings storageSettings = this.channel.getStorageSettings();
            DonkeyDao dao = null;
            boolean commitSuccess = false;
            long messageId = dispatchResult.getMessageId();
            try {
                if (attemptedResponse || responseError != null) {
                    if (dao == null) {
                        dao = daoFactory.getDao();
                    }
                    ConnectorMessage connectorMessage = null;
                    if (processedMessage != null) {
                        connectorMessage = processedMessage.getConnectorMessages().get(0);
                    } else {
                        HashSet<Integer> metaDataIds = new HashSet<Integer>();
                        metaDataIds.add(0);
                        connectorMessage = dao.getConnectorMessages(this.getChannelId(), messageId, metaDataIds, true).get(0);
                    }
                    if (attemptedResponse) {
                        connectorMessage.setSendAttempts(1);
                        connectorMessage.setResponseDate(dispatchResult.getResponseDate());
                        dao.updateSendAttempts(connectorMessage);
                    }
                    if (responseError != null) {
                        connectorMessage.setResponseError(responseError);
                        dao.updateErrors(connectorMessage);
                    }
                }
                if (selectedResponse != null && storageSettings.isStoreSentResponse()) {
                    if (dao == null) {
                        dao = daoFactory.getDao();
                    }
                    String responseContent = this.channel.getSerializer().serialize(selectedResponse);
                    dao.insertMessageContent(new MessageContent(this.getChannelId(), messageId, 0, ContentType.RESPONSE, responseContent, null, false));
                }
                if (storageSettings.isStoreMergedResponseMap() && processedMessage != null) {
                    if (dao == null) {
                        dao = daoFactory.getDao();
                    }
                    dao.updateResponseMap(processedMessage.getConnectorMessages().get(0));
                }
                if (dispatchResult.isMarkAsProcessed()) {
                    if (dao == null) {
                        dao = daoFactory.getDao();
                    }
                    dao.markAsProcessed(this.getChannelId(), messageId);
                    if (!this.channel.isUsingDestinationQueues()) {
                        this.channel.removeContent(dao, processedMessage, messageId, false, false);
                    }
                }
                if (dao != null) {
                    dao.commit(storageSettings.isDurable());
                    commitSuccess = true;
                }
                if (dispatchResult.isMarkAsProcessed() && this.channel.isUsingDestinationQueues()) {
                    this.channel.removeContent(dao, processedMessage, messageId, false, true);
                }
            }
            finally {
                if (dao != null) {
                    if (!commitSuccess) {
                        try {
                            dao.rollback();
                        }
                        catch (Exception exception) {}
                    }
                    dao.close();
                }
            }
        }
        finally {
            if (dispatchResult != null && dispatchResult.isLockAcquired()) {
                this.channel.releaseProcessLock();
                dispatchResult.setLockAcquired(false);
            }
        }
    }
}

