/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.event.MessageEventType;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.event.EventDispatcher;
import com.mirth.connect.donkey.server.event.MessageEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;

public class Statistics {
    public static final Status[] TRACKED_STATUSES = new Status[]{Status.RECEIVED, Status.FILTERED, Status.SENT, Status.ERROR};
    private Map<String, Map<Integer, Map<Status, AtomicLong>>> stats = new ConcurrentHashMap<String, Map<Integer, Map<Status, AtomicLong>>>();
    private EventDispatcher eventDispatcher;
    private boolean sendEvents;
    private boolean allowNegatives;

    public Statistics(boolean sendEvents) {
        this(sendEvents, false);
    }

    public Statistics(boolean sendEvents, boolean allowNegatives) {
        this.sendEvents = sendEvents;
        this.allowNegatives = allowNegatives;
    }

    public Map<String, Map<Integer, Map<Status, Long>>> getStats() {
        HashMap<String, Map<Integer, Map<Status, Long>>> stats = new HashMap<String, Map<Integer, Map<Status, Long>>>();
        for (Map.Entry<String, Map<Integer, Map<Status, AtomicLong>>> channelEntry : this.stats.entrySet()) {
            LinkedHashMap channelMap = new LinkedHashMap();
            for (Map.Entry<Integer, Map<Status, AtomicLong>> metaDataEntry : channelEntry.getValue().entrySet()) {
                LinkedHashMap<Status, Long> statusMap = new LinkedHashMap<Status, Long>();
                for (Map.Entry<Status, AtomicLong> statusEntry : metaDataEntry.getValue().entrySet()) {
                    statusMap.put(statusEntry.getKey(), statusEntry.getValue().get());
                }
                channelMap.put(metaDataEntry.getKey(), statusMap);
            }
            stats.put(channelEntry.getKey(), channelMap);
        }
        return stats;
    }

    public Map<Integer, Map<Status, Long>> getChannelStats(String channelId) {
        LinkedHashMap<Integer, Map<Status, Long>> channelStats = new LinkedHashMap<Integer, Map<Status, Long>>();
        for (Map.Entry<Integer, Map<Status, AtomicLong>> metaDataEntry : this.getChannelStatsMap(channelId).entrySet()) {
            LinkedHashMap<Status, Long> statusMap = new LinkedHashMap<Status, Long>();
            for (Map.Entry<Status, AtomicLong> statusEntry : metaDataEntry.getValue().entrySet()) {
                statusMap.put(statusEntry.getKey(), statusEntry.getValue().get());
            }
            channelStats.put(metaDataEntry.getKey(), statusMap);
        }
        return channelStats;
    }

    public Map<Status, Long> getConnectorStats(String channelId, Integer metaDataId) {
        LinkedHashMap<Status, Long> statusMap = new LinkedHashMap<Status, Long>();
        for (Map.Entry<Status, AtomicLong> statusEntry : this.getConnectorStatsMap(this.getChannelStatsMap(channelId), metaDataId).entrySet()) {
            statusMap.put(statusEntry.getKey(), statusEntry.getValue().get());
        }
        return statusMap;
    }

    public boolean isEmpty() {
        if (!this.stats.isEmpty()) {
            for (Map<Integer, Map<Status, AtomicLong>> channelMap : this.stats.values()) {
                for (Map<Status, AtomicLong> statusMap : channelMap.values()) {
                    for (AtomicLong diff : statusMap.values()) {
                        if (diff.get() == 0L) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void update(Map<String, Map<Integer, Map<Status, Long>>> stats) {
        for (Map.Entry<String, Map<Integer, Map<Status, Long>>> channelEntry : stats.entrySet()) {
            for (Map.Entry<Integer, Map<Status, Long>> connectorEntry : channelEntry.getValue().entrySet()) {
                Integer metaDataId = connectorEntry.getKey();
                if (metaDataId == null) continue;
                this.update(channelEntry.getKey(), metaDataId, connectorEntry.getValue());
            }
        }
    }

    public void update(String channelId, int metaDataId, Status incrementStatus, Status decrementStatus) {
        if (incrementStatus == decrementStatus) {
            return;
        }
        LinkedHashMap<Status, Long> statsDiff = new LinkedHashMap<Status, Long>();
        statsDiff.put(incrementStatus, 1L);
        if (decrementStatus != null) {
            statsDiff.put(decrementStatus, -1L);
        }
        this.update(channelId, metaDataId, statsDiff);
    }

    public void update(String channelId, int metaDataId, Map<Status, Long> statsDiff) {
        Map<Integer, Map<Status, AtomicLong>> channelStats = this.getChannelStatsMap(channelId);
        Map<Status, AtomicLong> aggregateStats = this.getConnectorStatsMap(channelStats, null);
        Map<Status, AtomicLong> connectorStats = this.getConnectorStatsMap(channelStats, metaDataId);
        for (Map.Entry<Status, Long> statsEntry : statsDiff.entrySet()) {
            MessageEventType type;
            Long diff = statsEntry.getValue();
            if (!ArrayUtils.contains((Object[])TRACKED_STATUSES, (Object)((Object)statsEntry.getKey())) || diff == 0L) continue;
            Status status = statsEntry.getKey();
            AtomicLong statValue = connectorStats.get((Object)status);
            Long connectorCount = this.updateStat(statValue, diff);
            switch (status) {
                case RECEIVED: {
                    if (metaDataId != 0) break;
                    this.updateStat(aggregateStats.get((Object)status), diff);
                    break;
                }
                case FILTERED: 
                case ERROR: {
                    this.updateStat(aggregateStats.get((Object)status), diff);
                    break;
                }
                case SENT: {
                    if (metaDataId <= 0) break;
                    this.updateStat(aggregateStats.get((Object)status), diff);
                    break;
                }
            }
            if (!this.sendEvents || (type = MessageEventType.fromStatus(status)) == null) continue;
            if (this.eventDispatcher == null) {
                this.eventDispatcher = Donkey.getInstance().getEventDispatcher();
            }
            this.eventDispatcher.dispatchEvent(new MessageEvent(channelId, metaDataId, type, connectorCount, diff <= 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateStat(AtomicLong stat, Long diff) {
        if (!this.allowNegatives && diff < 0L) {
            AtomicLong atomicLong = stat;
            synchronized (atomicLong) {
                long connectorDiff = diff;
                long statValueL = stat.get();
                if (statValueL + diff < 0L) {
                    connectorDiff = -statValueL;
                }
                return stat.addAndGet(connectorDiff);
            }
        }
        return stat.addAndGet(diff);
    }

    public void overwrite(String channelId, Integer metaDataId, Map<Status, Long> stats) {
        Map<Status, AtomicLong> connectorStats = this.getConnectorStatsMap(this.getChannelStatsMap(channelId), metaDataId);
        for (Map.Entry<Status, Long> entry : stats.entrySet()) {
            connectorStats.get((Object)entry.getKey()).set(entry.getValue());
        }
    }

    public void update(Statistics statistics) {
        for (Map.Entry<String, Map<Integer, Map<Status, Long>>> entry : statistics.getStats().entrySet()) {
            for (Map.Entry<Integer, Map<Status, Long>> connectorEntry : entry.getValue().entrySet()) {
                Integer metaDataId = connectorEntry.getKey();
                if (metaDataId == null) continue;
                this.update(entry.getKey(), metaDataId, connectorEntry.getValue());
            }
        }
    }

    public void resetStats(String channelId, Integer metaDataId, Set<Status> statuses) {
        for (Status status : statuses) {
            MessageEventType type;
            if (!ArrayUtils.contains((Object[])TRACKED_STATUSES, (Object)((Object)status))) continue;
            Map<Status, AtomicLong> connectorStats = this.getConnectorStatsMap(this.getChannelStatsMap(channelId), metaDataId);
            connectorStats.get((Object)status).set(0L);
            if (!this.sendEvents || metaDataId == null || (type = MessageEventType.fromStatus(status)) == null) continue;
            if (this.eventDispatcher == null) {
                this.eventDispatcher = Donkey.getInstance().getEventDispatcher();
            }
            this.eventDispatcher.dispatchEvent(new MessageEvent(channelId, metaDataId, type, 0L, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String channelId) {
        Map<String, Map<Integer, Map<Status, AtomicLong>>> map = this.stats;
        synchronized (map) {
            Map<Integer, Map<Status, AtomicLong>> channelStats = this.stats.get(channelId);
            if (channelStats != null) {
                Map<Integer, Map<Status, AtomicLong>> map2 = channelStats;
                synchronized (map2) {
                    this.stats.remove(channelId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Map<Integer, Map<Status, AtomicLong>>> map = this.stats;
        synchronized (map) {
            this.stats.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Map<Status, AtomicLong>> getChannelStatsMap(String channelId) {
        Map<Integer, Map<Status, AtomicLong>> channelStats = this.stats.get(channelId);
        if (channelStats == null) {
            Map<String, Map<Integer, Map<Status, AtomicLong>>> map = this.stats;
            synchronized (map) {
                channelStats = this.stats.get(channelId);
                if (channelStats == null) {
                    channelStats = new LinkedHashMap<Integer, Map<Status, AtomicLong>>();
                    this.stats.put(channelId, channelStats);
                }
            }
        }
        return channelStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Status, AtomicLong> getConnectorStatsMap(Map<Integer, Map<Status, AtomicLong>> channelStats, Integer metaDataId) {
        Map<Status, AtomicLong> connectorStats = channelStats.get(metaDataId);
        if (connectorStats == null) {
            Map<Integer, Map<Status, AtomicLong>> map = channelStats;
            synchronized (map) {
                connectorStats = channelStats.get(metaDataId);
                if (connectorStats == null) {
                    connectorStats = new LinkedHashMap<Status, AtomicLong>();
                    connectorStats.put(Status.RECEIVED, new AtomicLong(0L));
                    connectorStats.put(Status.FILTERED, new AtomicLong(0L));
                    connectorStats.put(Status.SENT, new AtomicLong(0L));
                    connectorStats.put(Status.ERROR, new AtomicLong(0L));
                    channelStats.put(metaDataId, connectorStats);
                }
            }
        }
        return connectorStats;
    }

    public static Set<Status> getTrackedStatuses() {
        return new HashSet<Status>(Arrays.asList(TRACKED_STATUSES));
    }
}

