/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.jdbc.PreparedStatementSource;
import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CachedPreparedStatementSource
implements PreparedStatementSource {
    private Map<Long, Map<String, PreparedStatement>> statements = new HashMap<Long, Map<String, PreparedStatement>>();
    private QuerySource querySource;
    private Connection connection;

    public CachedPreparedStatementSource(Connection connection, QuerySource querySource) {
        this.connection = connection;
        this.querySource = querySource;
    }

    @Override
    public PreparedStatement getPreparedStatement(String queryId, Long localChannelId) throws SQLException {
        PreparedStatement statement = null;
        Map<String, PreparedStatement> channelStatements = this.statements.get(localChannelId);
        if (channelStatements == null) {
            channelStatements = new HashMap<String, PreparedStatement>();
            this.statements.put(localChannelId, channelStatements);
        } else {
            statement = channelStatements.get(queryId);
        }
        if (statement == null || statement.isClosed()) {
            statement = null;
            if (localChannelId == null) {
                String query = this.querySource.getQuery(queryId);
                if (query != null) {
                    statement = this.connection.prepareStatement(query);
                }
            } else {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("localChannelId", localChannelId);
                String query = this.querySource.getQuery(queryId, values);
                if (query != null) {
                    statement = this.connection.prepareStatement(query);
                }
            }
            channelStatements.put(queryId, statement);
        }
        return statement;
    }
}

