/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.PooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class DBCPConnectionPool
implements ConnectionPool {
    private DataSource dataSource;
    private int maxConnections;

    public DBCPConnectionPool(String url, String username, String password, int maxConnections, boolean readOnly) {
        this.maxConnections = maxConnections;
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, username, password);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(false));
        poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(readOnly));
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        connectionPool.setMaxTotal(maxConnections);
        connectionPool.setMaxIdle(maxConnections);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        this.dataSource = dataSource;
    }

    @Override
    public PooledConnection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        return new PooledConnection(connection, ((DelegatingConnection)connection).getInnermostDelegate());
    }

    @Override
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

