/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.PooledConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DisabledConnectionPool
implements ConnectionPool {
    private String url;
    private String username;
    private String password;
    private boolean readOnly;

    public DisabledConnectionPool(String url, String username, String password, boolean readOnly) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.readOnly = readOnly;
    }

    @Override
    public PooledConnection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        connection.setAutoCommit(false);
        if (this.readOnly) {
            connection.setReadOnly(true);
        }
        return new PooledConnection(connection, connection);
    }

    @Override
    public Integer getMaxConnections() {
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }
}

