/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.ErrorContent;
import com.mirth.connect.donkey.model.message.MapContent;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.Encryptor;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.ChannelDoesNotExistException;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.jdbc.PreparedStatementSource;
import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import com.mirth.connect.donkey.util.MapUtil;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.io.ByteArrayInputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JdbcDao
implements DonkeyDao {
    private Donkey donkey;
    private Connection connection;
    private QuerySource querySource;
    private PreparedStatementSource statementSource;
    private SerializerProvider serializerProvider;
    private boolean encryptMessageContent;
    private boolean encryptAttachments;
    private boolean encryptCustomMetaData;
    private boolean decryptData;
    private StatisticsUpdater statisticsUpdater;
    private Set<ContentType> alwaysDecrypt = new HashSet<ContentType>();
    private Encryptor encryptor;
    private Statistics currentStats;
    private Statistics totalStats;
    private Statistics transactionStats = new Statistics(false, true);
    private Map<String, Map<Integer, Set<Status>>> resetCurrentStats = new HashMap<String, Map<Integer, Set<Status>>>();
    private Map<String, Map<Integer, Set<Status>>> resetTotalStats = new HashMap<String, Map<Integer, Set<Status>>>();
    private List<String> removedChannelIds = new ArrayList<String>();
    private String asyncCommitCommand;
    private Map<String, Long> localChannelIds;
    private String statsServerId;
    private boolean transactionAlteredChannels = false;
    private char quoteChar = (char)34;
    private Logger logger = LogManager.getLogger(this.getClass());

    protected JdbcDao(Donkey donkey, Connection connection, QuerySource querySource, PreparedStatementSource statementSource, SerializerProvider serializerProvider, boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData, boolean decryptData, StatisticsUpdater statisticsUpdater, Statistics currentStats, Statistics totalStats, String statsServerId) {
        this.donkey = donkey;
        this.connection = connection;
        this.querySource = querySource;
        this.statementSource = statementSource;
        this.serializerProvider = serializerProvider;
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
        this.decryptData = decryptData;
        this.statisticsUpdater = statisticsUpdater;
        this.currentStats = currentStats;
        this.totalStats = totalStats;
        this.statsServerId = statsServerId;
        this.encryptor = donkey.getEncryptor();
        this.alwaysDecrypt.addAll(Arrays.asList(ContentType.getMapTypes()));
        this.alwaysDecrypt.addAll(Arrays.asList(ContentType.getErrorTypes()));
        this.logger.debug("Opened connection");
    }

    @Override
    public void setEncryptData(boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData) {
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
    }

    @Override
    public void setDecryptData(boolean decryptData) {
        this.decryptData = decryptData;
    }

    @Override
    public void setStatisticsUpdater(StatisticsUpdater statisticsUpdater) {
        this.statisticsUpdater = statisticsUpdater;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    @Override
    public void insertMessage(Message message) {
        this.logger.debug(message.getChannelId() + "/" + message.getMessageId() + ": inserting message");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("insertMessage", message.getChannelId());
            statement.setLong(1, message.getMessageId());
            statement.setString(2, message.getServerId());
            statement.setTimestamp(3, new Timestamp(message.getReceivedDate().getTimeInMillis()));
            statement.setBoolean(4, message.isProcessed());
            Long originalId = message.getOriginalId();
            if (originalId != null) {
                statement.setLong(5, originalId);
            } else {
                statement.setNull(5, -5);
            }
            Long importId = message.getImportId();
            if (importId != null) {
                statement.setLong(6, importId);
            } else {
                statement.setNull(6, -5);
            }
            String importChannelId = message.getImportChannelId();
            if (importChannelId != null) {
                statement.setString(7, message.getImportChannelId());
            } else {
                statement.setNull(7, 12);
            }
            statement.executeUpdate();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateSendAttempts(ConnectorMessage connectorMessage) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + ": updating send attempts");
        Calendar sendDate = connectorMessage.getSendDate();
        Calendar responseDate = connectorMessage.getResponseDate();
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("updateSendAttempts", connectorMessage.getChannelId());
            statement.setInt(1, connectorMessage.getSendAttempts());
            statement.setTimestamp(2, sendDate == null ? null : new Timestamp(sendDate.getTimeInMillis()));
            statement.setTimestamp(3, responseDate == null ? null : new Timestamp(responseDate.getTimeInMillis()));
            statement.setInt(4, connectorMessage.getMetaDataId());
            statement.setLong(5, connectorMessage.getMessageId());
            statement.setString(6, connectorMessage.getServerId());
            statement.executeUpdate();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void insertMessageContent(MessageContent messageContent) {
        this.logger.debug(messageContent.getChannelId() + "/" + messageContent.getMessageId() + "/" + messageContent.getMetaDataId() + ": inserting message content (" + messageContent.getContentType().toString() + ")");
        this.insertContent(messageContent.getChannelId(), messageContent.getMessageId(), messageContent.getMetaDataId(), messageContent.getContentType(), messageContent.getContent(), messageContent.getDataType(), messageContent.isEncrypted());
    }

    @Override
    public void batchInsertMessageContent(MessageContent messageContent) {
        this.logger.debug(messageContent.getChannelId() + "/" + messageContent.getMessageId() + "/" + messageContent.getMetaDataId() + ": batch inserting message content (" + messageContent.getContentType().toString() + ")");
        PreparedStatement statement = null;
        try {
            boolean encrypted;
            String content;
            if (this.encryptMessageContent && this.encryptor != null && !messageContent.isEncrypted()) {
                content = this.encryptor.encrypt(messageContent.getContent());
                encrypted = true;
            } else {
                content = messageContent.getContent();
                encrypted = messageContent.isEncrypted();
            }
            statement = this.prepareStatement("batchInsertMessageContent", messageContent.getChannelId());
            statement.setInt(1, messageContent.getMetaDataId());
            statement.setLong(2, messageContent.getMessageId());
            statement.setInt(3, messageContent.getContentType().getContentTypeCode());
            statement.setString(4, content);
            statement.setString(5, messageContent.getDataType());
            statement.setBoolean(6, encrypted);
            statement.addBatch();
            statement.clearParameters();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void executeBatchInsertMessageContent(String channelId) {
        this.logger.debug(channelId + ": executing batch message content insert");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("batchInsertMessageContent", channelId);
            statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public void storeMessageContent(MessageContent messageContent) {
        this.logger.debug(messageContent.getChannelId() + "/" + messageContent.getMessageId() + "/" + messageContent.getMetaDataId() + ": updating message content (" + messageContent.getContentType().toString() + ")");
        this.storeContent(messageContent.getChannelId(), messageContent.getMessageId(), messageContent.getMetaDataId(), messageContent.getContentType(), messageContent.getContent(), messageContent.getDataType(), messageContent.isEncrypted());
    }

    private void insertContent(String channelId, long messageId, int metaDataId, ContentType contentType, String content, String dataType, boolean encrypted) {
        PreparedStatement statement = null;
        try {
            if (this.encryptMessageContent && this.encryptor != null && !encrypted) {
                content = this.encryptor.encrypt(content);
                encrypted = true;
            }
            statement = this.prepareStatement("insertMessageContent", channelId);
            statement.setInt(1, metaDataId);
            statement.setLong(2, messageId);
            statement.setInt(3, contentType.getContentTypeCode());
            statement.setString(4, content);
            statement.setString(5, dataType);
            statement.setBoolean(6, encrypted);
            statement.executeUpdate();
            statement.clearParameters();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    public void storeContent(String channelId, long messageId, int metaDataId, ContentType contentType, String content, String dataType, boolean encrypted) {
        PreparedStatement statement = null;
        try {
            if (this.encryptMessageContent && this.encryptor != null && !encrypted) {
                content = this.encryptor.encrypt(content);
                encrypted = true;
            }
            statement = this.prepareStatement("storeMessageContent", channelId);
            if (content == null) {
                statement.setNull(1, -1);
            } else {
                statement.setString(1, content);
            }
            statement.setString(2, dataType);
            statement.setBoolean(3, encrypted);
            statement.setInt(4, metaDataId);
            statement.setLong(5, messageId);
            statement.setInt(6, contentType.getContentTypeCode());
            int rowCount = statement.executeUpdate();
            statement.clearParameters();
            if (rowCount == 0) {
                this.logger.debug(channelId + "/" + messageId + "/" + metaDataId + ": updating message content (" + contentType.toString() + ")");
                this.closeDatabaseObjectIfNeeded(statement);
                statement = this.prepareStatement("insertMessageContent", channelId);
                statement.setInt(1, metaDataId);
                statement.setLong(2, messageId);
                statement.setInt(3, contentType.getContentTypeCode());
                statement.setString(4, content);
                statement.setString(5, dataType);
                statement.setBoolean(6, encrypted);
                statement.executeUpdate();
                statement.clearParameters();
            }
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void addChannelStatistics(Statistics statistics) {
        HashSet<String> failedChannelIds = null;
        for (Map.Entry<String, Map<Integer, Map<Status, Long>>> channelEntry : statistics.getStats().entrySet()) {
            try {
                String channelId = channelEntry.getKey();
                Map<Integer, Map<Status, Long>> channelAndConnectorStats = channelEntry.getValue();
                HashMap<Integer, Map<Status, Long>> connectorStatsToUpdate = new HashMap<Integer, Map<Status, Long>>();
                Map<Status, Long> channelStats = channelAndConnectorStats.get(null);
                for (Map.Entry<Integer, Map<Status, Long>> entry : channelAndConnectorStats.entrySet()) {
                    Map<Status, Long> connectorStats;
                    Integer metaDataId = entry.getKey();
                    if (metaDataId == null || !this.hasUpdatableStatistics(connectorStats = entry.getValue())) continue;
                    connectorStatsToUpdate.put(metaDataId, connectorStats);
                }
                if (connectorStatsToUpdate.isEmpty() && !this.hasUpdatableStatistics(channelStats)) continue;
                this.updateStatistics(channelId, null, channelStats);
                for (Map.Entry<Integer, Map<Status, Long>> entry : connectorStatsToUpdate.entrySet()) {
                    this.updateStatistics(channelId, entry.getKey(), entry.getValue());
                }
            }
            catch (ChannelDoesNotExistException e) {
                if (failedChannelIds == null) {
                    failedChannelIds = new HashSet<String>();
                }
                failedChannelIds.addAll(e.getChannelIds());
            }
        }
        if (failedChannelIds != null) {
            throw new ChannelDoesNotExistException(failedChannelIds);
        }
    }

    private boolean hasUpdatableStatistics(Map<Status, Long> stats) {
        return stats.get((Object)Status.RECEIVED) != 0L || stats.get((Object)Status.FILTERED) != 0L || stats.get((Object)Status.SENT) != 0L || stats.get((Object)Status.ERROR) != 0L;
    }

    private void updateStatistics(String channelId, Integer metaDataId, Map<Status, Long> stats) {
        long received = stats.get((Object)Status.RECEIVED);
        long filtered = stats.get((Object)Status.FILTERED);
        long sent = stats.get((Object)Status.SENT);
        long error = stats.get((Object)Status.ERROR);
        this.logger.debug(channelId + "/" + metaDataId + ": saving statistics");
        PreparedStatement statement = null;
        try {
            boolean usingCase = false;
            if (metaDataId == null) {
                if (this.querySource.queryExists("updateChannelStatisticsWithCase")) {
                    usingCase = true;
                    statement = this.prepareStatement("updateChannelStatisticsWithCase", channelId);
                } else {
                    statement = this.prepareStatement("updateChannelStatistics", channelId);
                }
            } else if (this.querySource.queryExists("updateConnectorStatisticsWithCase")) {
                usingCase = true;
                statement = this.prepareStatement("updateConnectorStatisticsWithCase", channelId);
            } else {
                statement = this.prepareStatement("updateConnectorStatistics", channelId);
            }
            int paramIndex = 1;
            if (usingCase) {
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, error);
                statement.setLong(paramIndex++, error);
                statement.setLong(paramIndex++, error);
                statement.setLong(paramIndex++, error);
            } else {
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, received);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, filtered);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, sent);
                statement.setLong(paramIndex++, error);
                statement.setLong(paramIndex++, error);
            }
            if (metaDataId != null) {
                statement.setInt(paramIndex++, metaDataId);
                statement.setString(paramIndex++, this.statsServerId);
            } else {
                statement.setString(paramIndex++, this.statsServerId);
            }
            if (statement.executeUpdate() == 0) {
                this.closeDatabaseObjectIfNeeded(statement);
                statement = this.prepareStatement("insertChannelStatistics", channelId);
                if (metaDataId == null) {
                    statement.setNull(1, 4);
                } else {
                    statement.setInt(1, metaDataId);
                }
                statement.setString(2, this.statsServerId);
                statement.setLong(3, received);
                statement.setLong(4, received);
                statement.setLong(5, filtered);
                statement.setLong(6, filtered);
                statement.setLong(7, sent);
                statement.setLong(8, sent);
                statement.setLong(9, error);
                statement.setLong(10, error);
                statement.executeUpdate();
            }
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void insertMessageAttachment(String channelId, long messageId, Attachment attachment) {
        this.logger.debug(channelId + "/" + messageId + ": inserting message attachment");
        PreparedStatement statement = null;
        try {
            String encryptionHeader = attachment.getEncryptionHeader();
            byte[] content = attachment.getContent();
            if (this.encryptAttachments && this.encryptor != null && !attachment.isEncrypted()) {
                Encryptor.EncryptedData result = this.encryptor.encrypt(content);
                encryptionHeader = result.getHeader();
                content = result.getEncryptedData();
            }
            statement = this.prepareStatement("insertMessageAttachment", channelId);
            statement.setString(1, attachment.getId());
            statement.setLong(2, messageId);
            statement.setString(3, attachment.getType());
            statement.setString(7, encryptionHeader);
            int chunkSize = 10000000;
            if (content.length <= chunkSize) {
                statement.setInt(4, 1);
                statement.setInt(5, content.length);
                statement.setBytes(6, content);
                statement.executeUpdate();
            } else {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
                int segmentIndex = 1;
                while (inputStream.available() > 0) {
                    statement.setInt(4, segmentIndex++);
                    int segmentSize = Math.min(chunkSize, inputStream.available());
                    byte[] segment = new byte[segmentSize];
                    inputStream.read(segment, 0, segmentSize);
                    statement.setInt(5, segmentSize);
                    statement.setBytes(6, segment);
                    statement.executeUpdate();
                }
            }
            statement.clearParameters();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateMessageAttachment(String channelId, long messageId, Attachment attachment) {
        this.logger.debug(channelId + "/" + messageId + ": updating message attachment");
        PreparedStatement segmentCountStatement = null;
        ResultSet segmentCountResult = null;
        PreparedStatement updateStatement = null;
        PreparedStatement insertStatement = null;
        try {
            String encryptionHeader = attachment.getEncryptionHeader();
            byte[] content = attachment.getContent();
            if (this.encryptAttachments && this.encryptor != null && !attachment.isEncrypted()) {
                Encryptor.EncryptedData result = this.encryptor.encrypt(content);
                encryptionHeader = result.getHeader();
                content = result.getEncryptedData();
            }
            segmentCountStatement = this.prepareStatement("selectMessageAttachmentSegmentCount", channelId);
            segmentCountStatement.setString(1, attachment.getId());
            segmentCountStatement.setLong(2, messageId);
            segmentCountResult = segmentCountStatement.executeQuery();
            segmentCountResult.next();
            int totalSegmentCount = segmentCountResult.getInt(1);
            updateStatement = this.prepareStatement("updateMessageAttachment", channelId);
            updateStatement.setString(1, attachment.getType());
            updateStatement.setString(4, encryptionHeader);
            updateStatement.setString(5, attachment.getId());
            updateStatement.setLong(6, messageId);
            insertStatement = this.prepareStatement("insertMessageAttachment", channelId);
            insertStatement.setString(1, attachment.getId());
            insertStatement.setLong(2, messageId);
            insertStatement.setString(3, attachment.getType());
            insertStatement.setString(7, encryptionHeader);
            int chunkSize = 10000000;
            ByteArrayInputStream inputStream = null;
            boolean done = false;
            int currentSegmentId = 1;
            while (!done) {
                int contentIndex;
                int attachmentSizeIndex;
                int segmentIdIndex;
                PreparedStatement statement;
                if (currentSegmentId <= totalSegmentCount) {
                    statement = updateStatement;
                    segmentIdIndex = 7;
                    attachmentSizeIndex = 2;
                    contentIndex = 3;
                } else {
                    statement = insertStatement;
                    segmentIdIndex = 4;
                    attachmentSizeIndex = 5;
                    contentIndex = 6;
                }
                statement.setInt(segmentIdIndex, currentSegmentId);
                if (content.length <= chunkSize) {
                    statement.setInt(attachmentSizeIndex, content.length);
                    statement.setBytes(contentIndex, content);
                    statement.executeUpdate();
                    ++currentSegmentId;
                    done = true;
                    continue;
                }
                if (inputStream == null) {
                    inputStream = new ByteArrayInputStream(content);
                }
                if (inputStream.available() > 0) {
                    int segmentSize = Math.min(chunkSize, inputStream.available());
                    byte[] segment = new byte[segmentSize];
                    inputStream.read(segment, 0, segmentSize);
                    statement.setInt(attachmentSizeIndex, segmentSize);
                    statement.setBytes(contentIndex, segment);
                    statement.executeUpdate();
                    ++currentSegmentId;
                    continue;
                }
                done = true;
            }
            updateStatement.clearParameters();
            insertStatement.clearParameters();
            if (totalSegmentCount >= currentSegmentId) {
                PreparedStatement deleteStatement = this.prepareStatement("deleteMessageAttachmentLingeringSegments", channelId);
                deleteStatement.setString(1, attachment.getId());
                deleteStatement.setLong(2, messageId);
                deleteStatement.setInt(3, currentSegmentId);
                deleteStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            ArrayList<AutoCloseable> dbObjects = new ArrayList<AutoCloseable>();
            dbObjects.add(segmentCountStatement);
            dbObjects.add(segmentCountResult);
            dbObjects.add(updateStatement);
            dbObjects.add(insertStatement);
            this.closeDatabaseObjectsIfNeeded(dbObjects);
        }
    }

    @Override
    public void insertMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": inserting custom meta data");
        PreparedStatement statement = null;
        try {
            ArrayList<String> metaDataColumnNames = new ArrayList<String>();
            Map<String, Object> metaDataMap = connectorMessage.getMetaDataMap();
            for (MetaDataColumn metaDataColumn : metaDataColumns) {
                Object value = metaDataMap.get(metaDataColumn.getName());
                if (value == null) continue;
                metaDataColumnNames.add(metaDataColumn.getName());
            }
            if (!metaDataColumnNames.isEmpty()) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("localChannelId", this.getLocalChannelId(connectorMessage.getChannelId()));
                values.put("metaDataColumnNames", this.quoteChar + StringUtils.join(metaDataColumnNames, (String)(this.quoteChar + "," + this.quoteChar)) + this.quoteChar);
                values.put("metaDataColumnPlaceholders", "?" + StringUtils.repeat((String)", ?", (int)(metaDataColumnNames.size() - 1)));
                statement = this.connection.prepareStatement(this.querySource.getQuery("insertMetaData", values));
                statement.setInt(1, connectorMessage.getMetaDataId());
                statement.setLong(2, connectorMessage.getMessageId());
                int n = 3;
                for (MetaDataColumn metaDataColumn : metaDataColumns) {
                    Object value = metaDataMap.get(metaDataColumn.getName());
                    if (value == null) continue;
                    if (this.encryptCustomMetaData && this.encryptor != null && metaDataColumn.getType() == MetaDataColumnType.STRING) {
                        String encryptedValue = this.encryptor.encrypt((String)value);
                        if (StringUtils.length((CharSequence)encryptedValue) <= 255) {
                            value = encryptedValue;
                        } else {
                            value = null;
                            this.logger.error("Encrypted custom metadata column " + metaDataColumn.getName() + " is too long and cannot be stored. Channel " + connectorMessage.getChannelId() + ", messsage " + connectorMessage.getMessageId() + "-" + connectorMessage.getMetaDataId());
                        }
                    }
                    switch (metaDataColumn.getType()) {
                        case STRING: {
                            statement.setString(n, (String)value);
                            break;
                        }
                        case NUMBER: {
                            statement.setBigDecimal(n, (BigDecimal)value);
                            break;
                        }
                        case BOOLEAN: {
                            statement.setBoolean(n, (Boolean)value);
                            break;
                        }
                        case TIMESTAMP: {
                            statement.setTimestamp(n, new Timestamp(((Calendar)value).getTimeInMillis()));
                        }
                    }
                    ++n;
                }
                statement.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new DonkeyDaoException("Failed to insert connector message meta data", e);
        }
        finally {
            this.close(statement);
        }
    }

    @Override
    public void storeMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating custom meta data");
        PreparedStatement statement = null;
        try {
            ArrayList<String> metaDataColumnNames = new ArrayList<String>();
            Map<String, Object> metaDataMap = connectorMessage.getMetaDataMap();
            for (MetaDataColumn metaDataColumn : metaDataColumns) {
                Object value = metaDataMap.get(metaDataColumn.getName());
                if (value == null) continue;
                metaDataColumnNames.add(metaDataColumn.getName());
            }
            if (!metaDataColumnNames.isEmpty()) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("localChannelId", this.getLocalChannelId(connectorMessage.getChannelId()));
                values.put("metaDataColumnPlaceholders", this.quoteChar + StringUtils.join(metaDataColumnNames, (String)(this.quoteChar + " = ?, " + this.quoteChar)) + this.quoteChar + " = ?");
                statement = this.connection.prepareStatement(this.querySource.getQuery("storeMetaData", values));
                int n = 1;
                for (MetaDataColumn metaDataColumn : metaDataColumns) {
                    Object value = metaDataMap.get(metaDataColumn.getName());
                    if (value == null) continue;
                    if (this.encryptCustomMetaData && this.encryptor != null && metaDataColumn.getType() == MetaDataColumnType.STRING) {
                        String encryptedValue = this.encryptor.encrypt((String)value);
                        if (StringUtils.length((CharSequence)encryptedValue) <= 255) {
                            value = encryptedValue;
                        } else {
                            value = null;
                            this.logger.error("Encrypted custom metadata column " + metaDataColumn.getName() + " is too long and cannot be stored. Channel " + connectorMessage.getChannelId() + ", messsage " + connectorMessage.getMessageId() + "-" + connectorMessage.getMetaDataId());
                        }
                    }
                    switch (metaDataColumn.getType()) {
                        case STRING: {
                            statement.setString(n, (String)value);
                            break;
                        }
                        case NUMBER: {
                            statement.setBigDecimal(n, (BigDecimal)value);
                            break;
                        }
                        case BOOLEAN: {
                            statement.setBoolean(n, (Boolean)value);
                            break;
                        }
                        case TIMESTAMP: {
                            statement.setTimestamp(n, new Timestamp(((Calendar)value).getTimeInMillis()));
                        }
                    }
                    ++n;
                }
                statement.setLong(n++, connectorMessage.getMessageId());
                statement.setInt(n, connectorMessage.getMetaDataId());
                statement.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new DonkeyDaoException("Failed to update connector message meta data", e);
        }
        finally {
            this.close(statement);
        }
    }

    @Override
    public void insertConnectorMessage(ConnectorMessage connectorMessage, boolean storeMaps, boolean updateStats) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": inserting connector message with" + (storeMaps ? "" : "out") + " maps");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("insertConnectorMessage", connectorMessage.getChannelId());
            statement.setInt(1, connectorMessage.getMetaDataId());
            statement.setLong(2, connectorMessage.getMessageId());
            statement.setString(3, connectorMessage.getServerId());
            statement.setTimestamp(4, new Timestamp(connectorMessage.getReceivedDate().getTimeInMillis()));
            statement.setString(5, Character.toString(connectorMessage.getStatus().getStatusCode()));
            if (connectorMessage.getConnectorName() == null) {
                statement.setNull(6, 12);
            } else {
                statement.setString(6, connectorMessage.getConnectorName());
            }
            statement.setInt(7, connectorMessage.getSendAttempts());
            if (connectorMessage.getSendDate() == null) {
                statement.setNull(8, 93);
            } else {
                statement.setTimestamp(8, new Timestamp(connectorMessage.getSendDate().getTimeInMillis()));
            }
            if (connectorMessage.getResponseDate() == null) {
                statement.setNull(9, 93);
            } else {
                statement.setTimestamp(9, new Timestamp(connectorMessage.getResponseDate().getTimeInMillis()));
            }
            statement.setInt(10, connectorMessage.getErrorCode());
            statement.setInt(11, connectorMessage.getChainId());
            statement.setInt(12, connectorMessage.getOrderId());
            statement.executeUpdate();
            if (storeMaps) {
                this.updateSourceMap(connectorMessage);
                this.updateMaps(connectorMessage);
            }
            this.updateErrors(connectorMessage);
            if (updateStats) {
                this.transactionStats.update(connectorMessage.getChannelId(), connectorMessage.getMetaDataId(), connectorMessage.getStatus(), null);
            }
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessage(String channelId, long messageId) {
        this.logger.debug(channelId + "/" + messageId + ": deleting message");
        PreparedStatement statement = null;
        try {
            this.cascadeMessageDelete("deleteMessageCascadeAttachments", messageId, channelId);
            this.cascadeMessageDelete("deleteMessageCascadeMetadata", messageId, channelId);
            this.cascadeMessageDelete("deleteMessageCascadeContent", messageId, channelId);
            this.cascadeMessageDelete("deleteMessageCascadeConnectorMessage", messageId, channelId);
            statement = this.prepareStatement("deleteMessage", channelId);
            statement.setLong(1, messageId);
            statement.executeUpdate();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds) {
        this.logger.debug(channelId + "/" + messageId + ": deleting connector messages");
        long localChannelId = this.getLocalChannelId(channelId);
        PreparedStatement statement = null;
        try {
            if (metaDataIds == null) {
                this.cascadeMessageDelete("deleteMessageCascadeMetadata", messageId, channelId);
                this.cascadeMessageDelete("deleteMessageCascadeContent", messageId, channelId);
                statement = this.prepareStatement("deleteConnectorMessages", channelId);
                statement.setLong(1, messageId);
                statement.executeUpdate();
            } else {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("localChannelId", localChannelId);
                values.put("metaDataIds", StringUtils.join(metaDataIds, (char)','));
                this.cascadeMessageDelete("deleteConnectorMessagesByMetaDataIdsCascadeContent", messageId, values);
                this.cascadeMessageDelete("deleteConnectorMessagesByMetaDataIdsCascadeMetadata", messageId, values);
                statement = null;
                try {
                    statement = this.getConnection().prepareStatement(this.querySource.getQuery("deleteConnectorMessagesByMetaDataIds", values));
                    statement.setLong(1, messageId);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessageStatistics(String channelId, long messageId, Set<Integer> metaDataIds) {
        Map<Integer, ConnectorMessage> connectorMessages = this.getConnectorMessages(channelId, messageId, new ArrayList<Integer>(metaDataIds));
        ConnectorMessage sourceMessage = connectorMessages.get(0);
        if (sourceMessage != null && sourceMessage.getServerId().equals(this.statsServerId)) {
            for (Map.Entry<Integer, ConnectorMessage> entry : connectorMessages.entrySet()) {
                Integer metaDataId = entry.getKey();
                ConnectorMessage connectorMessage = entry.getValue();
                if (!connectorMessage.getServerId().equals(this.statsServerId) || metaDataIds != null && !metaDataIds.contains(metaDataId)) continue;
                Status status = connectorMessage.getStatus();
                HashMap<Status, Long> statsDiff = new HashMap<Status, Long>();
                statsDiff.put(Status.RECEIVED, -1L);
                statsDiff.put(status, -1L);
                this.transactionStats.update(channelId, metaDataId, statsDiff);
            }
        }
    }

    @Override
    public void updateStatus(ConnectorMessage connectorMessage, Status previousStatus) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating status from " + previousStatus.getStatusCode() + " to " + connectorMessage.getStatus().getStatusCode());
        PreparedStatement statement = null;
        try {
            if (previousStatus == Status.RECEIVED) {
                previousStatus = null;
            }
            this.transactionStats.update(connectorMessage.getChannelId(), connectorMessage.getMetaDataId(), connectorMessage.getStatus(), previousStatus);
            statement = this.prepareStatement("updateStatus", connectorMessage.getChannelId());
            statement.setString(1, Character.toString(connectorMessage.getStatus().getStatusCode()));
            statement.setInt(2, connectorMessage.getMetaDataId());
            statement.setLong(3, connectorMessage.getMessageId());
            statement.setString(4, connectorMessage.getServerId());
            if (statement.executeUpdate() == 0) {
                throw new DonkeyDaoException("Failed to update connector message status, the connector message was removed from this server.");
            }
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateErrors(ConnectorMessage connectorMessage) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating errors");
        boolean errorsUpdated = false;
        if (this.updateError(connectorMessage.getProcessingErrorContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.PROCESSING_ERROR)) {
            errorsUpdated = true;
        }
        if (this.updateError(connectorMessage.getPostProcessorErrorContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.POSTPROCESSOR_ERROR)) {
            errorsUpdated = true;
        }
        if (this.updateError(connectorMessage.getResponseErrorContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.RESPONSE_ERROR)) {
            errorsUpdated = true;
        }
        if (errorsUpdated) {
            this.updateErrorCode(connectorMessage);
        }
    }

    private boolean updateError(ErrorContent errorContent, String channelId, long messageId, int metaDataId, ContentType contentType) {
        String error = errorContent.getContent();
        boolean encrypted = errorContent.isEncrypted();
        boolean persisted = errorContent.isPersisted();
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            if (persisted) {
                this.storeContent(channelId, messageId, metaDataId, contentType, error, null, encrypted);
            } else {
                this.insertContent(channelId, messageId, metaDataId, contentType, error, null, encrypted);
                errorContent.setPersisted(true);
            }
        } else if (persisted) {
            this.deleteMessageContentByMetaDataIdAndContentType(channelId, messageId, metaDataId, contentType);
        } else {
            return false;
        }
        return true;
    }

    private void updateErrorCode(ConnectorMessage connectorMessage) {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("updateErrorCode", connectorMessage.getChannelId());
            statement.setInt(1, connectorMessage.getErrorCode());
            statement.setInt(2, connectorMessage.getMetaDataId());
            statement.setLong(3, connectorMessage.getMessageId());
            statement.setString(4, connectorMessage.getServerId());
            statement.executeUpdate();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateMaps(ConnectorMessage connectorMessage) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating maps");
        this.updateMap(connectorMessage.getConnectorMapContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.CONNECTOR_MAP);
        this.updateMap(connectorMessage.getChannelMapContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.CHANNEL_MAP);
        this.updateMap(connectorMessage.getResponseMapContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.RESPONSE_MAP);
    }

    private void updateMap(MapContent mapContent, String channelId, long messageId, int metaDataId, ContentType contentType) {
        if (mapContent != null) {
            boolean encrypted = mapContent.isEncrypted();
            boolean persisted = mapContent.isPersisted();
            String content = null;
            if (encrypted) {
                content = (String)mapContent.getContent();
            } else {
                Map<String, Object> map = mapContent.getMap();
                if (MapUtils.isNotEmpty(map)) {
                    content = MapUtil.serializeMap(this.serializerProvider.getSerializer(metaDataId), map);
                }
            }
            if (content != null) {
                if (persisted) {
                    this.storeContent(channelId, messageId, metaDataId, contentType, content, null, encrypted);
                } else {
                    this.insertContent(channelId, messageId, metaDataId, contentType, content, null, encrypted);
                    mapContent.setPersisted(true);
                }
            } else if (persisted) {
                this.deleteMessageContentByMetaDataIdAndContentType(channelId, messageId, metaDataId, contentType);
            }
        }
    }

    @Override
    public void updateSourceMap(ConnectorMessage connectorMessage) {
        if (connectorMessage.getMetaDataId() == 0) {
            this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating source map");
            this.updateMap(connectorMessage.getSourceMapContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.SOURCE_MAP);
        }
    }

    @Override
    public void updateResponseMap(ConnectorMessage connectorMessage) {
        this.logger.debug(connectorMessage.getChannelId() + "/" + connectorMessage.getMessageId() + "/" + connectorMessage.getMetaDataId() + ": updating response map");
        this.updateMap(connectorMessage.getResponseMapContent(), connectorMessage.getChannelId(), connectorMessage.getMessageId(), connectorMessage.getMetaDataId(), ContentType.RESPONSE_MAP);
    }

    @Override
    public void markAsProcessed(String channelId, long messageId) {
        this.logger.debug(channelId + "/" + messageId + ": marking as processed");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("markAsProcessed", channelId);
            statement.setLong(1, messageId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public void resetMessage(String channelId, long messageId) {
        this.logger.debug(channelId + "/" + messageId + ": resetting message");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("resetMessage", channelId);
            statement.setLong(1, messageId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public Map<String, Long> getLocalChannelIds() {
        if (this.localChannelIds == null) {
            ResultSet resultSet = null;
            try {
                this.localChannelIds = new HashMap<String, Long>();
                resultSet = this.prepareStatement("getLocalChannelIds", null).executeQuery();
                while (resultSet.next()) {
                    this.localChannelIds.put(resultSet.getString(1), resultSet.getLong(2));
                }
                this.close(resultSet);
            }
            catch (SQLException e) {
                try {
                    throw new DonkeyDaoException(e);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
            }
        }
        return this.localChannelIds;
    }

    @Override
    public void removeChannel(String channelId) {
        if (!this.getLocalChannelIds().containsKey(channelId)) {
            return;
        }
        this.logger.debug(channelId + ": removing channel");
        this.transactionAlteredChannels = true;
        ArrayList<AutoCloseable> statements = new ArrayList<AutoCloseable>();
        try {
            statements.add(this.prepareStatement("dropStatisticsTable", channelId));
            statements.add(this.prepareStatement("dropAttachmentsTable", channelId));
            statements.add(this.prepareStatement("dropCustomMetadataTable", channelId));
            statements.add(this.prepareStatement("dropMessageContentTable", channelId));
            statements.add(this.prepareStatement("dropMessageMetadataTable", channelId));
            statements.add(this.prepareStatement("dropMessageSequence", channelId));
            statements.add(this.prepareStatement("dropMessageTable", channelId));
            statements.add(this.prepareStatement("deleteChannel", channelId));
            for (AutoCloseable statement : statements) {
                ((PreparedStatement)statement).executeUpdate();
            }
            this.removedChannelIds.add(channelId);
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectsIfNeeded(statements);
        }
    }

    @Override
    public Long selectMaxLocalChannelId() {
        ResultSet resultSet = null;
        try {
            Long maxLocalChannelId = 0L;
            resultSet = this.prepareStatement("selectMaxLocalChannelId", null).executeQuery();
            if (resultSet.next()) {
                maxLocalChannelId = resultSet.getLong(1);
            }
            resultSet.close();
            Long l = maxLocalChannelId;
            this.close(resultSet);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteAllMessages(String channelId) {
        this.logger.debug(channelId + ": deleting all messages");
        ArrayList<AutoCloseable> statements = new ArrayList<AutoCloseable>();
        try {
            this.cascadeMessageDelete("deleteAllMessagesCascadeAttachments", channelId);
            this.cascadeMessageDelete("deleteAllMessagesCascadeMetadata", channelId);
            this.cascadeMessageDelete("deleteAllMessagesCascadeContent", channelId);
            PreparedStatement statement = null;
            if (this.querySource.queryExists("dropConstraintMessageContentTable")) {
                statement = this.prepareStatement("dropConstraintMessageContentTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            if (this.querySource.queryExists("dropConstraintMessageCustomMetaDataTable")) {
                statement = this.prepareStatement("dropConstraintMessageCustomMetaDataTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            this.cascadeMessageDelete("deleteAllMessagesCascadeConnectorMessage", channelId);
            if (this.querySource.queryExists("addConstraintMessageCustomMetaDataTable")) {
                statement = this.prepareStatement("addConstraintMessageCustomMetaDataTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            if (this.querySource.queryExists("addConstraintMessageContentTable")) {
                statement = this.prepareStatement("addConstraintMessageContentTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            if (this.querySource.queryExists("dropConstraintConnectorMessageTable")) {
                statement = this.prepareStatement("dropConstraintConnectorMessageTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            if (this.querySource.queryExists("dropConstraintAttachmentTable")) {
                statement = this.prepareStatement("dropConstraintAttachmentTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            statement = this.prepareStatement("deleteAllMessages", channelId);
            statements.add(statement);
            statement.executeUpdate();
            if (this.querySource.queryExists("addConstraintAttachmentTable")) {
                statement = this.prepareStatement("addConstraintAttachmentTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
            if (this.querySource.queryExists("addConstraintConnectorMessageTable")) {
                statement = this.prepareStatement("addConstraintConnectorMessageTable", channelId);
                statements.add(statement);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectsIfNeeded(statements);
        }
    }

    @Override
    public void deleteMessageContent(String channelId, long messageId) {
        this.logger.debug(channelId + "/" + messageId + ": deleting content");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("deleteMessageContent", channelId);
            statement.setLong(1, messageId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public void deleteMessageContentByMetaDataIds(String channelId, long messageId, Set<Integer> metaDataIds) {
        this.logger.debug(channelId + "/" + messageId + ": deleting content by metadata IDs: " + String.valueOf(metaDataIds));
        PreparedStatement statement = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            values.put("metaDataIds", StringUtils.join(metaDataIds, (char)','));
            statement = this.getConnection().prepareStatement(this.querySource.getQuery("deleteMessageContentByMetaDataIds", values));
            statement.setLong(1, messageId);
            statement.executeUpdate();
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    private void deleteMessageContentByMetaDataIdAndContentType(String channelId, long messageId, int metaDataId, ContentType contentType) {
        this.logger.debug(channelId + "/" + messageId + ": deleting content");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("deleteMessageContentByMetaDataIdAndContentType", channelId);
            statement.setLong(1, messageId);
            statement.setInt(2, metaDataId);
            statement.setInt(3, contentType.getContentTypeCode());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public void deleteMessageAttachments(String channelId, long messageId) {
        this.logger.debug(channelId + "/" + messageId + ": deleting attachments");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("deleteMessageAttachments", channelId);
            statement.setLong(1, messageId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    @Override
    public List<MetaDataColumn> getMetaDataColumns(String channelId) {
        ArrayList<MetaDataColumn> metaDataColumns;
        ResultSet columns;
        block7: {
            columns = null;
            metaDataColumns = new ArrayList<MetaDataColumn>();
            long localChannelId = this.getLocalChannelId(channelId);
            columns = this.connection.getMetaData().getColumns(this.connection.getCatalog(), null, "d_mcm" + localChannelId, null);
            if (columns.next()) break block7;
            columns.close();
            columns = this.connection.getMetaData().getColumns(this.connection.getCatalog(), null, "D_MCM" + localChannelId, null);
            if (columns.next()) break block7;
            ArrayList<MetaDataColumn> arrayList = metaDataColumns;
            this.close(columns);
            return arrayList;
        }
        try {
            do {
                String name;
                if ((name = columns.getString("COLUMN_NAME")).equalsIgnoreCase("METADATA_ID") || name.equalsIgnoreCase("MESSAGE_ID")) continue;
                MetaDataColumnType columnType = MetaDataColumnType.fromSqlType(columns.getInt("DATA_TYPE"));
                if (columnType == null) {
                    this.logger.error("Invalid custom metadata column: " + name + " (type: " + JdbcDao.sqlTypeToString(columns.getInt("DATA_TYPE")) + ").");
                    continue;
                }
                metaDataColumns.add(new MetaDataColumn(name, columnType, null));
            } while (columns.next());
            ArrayList<MetaDataColumn> arrayList = metaDataColumns;
            this.close(columns);
            return arrayList;
        }
        catch (Exception e) {
            try {
                throw new DonkeyDaoException("Failed to retrieve meta data columns", e);
            }
            catch (Throwable throwable) {
                this.close(columns);
                throw throwable;
            }
        }
    }

    @Override
    public void removeMetaDataColumn(String channelId, String columnName) {
        this.logger.debug(channelId + "/: removing custom meta data column (" + columnName + ")");
        Statement statement = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            values.put("columnName", columnName);
            statement = this.connection.createStatement();
            if (this.querySource.queryExists("removeMetaDataColumnIndex")) {
                statement.executeUpdate(this.querySource.getQuery("removeMetaDataColumnIndex", values));
            }
            statement.executeUpdate(this.querySource.getQuery("removeMetaDataColumn", values));
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException("Failed to remove meta-data column", e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public long getMaxMessageId(String channelId) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("getMaxMessageId", channelId);
            resultSet = statement.executeQuery();
            long l = resultSet.next() ? Long.valueOf(resultSet.getLong(1)) : null;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public long getMinMessageId(String channelId) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("getMinMessageId", channelId);
            resultSet = statement.executeQuery();
            long l = resultSet.next() ? Long.valueOf(resultSet.getLong(1)) : null;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public long getNextMessageId(String channelId) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            statement = this.connection.createStatement();
            if (this.querySource.queryExists("lockMessageSequenceTable")) {
                statement.executeUpdate(this.querySource.getQuery("lockMessageSequenceTable", values));
            }
            resultSet = statement.executeQuery(this.querySource.getQuery("getNextMessageId", values));
            resultSet.next();
            long id = resultSet.getLong(1);
            this.close(resultSet);
            if (this.querySource.queryExists("incrementMessageIdSequence")) {
                statement.executeUpdate(this.querySource.getQuery("incrementMessageIdSequence", values));
            }
            long l = id;
            this.close(resultSet);
            this.close(statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<Attachment> getMessageAttachment(String channelId, long messageId) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("selectMessageAttachmentSizeByMessageId", channelId);
            statement.setLong(1, messageId);
            resultSet = statement.executeQuery();
            HashMap<String, Integer> attachmentSize = new HashMap<String, Integer>();
            while (resultSet.next()) {
                attachmentSize.put(resultSet.getString("id"), resultSet.getInt("attachment_size"));
            }
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            statement = this.prepareStatement("selectMessageAttachmentByMessageId", channelId);
            statement.setLong(1, messageId);
            statement.setFetchSize(1);
            resultSet = statement.executeQuery();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            String currentAttachmentId = null;
            String type = null;
            String encryptionHeader = null;
            byte[] content = null;
            int offset = 0;
            while (resultSet.next()) {
                byte[] segment;
                String attachmentId = resultSet.getString("id");
                if (!attachmentSize.containsKey(attachmentId)) continue;
                if (!attachmentId.equals(currentAttachmentId)) {
                    if (content != null) {
                        if (this.decryptData && this.encryptor != null && encryptionHeader != null) {
                            content = this.encryptor.decrypt(encryptionHeader, content);
                            attachments.add(new Attachment(currentAttachmentId, content, type));
                        } else {
                            attachments.add(new Attachment(currentAttachmentId, content, type, encryptionHeader));
                        }
                    }
                    currentAttachmentId = attachmentId;
                    type = resultSet.getString("type");
                    encryptionHeader = resultSet.getString("encryption_header");
                    content = new byte[((Integer)attachmentSize.get(attachmentId)).intValue()];
                    offset = 0;
                }
                if ((segment = resultSet.getBytes("content")) == null) continue;
                System.arraycopy(segment, 0, content, offset, segment.length);
                offset += segment.length;
            }
            if (content != null) {
                if (this.decryptData && this.encryptor != null && encryptionHeader != null) {
                    content = this.encryptor.decrypt(encryptionHeader, content);
                    attachments.add(new Attachment(currentAttachmentId, content, type));
                } else {
                    attachments.add(new Attachment(currentAttachmentId, content, type, encryptionHeader));
                }
            }
            content = null;
            ArrayList<Attachment> arrayList = attachments;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public Attachment getMessageAttachment(String channelId, String attachmentId, Long messageId) {
        ResultSet resultSet = null;
        Attachment attachment = new Attachment();
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("selectMessageAttachmentSize", channelId);
            statement.setString(1, attachmentId);
            statement.setLong(2, messageId);
            resultSet = statement.executeQuery();
            int size = 0;
            if (resultSet.next()) {
                size = resultSet.getInt("attachment_size");
            }
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            statement = this.prepareStatement("selectMessageAttachment", channelId);
            statement.setString(1, attachmentId);
            statement.setLong(2, messageId);
            statement.setFetchSize(1);
            resultSet = statement.executeQuery();
            String type = null;
            String encryptionHeader = null;
            byte[] content = null;
            int offset = 0;
            while (resultSet.next()) {
                byte[] segment;
                if (content == null) {
                    type = resultSet.getString("type");
                    encryptionHeader = resultSet.getString("encryption_header");
                    content = new byte[size];
                }
                if ((segment = resultSet.getBytes("content")) == null) continue;
                System.arraycopy(segment, 0, content, offset, segment.length);
                offset += segment.length;
            }
            if (content != null) {
                attachment.setId(attachmentId);
                attachment.setType(type);
                if (this.decryptData && this.encryptor != null && encryptionHeader != null) {
                    content = this.encryptor.decrypt(encryptionHeader, content);
                } else {
                    attachment.setEncryptionHeader(encryptionHeader);
                    attachment.setEncrypted(true);
                }
                attachment.setContent(content);
            }
            content = null;
            Attachment attachment2 = attachment;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return attachment2;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<Message> getUnfinishedMessages(String channelId, String serverId, int limit, Long minMessageId) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<Long, Message> messageMap = new HashMap<Long, Message>();
            ArrayList<Message> messageList = new ArrayList<Message>();
            ArrayList<Long> messageIds = new ArrayList<Long>();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            params.put("limit", limit);
            statement = this.connection.prepareStatement(this.querySource.getQuery("getUnfinishedMessages", params));
            statement.setLong(1, minMessageId);
            statement.setString(2, serverId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Message message = this.getMessageFromResultSet(channelId, resultSet);
                messageMap.put(message.getMessageId(), message);
                messageList.add(message);
                messageIds.add(message.getMessageId());
            }
            this.close(resultSet);
            this.close(statement);
            if (!messageIds.isEmpty()) {
                params = new HashMap();
                params.put("localChannelId", this.getLocalChannelId(channelId));
                params.put("messageIds", StringUtils.join(messageIds, (String)","));
                statement = this.connection.prepareStatement(this.querySource.getQuery("getConnectorMessagesByMessageIds", params));
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    ConnectorMessage connectorMessage = this.getConnectorMessageFromResultSet(channelId, resultSet, true, true);
                    ((Message)messageMap.get(connectorMessage.getMessageId())).getConnectorMessages().put(connectorMessage.getMetaDataId(), connectorMessage);
                }
            }
            ArrayList<Message> arrayList = messageList;
            this.close(resultSet);
            this.close(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<Message> getPendingConnectorMessages(String channelId, String serverId, int limit, Long minMessageId) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<Long, Message> messageMap = new HashMap<Long, Message>();
            ArrayList<Message> messageList = new ArrayList<Message>();
            ArrayList<Long> messageIds = new ArrayList<Long>();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            params.put("limit", limit);
            statement = this.connection.prepareStatement(this.querySource.getQuery("getPendingMessageIds", params));
            statement.setLong(1, minMessageId);
            statement.setString(2, serverId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Message message = new Message();
                message.setMessageId(resultSet.getLong(1));
                messageMap.put(message.getMessageId(), message);
                messageList.add(message);
                messageIds.add(message.getMessageId());
            }
            this.close(resultSet);
            this.close(statement);
            if (!messageIds.isEmpty()) {
                params = new HashMap();
                params.put("localChannelId", this.getLocalChannelId(channelId));
                params.put("messageIds", StringUtils.join(messageIds, (String)","));
                statement = this.connection.prepareStatement(this.querySource.getQuery("getPendingConnectorMessages", params));
                statement.setString(1, serverId);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    ConnectorMessage connectorMessage = this.getConnectorMessageFromResultSet(channelId, resultSet, true, true);
                    ((Message)messageMap.get(connectorMessage.getMessageId())).getConnectorMessages().put(connectorMessage.getMetaDataId(), connectorMessage);
                }
            }
            ArrayList<Message> arrayList = messageList;
            this.close(resultSet);
            this.close(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<Message> getMessages(String channelId, List<Long> messageIds) {
        if (messageIds.size() > 1000) {
            throw new DonkeyDaoException("Only up to 1000 message Ids at a time are supported.");
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        LinkedHashMap<Long, Message> messageMap = new LinkedHashMap<Long, Message>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            params.put("messageIds", StringUtils.join(messageIds, (String)","));
            statement = this.connection.prepareStatement(this.querySource.getQuery("getMessagesByMessageIds", params));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Message message = this.getMessageFromResultSet(channelId, resultSet);
                messageMap.put(message.getMessageId(), message);
            }
            if (!messageIds.isEmpty()) {
                this.close(resultSet);
                this.close(statement);
                Map<Long, Map<Integer, List<MessageContent>>> messageContentMap = this.getMessageContent(channelId, messageIds);
                Map<Long, Map<Integer, Map<String, Object>>> metaDataMaps = this.getMetaDataMaps(channelId, messageIds);
                params = new HashMap();
                params.put("localChannelId", this.getLocalChannelId(channelId));
                params.put("messageIds", StringUtils.join(messageIds, (String)","));
                statement = this.connection.prepareStatement(this.querySource.getQuery("getConnectorMessagesByMessageIds", params));
                resultSet = statement.executeQuery();
                ConnectorMessage sourceConnectorMessage = null;
                long currentMessageId = 0L;
                while (resultSet.next()) {
                    Map<String, Object> metaDataMap;
                    Map<Integer, Map<String, Object>> connectorMetaDataMap;
                    List<MessageContent> messageContents;
                    ConnectorMessage connectorMessage = this.getConnectorMessageFromResultSet(channelId, resultSet, false, false);
                    ((Message)messageMap.get(connectorMessage.getMessageId())).getConnectorMessages().put(connectorMessage.getMetaDataId(), connectorMessage);
                    if (currentMessageId != connectorMessage.getMessageId()) {
                        currentMessageId = connectorMessage.getMessageId();
                        sourceConnectorMessage = null;
                    }
                    if (connectorMessage.getMetaDataId() == 0) {
                        sourceConnectorMessage = connectorMessage;
                    } else if (sourceConnectorMessage != null) {
                        connectorMessage.setSourceMap(sourceConnectorMessage.getSourceMap());
                        MessageContent sourceEncoded = sourceConnectorMessage.getEncoded();
                        if (sourceEncoded != null) {
                            MessageContent destinationRaw = new MessageContent(channelId, sourceEncoded.getMessageId(), connectorMessage.getMetaDataId(), ContentType.RAW, sourceEncoded.getContent(), sourceEncoded.getDataType(), sourceEncoded.isEncrypted());
                            connectorMessage.setRaw(destinationRaw);
                        }
                    }
                    Map<Integer, List<MessageContent>> connectorMessageContentMap = messageContentMap.get(connectorMessage.getMessageId());
                    if (connectorMessageContentMap != null && (messageContents = connectorMessageContentMap.get(connectorMessage.getMetaDataId())) != null) {
                        this.loadMessageContent(connectorMessage, messageContents);
                    }
                    if ((connectorMetaDataMap = metaDataMaps.get(connectorMessage.getMessageId())) == null || (metaDataMap = connectorMetaDataMap.get(connectorMessage.getMetaDataId())) == null) continue;
                    connectorMessage.setMetaDataMap(metaDataMap);
                }
            }
            ArrayList<Message> arrayList = new ArrayList<Message>(messageMap.values());
            this.close(resultSet);
            this.close(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, String serverId, int metaDataId, Status status, int offset, int limit, Long minMessageId, Long maxMessageId) {
        ArrayList<ConnectorMessage> connectorMessages = new ArrayList<ConnectorMessage>();
        if (limit == 0) {
            return connectorMessages;
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            params.put("offset", offset);
            params.put("limit", limit);
            int index = 1;
            if (minMessageId == null || maxMessageId == null) {
                statement = this.connection.prepareStatement(this.querySource.getQuery(serverId != null ? "getConnectorMessagesByMetaDataIdAndStatusWithLimit" : "getConnectorMessagesByMetaDataIdAndStatusWithLimitAllServers", params));
                statement.setInt(index++, metaDataId);
                statement.setString(index++, Character.toString(status.getStatusCode()));
                if (serverId != null) {
                    statement.setString(index++, serverId);
                }
            } else {
                statement = this.connection.prepareStatement(this.querySource.getQuery(serverId != null ? "getConnectorMessagesByMetaDataIdAndStatusWithLimitAndRange" : "getConnectorMessagesByMetaDataIdAndStatusWithLimitAndRangeAllServers", params));
                statement.setInt(index++, metaDataId);
                statement.setString(index++, Character.toString(status.getStatusCode()));
                if (serverId != null) {
                    statement.setString(index++, serverId);
                }
                statement.setLong(index++, minMessageId);
                statement.setLong(index++, maxMessageId);
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                connectorMessages.add(this.getConnectorMessageFromResultSet(channelId, resultSet, true, true));
            }
            ArrayList<ConnectorMessage> arrayList = connectorMessages;
            this.close(resultSet);
            this.close(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds, boolean includeContent) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            values.put("metaDataIds", StringUtils.join(metaDataIds, (char)','));
            statement = this.connection.prepareStatement(this.querySource.getQuery("getConnectorMessagesByMessageIdAndMetaDataIds", values));
            statement.setLong(1, messageId);
            resultSet = statement.executeQuery();
            ArrayList<ConnectorMessage> connectorMessages = new ArrayList<ConnectorMessage>();
            while (resultSet.next()) {
                connectorMessages.add(this.getConnectorMessageFromResultSet(channelId, resultSet, includeContent, true));
            }
            ArrayList<ConnectorMessage> arrayList = connectorMessages;
            this.close(resultSet);
            this.close(statement);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public Map<Integer, ConnectorMessage> getConnectorMessages(String channelId, long messageId, List<Integer> metaDataIds) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            boolean includeMetaDataIds = CollectionUtils.isNotEmpty(metaDataIds);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            if (includeMetaDataIds) {
                params.put("metaDataIds", StringUtils.join(metaDataIds, (char)','));
            }
            statement = this.getConnection().prepareStatement(this.querySource.getQuery(includeMetaDataIds ? "getConnectorMessagesByMessageIdAndMetaDataIds" : "getConnectorMessagesByMessageId", params));
            statement.setLong(1, messageId);
            resultSet = statement.executeQuery();
            HashMap<Integer, ConnectorMessage> connectorMessages = new HashMap<Integer, ConnectorMessage>();
            while (resultSet.next()) {
                ConnectorMessage connectorMessage = this.getConnectorMessageFromResultSet(channelId, resultSet, true, true);
                connectorMessages.put(connectorMessage.getMetaDataId(), connectorMessage);
            }
            HashMap<Integer, ConnectorMessage> hashMap = connectorMessages;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return hashMap;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public Map<Integer, Status> getConnectorMessageStatuses(String channelId, long messageId, boolean checkProcessed) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(checkProcessed ? "getConnectorMessageStatusesCheckProcessed" : "getConnectorMessageStatuses", channelId);
            statement.setLong(1, messageId);
            resultSet = statement.executeQuery();
            HashMap<Integer, Status> statusMap = new HashMap<Integer, Status>();
            while (resultSet.next()) {
                statusMap.put(resultSet.getInt(1), Status.fromChar(resultSet.getString(2).charAt(0)));
            }
            HashMap<Integer, Status> hashMap = statusMap;
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return hashMap;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public int getConnectorMessageCount(String channelId, String serverId, int metaDataId, Status status) {
        if (this.donkey.getDeployedChannels().get(channelId) != null || this.getLocalChannelIds().get(channelId) != null) {
            ResultSet resultSet = null;
            PreparedStatement statement = null;
            try {
                statement = this.statementSource.getPreparedStatement(serverId != null ? "getConnectorMessageCountByMetaDataIdAndStatus" : "getConnectorMessageCountByMetaDataIdAndStatusAllServers", this.getLocalChannelId(channelId));
                statement.setInt(1, metaDataId);
                statement.setString(2, Character.toString(status.getStatusCode()));
                if (serverId != null) {
                    statement.setString(3, serverId);
                }
                resultSet = statement.executeQuery();
                resultSet.next();
                int n = resultSet.getInt(1);
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                return n;
            }
            catch (SQLException e) {
                try {
                    throw new DonkeyDaoException(e);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    this.closeDatabaseObjectIfNeeded(statement);
                    throw throwable;
                }
            }
        }
        return 0;
    }

    @Override
    public long getConnectorMessageMaxMessageId(String channelId, String serverId, int metaDataId, Status status) {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(serverId != null ? "getConnectorMessageMaxMessageIdByMetaDataIdAndStatus" : "getConnectorMessageMaxMessageIdByMetaDataIdAndStatusAllServers", channelId);
            statement.setInt(1, metaDataId);
            statement.setString(2, Character.toString(status.getStatusCode()));
            if (serverId != null) {
                statement.setString(3, serverId);
            }
            resultSet = statement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void addMetaDataColumn(String channelId, MetaDataColumn metaDataColumn) {
        this.logger.debug(channelId + ": adding custom meta data column (" + metaDataColumn.getName() + ")");
        Statement statement = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            values.put("columnName", metaDataColumn.getName());
            String queryName = "addMetaDataColumn" + StringUtils.capitalize((String)StringUtils.lowerCase((String)metaDataColumn.getType().toString()));
            statement = this.connection.createStatement();
            statement.executeUpdate(this.querySource.getQuery(queryName, values));
            if (this.querySource.queryExists(queryName + "Index")) {
                statement.executeUpdate(this.querySource.getQuery(queryName + "Index", values));
            }
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException("Failed to add meta-data column", e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public void createChannel(String channelId, long localChannelId) {
        this.logger.debug(channelId + ": creating channel");
        Statement initSequenceStatement = null;
        this.transactionAlteredChannels = true;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("createChannel", null);
            statement.setString(1, channelId);
            statement.setLong(2, localChannelId);
            statement.executeUpdate();
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", localChannelId);
            this.createTable("createMessageTable", values);
            this.createTable("createConnectorMessageTable", values);
            this.createTable("createMessageContentTable", values);
            this.createTable("createMessageCustomMetaDataTable", values);
            this.createTable("createMessageAttachmentTable", values);
            this.createTable("createMessageStatisticsTable", values);
            this.createTable("createMessageSequence", values);
            if (this.querySource.queryExists("initMessageSequence")) {
                initSequenceStatement = this.getConnection().createStatement();
                initSequenceStatement.executeUpdate(this.querySource.getQuery("initMessageSequence", values));
            }
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.close(initSequenceStatement);
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    private void createTable(String query, Map<String, Object> values) {
        if (this.querySource.queryExists(query)) {
            Statement statement = null;
            int n = 1;
            try {
                statement = this.connection.createStatement();
                statement.executeUpdate(this.querySource.getQuery(query, values));
                String sequenceQuery = this.querySource.getQuery(query + "Sequence", values);
                if (sequenceQuery != null) {
                    statement.executeUpdate(sequenceQuery);
                }
                String indexQuery = this.querySource.getQuery(query + "Index" + n, values);
                while (indexQuery != null) {
                    statement.executeUpdate(indexQuery);
                    indexQuery = this.querySource.getQuery(query + "Index" + ++n, values);
                }
            }
            catch (SQLException e) {
                throw new DonkeyDaoException(e);
            }
            finally {
                this.close(statement);
            }
        }
    }

    @Override
    public void checkAndCreateChannelTables() {
        Map<String, Long> channelIds = this.getLocalChannelIds();
        LinkedHashMap<CallSite, String> channelTablesMap = new LinkedHashMap<CallSite, String>();
        for (Long localChannelId : channelIds.values()) {
            channelTablesMap.put((CallSite)((Object)("d_m" + localChannelId)), "createMessageTable");
            channelTablesMap.put((CallSite)((Object)("d_mm" + localChannelId)), "createConnectorMessageTable");
            channelTablesMap.put((CallSite)((Object)("d_mc" + localChannelId)), "createMessageContentTable");
            channelTablesMap.put((CallSite)((Object)("d_mcm" + localChannelId)), "createMessageCustomMetaDataTable");
            channelTablesMap.put((CallSite)((Object)("d_ma" + localChannelId)), "createMessageAttachmentTable");
            channelTablesMap.put((CallSite)((Object)("d_ms" + localChannelId)), "createMessageStatisticsTable");
            channelTablesMap.put((CallSite)((Object)("d_msq" + localChannelId)), "createMessageSequence");
        }
        ResultSet rs = null;
        Statement statement = null;
        try {
            DatabaseMetaData dbMetaData = this.connection.getMetaData();
            rs = dbMetaData.getTables(null, null, "%", null);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME").toLowerCase();
                channelTablesMap.remove(tableName);
            }
            this.close(rs);
            if (this.querySource.queryExists("getSequenceMetadata")) {
                statement = this.connection.createStatement();
                rs = statement.executeQuery(this.querySource.getQuery("getSequenceMetadata"));
                while (rs.next()) {
                    String sequenceName = rs.getString("SEQUENCE_NAME").toLowerCase();
                    channelTablesMap.remove(sequenceName);
                }
            }
            this.close(rs);
            this.close(statement);
        }
        catch (Exception e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(statement);
                throw throwable;
            }
        }
        for (Map.Entry entry : channelTablesMap.entrySet()) {
            Statement initSequenceStatement = null;
            try {
                Long localChannelId = Long.parseLong(((String)entry.getKey()).replaceAll("[^0-9]", ""));
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("localChannelId", localChannelId);
                this.createTable((String)entry.getValue(), values);
                if (!((String)entry.getKey()).toLowerCase().contains("d_msq") || !this.querySource.queryExists("initMessageSequence")) continue;
                initSequenceStatement = this.connection.createStatement();
                initSequenceStatement.executeUpdate(this.querySource.getQuery("initMessageSequence", values));
            }
            catch (Exception e) {
                throw new DonkeyDaoException(e);
            }
            finally {
                this.close(initSequenceStatement);
            }
        }
    }

    @Override
    public void resetStatistics(String channelId, Integer metaDataId, Set<Status> statuses) {
        this.logger.debug(channelId + ": resetting statistics" + (String)(metaDataId == null ? "" : " for metadata id " + metaDataId));
        PreparedStatement statement = null;
        try {
            Map<Integer, Set<Status>> metaDataIds;
            if (statuses == null || statuses.size() == 0) {
                return;
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            int count = 0;
            StringBuilder builder = new StringBuilder();
            for (Status status : statuses) {
                if (++count > 1) {
                    builder.append(",");
                }
                builder.append(status.toString() + " = 0");
            }
            values.put("statuses", builder.toString());
            String queryName = metaDataId == null ? "resetChannelStatistics" : "resetConnectorStatistics";
            statement = this.connection.prepareStatement(this.querySource.getQuery(queryName, values));
            statement.setString(1, this.statsServerId);
            if (metaDataId != null) {
                statement.setInt(2, metaDataId);
            }
            statement.executeUpdate();
            if (!this.resetCurrentStats.containsKey(channelId)) {
                this.resetCurrentStats.put(channelId, new HashMap());
            }
            if (!(metaDataIds = this.resetCurrentStats.get(channelId)).containsKey(metaDataId)) {
                metaDataIds.put(metaDataId, statuses);
            }
            this.close(statement);
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        finally {
            this.close(statement);
        }
    }

    @Override
    public void resetAllStatistics(String channelId) {
        this.logger.debug(channelId + ": resetting all statistics (including lifetime)");
        PreparedStatement statement = null;
        try {
            Map<Integer, Map<Status, Long>> channelTotalStats;
            Map<Integer, Set<Status>> metaDataIdsTotal;
            Map<Integer, Map<Status, Long>> channelCurrentStats;
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            statement = this.connection.prepareStatement(this.querySource.getQuery("resetAllStatistics", values));
            statement.setString(1, this.statsServerId);
            statement.executeUpdate();
            Set<Status> statuses = Statistics.getTrackedStatuses();
            Map<Integer, Set<Status>> metaDataIdsCurrent = this.resetCurrentStats.get(channelId);
            if (metaDataIdsCurrent == null) {
                metaDataIdsCurrent = new HashMap<Integer, Set<Status>>();
                this.resetCurrentStats.put(channelId, metaDataIdsCurrent);
            }
            if ((channelCurrentStats = this.currentStats.getChannelStats(channelId)) != null) {
                for (Map.Entry<Integer, Map<Status, Long>> channelEntry : channelCurrentStats.entrySet()) {
                    metaDataIdsCurrent.put(channelEntry.getKey(), statuses);
                }
            }
            if ((metaDataIdsTotal = this.resetTotalStats.get(channelId)) == null) {
                metaDataIdsTotal = new HashMap<Integer, Set<Status>>();
                this.resetTotalStats.put(channelId, metaDataIdsTotal);
            }
            if ((channelTotalStats = this.totalStats.getChannelStats(channelId)) != null) {
                for (Map.Entry<Integer, Map<Status, Long>> channelEntry : channelTotalStats.entrySet()) {
                    metaDataIdsTotal.put(channelEntry.getKey(), statuses);
                }
            }
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    @Override
    public Statistics getChannelStatistics(String serverId) {
        return this.getChannelStatistics(serverId, false);
    }

    @Override
    public Statistics getChannelTotalStatistics(String serverId) {
        return this.getChannelStatistics(serverId, true);
    }

    private Statistics getChannelStatistics(String serverId, boolean total) {
        Map<String, Long> channelIds = this.getLocalChannelIds();
        String queryId = total ? "getChannelTotalStatistics" : "getChannelStatistics";
        Statistics statistics = new Statistics(!total);
        ResultSet resultSet = null;
        for (String channelId : channelIds.keySet()) {
            PreparedStatement statement = null;
            try {
                statement = this.prepareStatement(queryId, channelId);
                statement.setString(1, serverId);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Integer metaDataId = resultSet.getInt("metadata_id");
                    if (resultSet.wasNull()) {
                        metaDataId = null;
                    }
                    HashMap<Status, Long> stats = new HashMap<Status, Long>();
                    stats.put(Status.RECEIVED, resultSet.getLong("received"));
                    stats.put(Status.FILTERED, resultSet.getLong("filtered"));
                    stats.put(Status.SENT, resultSet.getLong("sent"));
                    stats.put(Status.ERROR, resultSet.getLong("error"));
                    statistics.overwrite(channelId, metaDataId, stats);
                }
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
            }
            catch (SQLException e) {
                try {
                    throw new DonkeyDaoException(e);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    this.closeDatabaseObjectIfNeeded(statement);
                    throw throwable;
                }
            }
        }
        return statistics;
    }

    @Override
    public void commit() {
        this.commit(true);
    }

    @Override
    public void commit(boolean durable) {
        Set<Status> statuses;
        Integer metaDataId;
        Map<Integer, Set<Status>> metaDataIds;
        String channelId;
        block16: {
            this.logger.debug("Committing transaction" + (durable ? "" : " asynchronously"));
            try {
                if (!durable && this.asyncCommitCommand != null) {
                    Statement statement = null;
                    try {
                        statement = this.connection.createStatement();
                        statement.execute(this.asyncCommitCommand);
                        break block16;
                    }
                    finally {
                        this.close(statement);
                    }
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new DonkeyDaoException(e);
            }
        }
        if (this.statisticsUpdater != null) {
            this.statisticsUpdater.update(this.transactionStats);
        }
        if (this.transactionAlteredChannels) {
            this.localChannelIds = null;
            this.transactionAlteredChannels = false;
        }
        if (this.currentStats != null) {
            for (Map.Entry<String, Map<Integer, Set<Status>>> entry : this.resetCurrentStats.entrySet()) {
                channelId = entry.getKey();
                metaDataIds = entry.getValue();
                for (Map.Entry<Integer, Set<Status>> metaDataEntry : metaDataIds.entrySet()) {
                    metaDataId = metaDataEntry.getKey();
                    statuses = metaDataEntry.getValue();
                    this.currentStats.resetStats(channelId, metaDataId, statuses);
                }
            }
            this.resetCurrentStats.clear();
            this.currentStats.update(this.transactionStats);
            for (String channelId2 : this.removedChannelIds) {
                this.currentStats.remove(channelId2);
            }
        }
        if (this.totalStats != null) {
            for (Map.Entry<String, Map<Integer, Set<Status>>> entry : this.resetTotalStats.entrySet()) {
                channelId = entry.getKey();
                metaDataIds = entry.getValue();
                for (Map.Entry<Integer, Set<Status>> metaDataEntry : metaDataIds.entrySet()) {
                    metaDataId = metaDataEntry.getKey();
                    statuses = metaDataEntry.getValue();
                    this.totalStats.resetStats(channelId, metaDataId, statuses);
                }
            }
            this.resetTotalStats.clear();
            this.totalStats.update(this.transactionStats);
            for (String channelId2 : this.removedChannelIds) {
                this.totalStats.remove(channelId2);
            }
        }
        this.transactionStats.clear();
    }

    @Override
    public void rollback() {
        this.logger.debug("Rolling back transaction");
        try {
            this.connection.rollback();
            this.transactionStats.clear();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
    }

    @Override
    public void close() {
        this.logger.debug("Closing connection");
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
    }

    protected void closeDatabaseObjectIfNeeded(AutoCloseable dbObject) {
    }

    protected void closeDatabaseObjectsIfNeeded(List<AutoCloseable> dbObjects) {
    }

    @Override
    public boolean initTableStructure() {
        if (!this.tableExists("d_channels")) {
            this.logger.debug("Creating channels table");
            this.createTable("createChannelsTable", null);
            return true;
        }
        return false;
    }

    private boolean tableExists(String tableName) {
        DatabaseMetaData metaData;
        ResultSet resultSet;
        block5: {
            resultSet = null;
            metaData = this.connection.getMetaData();
            resultSet = metaData.getTables(null, null, tableName, null);
            if (!resultSet.next()) break block5;
            boolean bl = true;
            this.close(resultSet);
            return bl;
        }
        try {
            resultSet = metaData.getTables(null, null, tableName.toUpperCase(), null);
            boolean bl = resultSet.next();
            this.close(resultSet);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                throw throwable;
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getAsyncCommitCommand() {
        return this.asyncCommitCommand;
    }

    public void setAsyncCommitCommand(String asyncCommitCommand) {
        this.asyncCommitCommand = asyncCommitCommand;
    }

    private Message getMessageFromResultSet(String channelId, ResultSet resultSet) {
        try {
            Message message = new Message();
            long messageId = resultSet.getLong("id");
            Calendar receivedDate = Calendar.getInstance();
            receivedDate.setTimeInMillis(resultSet.getTimestamp("received_date").getTime());
            message.setMessageId(messageId);
            message.setChannelId(channelId);
            message.setReceivedDate(receivedDate);
            message.setProcessed(resultSet.getBoolean("processed"));
            message.setServerId(resultSet.getString("server_id"));
            message.setImportChannelId(resultSet.getString("import_channel_id"));
            long importId = resultSet.getLong("import_id");
            if (!resultSet.wasNull()) {
                message.setImportId(importId);
            }
            long originalId = resultSet.getLong("original_id");
            if (!resultSet.wasNull()) {
                message.setOriginalId(originalId);
            }
            return message;
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
    }

    private ConnectorMessage getConnectorMessageFromResultSet(String channelId, ResultSet resultSet, boolean includeContent, boolean includeMetaDataMap) {
        try {
            ConnectorMessage connectorMessage = new ConnectorMessage();
            long messageId = resultSet.getLong("message_id");
            int metaDataId = resultSet.getInt("id");
            Calendar receivedDate = Calendar.getInstance();
            receivedDate.setTimeInMillis(resultSet.getTimestamp("received_date").getTime());
            Calendar sendDate = null;
            Timestamp sendDateTimestamp = resultSet.getTimestamp("send_date");
            if (sendDateTimestamp != null) {
                sendDate = Calendar.getInstance();
                sendDate.setTimeInMillis(sendDateTimestamp.getTime());
            }
            Calendar responseDate = null;
            Timestamp responseDateTimestamp = resultSet.getTimestamp("response_date");
            if (responseDateTimestamp != null) {
                responseDate = Calendar.getInstance();
                responseDate.setTimeInMillis(responseDateTimestamp.getTime());
            }
            connectorMessage.setChannelName(this.getDeployedChannelName(channelId));
            connectorMessage.setMessageId(messageId);
            connectorMessage.setMetaDataId(metaDataId);
            connectorMessage.setChannelId(channelId);
            connectorMessage.setServerId(resultSet.getString("server_id"));
            connectorMessage.setConnectorName(resultSet.getString("connector_name"));
            connectorMessage.setReceivedDate(receivedDate);
            connectorMessage.setStatus(Status.fromChar(resultSet.getString("status").charAt(0)));
            connectorMessage.setSendAttempts(resultSet.getInt("send_attempts"));
            connectorMessage.setSendDate(sendDate);
            connectorMessage.setResponseDate(responseDate);
            connectorMessage.setErrorCode(resultSet.getInt("error_code"));
            connectorMessage.setChainId(resultSet.getInt("chain_id"));
            connectorMessage.setOrderId(resultSet.getInt("order_id"));
            if (includeContent) {
                if (metaDataId > 0) {
                    this.loadMessageContent(connectorMessage, this.getDestinationMessageContentFromSource(channelId, messageId, metaDataId));
                }
                this.loadMessageContent(connectorMessage, this.getMessageContent(channelId, messageId, metaDataId));
            }
            if (includeMetaDataMap) {
                connectorMessage.setMetaDataMap(this.getMetaDataMap(channelId, messageId, metaDataId));
            }
            return connectorMessage;
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
    }

    private List<MessageContent> getMessageContent(String channelId, long messageId, int metaDataId) {
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("getMessageContent", channelId);
            statement.setLong(1, messageId);
            statement.setInt(2, metaDataId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String content = resultSet.getString("content");
                ContentType contentType = ContentType.fromCode(resultSet.getInt("content_type"));
                String dataType = resultSet.getString("data_type");
                boolean encrypted = resultSet.getBoolean("is_encrypted");
                if ((this.decryptData || this.alwaysDecrypt.contains((Object)contentType)) && encrypted && this.encryptor != null) {
                    content = this.encryptor.decrypt(content);
                    encrypted = false;
                }
                messageContents.add(new MessageContent(channelId, messageId, metaDataId, contentType, content, dataType, encrypted));
            }
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
        return messageContents;
    }

    private Map<Long, Map<Integer, List<MessageContent>>> getMessageContent(String channelId, List<Long> messageIds) {
        if (messageIds.size() > 1000) {
            throw new DonkeyDaoException("Only up to 1000 message Ids at a time are supported.");
        }
        LinkedHashMap<Long, Map<Integer, List<MessageContent>>> messageContentMap = new LinkedHashMap<Long, Map<Integer, List<MessageContent>>>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("localChannelId", this.getLocalChannelId(channelId));
            params.put("messageIds", StringUtils.join(messageIds, (String)","));
            statement = this.connection.prepareStatement(this.querySource.getQuery("getMessageContentByMessageIds", params));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ArrayList<MessageContent> messageContents;
                HashMap<Integer, ArrayList<MessageContent>> connectorMessageContentMap;
                Long messageId = resultSet.getLong("message_id");
                Integer metaDataId = resultSet.getInt("metadata_id");
                String content = resultSet.getString("content");
                ContentType contentType = ContentType.fromCode(resultSet.getInt("content_type"));
                String dataType = resultSet.getString("data_type");
                boolean encrypted = resultSet.getBoolean("is_encrypted");
                if ((this.decryptData || this.alwaysDecrypt.contains((Object)contentType)) && encrypted && this.encryptor != null) {
                    content = this.encryptor.decrypt(content);
                    encrypted = false;
                }
                if ((connectorMessageContentMap = (HashMap<Integer, ArrayList<MessageContent>>)messageContentMap.get(messageId)) == null) {
                    connectorMessageContentMap = new HashMap<Integer, ArrayList<MessageContent>>();
                    messageContentMap.put(messageId, connectorMessageContentMap);
                }
                if ((messageContents = (ArrayList<MessageContent>)connectorMessageContentMap.get(metaDataId)) == null) {
                    messageContents = new ArrayList<MessageContent>();
                    connectorMessageContentMap.put(metaDataId, messageContents);
                }
                messageContents.add(new MessageContent(channelId, messageId, metaDataId, contentType, content, dataType, encrypted));
            }
            this.close(resultSet);
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
        return messageContentMap;
    }

    private List<MessageContent> getDestinationMessageContentFromSource(String channelId, long messageId, int metaDataId) {
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement("getDestinationMessageContentFromSource", channelId);
            statement.setLong(1, messageId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String content = resultSet.getString("content");
                ContentType contentType = ContentType.fromCode(resultSet.getInt("content_type"));
                String dataType = resultSet.getString("data_type");
                boolean encrypted = resultSet.getBoolean("is_encrypted");
                if ((this.decryptData || this.alwaysDecrypt.contains((Object)contentType)) && encrypted && this.encryptor != null) {
                    content = this.encryptor.decrypt(content);
                    encrypted = false;
                }
                if (contentType == ContentType.ENCODED) {
                    contentType = ContentType.RAW;
                }
                messageContents.add(new MessageContent(channelId, messageId, metaDataId, contentType, content, dataType, encrypted));
            }
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
        return messageContents;
    }

    private void loadMessageContent(ConnectorMessage connectorMessage, List<MessageContent> messageContents) {
        for (MessageContent messageContent : messageContents) {
            switch (messageContent.getContentType()) {
                case RAW: {
                    connectorMessage.setRaw(messageContent);
                    break;
                }
                case PROCESSED_RAW: {
                    connectorMessage.setProcessedRaw(messageContent);
                    break;
                }
                case TRANSFORMED: {
                    connectorMessage.setTransformed(messageContent);
                    break;
                }
                case ENCODED: {
                    connectorMessage.setEncoded(messageContent);
                    break;
                }
                case SENT: {
                    connectorMessage.setSent(messageContent);
                    break;
                }
                case RESPONSE: {
                    connectorMessage.setResponse(messageContent);
                    break;
                }
                case RESPONSE_TRANSFORMED: {
                    connectorMessage.setResponseTransformed(messageContent);
                    break;
                }
                case PROCESSED_RESPONSE: {
                    connectorMessage.setProcessedResponse(messageContent);
                    break;
                }
                case CONNECTOR_MAP: {
                    connectorMessage.setConnectorMapContent(this.getMapContentFromMessageContent(messageContent));
                    break;
                }
                case CHANNEL_MAP: {
                    connectorMessage.setChannelMapContent(this.getMapContentFromMessageContent(messageContent));
                    break;
                }
                case RESPONSE_MAP: {
                    connectorMessage.setResponseMapContent(this.getMapContentFromMessageContent(messageContent));
                    break;
                }
                case PROCESSING_ERROR: {
                    connectorMessage.setProcessingErrorContent(this.getErrorContentFromMessageContent(messageContent));
                    break;
                }
                case POSTPROCESSOR_ERROR: {
                    connectorMessage.setPostProcessorErrorContent(this.getErrorContentFromMessageContent(messageContent));
                    break;
                }
                case RESPONSE_ERROR: {
                    connectorMessage.setResponseErrorContent(this.getErrorContentFromMessageContent(messageContent));
                    break;
                }
                case SOURCE_MAP: {
                    connectorMessage.setSourceMapContent(this.getMapContentFromMessageContent(messageContent));
                }
            }
        }
    }

    private MapContent getMapContentFromMessageContent(MessageContent content) {
        if (content == null) {
            return new MapContent(new HashMap<String, Object>(), false);
        }
        if (StringUtils.isBlank((CharSequence)content.getContent())) {
            return new MapContent(new HashMap<String, Object>(), true);
        }
        return new MapContent(MapUtil.deserializeMap(this.serializerProvider.getSerializer(content.getMetaDataId()), content.getContent()), true);
    }

    private ErrorContent getErrorContentFromMessageContent(MessageContent content) {
        if (content == null) {
            return new ErrorContent(null, false);
        }
        return new ErrorContent(content.getContent(), true);
    }

    private Map<String, Object> getMetaDataMap(String channelId, long messageId, int metaDataId) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            statement = this.connection.prepareStatement(this.querySource.getQuery("getMetaDataMap", values));
            statement.setLong(1, messageId);
            statement.setInt(2, metaDataId);
            HashMap<String, Object> metaDataMap = new HashMap<String, Object>();
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    MetaDataColumnType metaDataColumnType = MetaDataColumnType.fromSqlType(resultSetMetaData.getColumnType(i));
                    Object value = null;
                    switch (metaDataColumnType) {
                        case STRING: {
                            value = resultSet.getString(i);
                            if (this.encryptor == null || !StringUtils.startsWith((CharSequence)((String)value), (CharSequence)"{alg=")) break;
                            try {
                                value = this.encryptor.decrypt((String)value);
                            }
                            catch (Exception e) {
                                this.logger.debug("Unable to decrypt custom metadata column " + resultSetMetaData.getColumnName(i).toUpperCase() + " for channel " + channelId + ", messsage " + messageId + "-" + metaDataId, (Throwable)e);
                            }
                            break;
                        }
                        case NUMBER: {
                            value = resultSet.getBigDecimal(i);
                            break;
                        }
                        case BOOLEAN: {
                            value = resultSet.getBoolean(i);
                            break;
                        }
                        case TIMESTAMP: {
                            Timestamp timestamp = resultSet.getTimestamp(i);
                            if (timestamp == null) break;
                            value = Calendar.getInstance();
                            ((Calendar)value).setTimeInMillis(timestamp.getTime());
                            break;
                        }
                        default: {
                            throw new Exception("Unrecognized MetaDataColumnType");
                        }
                    }
                    metaDataMap.put(resultSetMetaData.getColumnName(i).toUpperCase(), value);
                }
            }
            HashMap<String, Object> hashMap = metaDataMap;
            this.close(resultSet);
            this.close(statement);
            return hashMap;
        }
        catch (Exception e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    private Map<Long, Map<Integer, Map<String, Object>>> getMetaDataMaps(String channelId, List<Long> messageIds) {
        if (messageIds.size() > 1000) {
            throw new DonkeyDaoException("Only up to 1000 message Ids at a time are supported.");
        }
        HashMap<Long, Map<Integer, Map<String, Object>>> metaDataMaps = new HashMap<Long, Map<Integer, Map<String, Object>>>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("localChannelId", this.getLocalChannelId(channelId));
            values.put("messageIds", StringUtils.join(messageIds, (String)","));
            statement = this.connection.prepareStatement(this.querySource.getQuery("getMetaDataMapByMessageId", values));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> metaDataMap;
                Long messageId = resultSet.getLong("message_id");
                Integer metaDataId = resultSet.getInt("metadata_id");
                HashMap connectorMetaDataMap = (HashMap)metaDataMaps.get(messageId);
                if (connectorMetaDataMap == null) {
                    connectorMetaDataMap = new HashMap();
                    metaDataMaps.put(messageId, connectorMetaDataMap);
                }
                if ((metaDataMap = (HashMap<String, Object>)connectorMetaDataMap.get(metaDataId)) == null) {
                    metaDataMap = new HashMap<String, Object>();
                    connectorMetaDataMap.put(metaDataId, metaDataMap);
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    MetaDataColumnType metaDataColumnType = MetaDataColumnType.fromSqlType(resultSetMetaData.getColumnType(i));
                    Object value = null;
                    switch (metaDataColumnType) {
                        case STRING: {
                            value = resultSet.getString(i);
                            if (this.encryptor == null || !StringUtils.startsWith((CharSequence)((String)value), (CharSequence)"{alg=")) break;
                            try {
                                value = this.encryptor.decrypt((String)value);
                            }
                            catch (Exception e) {
                                this.logger.debug("Unable to decrypt custom metadata column " + resultSetMetaData.getColumnName(i).toUpperCase() + " for channel " + channelId + ", messsage " + messageId + "-" + metaDataId, (Throwable)e);
                            }
                            break;
                        }
                        case NUMBER: {
                            value = resultSet.getBigDecimal(i);
                            break;
                        }
                        case BOOLEAN: {
                            value = resultSet.getBoolean(i);
                            break;
                        }
                        case TIMESTAMP: {
                            Timestamp timestamp = resultSet.getTimestamp(i);
                            if (timestamp == null) break;
                            value = Calendar.getInstance();
                            ((Calendar)value).setTimeInMillis(timestamp.getTime());
                            break;
                        }
                        default: {
                            throw new Exception("Unrecognized MetaDataColumnType");
                        }
                    }
                    metaDataMap.put(resultSetMetaData.getColumnName(i).toUpperCase(), value);
                }
            }
            HashMap<Long, Map<Integer, Map<String, Object>>> hashMap = metaDataMaps;
            this.close(resultSet);
            this.close(statement);
            return hashMap;
        }
        catch (Exception e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeMessageDelete(String queryId, String channelId) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(queryId, channelId);
            if (statement != null) {
                statement.executeUpdate();
            }
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeMessageDelete(String queryId, long messageId, String channelId) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(queryId, channelId);
            if (statement != null) {
                statement.setLong(1, messageId);
                statement.executeUpdate();
            }
        }
        finally {
            this.closeDatabaseObjectIfNeeded(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeMessageDelete(String queryId, long messageId, Map<String, Object> values) throws SQLException {
        String query = this.querySource.getQuery(queryId, values);
        if (query != null) {
            PreparedStatement statement = null;
            try {
                statement = this.connection.prepareStatement(query);
                statement.setLong(1, messageId);
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
    }

    PreparedStatement prepareStatement(String queryId, String channelId) throws SQLException {
        Long localChannelId = null;
        if (channelId != null) {
            localChannelId = this.getLocalChannelId(channelId);
        }
        return this.statementSource.getPreparedStatement(queryId, localChannelId);
    }

    protected void close(Statement statement) {
        try {
            DbUtils.close((Statement)statement);
        }
        catch (SQLException e) {
            this.logger.error("Failed to close JDBC statement", (Throwable)e);
        }
    }

    protected void close(ResultSet resultSet) {
        try {
            DbUtils.close((ResultSet)resultSet);
        }
        catch (SQLException e) {
            this.logger.error("Failed to close JDBC result set", (Throwable)e);
        }
    }

    private static String sqlTypeToString(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    protected long getLocalChannelId(String channelId) {
        Channel channel = this.donkey.getDeployedChannels().get(channelId);
        if (channel == null) {
            Long localChannelId = this.getLocalChannelIds().get(channelId);
            if (localChannelId == null) {
                throw new ChannelDoesNotExistException(channelId);
            }
            return localChannelId;
        }
        return channel.getLocalChannelId();
    }

    protected String getDeployedChannelName(String channelId) {
        Channel channel = this.donkey.getDeployedChannels().get(channelId);
        return channel != null ? channel.getName() : "";
    }

    @Override
    public List<Ports> getPortsInUse() {
        String queryId = "getPortsInUse";
        String query = this.querySource.getQuery(queryId);
        ArrayList<Ports> ports = new ArrayList<Ports>();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Ports port = new Ports();
                port.setId(resultSet.getString("id"));
                port.setName(resultSet.getString("name"));
                port.setPort(resultSet.getString("portstring"));
                ports.add(port);
            }
            this.close(resultSet);
            this.closeDatabaseObjectIfNeeded(statement);
        }
        catch (SQLException e) {
            try {
                throw new DonkeyDaoException(e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.closeDatabaseObjectIfNeeded(statement);
                throw throwable;
            }
        }
        return ports;
    }
}

