/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDao;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.OracleJdbcDao;
import com.mirth.connect.donkey.server.data.jdbc.PreparedStatementSource;
import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleDaoFactory
extends JdbcDaoFactory {
    private static final String COMMAND = "COMMIT WRITE BATCH NOWAIT";
    private static final int REQUIRED_MAJOR_VERSION = 10;
    private static final int REQUIRED_MINOR_VERSION = 2;
    private Boolean supported;
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public JdbcDao getDao(SerializerProvider serializerProvider) {
        JdbcDao dao = super.getDao(serializerProvider);
        dao.setAsyncCommitCommand(this.getAsyncCommitCommand(dao));
        return dao;
    }

    @Override
    protected JdbcDao getDao(Donkey donkey, Connection connection, QuerySource querySource, PreparedStatementSource statementSource, SerializerProvider serializerProvider, boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData, boolean decryptData, StatisticsUpdater statisticsUpdater, Statistics currentStats, Statistics totalStats, String statsServerId) {
        return new OracleJdbcDao(donkey, connection, querySource, statementSource, serializerProvider, encryptMessageContent, encryptAttachments, encryptCustomMetaData, decryptData, statisticsUpdater, currentStats, totalStats, statsServerId);
    }

    private String getAsyncCommitCommand(JdbcDao dao) {
        if (this.supported == null) {
            try {
                DatabaseMetaData metaData = dao.getConnection().getMetaData();
                int majorVersion = metaData.getDatabaseMajorVersion();
                int minorVersion = metaData.getDatabaseMinorVersion();
                if (majorVersion > 10 || majorVersion == 10 && minorVersion >= 2) {
                    this.supported = true;
                    this.logger.debug("Detected support for asynchronous commits in Oracle");
                } else {
                    this.supported = false;
                    this.logger.debug("Asynchronous commits are not supported by the current Oracle connection");
                }
            }
            catch (SQLException e) {
                throw new DonkeyDaoException(e);
            }
        }
        return this.supported != false ? COMMAND : null;
    }
}

