/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDao;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDaoFactory;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostgresqlDaoFactory
extends JdbcDaoFactory {
    private static final String COMMAND = "SET LOCAL synchronous_commit TO OFF; COMMIT;";
    private static final int REQUIRED_MAJOR_VERSION = 8;
    private static final int REQUIRED_MINOR_VERSION = 3;
    private Boolean supported;
    private Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public JdbcDao getDao(SerializerProvider serializerProvider) {
        JdbcDao dao = super.getDao(serializerProvider);
        dao.setAsyncCommitCommand(this.getAsyncCommitCommand(dao));
        return dao;
    }

    private String getAsyncCommitCommand(JdbcDao dao) {
        if (this.supported == null) {
            try {
                DatabaseMetaData metaData = dao.getConnection().getMetaData();
                int majorVersion = metaData.getDatabaseMajorVersion();
                int minorVersion = metaData.getDatabaseMinorVersion();
                if (majorVersion > 8 || majorVersion == 8 && minorVersion >= 3) {
                    this.supported = true;
                    this.logger.debug("Detected support for asynchronous commits in PostgreSQL");
                } else {
                    this.supported = false;
                    this.logger.debug("Asynchronous commits are not supported by the current PostgreSQL connection");
                }
            }
            catch (SQLException e) {
                throw new DonkeyDaoException(e);
            }
        }
        return this.supported != false ? COMMAND : null;
    }
}

