/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import com.mirth.connect.donkey.util.ResourceUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlQuerySource
implements QuerySource {
    private Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, String> queries = new HashMap<String, String>();

    public void load(String xmlFile) throws XmlQuerySourceException {
        Document document = null;
        InputStream is = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            is = ResourceUtil.getResourceStream(XmlQuerySource.class, xmlFile);
            document = documentBuilder.parse(is);
        }
        catch (Exception e) {
            try {
                throw new XmlQuerySourceException("Failed to read query file: " + xmlFile, e);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeResourceQuietly(is);
                throw throwable;
            }
        }
        ResourceUtil.closeResourceQuietly(is);
        NodeList queryNodes = document.getElementsByTagName("query");
        int queryNodeCount = queryNodes.getLength();
        for (int i = 0; i < queryNodeCount; ++i) {
            String query;
            Attr attr;
            Node node = queryNodes.item(i);
            if (!node.hasAttributes() || (attr = (Attr)node.getAttributes().getNamedItem("id")) == null || (query = StringUtils.trim((String)node.getTextContent())).length() <= 0) continue;
            this.queries.put(attr.getValue(), query);
        }
    }

    @Override
    public String getQuery(String queryName) {
        return this.getQuery(queryName, null);
    }

    @Override
    public String getQuery(String queryName, Map<String, Object> values) {
        String query = this.queries.get(queryName);
        if (query == null) {
            return null;
        }
        if (values != null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                query = StringUtils.replace((String)query, (String)("${" + entry.getKey() + "}"), (String)entry.getValue().toString());
            }
        }
        this.logger.debug(query);
        return query;
    }

    @Override
    public boolean queryExists(String queryName) {
        return this.queries.containsKey(queryName);
    }

    public class XmlQuerySourceException
    extends Exception {
        public XmlQuerySourceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

