/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.timed;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.util.ActionTimer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimedDao
implements DonkeyDao {
    private DonkeyDao dao;
    private ActionTimer timer;

    protected TimedDao(DonkeyDao dao, ActionTimer timer) {
        this.dao = dao;
        this.timer = timer;
    }

    public DonkeyDao getDao() {
        return this.dao;
    }

    public void setDao(DonkeyDao dao) {
        this.dao = dao;
    }

    public ActionTimer getTimer() {
        return this.timer;
    }

    public void setTimer(ActionTimer timer) {
        this.timer = timer;
    }

    @Override
    public void setEncryptData(boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData) {
        this.dao.setEncryptData(encryptMessageContent, encryptAttachments, encryptCustomMetaData);
    }

    @Override
    public void setDecryptData(boolean decryptData) {
        this.dao.setDecryptData(decryptData);
    }

    @Override
    public void setStatisticsUpdater(StatisticsUpdater statisticsUpdater) {
        this.dao.setStatisticsUpdater(statisticsUpdater);
    }

    @Override
    public void commit() {
        this.dao.commit();
    }

    @Override
    public void commit(boolean durable) {
        this.dao.commit(durable);
    }

    @Override
    public void rollback() {
        this.dao.rollback();
    }

    @Override
    public void close() {
        this.dao.close();
    }

    @Override
    public boolean isClosed() {
        return this.dao.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMessage(Message message) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.insertMessage(message);
        }
        finally {
            this.timer.log("insertMessage", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertConnectorMessage(ConnectorMessage connectorMessage, boolean storeMaps, boolean updateStats) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.insertConnectorMessage(connectorMessage, storeMaps, updateStats);
        }
        finally {
            this.timer.log("insertConnectorMessage", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMessageContent(MessageContent messageContent) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.insertMessageContent(messageContent);
        }
        finally {
            this.timer.log("insertMessageContent", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchInsertMessageContent(MessageContent messageContent) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.batchInsertMessageContent(messageContent);
        }
        finally {
            this.timer.log("batchInsertMessageContent", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatchInsertMessageContent(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.executeBatchInsertMessageContent(channelId);
        }
        finally {
            this.timer.log("executeBatchInsertMessageContent", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMessageAttachment(String channelId, long messageId, Attachment attachment) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.insertMessageAttachment(channelId, messageId, attachment);
        }
        finally {
            this.timer.log("insertMessageAttachment", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageAttachment(String channelId, long messageId, Attachment attachment) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateMessageAttachment(channelId, messageId, attachment);
        }
        finally {
            this.timer.log("updateMessageAttachment", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.insertMetaData(connectorMessage, metaDataColumns);
        }
        finally {
            this.timer.log("insertMetaData", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.storeMetaData(connectorMessage, metaDataColumns);
        }
        finally {
            this.timer.log("storeMetaData", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessageContent(MessageContent messageContent) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.storeMessageContent(messageContent);
        }
        finally {
            this.timer.log("storeMessageContent", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannelStatistics(Statistics statistics) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.addChannelStatistics(statistics);
        }
        finally {
            this.timer.log("addChannelStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSendAttempts(ConnectorMessage connectorMessage) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateSendAttempts(connectorMessage);
        }
        finally {
            this.timer.log("updateResponseError", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(ConnectorMessage connectorMessage, Status previousStatus) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateStatus(connectorMessage, previousStatus);
        }
        finally {
            this.timer.log("updateStatus", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateErrors(ConnectorMessage connectorMessage) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateErrors(connectorMessage);
        }
        finally {
            this.timer.log("updateErrors", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMaps(ConnectorMessage connectorMessage) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateMaps(connectorMessage);
        }
        finally {
            this.timer.log("updateMaps", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSourceMap(ConnectorMessage connectorMessage) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateSourceMap(connectorMessage);
        }
        finally {
            this.timer.log("updateSourceMap", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResponseMap(ConnectorMessage connectorMessage) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.updateResponseMap(connectorMessage);
        }
        finally {
            this.timer.log("updateResponseMap", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsProcessed(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.markAsProcessed(channelId, messageId);
        }
        finally {
            this.timer.log("markAsProcessed", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMessage(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.resetMessage(channelId, messageId);
        }
        finally {
            this.timer.log("resetMessage", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteMessage(channelId, messageId);
        }
        finally {
            this.timer.log("deleteMessage", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteConnectorMessages(channelId, messageId, metaDataIds);
        }
        finally {
            this.timer.log("deleteConnectorMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessageStatistics(String channelId, long messageId, Set<Integer> metaDataIds) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteMessageStatistics(channelId, messageId, metaDataIds);
        }
        finally {
            this.timer.log("deleteMessageStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllMessages(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteAllMessages(channelId);
        }
        finally {
            this.timer.log("deleteAllMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessageContent(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteMessageContent(channelId, messageId);
        }
        finally {
            this.timer.log("deleteMessageContent", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessageContentByMetaDataIds(String channelId, long messageId, Set<Integer> metaDataIds) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteMessageContentByMetaDataIds(channelId, messageId, metaDataIds);
        }
        finally {
            this.timer.log("deleteMessageContentByMetaDataIds", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessageAttachments(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.deleteMessageAttachments(channelId, messageId);
        }
        finally {
            this.timer.log("deleteMessageAttachments", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createChannel(String channelId, long localChannelId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.createChannel(channelId, localChannelId);
        }
        finally {
            this.timer.log("createChannel", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initTableStructure() {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = this.dao.initTableStructure();
            return bl;
        }
        finally {
            this.timer.log("initTableStructure", System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public void checkAndCreateChannelTables() {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.checkAndCreateChannelTables();
        }
        finally {
            this.timer.log("checkOrCreateChannelTables", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChannel(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.removeChannel(channelId);
        }
        finally {
            this.timer.log("removeChannel", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaDataColumn(String channelId, MetaDataColumn metaDataColumn) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.addMetaDataColumn(channelId, metaDataColumn);
        }
        finally {
            this.timer.log("addMetaDataColumn", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaDataColumn(String channelId, String columnName) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.removeMetaDataColumn(channelId, columnName);
        }
        finally {
            this.timer.log("removeMetaDataColumn", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStatistics(String channelId, Integer metaDataId, Set<Status> statuses) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.resetStatistics(channelId, metaDataId, statuses);
        }
        finally {
            this.timer.log("resetStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllStatistics(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            this.dao.resetAllStatistics(channelId);
        }
        finally {
            this.timer.log("resetStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long selectMaxLocalChannelId() {
        long startTime = System.currentTimeMillis();
        try {
            Long l = this.dao.selectMaxLocalChannelId();
            return l;
        }
        finally {
            this.timer.log("selectMaxLocalChannelId", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> getLocalChannelIds() {
        long startTime = System.currentTimeMillis();
        try {
            Map<String, Long> map = this.dao.getLocalChannelIds();
            return map;
        }
        finally {
            this.timer.log("getLocalChannelIds", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxMessageId(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            long l = this.dao.getMaxMessageId(channelId);
            return l;
        }
        finally {
            this.timer.log("getMaxMessageId", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinMessageId(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            long l = this.dao.getMinMessageId(channelId);
            return l;
        }
        finally {
            this.timer.log("getMinMessageId", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextMessageId(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            long l = this.dao.getNextMessageId(channelId);
            return l;
        }
        finally {
            this.timer.log("getNextMessageId", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getMessageAttachment(String channelId, long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            List<Attachment> list = this.dao.getMessageAttachment(channelId, messageId);
            return list;
        }
        finally {
            this.timer.log("getMessageAttachment", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachment getMessageAttachment(String channelId, String attachmentId, Long messageId) {
        long startTime = System.currentTimeMillis();
        try {
            Attachment attachment = this.dao.getMessageAttachment(channelId, attachmentId, messageId);
            return attachment;
        }
        finally {
            this.timer.log("getMessageAttachment", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPendingConnectorMessages(String channelId, String serverId, int limit, Long minMessageId) {
        long startTime = System.currentTimeMillis();
        try {
            List<Message> list = this.dao.getPendingConnectorMessages(channelId, serverId, limit, minMessageId);
            return list;
        }
        finally {
            this.timer.log("getPendingConnectorMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessages(String channelId, List<Long> messageIds) {
        long startTime = System.currentTimeMillis();
        try {
            List<Message> list = this.dao.getMessages(channelId, messageIds);
            return list;
        }
        finally {
            this.timer.log("getMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, String serverId, int metaDataId, Status status, int offset, int limit, Long minMessageId, Long maxMessageId) {
        long startTime = System.currentTimeMillis();
        try {
            List<ConnectorMessage> list = this.dao.getConnectorMessages(channelId, serverId, metaDataId, status, offset, limit, minMessageId, maxMessageId);
            return list;
        }
        finally {
            this.timer.log("getConnectorMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds, boolean includeContent) {
        long startTime = System.currentTimeMillis();
        try {
            List<ConnectorMessage> list = this.dao.getConnectorMessages(channelId, messageId, metaDataIds, includeContent);
            return list;
        }
        finally {
            this.timer.log("getConnectorMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, ConnectorMessage> getConnectorMessages(String channelId, long messageId, List<Integer> metaDataIds) {
        long startTime = System.currentTimeMillis();
        try {
            Map<Integer, ConnectorMessage> map = this.dao.getConnectorMessages(channelId, messageId, metaDataIds);
            return map;
        }
        finally {
            this.timer.log("getConnectorMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectorMessageCount(String channelId, String serverId, int metaDataId, Status status) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.dao.getConnectorMessageCount(channelId, serverId, metaDataId, status);
            return n;
        }
        finally {
            this.timer.log("getConnectorMessageCount", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConnectorMessageMaxMessageId(String channelId, String serverId, int metaDataId, Status status) {
        long startTime = System.currentTimeMillis();
        try {
            long l = this.dao.getConnectorMessageMaxMessageId(channelId, serverId, metaDataId, status);
            return l;
        }
        finally {
            this.timer.log("getConnectorMessageMaxMessageId", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Status> getConnectorMessageStatuses(String channelId, long messageId, boolean checkProcessed) {
        long startTime = System.currentTimeMillis();
        try {
            Map<Integer, Status> map = this.dao.getConnectorMessageStatuses(channelId, messageId, checkProcessed);
            return map;
        }
        finally {
            this.timer.log("getConnectorMessageStatuses", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getUnfinishedMessages(String channelId, String serverId, int limit, Long minMessageId) {
        long startTime = System.currentTimeMillis();
        try {
            List<Message> list = this.dao.getUnfinishedMessages(channelId, serverId, limit, minMessageId);
            return list;
        }
        finally {
            this.timer.log("getUnfinishedMessages", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetaDataColumn> getMetaDataColumns(String channelId) {
        long startTime = System.currentTimeMillis();
        try {
            List<MetaDataColumn> list = this.dao.getMetaDataColumns(channelId);
            return list;
        }
        finally {
            this.timer.log("getMetaDataColumns", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getChannelStatistics(String serverId) {
        long startTime = System.currentTimeMillis();
        try {
            Statistics statistics = this.dao.getChannelStatistics(serverId);
            return statistics;
        }
        finally {
            this.timer.log("getChannelStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getChannelTotalStatistics(String serverId) {
        long startTime = System.currentTimeMillis();
        try {
            Statistics statistics = this.dao.getChannelTotalStatistics(serverId);
            return statistics;
        }
        finally {
            this.timer.log("getChannelTotalStatistics", System.currentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Ports> getPortsInUse() {
        long startTime = System.currentTimeMillis();
        try {
            List<Ports> list = this.dao.getPortsInUse();
            return list;
        }
        finally {
            this.timer.log("getPortsInUse", System.currentTimeMillis() - startTime);
        }
    }
}

