/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.message.batch;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.DeployException;
import com.mirth.connect.donkey.server.UndeployException;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptor;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BatchAdaptorFactory {
    protected SourceConnector sourceConnector;
    private AtomicInteger batches = new AtomicInteger();
    private AtomicBoolean finished = new AtomicBoolean();
    private boolean useFirstReponse = false;

    public BatchAdaptorFactory(SourceConnector sourceConnector) {
        this.sourceConnector = sourceConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startBatch() throws BatchMessageException {
        AtomicInteger atomicInteger = this.batches;
        synchronized (atomicInteger) {
            if (!this.finished.get()) {
                this.batches.incrementAndGet();
                return true;
            }
        }
        return false;
    }

    public void finishBatch() {
        this.batches.decrementAndGet();
    }

    public void start() throws ConnectorTaskException, InterruptedException {
        this.finished.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ConnectorTaskException, InterruptedException {
        this.finished.set(true);
        while (true) {
            AtomicInteger atomicInteger = this.batches;
            synchronized (atomicInteger) {
                if (this.batches.get() == 0) {
                    return;
                }
            }
            Thread.sleep(100L);
        }
    }

    public boolean isUseFirstReponse() {
        return this.useFirstReponse;
    }

    public void setUseFirstReponse(boolean useFirstReponse) {
        this.useFirstReponse = useFirstReponse;
    }

    public abstract BatchAdaptor createBatchAdaptor(BatchRawMessage var1);

    public abstract void onDeploy() throws DeployException;

    public abstract void onUndeploy() throws UndeployException;
}

