/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.queue;

import com.mirth.connect.donkey.model.event.MessageEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.event.MessageEvent;
import com.mirth.connect.donkey.server.queue.ConnectorMessageQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SourceQueue
extends ConnectorMessageQueue {
    private Set<Long> checkedOut = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    protected ConnectorMessage pollFirstValue() {
        Iterator iterator = this.buffer.entrySet().iterator();
        if (iterator.hasNext()) {
            ConnectorMessage connectorMessage = (ConnectorMessage)iterator.next().getValue();
            iterator.remove();
            return connectorMessage;
        }
        return null;
    }

    public synchronized ConnectorMessage poll() {
        if (this.size == null) {
            this.updateSize();
        }
        ConnectorMessage connectorMessage = null;
        if (this.size > 0) {
            connectorMessage = this.pollFirstValue();
            if (connectorMessage == null) {
                this.fillBuffer();
                connectorMessage = this.pollFirstValue();
            }
            while (connectorMessage != null && this.checkedOut.contains(connectorMessage.getMessageId())) {
                connectorMessage = this.pollFirstValue();
            }
        }
        if (connectorMessage != null) {
            this.decrementActualSize();
            this.checkedOut.add(connectorMessage.getMessageId());
            this.eventDispatcher.dispatchEvent(new MessageEvent(this.channelId, this.metaDataId, MessageEventType.QUEUED, Long.valueOf(this.size()), true));
        }
        return connectorMessage;
    }

    public synchronized void finish(ConnectorMessage connectorMessage) {
        if (connectorMessage != null) {
            Long messageId = connectorMessage.getMessageId();
            if (this.buffer.containsKey(messageId)) {
                this.buffer.remove(messageId);
            }
            this.checkedOut.remove(messageId);
        }
    }

    @Override
    protected void reset() {
        this.checkedOut.clear();
    }

    public synchronized void decrementSize() {
        if (this.size != null) {
            this.decrementActualSize();
        }
        this.eventDispatcher.dispatchEvent(new MessageEvent(this.channelId, this.metaDataId, MessageEventType.QUEUED, Long.valueOf(this.size()), true));
    }

    public ConnectorMessage poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.waitTimeout(timeout, unit);
        return this.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTimeout(long timeout, TimeUnit unit) throws InterruptedException {
        if ((this.size == null || this.size == 0 || this.checkedOut.size() == this.getBufferCapacity()) && timeout > 0L) {
            AtomicBoolean atomicBoolean = this.timeoutLock;
            synchronized (atomicBoolean) {
                this.timeoutLock.set(true);
                this.timeoutLock.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
            }
        }
    }
}

