/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;

public class PropertiesConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(Properties.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Properties properties = (Properties)value;
        ArrayList<Object> keys = Collections.list(properties.keys());
        Collections.sort(keys, new KeyComparator());
        for (Object e : keys) {
            writer.startNode("property");
            writer.addAttribute("name", e.toString());
            writer.setValue(properties.getProperty(e.toString()));
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Properties properties = new Properties();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            properties.setProperty(reader.getAttribute("name"), reader.getValue());
            reader.moveUp();
        }
        return properties;
    }

    private class KeyComparator
    implements Comparator<Object> {
        private KeyComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            return obj1.toString().compareTo(obj2.toString());
        }
    }
}

