/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.hl7v2;

import java.util.HashMap;
import java.util.Map;

public class Component {
    private static final String DATATYPE_SUFFIX = "]";
    private static final String DATATYPE_PREFIX = " [";
    private static final String COMPOSITE_PREFIX = ".composite._";
    private static final String MESSAGE_PREFIX = ".message._";
    private static final String SEGMENT_PREFIX = ".segment._";
    private static final String MODEL_CLASSPATH = "com.mirth.connect.model.hl7v2.v";
    protected String description = "";
    protected String name = "";
    protected static Map<Class, Component> cacheMap = new HashMap<Class, Component>();
    protected static String[] versions = new String[]{"21", "22", "23", "231", "24", "25", "251", "26", "27", "271", "28", "281", "282"};

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Component getComponent(int n) {
        return null;
    }

    public String getComponentDescription(int n) {
        return null;
    }

    public static Component getCachedComponent(Class clazz) throws InstantiationException, IllegalAccessException {
        Component component = cacheMap.get(clazz);
        if (component == null) {
            component = (Component)clazz.newInstance();
            cacheMap.put(clazz, component);
        }
        return component;
    }

    public static Component getCachedComponent(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(string);
        return Component.getCachedComponent(clazz);
    }

    public static String getMessageDescription(String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        string2 = string2.replaceAll("\\^", "").replaceAll("-", "");
        Component component = Component.getCachedComponent(MODEL_CLASSPATH + string + MESSAGE_PREFIX + string2);
        return component.getDescription();
    }

    public static String getMessageDescription(String string) {
        String string2 = "";
        for (int i = versions.length - 1; i >= 0; --i) {
            try {
                string2 = Component.getMessageDescription(versions[i], string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.length() > 0) break;
        }
        return string2;
    }

    public static String getSegmentDescription(String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Component component = Component.getCachedComponent(MODEL_CLASSPATH + string + SEGMENT_PREFIX + string2);
        return component.getDescription();
    }

    public static String getSegmentDescription(String string) {
        String string2 = "";
        for (int i = versions.length - 1; i >= 0; --i) {
            try {
                string2 = Component.getSegmentDescription(versions[i], string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.length() > 0) break;
        }
        return string2;
    }

    public static String getSegmentFieldDescription(String string, String string2, int n, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Component.getComponentFieldDescription(string, string2, SEGMENT_PREFIX, n, bl);
    }

    public static String getSegmentFieldDescription(String string, String string2, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Component.getComponentFieldDescription(string, string2, SEGMENT_PREFIX, bl);
    }

    public static String getSegmentorCompositeFieldDescription(String string, boolean bl) {
        int n;
        String string2 = "";
        for (n = versions.length - 1; n >= 0; --n) {
            try {
                string2 = Component.getSegmentFieldDescription(versions[n], string, bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || string2.length() <= 0) continue;
            return string2;
        }
        for (n = versions.length - 1; n >= 0; --n) {
            try {
                string2 = Component.getCompositeFieldDescription(versions[n], string, bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || string2.length() <= 0) continue;
            return string2;
        }
        return string2;
    }

    public static String getCompositeDescription(String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Component component = Component.getCachedComponent(MODEL_CLASSPATH + string + COMPOSITE_PREFIX + string2);
        return component.getDescription();
    }

    public static String getCompositeFieldDescription(String string, String string2, int n, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Component.getComponentFieldDescription(string, string2, COMPOSITE_PREFIX, n, bl);
    }

    public static String getCompositeFieldDescription(String string, String string2, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Component.getComponentFieldDescription(string, string2, COMPOSITE_PREFIX, bl);
    }

    public static String getCompositeFieldDescriptionWithSegment(String string, String string2, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String[] stringArray = string2.split("\\.");
        String string3 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]) - 1;
        int n2 = Integer.parseInt(stringArray[2]) - 1;
        Component component = Component.getCachedComponent(MODEL_CLASSPATH + string + SEGMENT_PREFIX + string3);
        Component component2 = component.getComponent(n);
        if (bl) {
            Component component3 = component2.getComponent(n2);
            return component2.getComponentDescription(n2) + DATATYPE_PREFIX + component3.getName() + DATATYPE_SUFFIX;
        }
        return component2.getComponentDescription(n2);
    }

    public static String getCompositeFieldDescriptionWithSegment(String string, boolean bl) {
        String string2 = "";
        for (int i = versions.length - 1; i >= 0; --i) {
            try {
                string2 = Component.getCompositeFieldDescriptionWithSegment(versions[i], string, bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.length() > 0) break;
        }
        return string2;
    }

    private static String getComponentFieldDescription(String string, String string2, String string3, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String[] stringArray = string2.split("\\.");
        String string4 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        return Component.getComponentFieldDescription(string, string4, string3, n, bl);
    }

    private static String getComponentFieldDescription(String string, String string2, String string3, int n, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Component component = Component.getCachedComponent(MODEL_CLASSPATH + string + string3 + string2);
        --n;
        if (bl) {
            Component component2 = component.getComponent(n);
            return component.getComponentDescription(n) + DATATYPE_PREFIX + component2.getName() + DATATYPE_SUFFIX;
        }
        return component.getComponentDescription(n);
    }
}

