/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.util.AttachmentUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class AttachmentExportDialog
extends MirthDialog {
    private Preferences userPreferences = Preferences.userNodeForPackage(Mirth.class);
    private JRadioButton textButton;
    private JRadioButton binaryButton;
    private JRadioButton serverButton;
    private JRadioButton localButton;
    private JButton browseButton;
    private JTextField fileField;
    private JButton exportButton;
    private JButton cancelButton;

    public AttachmentExportDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.setTitle("Export Attachment");
        this.setPreferredSize(new Dimension(500, 155));
        this.getContentPane().setBackground(Color.white);
        this.setLocationRelativeTo(null);
        DisplayUtil.setResizable(this, false);
        this.setModal(true);
        this.initComponents();
        this.initLayout();
        this.pack();
    }

    private void initComponents() {
        this.binaryButton = new JRadioButton("Binary");
        this.binaryButton.setSelected(true);
        this.binaryButton.setBackground(Color.white);
        this.binaryButton.setFocusable(false);
        this.textButton = new JRadioButton("Text");
        this.textButton.setBackground(Color.white);
        this.textButton.setFocusable(false);
        ButtonGroup typeButtonGroup = new ButtonGroup();
        typeButtonGroup.add(this.binaryButton);
        typeButtonGroup.add(this.textButton);
        this.serverButton = new JRadioButton("Server");
        this.serverButton.setBackground(Color.white);
        this.serverButton.setFocusable(false);
        this.localButton = new JRadioButton("My Computer");
        this.localButton.setBackground(Color.white);
        this.localButton.setSelected(true);
        this.localButton.setFocusable(false);
        this.browseButton = new MirthButton("Browse...");
        this.localButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentExportDialog.this.browseButton.setEnabled(true);
                AttachmentExportDialog.this.fileField.setText(null);
            }
        });
        this.serverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentExportDialog.this.browseButton.setEnabled(false);
                AttachmentExportDialog.this.fileField.setText(null);
            }
        });
        ButtonGroup locationButtonGroup = new ButtonGroup();
        locationButtonGroup.add(this.serverButton);
        locationButtonGroup.add(this.localButton);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentExportDialog.this.browseSelected();
            }
        });
        this.fileField = new JTextField();
        this.exportButton = new JButton("Export");
        this.cancelButton = new JButton("Cancel");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentExportDialog.this.export();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentExportDialog.this.setVisible(false);
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, fill", "[right][left]"));
        this.add(new JLabel("File Type:"));
        this.add((Component)this.binaryButton, "split 2");
        this.add((Component)this.textButton, "wrap");
        this.add(new JLabel("Export To:"));
        this.add((Component)this.serverButton, "split 3");
        this.add(this.localButton);
        this.add((Component)this.browseButton, "wrap");
        this.add(new JLabel("File:"));
        this.add((Component)this.fileField, "push, growx, span");
        this.add((Component)new JSeparator(), "grow, span");
        this.add((Component)this.exportButton, "width 60, right, split 2, spanx, gaptop 4");
        this.add((Component)this.cancelButton, "width 60, gaptop 4");
    }

    private void browseSelected() {
        File currentDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        if (this.userPreferences != null && (currentDir = new File(this.userPreferences.get("currentDirectory", ""))).exists()) {
            chooser.setCurrentDirectory(currentDir);
        }
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            if (this.userPreferences != null) {
                this.userPreferences.put("currentDirectory", chooser.getCurrentDirectory().getPath());
            }
            this.fileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void export() {
        if (StringUtils.isBlank((CharSequence)this.fileField.getText())) {
            PlatformUI.MIRTH_FRAME.alertError(this, "Please fill in required fields.");
            this.fileField.setBackground(UIConstants.INVALID_COLOR);
            return;
        }
        this.fileField.setBackground(Color.white);
        if (PlatformUI.MIRTH_FRAME.messageBrowser.getSelectedMimeType().equalsIgnoreCase("dicom")) {
            PlatformUI.MIRTH_FRAME.alertError(this, "Cannot export DICOM attachments.");
            return;
        }
        this.doExport();
        this.setVisible(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void doExport() {
        final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Exporting attachment...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private String errorMessage = "";

            @Override
            public Void doInBackground() {
                boolean binary = AttachmentExportDialog.this.binaryButton.isSelected();
                try {
                    if (AttachmentExportDialog.this.localButton.isSelected()) {
                        AttachmentUtil.writeToFile((String)AttachmentExportDialog.this.fileField.getText(), (Attachment)AttachmentExportDialog.this.getSelectedAttachment(), (boolean)binary);
                    } else {
                        PlatformUI.MIRTH_FRAME.mirthClient.exportAttachmentServer(PlatformUI.MIRTH_FRAME.messageBrowser.getChannelId(), PlatformUI.MIRTH_FRAME.messageBrowser.getSelectedMessageId(), PlatformUI.MIRTH_FRAME.messageBrowser.getSelectedAttachmentId(), AttachmentExportDialog.this.fileField.getText(), binary);
                    }
                }
                catch (Exception e) {
                    this.errorMessage = e.getMessage();
                }
                return null;
            }

            @Override
            public void done() {
                PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)PlatformUI.MIRTH_FRAME), StringUtils.isBlank((CharSequence)this.errorMessage) ? "Successfully exported attachment to: " + AttachmentExportDialog.this.fileField.getText() : "Failed to export attachment: " + this.errorMessage);
            }
        };
        worker.execute();
    }

    public Attachment getSelectedAttachment() throws ClientException {
        return PlatformUI.MIRTH_FRAME.mirthClient.getAttachment(PlatformUI.MIRTH_FRAME.messageBrowser.getChannelId(), PlatformUI.MIRTH_FRAME.messageBrowser.getSelectedMessageId(), PlatformUI.MIRTH_FRAME.messageBrowser.getSelectedAttachmentId());
    }
}

