/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.VariableTransferable;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.util.TcpUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ByteAbbreviationList
extends JPanel {
    private JScrollPane jScrollPane1;
    private MirthVariableList mirthVariableList;

    public ByteAbbreviationList() {
        this.initComponents();
        this.mirthVariableList.setTransferMode(VariableListHandler.TransferMode.RAW);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i <= 127; ++i) {
            model.addElement(TcpUtil.convertHexToAbbreviation((String)Integer.toHexString(i).toUpperCase()));
        }
        this.mirthVariableList.setModel(model);
        this.mirthVariableList.setTransferHandler(new VariableListHandler(VariableListHandler.TransferMode.RAW){

            @Override
            protected Transferable createTransferable(JComponent c) {
                int index = ((JList)c).getSelectedIndex();
                if (index >= 0) {
                    return new VariableTransferable(String.format("%02x", index).toUpperCase(), VariableListHandler.TransferMode.RAW);
                }
                return null;
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mirthVariableList = new MirthVariableList();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createTitledBorder("Byte Abbreviations"));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirthVariableList.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirthVariableList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.mirthVariableList));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 113, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 253, Short.MAX_VALUE));
    }
}

