/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.LibraryResourcesPanel;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateLibrariesPanel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePanel;
import com.mirth.connect.client.ui.dependencies.ChannelDependenciesPanel;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class ChannelDependenciesDialog
extends MirthDialog {
    private Channel channel;
    private boolean saved;
    private boolean resourcesReady;
    private boolean codeTemplateLibrariesReady;
    private JPanel containerPanel;
    private JTabbedPane tabPane;
    private JPanel resourcesContainerPanel;
    private LibraryResourcesPanel resourcesPanel;
    private JPanel codeTemplateLibrariesContainerPanel;
    private CodeTemplateLibrariesPanel codeTemplateLibrariesPanel;
    private JPanel dependenciesContainerPanel;
    private ChannelDependenciesPanel dependenciesPanel;
    private JPanel bottomPanel;
    private JSeparator separator;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;

    public ChannelDependenciesDialog(Channel channel) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.channel = channel;
        this.initComponents();
        this.initLayout();
        this.setPreferredSize(new Dimension(450, 434));
        this.setDefaultCloseOperation(2);
        this.setTitle("Channel Dependencies");
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.okButton.setEnabled(false);
        this.resourcesPanel.initialize();
        this.codeTemplateLibrariesPanel.initialize();
        this.setVisible(true);
    }

    public boolean wasSaved() {
        return this.saved;
    }

    public Map<Integer, Map<String, String>> getSelectedResourceIds() {
        return this.resourcesPanel.getSelectedResourceIds();
    }

    public void resourcesReady() {
        this.resourcesReady = true;
        this.checkReady();
    }

    public void codeTemplateLibrariesReady() {
        this.codeTemplateLibrariesReady = true;
        this.checkReady();
    }

    private void checkReady() {
        if (this.resourcesReady && this.codeTemplateLibrariesReady) {
            this.okButton.setEnabled(true);
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.containerPanel = new JPanel();
        this.tabPane = new JTabbedPane();
        this.resourcesContainerPanel = new JPanel();
        this.resourcesContainerPanel.setBackground(this.getBackground());
        this.resourcesPanel = new LibraryResourcesPanel(this, this.channel);
        this.codeTemplateLibrariesContainerPanel = new JPanel();
        this.codeTemplateLibrariesContainerPanel.setBackground(this.getBackground());
        this.codeTemplateLibrariesPanel = new CodeTemplateLibrariesPanel(this, this.channel);
        this.dependenciesContainerPanel = new JPanel();
        this.dependenciesContainerPanel.setBackground(this.getBackground());
        this.dependenciesPanel = new ChannelDependenciesPanel(this, this.channel);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBackground(this.getBackground());
        this.separator = new JSeparator();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(this.getBackground());
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelDependenciesDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelDependenciesDialog.this.cancelButtonActionPerformed();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 12 0, novisualpadding, hidemode 3, fill"));
        this.containerPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.codeTemplateLibrariesContainerPanel.setLayout((LayoutManager)new MigLayout("insets 12 12 0 12, novisualpadding, hidemode 3, fill"));
        this.codeTemplateLibrariesContainerPanel.add((Component)this.codeTemplateLibrariesPanel, "grow");
        this.tabPane.add("Code Template Libraries", this.codeTemplateLibrariesContainerPanel);
        this.resourcesContainerPanel.setLayout((LayoutManager)new MigLayout("insets 12 12 0 12, novisualpadding, hidemode 3, fill"));
        this.resourcesContainerPanel.add((Component)this.resourcesPanel, "grow");
        this.tabPane.add("Library Resources", this.resourcesContainerPanel);
        this.dependenciesContainerPanel.setLayout((LayoutManager)new MigLayout("insets 12 12 0 12, novisualpadding, hidemode 3, fill"));
        this.dependenciesContainerPanel.add((Component)this.dependenciesPanel, "grow");
        this.tabPane.add("Deploy/Start Dependencies", this.dependenciesContainerPanel);
        this.containerPanel.add((Component)this.tabPane, "grow, push");
        this.add((Component)this.containerPanel, "grow, push");
        this.bottomPanel.setLayout((LayoutManager)new MigLayout("insets 0 12 0 12, novisualpadding, hidemode 3, fill"));
        this.bottomPanel.add((Component)this.separator, "grow");
        this.buttonPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.buttonPanel.add((Component)this.okButton, "w 48!");
        this.buttonPanel.add((Component)this.cancelButton, "w 48!");
        this.bottomPanel.add((Component)this.buttonPanel, "newline, right");
        this.add((Component)this.bottomPanel, "newline, grow");
    }

    private void okButtonActionPerformed() {
        if (!this.dependenciesPanel.saveChanges()) {
            return;
        }
        boolean resourcesChanged = false;
        Map<Integer, Map<String, String>> selectedResourceIds = this.resourcesPanel.getSelectedResourceIds();
        if (!Objects.equals(this.channel.getProperties().getResourceIds(), selectedResourceIds.get(null))) {
            resourcesChanged = true;
        }
        if (!Objects.equals(((SourceConnectorPropertiesInterface)this.channel.getSourceConnector().getProperties()).getSourceConnectorProperties().getResourceIds(), selectedResourceIds.get(this.channel.getSourceConnector().getMetaDataId()))) {
            resourcesChanged = true;
        }
        for (Connector destinationConnector : this.channel.getDestinationConnectors()) {
            if (Objects.equals(((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().getResourceIds(), selectedResourceIds.get(destinationConnector.getMetaDataId()))) continue;
            resourcesChanged = true;
            break;
        }
        final boolean resourcesChangedFinal = resourcesChanged;
        Map<String, CodeTemplateLibrary> libraryMap = this.codeTemplateLibrariesPanel.getLibraryMap();
        if (this.codeTemplateLibrariesPanel.wasChanged() && !PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().equals(libraryMap)) {
            if (!PlatformUI.MIRTH_FRAME.alertOption(this, "You've made changes to code template libraries, which will be saved now. Are you sure you wish to continue?")) {
                return;
            }
            CodeTemplatePanel.UpdateSwingWorker worker = PlatformUI.MIRTH_FRAME.codeTemplatePanel.getSwingWorker(libraryMap, new HashMap<String, CodeTemplateLibrary>(), new HashMap<String, CodeTemplate>(), new HashMap<String, CodeTemplate>(), false);
            worker.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (resourcesChangedFinal) {
                        ChannelDependenciesDialog.this.saved = true;
                    }
                    ChannelDependenciesDialog.this.dispose();
                }
            });
            worker.execute();
        } else {
            if (resourcesChangedFinal) {
                this.saved = true;
            }
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed() {
        this.dispose();
    }
}

