/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ForbiddenException;
import com.mirth.connect.client.ui.AbstractChannelTableNode;
import com.mirth.connect.client.ui.AbstractFramePanel;
import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.ChannelSetup;
import com.mirth.connect.client.ui.ChannelTableColumnFactory;
import com.mirth.connect.client.ui.ChannelTableNameEntry;
import com.mirth.connect.client.ui.ChannelTableNode;
import com.mirth.connect.client.ui.ChannelTableNodeFactory;
import com.mirth.connect.client.ui.ChannelTreeTableModel;
import com.mirth.connect.client.ui.ChannelWizard;
import com.mirth.connect.client.ui.DeployInDebugModeDialog;
import com.mirth.connect.client.ui.ExportChannelLibrariesDialog;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.QueuingSwingWorker;
import com.mirth.connect.client.ui.QueuingSwingWorkerTask;
import com.mirth.connect.client.ui.TagTreeCellRenderer;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateImportDialog;
import com.mirth.connect.client.ui.components.ChannelTableTransferHandler;
import com.mirth.connect.client.ui.components.IconToggleButton;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.components.tag.ChannelNameFilterCompletion;
import com.mirth.connect.client.ui.components.tag.FilterCompletion;
import com.mirth.connect.client.ui.components.tag.MirthTagField;
import com.mirth.connect.client.ui.components.tag.SearchFilterListener;
import com.mirth.connect.client.ui.components.tag.TagFilterCompletion;
import com.mirth.connect.client.ui.tag.SettingsPanelTags;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.filter.SearchFilter;
import com.mirth.connect.model.filter.SearchFilterParser;
import com.mirth.connect.model.util.ImportConverter3_0_0;
import com.mirth.connect.plugins.ChannelColumnPlugin;
import com.mirth.connect.plugins.ChannelPanelPlugin;
import com.mirth.connect.plugins.TaskPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class ChannelPanel
extends AbstractFramePanel {
    public static final String STATUS_COLUMN_NAME = "Status";
    public static final String DATA_TYPE_COLUMN_NAME = "Data Type";
    public static final String NAME_COLUMN_NAME = "Name";
    public static final String ID_COLUMN_NAME = "Id";
    public static final String LOCAL_CHANNEL_ID = "Local Id";
    public static final String DESCRIPTION_COLUMN_NAME = "Description";
    public static final String DEPLOYED_REVISION_DELTA_COLUMN_NAME = "Rev \u0394";
    public static final String LAST_DEPLOYED_COLUMN_NAME = "Last Deployed";
    public static final String LAST_MODIFIED_COLUMN_NAME = "Last Modified";
    public static final int STATUS_COLUMN_NUMBER = 0;
    public static final int DATA_TYPE_COLUMN_NUMBER = 1;
    public static final int NAME_COLUMN_NUMBER = 2;
    public static final int ID_COLUMN_NUMBER = 3;
    public static final int LOCAL_CHANNEL_ID_COLUMN_NUMBER = 4;
    public static final int DESCRIPTION_COLUMN_NUMBER = 5;
    public static final int DEPLOYED_REVISION_DELTA_COLUMN_NUMBER = 6;
    public static final int LAST_DEPLOYED_COLUMN_NUMBER = 7;
    public static final int LAST_MODIFIED_COLUMN_NUMBER = 8;
    private static final String[] DEFAULT_COLUMNS = new String[]{"Status", "Data Type", "Name", "Id", "Local Id", "Description", "Rev \u0394", "Last Deployed", "Last Modified"};
    private static final int TASK_CHANNEL_REFRESH = 0;
    private static final int TASK_CHANNEL_REDEPLOY_ALL = 1;
    private static final int TASK_CHANNEL_DEBUG_DEPLOY = 2;
    private static final int TASK_CHANNEL_DEPLOY = 3;
    private static final int TASK_CHANNEL_EDIT_GLOBAL_SCRIPTS = 4;
    private static final int TASK_CHANNEL_EDIT_CODE_TEMPLATES = 5;
    private static final int TASK_CHANNEL_NEW_CHANNEL = 6;
    private static final int TASK_CHANNEL_IMPORT_CHANNEL = 7;
    private static final int TASK_CHANNEL_EXPORT_ALL_CHANNELS = 8;
    private static final int TASK_CHANNEL_EXPORT_CHANNEL = 9;
    private static final int TASK_CHANNEL_DELETE_CHANNEL = 10;
    private static final int TASK_CHANNEL_CLONE = 11;
    private static final int TASK_CHANNEL_EDIT = 12;
    private static final int TASK_CHANNEL_ENABLE = 13;
    private static final int TASK_CHANNEL_DISABLE = 14;
    private static final int TASK_CHANNEL_VIEW_MESSAGES = 15;
    private static final int TASK_GROUP_SAVE = 0;
    private static final int TASK_GROUP_ASSIGN_CHANNEL = 1;
    private static final int TASK_GROUP_NEW_GROUP = 2;
    private static final int TASK_GROUP_EDIT_DETAILS = 3;
    private static final int TASK_GROUP_IMPORT_GROUP = 4;
    private static final int TASK_GROUP_EXPORT_ALL_GROUPS = 5;
    private static final int TASK_GROUP_EXPORT_GROUP = 6;
    private static final int TASK_GROUP_DELETE_GROUP = 7;
    private Frame parent;
    private Map<String, String> channelIdsAndNames = new HashMap<String, String>();
    private Map<String, ChannelStatus> channelStatuses = new LinkedHashMap<String, ChannelStatus>();
    private Map<String, ChannelGroupStatus> groupStatuses = new LinkedHashMap<String, ChannelGroupStatus>();
    private Set<ChannelDependency> channelDependencies = new HashSet<ChannelDependency>();
    private Preferences userPreferences;
    private boolean tagTextModeSelected = false;
    private boolean tagIconModeSelected = false;
    private boolean canViewChannelGroups = AuthorizationControllerFactory.getAuthorizationController().checkTask("channelGroup", "doExportGroup");
    private boolean channelsGroupsLoaded = false;
    public JXTaskPane channelTasks;
    public JPopupMenu channelPopupMenu;
    public JXTaskPane groupTasks;
    public JPopupMenu groupPopupMenu;
    private JSplitPane splitPane;
    private JPanel topPanel;
    private MirthTreeTable channelTable;
    private JScrollPane channelScrollPane;
    private JPanel filterPanel;
    private JLabel filterLabel;
    private MirthTagField tagField;
    private JLabel tagsLabel;
    private IconToggleButton tagModeTextButton;
    private IconToggleButton tagModeIconButton;
    private IconToggleButton tableModeGroupsButton;
    private IconToggleButton tableModeChannelsButton;
    private JTabbedPane tabPane;

    public ChannelPanel() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
        this.initComponents();
        this.initLayout();
        this.channelTasks = new JXTaskPane();
        this.channelTasks.setTitle("Channel Tasks");
        this.channelTasks.setName("channel");
        this.channelTasks.setFocusable(false);
        this.channelPopupMenu = new JPopupMenu();
        this.channelTable.setComponentPopupMenu(this.channelPopupMenu);
        this.parent.addTask("doRefreshChannels", "Refresh", "Refresh the list of channels.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doRedeployAll", "Redeploy All", "Undeploy all channels and deploy all currently enabled channels.", "A", new ImageIcon(Frame.class.getResource("images/arrow_rotate_clockwise.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doDeployInDebug", "Debug Channel", "Deploys the currently selected channel in debug mode.", "", new ImageIcon(Frame.class.getResource("images/bug_go.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doDeployChannel", "Deploy Channel", "Deploys the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/arrow_redo.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doEditGlobalScripts", "Edit Global Scripts", "Edit scripts that are not channel specific.", "G", new ImageIcon(Frame.class.getResource("images/script_edit.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doEditCodeTemplates", "Edit Code Templates", "Create and manage templates to be used in JavaScript throughout BridgeLink.", "", new ImageIcon(Frame.class.getResource("images/page_edit.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doNewChannel", "New Channel", "Create a new channel.", "N", new ImageIcon(Frame.class.getResource("images/application_form_add.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doImportChannel", "Import Channel", "Import a channel from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doExportAllChannels", "Export All Channels", "Export all of the channels to XML files.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doExportChannel", "Export Channel", "Export the currently selected channel to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doDeleteChannel", "Delete Channel", "Delete the currently selected channel.", "L", new ImageIcon(Frame.class.getResource("images/application_form_delete.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doCloneChannel", "Clone Channel", "Clone the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/page_copy.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doEditChannel", "Edit Channel", "Edit the currently selected channel.", "I", new ImageIcon(Frame.class.getResource("images/application_form_edit.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doEnableChannel", "Enable Channel", "Enable the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doDisableChannel", "Disable Channel", "Disable the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/control_stop_blue.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.addTask("doViewMessages", "View Messages", "Show the messages for the currently selected channel.", "", new ImageIcon(Frame.class.getResource("images/page_white_stack.png")), this.channelTasks, this.channelPopupMenu, this);
        this.parent.setNonFocusable(this.channelTasks);
        this.parent.taskPaneContainer.add((Component)this.channelTasks, this.parent.taskPaneContainer.getComponentCount() - 1);
        this.groupTasks = new JXTaskPane();
        this.groupTasks.setTitle("Group Tasks");
        this.groupTasks.setName("channelGroup");
        this.groupTasks.setFocusable(false);
        this.groupPopupMenu = new JPopupMenu();
        this.parent.addTask("doSaveGroups", "Save Group Changes", "Save all changes made to channel groups.", "", new ImageIcon(Frame.class.getResource("images/disk.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doAssignChannelToGroup", "Assign To Group", "Assign channel(s) to a group.", "A", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doNewGroup", "New Group", "Create a new channel group.", "N", new ImageIcon(Frame.class.getResource("images/application_form_add.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doEditGroupDetails", "Edit Group Details", "Edit group name and description.", "E", new ImageIcon(Frame.class.getResource("images/application_form_edit.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doImportGroup", "Import Group", "Import a channel group from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doExportAllGroups", "Export All Groups", "Export all of the channel groups to XML files.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doExportGroup", "Export Group", "Export the currently selected channel group to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.addTask("doDeleteGroup", "Delete Group", "Delete the currently selected channel group.", "L", new ImageIcon(Frame.class.getResource("images/application_form_delete.png")), this.groupTasks, this.groupPopupMenu, this);
        this.parent.setNonFocusable(this.groupTasks);
        this.parent.taskPaneContainer.add((Component)this.groupTasks, this.parent.taskPaneContainer.getComponentCount() - 1);
        this.channelScrollPane.setComponentPopupMenu(this.channelPopupMenu);
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        if (this.canViewChannelGroups && this.userPreferences.getBoolean("channelGroupViewEnabled", true)) {
            this.tableModeGroupsButton.setSelected(true);
            this.tableModeGroupsButton.setContentFilled(true);
            this.tableModeChannelsButton.setContentFilled(false);
            model.setGroupModeEnabled(true);
        } else {
            this.tableModeChannelsButton.setSelected(true);
            this.tableModeChannelsButton.setContentFilled(true);
            this.tableModeGroupsButton.setContentFilled(false);
            model.setGroupModeEnabled(false);
        }
        if (!this.canViewChannelGroups) {
            this.tableModeGroupsButton.setEnabled(false);
        }
        this.updateTagButtons(this.userPreferences.getBoolean("showTags", true), this.userPreferences.getBoolean("tagTextMode", false), false);
        this.updateModel(new TableState(new ArrayList<String>(), null));
        this.updateTasks();
    }

    @Override
    public void switchPanel() {
        boolean groupViewEnabled = this.canViewChannelGroups && this.userPreferences.getBoolean("channelGroupViewEnabled", true);
        this.switchTableMode(groupViewEnabled, false);
        if (groupViewEnabled) {
            this.tableModeGroupsButton.setSelected(true);
            this.tableModeGroupsButton.setContentFilled(true);
            this.tableModeChannelsButton.setContentFilled(false);
        } else {
            this.tableModeChannelsButton.setSelected(true);
            this.tableModeChannelsButton.setContentFilled(true);
            this.tableModeGroupsButton.setContentFilled(false);
        }
        this.updateTagButtons(this.userPreferences.getBoolean("showTags", true), this.userPreferences.getBoolean("tagTextMode", false), false);
        ArrayList<JXTaskPane> taskPanes = new ArrayList<JXTaskPane>();
        taskPanes.add(this.channelTasks);
        if (groupViewEnabled) {
            taskPanes.add(this.groupTasks);
        }
        for (TaskPlugin plugin : LoadedExtensions.getInstance().getTaskPlugins().values()) {
            JXTaskPane taskPane = plugin.getTaskPane();
            if (taskPane == null) continue;
            taskPanes.add(taskPane);
        }
        this.tagField.setFocus(true);
        this.parent.setBold(this.parent.viewPane, 1);
        this.parent.setPanelName("Channels");
        this.parent.setCurrentContentPage(this);
        this.parent.setFocus(taskPanes.toArray(new JXTaskPane[taskPanes.size()]), true, true);
        this.parent.setSaveEnabled(false);
        this.setSaveEnabled(false);
        this.doRefreshChannels();
    }

    private void updateTagButtons(boolean showTags, boolean textMode, boolean updatePreferences) {
        this.tagModeTextButton.setSelected(showTags && textMode);
        this.tagModeIconButton.setSelected(showTags && !textMode);
        this.tagModeTextButton.setContentFilled(showTags && textMode);
        this.tagModeIconButton.setContentFilled(showTags && !textMode);
        this.channelTable.setTreeCellRenderer(new TagTreeCellRenderer(showTags, textMode));
        this.tagTextModeSelected = showTags && textMode;
        boolean bl = this.tagIconModeSelected = showTags && !textMode;
        if (updatePreferences) {
            this.userPreferences.putBoolean("showTags", showTags);
            this.userPreferences.putBoolean("tagTextMode", textMode);
        }
    }

    public void closePopupWindow() {
        this.tagField.closePopupWindow();
    }

    @Override
    public boolean isSaveEnabled() {
        return this.groupTasks.getContentPane().getComponent(0).isVisible();
    }

    @Override
    public void setSaveEnabled(boolean enabled) {
        this.setGroupTaskVisibility(0, enabled);
    }

    @Override
    public boolean changesHaveBeenMade() {
        return this.isSaveEnabled();
    }

    @Override
    public void doContextSensitiveSave() {
        if (this.isSaveEnabled()) {
            this.doSaveGroups();
        }
    }

    @Override
    public boolean confirmLeave() {
        return this.promptSave(false);
    }

    private boolean promptSave(boolean force) {
        int option = force ? JOptionPane.showConfirmDialog((Component)((Object)this.parent), "You must save the channel group changes before continuing. Would you like to save now?") : JOptionPane.showConfirmDialog((Component)((Object)this.parent), "Would you like to save the channel groups?");
        if (option == 0) {
            return this.doSaveGroups(false);
        }
        return option != 2 && option != -1 && (option != 1 || !force);
    }

    @Override
    protected Component addAction(Action action, Set<String> options) {
        Component taskComponent = this.channelTasks.add(action);
        this.channelPopupMenu.add(action);
        return taskComponent;
    }

    public Map<String, String> getCachedChannelIdsAndNames() {
        return this.channelIdsAndNames;
    }

    public Map<String, ChannelStatus> getCachedChannelStatuses() {
        return this.channelStatuses;
    }

    public Map<String, ChannelGroupStatus> getCachedGroupStatuses() {
        return this.groupStatuses;
    }

    public Set<ChannelDependency> getCachedChannelDependencies() {
        return this.channelDependencies;
    }

    public Set<ChannelTag> getCachedChannelTags() {
        return this.parent.getCachedChannelTags();
    }

    public String getUserTags() {
        return this.tagField.getTags();
    }

    public void doRefreshChannels() {
        this.doRefreshChannels(true);
    }

    public void doRefreshChannels(boolean queue) {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        QueuingSwingWorkerTask<Void, Void> task = new QueuingSwingWorkerTask<Void, Void>("doRefreshChannels", "Loading channels..."){

            @Override
            public Void doInBackground() {
                ChannelPanel.this.retrieveChannels();
                return null;
            }

            @Override
            public void done() {
                ChannelPanel.this.updateModel(ChannelPanel.this.getCurrentTableState());
                ChannelPanel.this.channelsGroupsLoaded = true;
                ChannelPanel.this.updateTasks();
                ChannelPanel.this.updateTags(false);
                ChannelPanel.this.parent.setSaveEnabled(false);
            }
        };
        new QueuingSwingWorker<Void, Void>(task, queue).executeDelegate();
    }

    private void updateTasks() {
        int[] rows = this.channelTable.getSelectedModelRows();
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        boolean filterEnabled = this.tagField.isFilterEnabled();
        boolean saveEnabled = this.isSaveEnabled();
        this.setAllTaskVisibility(false);
        this.setChannelTaskVisible(0);
        this.setChannelTaskVisible(1);
        this.setChannelTaskVisible(4);
        this.setChannelTaskVisible(5);
        this.setChannelTaskVisible(6);
        this.setChannelTaskVisible(7);
        if (model.isGroupModeEnabled()) {
            if (!filterEnabled) {
                if (this.channelsGroupsLoaded) {
                    this.setGroupTaskVisible(2);
                }
                if (!saveEnabled) {
                    this.setGroupTaskVisible(4);
                }
            }
            if (!saveEnabled) {
                this.setGroupTaskVisible(5);
            }
        } else {
            this.setChannelTaskVisible(8);
        }
        if (rows.length > 0) {
            boolean allGroups = true;
            boolean allChannels = true;
            boolean allEnabled = true;
            boolean allDisabled = true;
            boolean channelNodeFound = false;
            boolean includesDefaultGroup = false;
            for (int row : rows) {
                TreePath path = this.channelTable.getPathForRow(row);
                if (path == null) continue;
                AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
                if (node.isGroupNode()) {
                    allChannels = false;
                    Enumeration channelNodes = node.children();
                    while (channelNodes.hasMoreElements()) {
                        AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)channelNodes.nextElement());
                        if (channelNode.getChannelStatus().getChannel().getExportData().getMetadata().isEnabled()) {
                            allDisabled = false;
                        } else {
                            allEnabled = false;
                        }
                        channelNodeFound = true;
                    }
                    if (!StringUtils.equals((CharSequence)node.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group")) continue;
                    includesDefaultGroup = true;
                    continue;
                }
                allGroups = false;
                if (node.getChannelStatus().getChannel().getExportData().getMetadata().isEnabled()) {
                    allDisabled = false;
                    continue;
                }
                allEnabled = false;
            }
            if (!allGroups || channelNodeFound) {
                if (!allDisabled) {
                    this.setChannelTaskVisible(14);
                }
                if (!allEnabled) {
                    this.setChannelTaskVisible(13);
                }
            }
            if (allGroups) {
                if (rows.length == 1 && !includesDefaultGroup && !filterEnabled) {
                    this.setGroupTaskVisible(3);
                }
                if (channelNodeFound && !allDisabled) {
                    this.setChannelTaskVisible(3);
                }
                if (!saveEnabled) {
                    this.setGroupTaskVisible(6);
                }
                if (!includesDefaultGroup && !filterEnabled) {
                    this.setGroupTaskVisible(7);
                }
            } else if (allChannels) {
                if (!allDisabled) {
                    this.setChannelTaskVisible(3);
                }
                if (!filterEnabled && model.isGroupModeEnabled()) {
                    this.setGroupTaskVisible(1);
                }
                this.setChannelTaskVisible(9);
                this.setChannelTaskVisible(10);
                if (rows.length == 1) {
                    this.setChannelTaskVisible(11);
                    this.setChannelTaskVisible(12);
                    this.setChannelTaskVisible(2);
                }
            } else {
                this.setChannelTaskVisible(3);
            }
            if (this.parent.multiChannelMessageBrowsingEnabled || allChannels && rows.length == 1) {
                this.setChannelTaskVisible(15);
            }
        }
    }

    private void updateTags(boolean updateController) {
        HashSet<FilterCompletion> tags = new HashSet<FilterCompletion>();
        for (ChannelStatus status : this.channelStatuses.values()) {
            tags.add(new ChannelNameFilterCompletion(status.getChannel().getName()));
        }
        for (ChannelTag channelTag : this.getCachedChannelTags()) {
            tags.add(new TagFilterCompletion(channelTag));
        }
        this.tagField.update(tags, false, true, updateController);
    }

    public void retrieveGroups() {
        block2: {
            try {
                this.updateChannelGroups(this.parent.mirthClient.getAllChannelGroups());
            }
            catch (ClientException e) {
                this.updateChannelGroups(null);
                if (e instanceof ForbiddenException) break block2;
                SwingUtilities.invokeLater(() -> this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, false));
            }
        }
    }

    public void retrieveChannelIdsAndNames() {
        try {
            this.channelIdsAndNames = this.parent.mirthClient.getChannelIdsAndNames();
        }
        catch (ClientException e) {
            SwingUtilities.invokeLater(() -> this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, false));
        }
    }

    public void retrieveChannels() {
        this.retrieveChannels(true);
    }

    public void retrieveChannels(boolean refreshTags) {
        try {
            SettingsPanelTags tagsPanel;
            this.channelIdsAndNames = this.parent.mirthClient.getChannelIdsAndNames();
            this.updateChannelStatuses(this.parent.mirthClient.getChannelSummary(this.getChannelHeaders(), false));
            try {
                this.updateChannelGroups(this.parent.mirthClient.getAllChannelGroups());
            }
            catch (ForbiddenException e) {
                this.updateChannelGroups(null);
            }
            this.channelDependencies = this.parent.mirthClient.getChannelDependencies();
            this.updateChannelMetadata(this.parent.mirthClient.getChannelMetadata());
            if (refreshTags && (tagsPanel = this.parent.getTagsPanel()) != null) {
                tagsPanel.refresh();
            }
        }
        catch (ClientException e) {
            SwingUtilities.invokeLater(() -> this.parent.alertThrowable((Component)((Object)this.parent), e));
        }
    }

    public void retrieveDependencies() {
        try {
            this.channelDependencies = this.parent.mirthClient.getChannelDependencies();
        }
        catch (ClientException e) {
            SwingUtilities.invokeLater(() -> this.parent.alertThrowable((Component)((Object)this.parent), e));
        }
    }

    public Map<String, ChannelHeader> getChannelHeaders() {
        HashMap<String, ChannelHeader> channelHeaders = new HashMap<String, ChannelHeader>();
        for (ChannelStatus channelStatus : this.channelStatuses.values()) {
            Channel channel = channelStatus.getChannel();
            channelHeaders.put(channel.getId(), new ChannelHeader(channel.getRevision().intValue(), channelStatus.getDeployedDate(), channelStatus.isCodeTemplatesChanged()));
        }
        return channelHeaders;
    }

    public void updateChannelTags(List<ChannelTag> channelTags, String channelId) {
        ArrayList<ChannelTag> tagsCopy = new ArrayList<ChannelTag>(channelTags);
        HashSet<ChannelTag> updateTagList = new HashSet<ChannelTag>();
        Iterator it = tagsCopy.iterator();
        while (it.hasNext()) {
            ChannelTag tagToUpdate = (ChannelTag)it.next();
            for (ChannelTag existingTag : this.getCachedChannelTags()) {
                if (existingTag.getId().equals(tagToUpdate.getId()) || existingTag.getName().equalsIgnoreCase(tagToUpdate.getName())) {
                    existingTag.getChannelIds().add(channelId);
                    it.remove();
                }
                updateTagList.add(existingTag);
            }
        }
        for (ChannelTag newTag : tagsCopy) {
            String tagName = newTag.getName();
            newTag.setName(StringUtils.substring((String)tagName, (int)0, (int)24));
            updateTagList.add(newTag);
        }
        SettingsPanelTags tagsPanel = this.parent.getTagsPanel();
        if (tagsPanel != null) {
            tagsPanel.updateTagsTable(updateTagList);
        }
    }

    public boolean doSaveGroups() {
        return this.doSaveGroups(true);
    }

    public boolean doSaveGroups(boolean asynchronous) {
        if (this.tagField.isFilterEnabled()) {
            return false;
        }
        HashSet<ChannelGroup> channelGroups = new HashSet<ChannelGroup>();
        HashSet<String> removedChannelGroupIds = new HashSet<String>(this.groupStatuses.keySet());
        removedChannelGroupIds.remove("Default Group");
        MutableTreeTableNode root = (MutableTreeTableNode)this.channelTable.getTreeTableModel().getRoot();
        if (root == null) {
            return false;
        }
        Enumeration groupNodes = root.children();
        while (groupNodes.hasMoreElements()) {
            ChannelGroup group = ((AbstractChannelTableNode)((Object)groupNodes.nextElement())).getGroupStatus().getGroup();
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)"Default Group")) {
                channelGroups.add(group);
                removedChannelGroupIds.remove(group.getId());
            }
            if (!StringUtils.isBlank((CharSequence)group.getName())) continue;
            this.parent.alertError((Component)((Object)this.parent), "One or more groups have a blank name.");
            return false;
        }
        if (!asynchronous) {
            return this.attemptUpdate(channelGroups, removedChannelGroupIds, false);
        }
        new UpdateSwingWorker(channelGroups, removedChannelGroupIds, false).execute();
        this.tagField.setEnabled(true);
        this.filterLabel.setEnabled(true);
        return true;
    }

    private boolean attemptUpdate(Set<ChannelGroup> channelGroups, Set<String> removedChannelGroupIds, boolean override) {
        boolean result = false;
        boolean tryAgain = false;
        try {
            result = this.updateGroups(channelGroups, removedChannelGroupIds, override);
            if (result) {
                this.afterUpdate();
            } else if (!override) {
                if (this.parent.alertOption((Component)((Object)this.parent), "One or more channel groups have been modified since you last refreshed.\nDo you want to overwrite the changes?")) {
                    tryAgain = true;
                }
            } else {
                this.parent.alertError((Component)((Object)this.parent), "Unable to save channel groups.");
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof ExecutionException) {
                cause = e.getCause();
            }
            this.parent.alertThrowable((Component)((Object)this.parent), cause, "Unable to save channel groups: " + cause.getMessage());
        }
        if (tryAgain && !override) {
            return this.attemptUpdate(channelGroups, removedChannelGroupIds, true);
        }
        return result;
    }

    private boolean updateGroups(Set<ChannelGroup> channelGroups, Set<String> removedChannelGroupIds, boolean override) throws ClientException {
        return this.parent.mirthClient.updateChannelGroups(channelGroups, removedChannelGroupIds, override);
    }

    private void afterUpdate() {
        this.parent.setSaveEnabled(false);
        this.doRefreshChannels();
    }

    public void doRedeployAll() {
        if (!this.parent.alertOption((Component)((Object)this.parent), "Are you sure you want to redeploy all channels?")) {
            return;
        }
        final String workingId = this.parent.startWorking("Deploying channels...");
        this.parent.dashboardPanel.deselectRows(false);
        this.parent.doShowDashboard();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    ChannelPanel.this.parent.mirthClient.redeployAllChannels();
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), e));
                }
                return null;
            }

            @Override
            public void done() {
                ChannelPanel.this.parent.stopWorking(workingId);
                ChannelPanel.this.parent.doRefreshStatuses(true);
            }
        };
        worker.execute();
    }

    public void doDeployInDebug() {
        DeployInDebugModeDialog deployInDebugMode = new DeployInDebugModeDialog();
        DebugOptions debugOptions = deployInDebugMode.getDebugOptions();
        if (deployInDebugMode.getIsDebugChannel()) {
            this.doDeployChannel(debugOptions);
        }
    }

    public void doDeployChannel() {
        this.doDeployChannel(null);
    }

    public void doDeployChannel(DebugOptions debugOptions) {
        List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() == 0) {
            this.parent.alertWarning((Component)((Object)this.parent), "Channel no longer exists.");
            return;
        }
        LinkedHashSet<String> selectedEnabledChannelIds = new LinkedHashSet<String>();
        boolean channelDisabled = false;
        for (Channel channel : selectedChannels) {
            if (channel.getExportData().getMetadata().isEnabled()) {
                selectedEnabledChannelIds.add(channel.getId());
                continue;
            }
            channelDisabled = true;
        }
        if (channelDisabled) {
            this.parent.alertWarning((Component)((Object)this.parent), "Disabled channels will not be deployed.");
        }
        this.parent.deployChannel(selectedEnabledChannelIds, debugOptions);
    }

    public void doEditGlobalScripts() {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        this.parent.doEditGlobalScripts();
    }

    public void doEditCodeTemplates() {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        this.parent.doEditCodeTemplates();
    }

    public void doNewGroup() {
        if (this.tagField.isFilterEnabled()) {
            return;
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (root == null) {
            return;
        }
        GroupDetailsDialog dialog = new GroupDetailsDialog(true);
        if (dialog.wasSaved()) {
            AbstractChannelTableNode groupNode = model.addNewGroup(new ChannelGroup(dialog.getGroupName(), dialog.getGroupDescription()));
            this.parent.setSaveEnabled(true);
            final TreePath path = new TreePath(new Object[]{root, groupNode});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChannelPanel.this.channelTable.getTreeSelectionModel().setSelectionPath(path);
                }
            });
        }
        this.tagField.setEnabled(false);
        this.filterLabel.setEnabled(false);
    }

    private boolean checkGroupId(String id) {
        MutableTreeTableNode root = (MutableTreeTableNode)this.channelTable.getTreeTableModel().getRoot();
        if (root == null) {
            return false;
        }
        Enumeration groupNodes = root.children();
        while (groupNodes.hasMoreElements()) {
            if (!StringUtils.equals((CharSequence)((AbstractChannelTableNode)((Object)groupNodes.nextElement())).getGroupStatus().getGroup().getId(), (CharSequence)id)) continue;
            return false;
        }
        return true;
    }

    private boolean checkGroupName(String name) {
        return this.checkGroupName(name, true);
    }

    private boolean checkGroupName(String name, boolean includeSelectedRow) {
        MutableTreeTableNode root = (MutableTreeTableNode)this.channelTable.getTreeTableModel().getRoot();
        if (root == null) {
            return false;
        }
        Enumeration groupNodes = root.children();
        while (groupNodes.hasMoreElements()) {
            AbstractChannelTableNode selectedNode;
            AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
            if (!includeSelectedRow && this.channelTable.getSelectedRow() != -1 && (selectedNode = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(this.channelTable.getSelectedRow()).getLastPathComponent())).isGroupNode() && selectedNode.getGroupStatus().getGroup().getId().equals(groupNode.getGroupStatus().getGroup().getId()) || !StringUtils.equals((CharSequence)groupNode.getGroupStatus().getGroup().getName(), (CharSequence)name)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAssignChannelToGroup() {
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        int[] rows = this.channelTable.getSelectedModelRows();
        if (model.isGroupModeEnabled() && rows.length > 0) {
            for (int row : rows) {
                if (!((AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent())).isGroupNode()) continue;
                return;
            }
            GroupAssignmentDialog dialog = new GroupAssignmentDialog();
            if (dialog.wasSaved()) {
                AbstractChannelTableNode groupNode = null;
                Enumeration groupNodes = ((MutableTreeTableNode)model.getRoot()).children();
                while (groupNodes.hasMoreElements()) {
                    AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                    if (!StringUtils.equals((CharSequence)node.getGroupStatus().getGroup().getId(), (CharSequence)dialog.getSelectedGroupId())) continue;
                    groupNode = node;
                    break;
                }
                if (groupNode != null) {
                    ListSelectionListener[] listeners;
                    TableState tableState = this.getCurrentTableState();
                    tableState.getExpandedGroupIds().add(groupNode.getGroupStatus().getGroup().getId());
                    for (ListSelectionListener listener : listeners = ((DefaultListSelectionModel)this.channelTable.getSelectionModel()).getListSelectionListeners()) {
                        this.channelTable.getSelectionModel().removeListSelectionListener(listener);
                    }
                    try {
                        ArrayList<AbstractChannelTableNode> channelNodes = new ArrayList<AbstractChannelTableNode>();
                        for (int row : rows) {
                            channelNodes.add((AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent()));
                        }
                        Object object = channelNodes.iterator();
                        while (object.hasNext()) {
                            AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)object.next());
                            model.addChannelToGroup(groupNode, channelNode.getChannelStatus().getChannel().getId());
                        }
                        this.channelTable.expandPath(new TreePath(new Object[]{this.channelTable.getTreeTableModel().getRoot(), groupNode}));
                        this.parent.setSaveEnabled(true);
                    }
                    finally {
                        for (ListSelectionListener listener : listeners) {
                            this.channelTable.getSelectionModel().addListSelectionListener(listener);
                        }
                        this.restoreTableState(tableState);
                    }
                }
            }
        }
    }

    public void doEditGroupDetails() {
        GroupDetailsDialog dialog;
        AbstractChannelTableNode node;
        if (this.tagField.isFilterEnabled()) {
            return;
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (root == null) {
            return;
        }
        int[] rows = this.channelTable.getSelectedModelRows();
        if (rows.length == 1 && (node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(rows[0]).getLastPathComponent())).isGroupNode() && !StringUtils.equals((CharSequence)node.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group") && (dialog = new GroupDetailsDialog(false)).wasSaved()) {
            this.channelTable.getTreeTableModel().setValueAt((Object)new ChannelTableNameEntry(dialog.getGroupName()), (Object)node, 2);
            this.channelTable.getTreeTableModel().setValueAt((Object)dialog.getGroupDescription(), (Object)node, 5);
            this.parent.setSaveEnabled(true);
        }
    }

    public void doNewChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        if (LoadedExtensions.getInstance().getSourceConnectors().size() == 0 || LoadedExtensions.getInstance().getDestinationConnectors().size() == 0) {
            this.parent.alertError((Component)((Object)this.parent), "You must have at least one source connector and one destination connector installed.");
            return;
        }
        new ChannelWizard();
    }

    public void createNewChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        Channel channel = new Channel();
        try {
            channel.setId(this.parent.mirthClient.getGuid());
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
        channel.setName("");
        HashSet<String> selectedGroupIds = new HashSet<String>();
        if (((ChannelTreeTableModel)this.channelTable.getTreeTableModel()).isGroupModeEnabled()) {
            for (int row : this.channelTable.getSelectedModelRows()) {
                TreePath path = this.channelTable.getPathForRow(row);
                if (path == null) continue;
                AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)path.getLastPathComponent());
                if (node.isGroupNode()) {
                    selectedGroupIds.add(node.getGroupStatus().getGroup().getId());
                    continue;
                }
                if (!(node.getParent() instanceof AbstractChannelTableNode) || !(node = (AbstractChannelTableNode)node.getParent()).isGroupNode()) continue;
                selectedGroupIds.add(node.getGroupStatus().getGroup().getId());
            }
        }
        this.parent.setupChannel(channel, selectedGroupIds.size() == 1 ? (String)selectedGroupIds.iterator().next() : null);
    }

    public void addChannelToGroup(String channelId, String groupId) {
        HashSet<ChannelGroup> channelGroups = new HashSet<ChannelGroup>();
        for (ChannelGroupStatus groupStatus : this.groupStatuses.values()) {
            ChannelGroup group = groupStatus.getGroup();
            if (group.getId().equals("Default Group")) continue;
            if (group.getId().equals(groupId)) {
                group.getChannels().add(new Channel(channelId));
            }
            channelGroups.add(group);
        }
        new UpdateSwingWorker(channelGroups, new HashSet<String>(), false).execute();
    }

    public void doImportGroup() {
        if (this.isSaveEnabled() && !this.promptSave(true) || this.tagField.isFilterEnabled()) {
            return;
        }
        String content = this.parent.browseForFileString("XML");
        if (content != null) {
            this.importGroup(content, true);
        }
    }

    public void importGroup(String content, boolean showAlerts) {
        if (showAlerts && !this.parent.promptObjectMigration(content, "group") || this.tagField.isFilterEnabled()) {
            return;
        }
        ChannelGroup importGroup = null;
        try {
            importGroup = (ChannelGroup)ObjectXMLSerializer.getInstance().deserialize(content, ChannelGroup.class);
        }
        catch (Exception e) {
            if (showAlerts) {
                this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, "Invalid channel group file:\n" + e.getMessage());
            }
            return;
        }
        this.importGroup(importGroup, showAlerts);
    }

    public void importGroup(ChannelGroup importGroup, boolean showAlerts) {
        this.importGroup(importGroup, showAlerts, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importGroup(ChannelGroup importGroup, boolean showAlerts, boolean synchronous) {
        LinkedHashMap<String, CodeTemplateLibrary> codeTemplateLibraryMap = new LinkedHashMap<String, CodeTemplateLibrary>();
        HashSet<String> codeTemplateIds = new HashSet<String>();
        for (Channel channel : importGroup.getChannels()) {
            if (channel.getExportData() == null || channel.getExportData().getCodeTemplateLibraries() == null) continue;
            for (CodeTemplateLibrary library : channel.getExportData().getCodeTemplateLibraries()) {
                CodeTemplateLibrary matchingLibrary = (CodeTemplateLibrary)codeTemplateLibraryMap.get(library.getId());
                if (matchingLibrary != null) {
                    for (Object codeTemplate : library.getCodeTemplates()) {
                        if (!codeTemplateIds.add(codeTemplate.getId())) continue;
                        matchingLibrary.getCodeTemplates().add(codeTemplate);
                    }
                } else {
                    Object codeTemplate;
                    matchingLibrary = library;
                    codeTemplateLibraryMap.put(matchingLibrary.getId(), matchingLibrary);
                    ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
                    codeTemplate = matchingLibrary.getCodeTemplates().iterator();
                    while (codeTemplate.hasNext()) {
                        CodeTemplate codeTemplate2 = (CodeTemplate)codeTemplate.next();
                        if (!codeTemplateIds.add(codeTemplate2.getId())) continue;
                        codeTemplates.add(codeTemplate2);
                    }
                    matchingLibrary.setCodeTemplates(codeTemplates);
                }
                matchingLibrary.getEnabledChannelIds().addAll(library.getEnabledChannelIds());
                matchingLibrary.getEnabledChannelIds().add(channel.getId());
                matchingLibrary.getDisabledChannelIds().addAll(library.getDisabledChannelIds());
                matchingLibrary.getDisabledChannelIds().removeAll(matchingLibrary.getEnabledChannelIds());
            }
            channel.getExportData().clearCodeTemplateLibraries();
        }
        ArrayList<CodeTemplateLibrary> codeTemplateLibraries = new ArrayList<CodeTemplateLibrary>(codeTemplateLibraryMap.values());
        this.parent.removeInvalidItems(codeTemplateLibraries, CodeTemplateLibrary.class);
        if (CollectionUtils.isNotEmpty(codeTemplateLibraries)) {
            CodeTemplateImportDialog dialog;
            boolean importLibraries;
            String importChannelCodeTemplateLibraries = this.userPreferences.get("importChannelCodeTemplateLibraries", null);
            if (importChannelCodeTemplateLibraries == null) {
                JCheckBox alwaysChooseCheckBox = new JCheckBox("Always choose this option by default in the future (may be changed in the Administrator settings)");
                Object[] params = new Object[]{"Group \"" + importGroup.getName() + "\" has code template libraries included with it. Would you like to import them?", alwaysChooseCheckBox};
                int result = JOptionPane.showConfirmDialog(this, params, "Select an Option", 1, 3);
                if (result != 0 && result != 1) return;
                boolean bl = importLibraries = result == 0;
                if (alwaysChooseCheckBox.isSelected()) {
                    this.userPreferences.putBoolean("importChannelCodeTemplateLibraries", importLibraries);
                }
            } else {
                importLibraries = Boolean.parseBoolean(importChannelCodeTemplateLibraries);
            }
            if (importLibraries && (dialog = new CodeTemplateImportDialog((java.awt.Frame)((Object)this.parent), codeTemplateLibraries, false, true)).wasSaved()) {
                CodeTemplateLibrarySaveResult updateSummary = this.parent.codeTemplatePanel.attemptUpdate(dialog.getUpdatedLibraries(), new HashMap<String, CodeTemplateLibrary>(), dialog.getUpdatedCodeTemplates(), new HashMap<String, CodeTemplate>(), true, null, null);
                if (updateSummary == null || updateSummary.isOverrideNeeded() || !updateSummary.isLibrariesSuccess()) {
                    return;
                }
                for (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult result : updateSummary.getCodeTemplateResults().values()) {
                    if (result.isSuccess()) continue;
                    return;
                }
                this.parent.codeTemplatePanel.doRefreshCodeTemplates();
            }
        }
        ArrayList<Channel> successfulChannels = new ArrayList<Channel>();
        for (Channel channel : importGroup.getChannels()) {
            Channel importChannel = this.importChannel(channel, false, false);
            if (importChannel == null) continue;
            successfulChannels.add(importChannel);
        }
        if (!StringUtils.equals((CharSequence)importGroup.getId(), (CharSequence)"Default Group")) {
            Object channels;
            String tempId;
            ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
            AbstractChannelTableNode importGroupNode = null;
            String groupName = importGroup.getName();
            try {
                tempId = this.parent.mirthClient.getGuid();
            }
            catch (ClientException e) {
                tempId = UUID.randomUUID().toString();
            }
            if (!this.checkGroupName(groupName)) {
                if (!this.parent.alertOption((Component)((Object)this.parent), "Would you like to overwrite the existing group?  Choose 'No' to create a new group.")) {
                    importGroup.setRevision(Integer.valueOf(0));
                    do {
                        if ((groupName = DisplayUtil.showInputDialog(this, "Please enter a new name for the group.", groupName)) != null) continue;
                        return;
                    } while (!this.checkGroupName(groupName));
                    importGroup.setId(tempId);
                    importGroup.setName(groupName);
                } else {
                    MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
                    Enumeration groupNodes = root.children();
                    while (groupNodes.hasMoreElements()) {
                        AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                        if (!StringUtils.equals((CharSequence)groupNode.getGroupStatus().getGroup().getName(), (CharSequence)groupName)) continue;
                        importGroupNode = groupNode;
                    }
                }
            } else {
                importGroup.setRevision(Integer.valueOf(0));
                if (!this.checkGroupId(importGroup.getId())) {
                    importGroup.setId(tempId);
                }
            }
            HashSet<ChannelGroup> channelGroups = new HashSet<ChannelGroup>();
            HashSet<String> removedChannelGroupIds = new HashSet<String>(this.groupStatuses.keySet());
            removedChannelGroupIds.remove("Default Group");
            MutableTreeTableNode root = (MutableTreeTableNode)this.channelTable.getTreeTableModel().getRoot();
            if (root == null) {
                return;
            }
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                ChannelGroup group = ((AbstractChannelTableNode)((Object)groupNodes.nextElement())).getGroupStatus().getGroup();
                if (StringUtils.equals((CharSequence)group.getId(), (CharSequence)"Default Group")) continue;
                if (importGroupNode != null && StringUtils.equals((CharSequence)group.getId(), (CharSequence)importGroupNode.getGroupStatus().getGroup().getId())) {
                    group = importGroup;
                    group.setRevision(importGroupNode.getGroupStatus().getGroup().getRevision());
                    HashSet<String> channelIds = new HashSet<String>();
                    for (Channel channel : group.getChannels()) {
                        channelIds.add(channel.getId());
                    }
                    for (Channel channel : successfulChannels) {
                        channelIds.add(channel.getId());
                    }
                    channels = new ArrayList();
                    for (String channelId : channelIds) {
                        channels.add(new Channel(channelId));
                    }
                    group.setChannels((List)channels);
                }
                channelGroups.add(group);
                removedChannelGroupIds.remove(group.getId());
            }
            if (importGroupNode == null) {
                ArrayList<Channel> channels2 = new ArrayList<Channel>();
                for (Channel channel : successfulChannels) {
                    channels2.add(new Channel(channel.getId()));
                }
                importGroup.setChannels(channels2);
                channelGroups.add(importGroup);
                removedChannelGroupIds.remove(importGroup.getId());
            }
            HashSet<String> channelIds = new HashSet<String>();
            for (Channel channel : importGroup.getChannels()) {
                channelIds.add(channel.getId());
            }
            for (ChannelGroup group : channelGroups) {
                if (group == importGroup) continue;
                channels = group.getChannels().iterator();
                while (channels.hasNext()) {
                    if (channelIds.add(((Channel)channels.next()).getId())) continue;
                    channels.remove();
                }
            }
            this.attemptUpdate(channelGroups, removedChannelGroupIds, false);
        }
        if (synchronous) {
            this.retrieveChannels();
            this.updateModel(this.getCurrentTableState());
            this.channelsGroupsLoaded = true;
            this.updateTasks();
            this.parent.setSaveEnabled(false);
            return;
        } else {
            this.doRefreshChannels();
        }
    }

    public void doImportChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        List<String> contentList = this.parent.browseForMultipleFileStrings("XML");
        if (contentList.size() == 1) {
            this.importChannel(contentList.get(0), true);
        } else {
            for (String content : contentList) {
                this.importChannel(content, false);
            }
        }
    }

    public void importChannel(String content, boolean showAlerts) {
        if (showAlerts && !this.parent.promptObjectMigration(content, "channel")) {
            return;
        }
        Channel importChannel = null;
        try {
            importChannel = (Channel)ObjectXMLSerializer.getInstance().deserialize(content, Channel.class);
        }
        catch (Exception e) {
            if (showAlerts) {
                this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, "Invalid channel file:\n" + e.getMessage());
            }
            return;
        }
        this.importChannel(importChannel, showAlerts);
    }

    public Channel importChannel(Channel importChannel, boolean showAlerts) {
        return this.importChannel(importChannel, showAlerts, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Channel importChannel(Channel importChannel, boolean showAlerts, boolean refreshStatuses) {
        boolean overwrite2 = false;
        Integer userId = null;
        Channel originalStateChannel = null;
        try {
            originalStateChannel = this.parent.mirthClient.getChannel(importChannel.getId(), false);
            userId = originalStateChannel != null ? originalStateChannel.getExportData().getMetadata().getUserId() : this.parent.mirthClient.getCurrentUser().getId();
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            String channelName = importChannel.getName();
            String tempId = this.parent.mirthClient.getGuid();
            if (!this.parent.checkChannelName(channelName, tempId)) {
                if (!this.parent.alertOption((Component)((Object)this.parent), "Would you like to overwrite the existing channel?  Choose 'No' to create a new channel.")) {
                    importChannel.setRevision(0);
                    do {
                        if ((channelName = DisplayUtil.showInputDialog(this, "Please enter a new name for the channel.", channelName)) != null) continue;
                        return null;
                    } while (!this.parent.checkChannelName(channelName, tempId));
                    importChannel.setName(channelName);
                    this.setIdAndUpdateLibraries(importChannel, tempId);
                } else {
                    overwrite2 = true;
                    for (ChannelStatus channelStatus : this.channelStatuses.values()) {
                        Channel channel = channelStatus.getChannel();
                        if (!channel.getName().equalsIgnoreCase(channelName)) continue;
                        importChannel.setRevision(channel.getRevision().intValue());
                        this.setIdAndUpdateLibraries(importChannel, channel.getId());
                    }
                }
            } else {
                importChannel.setRevision(0);
                if (!this.checkChannelId(importChannel.getId())) {
                    this.setIdAndUpdateLibraries(importChannel, tempId);
                }
            }
            this.channelStatuses.put(importChannel.getId(), new ChannelStatus(importChannel));
            List channelTags = importChannel.getExportData().getChannelTags();
            if (channelTags != null && !channelTags.isEmpty()) {
                this.updateChannelTags(channelTags, importChannel.getId());
            }
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
        if (!(importChannel instanceof InvalidChannel)) {
            this.parent.removeInvalidItems(importChannel.getExportData().getCodeTemplateLibraries(), CodeTemplateLibrary.class);
            if (!(importChannel instanceof InvalidChannel) && !importChannel.getExportData().getCodeTemplateLibraries().isEmpty()) {
                CodeTemplateImportDialog dialog;
                boolean importLibraries;
                String importChannelCodeTemplateLibraries = this.userPreferences.get("importChannelCodeTemplateLibraries", null);
                if (importChannelCodeTemplateLibraries == null) {
                    JCheckBox alwaysChooseCheckBox = new JCheckBox("Always choose this option by default in the future (may be changed in the Administrator settings)");
                    Object[] params = new Object[]{"Channel \"" + importChannel.getName() + "\" has code template libraries included with it. Would you like to import them?", alwaysChooseCheckBox};
                    int result = JOptionPane.showConfirmDialog(this, params, "Select an Option", 1, 3);
                    if (result != 0 && result != 1) return null;
                    boolean bl = importLibraries = result == 0;
                    if (alwaysChooseCheckBox.isSelected()) {
                        this.userPreferences.putBoolean("importChannelCodeTemplateLibraries", importLibraries);
                    }
                } else {
                    importLibraries = Boolean.parseBoolean(importChannelCodeTemplateLibraries);
                }
                if (importLibraries && (dialog = new CodeTemplateImportDialog((java.awt.Frame)((Object)this.parent), importChannel.getExportData().getCodeTemplateLibraries(), false, true)).wasSaved()) {
                    CodeTemplateLibrarySaveResult updateSummary = this.parent.codeTemplatePanel.attemptUpdate(dialog.getUpdatedLibraries(), new HashMap<String, CodeTemplateLibrary>(), dialog.getUpdatedCodeTemplates(), new HashMap<String, CodeTemplate>(), true, null, null);
                    if (updateSummary == null || updateSummary.isOverrideNeeded() || !updateSummary.isLibrariesSuccess()) {
                        return null;
                    }
                    for (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult result : updateSummary.getCodeTemplateResults().values()) {
                        if (result.isSuccess()) continue;
                        return null;
                    }
                    this.parent.codeTemplatePanel.doRefreshCodeTemplates();
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependentIds()) || CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependencyIds())) {
                HashSet<ChannelDependency> channelDependencies = new HashSet<ChannelDependency>(this.getCachedChannelDependencies());
                if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependentIds())) {
                    for (String dependentId : importChannel.getExportData().getDependentIds()) {
                        if (!StringUtils.isNotBlank((CharSequence)dependentId) || StringUtils.equals((CharSequence)dependentId, (CharSequence)importChannel.getId())) continue;
                        channelDependencies.add(new ChannelDependency(dependentId, importChannel.getId()));
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)importChannel.getExportData().getDependencyIds())) {
                    for (String dependencyId : importChannel.getExportData().getDependencyIds()) {
                        if (!StringUtils.isNotBlank((CharSequence)dependencyId) || StringUtils.equals((CharSequence)dependencyId, (CharSequence)importChannel.getId())) continue;
                        channelDependencies.add(new ChannelDependency(importChannel.getId(), dependencyId));
                    }
                }
                if (!channelDependencies.equals(this.getCachedChannelDependencies())) {
                    try {
                        this.parent.mirthClient.setChannelDependencies(channelDependencies);
                    }
                    catch (ClientException e) {
                        this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, "Unable to save channel dependencies.");
                    }
                }
            }
            importChannel.getExportData().clearCodeTemplateLibraries();
            importChannel.getExportData().clearDependencies();
            this.parent.updateResourceNames(importChannel);
        }
        if (overwrite2 || !showAlerts || importChannel instanceof InvalidChannel) {
            Throwable cause;
            try {
                this.parent.updateChannel(importChannel, overwrite2, userId, null);
                if (importChannel instanceof InvalidChannel && showAlerts) {
                    InvalidChannel invalidChannel = (InvalidChannel)importChannel;
                    cause = invalidChannel.getCause();
                    this.parent.alertThrowable((Component)((Object)this.parent), cause, "Channel \"" + importChannel.getName() + "\" is invalid. " + this.getMissingExtensions(invalidChannel) + " Original cause:\n" + cause.getMessage());
                }
            }
            catch (Exception e) {
                this.channelStatuses.remove(importChannel.getId());
                this.parent.alertThrowable((Component)((Object)this.parent), e);
                cause = null;
                return cause;
            }
            finally {
                if (refreshStatuses) {
                    this.doRefreshChannels();
                }
            }
        }
        if (!showAlerts) return importChannel;
        final Channel importChannelFinal = importChannel;
        final boolean overwriteFinal = overwrite2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ChannelPanel.this.parent.editChannel(importChannelFinal);
                    ChannelPanel.this.parent.setSaveEnabled(!overwriteFinal);
                }
                catch (Exception e) {
                    ChannelPanel.this.channelStatuses.remove(importChannelFinal.getId());
                    ChannelPanel.this.parent.alertError((Component)((Object)ChannelPanel.this.parent), "Channel had an unknown problem. Channel import aborted.");
                    ChannelPanel.this.parent.channelEditPanel = new ChannelSetup();
                    ChannelPanel.this.parent.doShowChannel();
                }
            }
        });
        return importChannel;
    }

    private void setIdAndUpdateLibraries(Channel channel, String newChannelId) {
        if (CollectionUtils.isNotEmpty((Collection)channel.getExportData().getCodeTemplateLibraries())) {
            for (CodeTemplateLibrary library : channel.getExportData().getCodeTemplateLibraries()) {
                library.getEnabledChannelIds().remove(channel.getId());
                library.getEnabledChannelIds().add(newChannelId);
            }
        }
        channel.setId(newChannelId);
    }

    public void doExportAllChannels() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        if (!this.channelStatuses.isEmpty()) {
            ArrayList<Channel> selectedChannels = new ArrayList<Channel>();
            for (ChannelStatus channelStatus : this.channelStatuses.values()) {
                selectedChannels.add(channelStatus.getChannel());
            }
            this.exportChannels(selectedChannels);
        }
    }

    public boolean doExportChannel() {
        Channel channel;
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return false;
        }
        if (this.isGroupSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on channels.");
            return false;
        }
        if (this.parent.changesHaveBeenMade()) {
            if (this.parent.alertOption(this, "This channel has been modified. You must save the channel changes before you can export. Would you like to save them now?")) {
                if (!this.parent.channelEditPanel.saveChanges()) {
                    return false;
                }
            } else {
                return false;
            }
            this.parent.setSaveEnabled(false);
        }
        if (this.parent.currentContentPage == this.parent.channelEditPanel || this.parent.currentContentPage == this.parent.channelEditPanel.filterPane || this.parent.currentContentPage == this.parent.channelEditPanel.transformerPane) {
            channel = this.parent.channelEditPanel.currentChannel;
        } else {
            List<Channel> selectedChannels = this.getSelectedChannels();
            if (selectedChannels.size() > 1) {
                this.exportChannels(selectedChannels);
                return true;
            }
            channel = selectedChannels.get(0);
        }
        if (this.channelHasLinkedCodeTemplates(channel)) {
            boolean addLibraries = true;
            String exportChannelCodeTemplateLibraries = this.userPreferences.get("exportChannelCodeTemplateLibraries", null);
            if (exportChannelCodeTemplateLibraries == null) {
                ExportChannelLibrariesDialog dialog = new ExportChannelLibrariesDialog(channel);
                if (dialog.getResult() == 1) {
                    addLibraries = false;
                } else if (dialog.getResult() != 0) {
                    return false;
                }
            } else {
                addLibraries = Boolean.parseBoolean(exportChannelCodeTemplateLibraries);
            }
            if (addLibraries) {
                this.addCodeTemplateLibrariesToChannel(channel);
            }
        }
        this.addDependenciesToChannel(channel);
        this.addTagsToChannel(channel);
        this.parent.updateResourceNames(channel);
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String channelXML = serializer.serialize((Object)channel);
        channel.getExportData().clearAllExceptMetadata();
        return this.parent.exportFile(channelXML, channel.getName(), "XML", "Channel");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportChannels(List<Channel> channelList) {
        if (this.channelHasLinkedCodeTemplates(channelList)) {
            boolean addLibraries;
            String exportChannelCodeTemplateLibraries = this.userPreferences.get("exportChannelCodeTemplateLibraries", null);
            if (exportChannelCodeTemplateLibraries == null) {
                JCheckBox alwaysChooseCheckBox = new JCheckBox("Always choose this option by default in the future (may be changed in the Administrator settings)");
                Object[] params = new Object[]{"<html>One or more channels has code template libraries linked to them.<br/>Do you wish to include these libraries in each respective channel export?</html>", alwaysChooseCheckBox};
                int result = JOptionPane.showConfirmDialog(this, params, "Select an Option", 1, 3);
                if (result != 0 && result != 1) return;
                boolean bl = addLibraries = result == 0;
                if (alwaysChooseCheckBox.isSelected()) {
                    this.userPreferences.putBoolean("exportChannelCodeTemplateLibraries", addLibraries);
                }
            } else {
                addLibraries = Boolean.parseBoolean(exportChannelCodeTemplateLibraries);
            }
            if (addLibraries) {
                for (Channel channel : channelList) {
                    this.addCodeTemplateLibrariesToChannel(channel);
                }
            }
        }
        for (Channel channel : channelList) {
            this.addDependenciesToChannel(channel);
            this.addTagsToChannel(channel);
        }
        JFileChooser exportFileChooser = new JFileChooser();
        exportFileChooser.setFileSelectionMode(1);
        File currentDir = new File(Frame.userPreferences.get("currentDirectory", ""));
        if (currentDir.exists()) {
            exportFileChooser.setCurrentDirectory(currentDir);
        }
        int returnVal = exportFileChooser.showSaveDialog(this);
        File exportFile = null;
        File exportDirectory = null;
        String exportPath = "/";
        if (returnVal == 0) {
            Frame.userPreferences.put("currentDirectory", exportFileChooser.getCurrentDirectory().getPath());
            int exportCollisionCount = 0;
            exportDirectory = exportFileChooser.getSelectedFile();
            exportPath = exportDirectory.getAbsolutePath();
            for (Channel channel : channelList) {
                exportFile = new File(exportPath + "/" + channel.getName() + ".xml");
                if (exportFile.exists()) {
                    ++exportCollisionCount;
                }
                this.parent.updateResourceNames(channel);
            }
            try {
                int exportCount = 0;
                boolean overwriteAll = false;
                boolean skipAll = false;
                int size = channelList.size();
                for (int i = 0; i < size; ++i) {
                    Channel channel = channelList.get(i);
                    exportFile = new File(exportPath + "/" + channel.getName() + ".xml");
                    boolean fileExists = exportFile.exists();
                    if (fileExists) {
                        if (!overwriteAll && !skipAll) {
                            if (exportCollisionCount == 1) {
                                if (!this.parent.alertOption((Component)((Object)this.parent), "The file " + channel.getName() + ".xml already exists.  Would you like to overwrite it?")) {
                                    continue;
                                }
                            } else {
                                Frame.ConflictOption conflictStatus = this.parent.alertConflict((Component)((Object)this.parent), "<html>The file " + channel.getName() + ".xml already exists.<br>Would you like to overwrite it?</html>", exportCollisionCount);
                                if (conflictStatus == Frame.ConflictOption.YES_APPLY_ALL) {
                                    overwriteAll = true;
                                } else {
                                    if (conflictStatus == Frame.ConflictOption.NO) {
                                        --exportCollisionCount;
                                        continue;
                                    }
                                    if (conflictStatus == Frame.ConflictOption.NO_APPLY_ALL) {
                                        skipAll = true;
                                        continue;
                                    }
                                }
                            }
                        }
                        --exportCollisionCount;
                    }
                    if (fileExists && skipAll) continue;
                    String channelXML = ObjectXMLSerializer.getInstance().serialize((Object)channel);
                    FileUtils.writeStringToFile((File)exportFile, (String)channelXML, (String)"UTF-8");
                    ++exportCount;
                }
                if (exportCount > 0) {
                    this.parent.alertInformation((Component)((Object)this.parent), exportCount + " files were written successfully to " + exportPath + ".");
                }
            }
            catch (IOException ex) {
                this.parent.alertError((Component)((Object)this.parent), "File could not be written.");
            }
        }
        for (Channel channel : channelList) {
            channel.getExportData().clearAllExceptMetadata();
        }
    }

    private boolean channelHasLinkedCodeTemplates(Channel channel) {
        return this.channelHasLinkedCodeTemplates(Collections.singletonList(channel));
    }

    private boolean channelHasLinkedCodeTemplates(List<Channel> channels) {
        for (Channel channel : channels) {
            for (CodeTemplateLibrary library : this.parent.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
                if (!library.getEnabledChannelIds().contains(channel.getId()) && (!library.isIncludeNewChannels() || library.getDisabledChannelIds().contains(channel.getId()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupHasLinkedCodeTemplates(List<ChannelGroup> groups) {
        for (ChannelGroup group : groups) {
            if (!this.channelHasLinkedCodeTemplates(group.getChannels())) continue;
            return true;
        }
        return false;
    }

    private void addCodeTemplateLibrariesToChannel(Channel channel) {
        ArrayList<CodeTemplateLibrary> channelLibraries = new ArrayList<CodeTemplateLibrary>();
        for (CodeTemplateLibrary library : this.parent.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
            if (!library.getEnabledChannelIds().contains(channel.getId()) && (!library.isIncludeNewChannels() || library.getDisabledChannelIds().contains(channel.getId()))) continue;
            library = new CodeTemplateLibrary(library);
            ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                codeTemplate = this.parent.codeTemplatePanel.getCachedCodeTemplates().get(codeTemplate.getId());
                if (codeTemplate == null) continue;
                codeTemplates.add(codeTemplate);
            }
            library.setCodeTemplates(codeTemplates);
            channelLibraries.add(library);
        }
        channel.getExportData().setCodeTemplateLibraries(channelLibraries);
    }

    private void addDependenciesToChannel(Channel channel) {
        HashSet<String> dependentIds = new HashSet<String>();
        HashSet<String> dependencyIds = new HashSet<String>();
        for (ChannelDependency channelDependency : this.getCachedChannelDependencies()) {
            if (StringUtils.equals((CharSequence)channelDependency.getDependencyId(), (CharSequence)channel.getId())) {
                dependentIds.add(channelDependency.getDependentId());
                continue;
            }
            if (!StringUtils.equals((CharSequence)channelDependency.getDependentId(), (CharSequence)channel.getId())) continue;
            dependencyIds.add(channelDependency.getDependencyId());
        }
        if (CollectionUtils.isNotEmpty(dependentIds)) {
            channel.getExportData().setDependentIds(dependentIds);
        }
        if (CollectionUtils.isNotEmpty(dependencyIds)) {
            channel.getExportData().setDependencyIds(dependencyIds);
        }
    }

    private void addTagsToChannel(Channel channel) {
        ArrayList<ChannelTag> channelTags = new ArrayList<ChannelTag>();
        for (ChannelTag channelTag : this.getCachedChannelTags()) {
            if (!channelTag.getChannelIds().contains(channel.getId())) continue;
            channelTags.add(channelTag);
        }
        if (CollectionUtils.isNotEmpty(channelTags)) {
            channel.getExportData().setChannelTags(channelTags);
        }
    }

    public boolean doExportAllGroups() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return false;
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        if (!model.isGroupModeEnabled()) {
            return false;
        }
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (root == null) {
            return false;
        }
        ArrayList<ChannelGroup> groups = new ArrayList<ChannelGroup>();
        Enumeration groupNodes = root.children();
        while (groupNodes.hasMoreElements()) {
            AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
            if (!groupNode.isGroupNode()) continue;
            groups.add(new ChannelGroup(groupNode.getGroupStatus().getGroup()));
        }
        return this.handleExportGroups(groups);
    }

    public boolean doExportGroup() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return false;
        }
        if (this.isChannelSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on groups.");
            return false;
        }
        int[] rows = this.channelTable.getSelectedModelRows();
        if (rows.length > 0) {
            ArrayList<ChannelGroup> groups = new ArrayList<ChannelGroup>();
            for (int row : rows) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
                if (!groupNode.isGroupNode()) continue;
                groups.add(new ChannelGroup(groupNode.getGroupStatus().getGroup()));
            }
            return this.handleExportGroups(groups);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleExportGroups(List<ChannelGroup> groups) {
        for (ChannelGroup group : groups) {
            ArrayList<Channel> channels = new ArrayList<Channel>();
            for (Channel channel : group.getChannels()) {
                ChannelStatus channelStatus = this.channelStatuses.get(channel.getId());
                if (channelStatus == null) continue;
                channels.add(channelStatus.getChannel());
            }
            group.setChannels(channels);
        }
        try {
            if (this.groupHasLinkedCodeTemplates(groups)) {
                boolean addLibraries;
                String exportChannelCodeTemplateLibraries = this.userPreferences.get("exportChannelCodeTemplateLibraries", null);
                if (exportChannelCodeTemplateLibraries == null) {
                    JCheckBox alwaysChooseCheckBox = new JCheckBox("Always choose this option by default in the future (may be changed in the Administrator settings)");
                    Object[] params = new Object[]{"<html>One or more channels has code template libraries linked to them.<br/>Do you wish to include these libraries in each respective channel export?</html>", alwaysChooseCheckBox};
                    int result = JOptionPane.showConfirmDialog(this, params, "Select an Option", 1, 3);
                    if (result != 0 && result != 1) {
                        boolean channelStatus = false;
                        return channelStatus;
                    }
                    boolean bl = addLibraries = result == 0;
                    if (alwaysChooseCheckBox.isSelected()) {
                        this.userPreferences.putBoolean("exportChannelCodeTemplateLibraries", addLibraries);
                    }
                } else {
                    addLibraries = Boolean.parseBoolean(exportChannelCodeTemplateLibraries);
                }
                if (addLibraries) {
                    for (ChannelGroup group : groups) {
                        for (Channel channel : group.getChannels()) {
                            this.addCodeTemplateLibrariesToChannel(channel);
                        }
                    }
                }
            }
            for (ChannelGroup group : groups) {
                for (Channel channel : group.getChannels()) {
                    this.addDependenciesToChannel(channel);
                    this.addTagsToChannel(channel);
                    this.parent.updateResourceNames(channel);
                }
            }
            if (groups.size() == 1) {
                boolean bl = this.exportGroup(groups.iterator().next());
                return bl;
            }
            boolean bl = this.exportGroups(groups);
            return bl;
        }
        finally {
            Iterator<ChannelGroup> iterator = groups.iterator();
            block11: while (true) {
                if (!iterator.hasNext()) {
                }
                ChannelGroup group = iterator.next();
                Iterator iterator2 = group.getChannels().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block11;
                    Channel channel = (Channel)iterator2.next();
                    channel.getExportData().clearAllExceptMetadata();
                }
                break;
            }
        }
    }

    private boolean exportGroup(ChannelGroup group) {
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        String groupXML = serializer.serialize((Object)group);
        return this.parent.exportFile(groupXML, group.getName().replaceAll("[^a-zA-Z_0-9\\-\\s]", ""), "XML", "Channel group");
    }

    private boolean exportGroups(List<ChannelGroup> groups) {
        JFileChooser exportFileChooser = new JFileChooser();
        exportFileChooser.setFileSelectionMode(1);
        File currentDir = new File(Frame.userPreferences.get("currentDirectory", ""));
        if (currentDir.exists()) {
            exportFileChooser.setCurrentDirectory(currentDir);
        }
        int returnVal = exportFileChooser.showSaveDialog(this);
        File exportFile = null;
        File exportDirectory = null;
        String exportPath = "/";
        if (returnVal == 0) {
            Frame.userPreferences.put("currentDirectory", exportFileChooser.getCurrentDirectory().getPath());
            int exportCollisionCount = 0;
            exportDirectory = exportFileChooser.getSelectedFile();
            exportPath = exportDirectory.getAbsolutePath();
            for (ChannelGroup group : groups) {
                exportFile = new File(exportPath + "/" + group.getName().replaceAll("[^a-zA-Z_0-9\\-\\s]", "") + ".xml");
                if (!exportFile.exists()) continue;
                ++exportCollisionCount;
            }
            try {
                int exportCount = 0;
                boolean overwriteAll = false;
                boolean skipAll = false;
                int size = groups.size();
                for (int i = 0; i < size; ++i) {
                    ChannelGroup group = groups.get(i);
                    String groupName = group.getName().replaceAll("[^a-zA-Z_0-9\\-\\s]", "");
                    exportFile = new File(exportPath + "/" + groupName + ".xml");
                    boolean fileExists = exportFile.exists();
                    if (fileExists) {
                        if (!overwriteAll && !skipAll) {
                            if (exportCollisionCount == 1) {
                                if (!this.parent.alertOption((Component)((Object)this.parent), "The file " + groupName + ".xml already exists.  Would you like to overwrite it?")) {
                                    continue;
                                }
                            } else {
                                Frame.ConflictOption conflictStatus = this.parent.alertConflict((Component)((Object)this.parent), "<html>The file " + groupName + ".xml already exists.<br>Would you like to overwrite it?</html>", exportCollisionCount);
                                if (conflictStatus == Frame.ConflictOption.YES_APPLY_ALL) {
                                    overwriteAll = true;
                                } else {
                                    if (conflictStatus == Frame.ConflictOption.NO) {
                                        --exportCollisionCount;
                                        continue;
                                    }
                                    if (conflictStatus == Frame.ConflictOption.NO_APPLY_ALL) {
                                        skipAll = true;
                                        continue;
                                    }
                                }
                            }
                        }
                        --exportCollisionCount;
                    }
                    if (fileExists && skipAll) continue;
                    String groupXML = ObjectXMLSerializer.getInstance().serialize((Object)group);
                    FileUtils.writeStringToFile((File)exportFile, (String)groupXML, (String)"UTF-8");
                    ++exportCount;
                }
                if (exportCount > 0) {
                    this.parent.alertInformation((Component)((Object)this.parent), exportCount + " files were written successfully to " + exportPath + ".");
                    return true;
                }
            }
            catch (IOException ex) {
                this.parent.alertError((Component)((Object)this.parent), "File could not be written.");
            }
        }
        return false;
    }

    public void doDeleteGroup() {
        if (this.isChannelSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on groups.");
            return;
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        int[] rows = this.channelTable.getSelectedModelRows();
        if (rows.length >= 0) {
            ArrayList<AbstractChannelTableNode> groupNodes = new ArrayList<AbstractChannelTableNode>();
            for (int row : rows) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
                if (!groupNode.isGroupNode() || StringUtils.equals((CharSequence)groupNode.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group")) continue;
                groupNodes.add(groupNode);
            }
            Object object = groupNodes.iterator();
            while (object.hasNext()) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)object.next());
                HashSet<String> channelIds = new HashSet<String>();
                Enumeration channelNodes = groupNode.children();
                while (channelNodes.hasMoreElements()) {
                    channelIds.add(((AbstractChannelTableNode)((Object)channelNodes.nextElement())).getChannelStatus().getChannel().getId());
                }
                for (String channelId : channelIds) {
                    model.removeChannelFromGroup(groupNode, channelId);
                }
                model.removeGroup(groupNode);
            }
            this.parent.setSaveEnabled(true);
        }
    }

    public void doDeleteChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        if (this.isGroupSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on channels.");
            return;
        }
        final List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() == 0) {
            return;
        }
        if (!this.parent.alertOption((Component)((Object)this.parent), "Are you sure you want to delete the selected channel(s)?\nAny selected deployed channel(s) will first be undeployed.")) {
            return;
        }
        final String workingId = this.parent.startWorking("Deleting channel...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> channelIds = new HashSet<String>(selectedChannels.size());
                for (Channel channel : selectedChannels) {
                    channelIds.add(channel.getId());
                }
                try {
                    ChannelPanel.this.parent.mirthClient.removeChannels(channelIds);
                }
                catch (ClientException e) {
                    SwingUtilities.invokeLater(() -> ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), e));
                }
                return null;
            }

            @Override
            public void done() {
                ChannelPanel.this.doRefreshChannels();
                ChannelPanel.this.parent.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doCloneChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        if (this.isGroupSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on channels.");
            return;
        }
        List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() > 1) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on a single channel.");
            return;
        }
        Channel channel = selectedChannels.get(0);
        if (channel instanceof InvalidChannel) {
            InvalidChannel invalidChannel = (InvalidChannel)channel;
            Throwable cause = invalidChannel.getCause();
            this.parent.alertThrowable((Component)((Object)this.parent), cause, "Channel \"" + channel.getName() + "\" is invalid and cannot be cloned. " + this.getMissingExtensions(invalidChannel) + "Original cause:\n" + cause.getMessage());
            return;
        }
        try {
            channel = (Channel)SerializationUtils.clone((Serializable)channel);
        }
        catch (SerializationException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
            return;
        }
        ArrayList<ChannelTag> channelTags = new ArrayList<ChannelTag>();
        for (ChannelTag tag : this.getCachedChannelTags()) {
            if (!tag.getChannelIds().contains(channel.getId())) continue;
            channelTags.add(tag);
        }
        try {
            channel.setRevision(0);
            channel.setId(this.parent.mirthClient.getGuid());
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
        String channelName = channel.getName();
        do {
            if ((channelName = DisplayUtil.showInputDialog(this, "Please enter a new name for the channel.", channelName)) != null) continue;
            return;
        } while (!this.parent.checkChannelName(channelName, channel.getId()));
        channel.setName(channelName);
        this.channelStatuses.put(channel.getId(), new ChannelStatus(channel));
        for (ChannelTag tag : channelTags) {
            tag.getChannelIds().add(channel.getId());
        }
        this.parent.editChannel(channel);
        this.parent.setSaveEnabled(true);
    }

    public void doEditChannel() {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        if (this.parent.isEditingChannel) {
            return;
        }
        this.parent.isEditingChannel = true;
        if (this.isGroupSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on channels.");
            return;
        }
        List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() > 1) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "This operation can only be performed on a single channel.");
        } else if (selectedChannels.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "Channel no longer exists.");
        } else {
            try {
                Channel channel = selectedChannels.get(0);
                if (channel instanceof InvalidChannel) {
                    InvalidChannel invalidChannel = (InvalidChannel)channel;
                    Throwable cause = invalidChannel.getCause();
                    this.parent.alertThrowable((Component)((Object)this.parent), cause, "Channel \"" + channel.getName() + "\" is invalid and cannot be edited. " + this.getMissingExtensions(invalidChannel) + "Original cause:\n" + cause.getMessage());
                } else {
                    this.parent.editChannel((Channel)SerializationUtils.clone((Serializable)channel));
                }
            }
            catch (SerializationException e) {
                this.parent.alertThrowable((Component)((Object)this.parent), e);
            }
        }
        this.parent.isEditingChannel = false;
    }

    public void doEnableChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        final List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() == 0) {
            this.parent.alertWarning((Component)((Object)this.parent), "Channel no longer exists.");
            return;
        }
        final HashSet<String> channelIds = new HashSet<String>();
        HashSet<Channel> failedChannels = new HashSet<Channel>();
        String firstValidationMessage = null;
        Iterator<Channel> it = selectedChannels.iterator();
        while (it.hasNext()) {
            Channel channel = it.next();
            String validationMessage = null;
            if (channel instanceof InvalidChannel) {
                failedChannels.add(channel);
                it.remove();
                continue;
            }
            validationMessage = this.parent.channelEditPanel.checkAllForms(channel);
            if (validationMessage != null) {
                if (firstValidationMessage == null) {
                    firstValidationMessage = validationMessage;
                }
                failedChannels.add(channel);
                it.remove();
                continue;
            }
            channelIds.add(channel.getId());
        }
        if (!channelIds.isEmpty()) {
            final String workingId = this.parent.startWorking("Enabling channel...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    for (Channel channel : selectedChannels) {
                        channel.getExportData().getMetadata().setEnabled(true);
                    }
                    try {
                        ChannelPanel.this.parent.mirthClient.setChannelEnabled(channelIds, true);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), e));
                    }
                    return null;
                }

                @Override
                public void done() {
                    ChannelPanel.this.doRefreshChannels();
                    ChannelPanel.this.parent.stopWorking(workingId);
                }
            };
            worker.execute();
        }
        if (!failedChannels.isEmpty()) {
            if (failedChannels.size() == 1) {
                Channel channel = (Channel)failedChannels.iterator().next();
                if (channel instanceof InvalidChannel) {
                    InvalidChannel invalidChannel = (InvalidChannel)channel;
                    Throwable cause = invalidChannel.getCause();
                    this.parent.alertThrowable((Component)((Object)this.parent), cause, "Channel \"" + invalidChannel.getName() + "\" is invalid and cannot be enabled. " + this.getMissingExtensions(invalidChannel) + "Original cause:\n" + cause.getMessage());
                } else {
                    this.parent.alertCustomError((Component)((Object)this.parent), firstValidationMessage, "The channel was not configured properly.  Please fix the following problem(s) in the channel before trying to enable it again:");
                }
            } else {
                Object message = "The following channels are invalid or not configured properly:\n\n";
                for (Channel channel : failedChannels) {
                    message = (String)message + "    " + channel.getName() + " (" + channel.getId() + ")\n";
                }
                this.parent.alertError((Component)((Object)this.parent), (String)message);
            }
        }
    }

    public void doDisableChannel() {
        if (this.isSaveEnabled() && !this.promptSave(true)) {
            return;
        }
        final List<Channel> selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() == 0) {
            this.parent.alertWarning((Component)((Object)this.parent), "Channel no longer exists.");
            return;
        }
        final String workingId = this.parent.startWorking("Disabling channels...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                HashSet<String> channelIds = new HashSet<String>();
                for (Channel channel : selectedChannels) {
                    if (channel instanceof InvalidChannel) continue;
                    channel.getExportData().getMetadata().setEnabled(false);
                    channelIds.add(channel.getId());
                }
                if (CollectionUtils.isNotEmpty(channelIds)) {
                    try {
                        ChannelPanel.this.parent.mirthClient.setChannelEnabled(channelIds, false);
                    }
                    catch (ClientException e) {
                        SwingUtilities.invokeLater(() -> ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), e));
                    }
                }
                return null;
            }

            @Override
            public void done() {
                ChannelPanel.this.doRefreshChannels();
                ChannelPanel.this.parent.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    public void doViewMessages() {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        this.parent.doShowMessages();
    }

    public static int getNumberOfDefaultColumns() {
        return DEFAULT_COLUMNS.length;
    }

    private void setChannelTaskVisible(int task) {
        this.setChannelTaskVisibility(task, true);
    }

    private void setChannelTaskVisibility(int task, boolean visible) {
        this.parent.setVisibleTasks(this.channelTasks, this.channelPopupMenu, task, task, visible);
    }

    private void setGroupTaskVisible(int task) {
        this.setGroupTaskVisibility(task, true);
    }

    private void setGroupTaskVisibility(int task, boolean visible) {
        this.parent.setVisibleTasks(this.groupTasks, this.groupPopupMenu, task, task, visible);
    }

    private void setAllTaskVisibility(boolean visible) {
        this.parent.setVisibleTasks(this.channelTasks, this.channelPopupMenu, 1, 15, visible);
        this.parent.setVisibleTasks(this.groupTasks, this.groupPopupMenu, 1, 7, visible);
    }

    public void updateChannelStatuses(List<ChannelSummary> changedChannels) {
        for (ChannelSummary channelSummary : changedChannels) {
            String channelId = channelSummary.getChannelId();
            if (channelSummary.isDeleted()) {
                this.channelStatuses.remove(channelId);
                continue;
            }
            ChannelStatus channelStatus = this.channelStatuses.get(channelId);
            if (channelStatus == null) {
                channelStatus = new ChannelStatus();
                this.channelStatuses.put(channelId, channelStatus);
            }
            if (channelSummary.getChannelStatus().getChannel() != null) {
                channelStatus.setChannel(channelSummary.getChannelStatus().getChannel());
            }
            if (channelSummary.isUndeployed()) {
                channelStatus.setDeployedDate(null);
                channelStatus.setDeployedRevisionDelta(null);
                channelStatus.setCodeTemplatesChanged(false);
            } else {
                if (channelSummary.getChannelStatus().getDeployedDate() != null) {
                    channelStatus.setDeployedDate(channelSummary.getChannelStatus().getDeployedDate());
                    channelStatus.setDeployedRevisionDelta(channelSummary.getChannelStatus().getDeployedRevisionDelta());
                }
                channelStatus.setCodeTemplatesChanged(channelSummary.getChannelStatus().isCodeTemplatesChanged());
            }
            channelStatus.setLocalChannelId(channelSummary.getChannelStatus().getLocalChannelId());
        }
    }

    public void updateDefaultChannelGroup(List<DashboardStatus> statuses) {
        if (statuses != null && this.groupStatuses != null) {
            HashMap<String, DashboardStatus> dashboardStatusMap = new HashMap<String, DashboardStatus>();
            for (DashboardStatus status : statuses) {
                dashboardStatusMap.put(status.getChannelId(), status);
            }
            for (ChannelGroupStatus groupStatus : this.groupStatuses.values()) {
                if (StringUtils.equals((CharSequence)groupStatus.getGroup().getId(), (CharSequence)"Default Group")) continue;
                for (Channel channel : groupStatus.getGroup().getChannels()) {
                    dashboardStatusMap.remove(channel.getId());
                }
            }
            ChannelGroup defaultGroup = ChannelGroup.getDefaultGroup();
            ArrayList<ChannelStatus> defaultGroupChannelStatuses = new ArrayList<ChannelStatus>();
            ChannelGroupStatus defaultGroupStatus = new ChannelGroupStatus(defaultGroup, defaultGroupChannelStatuses);
            for (DashboardStatus status : dashboardStatusMap.values()) {
                defaultGroup.getChannels().add(new Channel(status.getChannelId()));
                ChannelStatus channelStatus = this.channelStatuses.get(status.getChannelId());
                if (channelStatus == null) continue;
                defaultGroupChannelStatuses.add(channelStatus);
            }
            this.groupStatuses.put(defaultGroup.getId(), defaultGroupStatus);
        }
    }

    private void updateChannelGroups(List<ChannelGroup> channelGroups) {
        if (channelGroups == null) {
            channelGroups = new ArrayList<ChannelGroup>();
        }
        this.groupStatuses.clear();
        ChannelGroup defaultGroup = ChannelGroup.getDefaultGroup();
        ArrayList<ChannelStatus> defaultGroupChannelStatuses = new ArrayList<ChannelStatus>();
        ChannelGroupStatus defaultGroupStatus = new ChannelGroupStatus(defaultGroup, defaultGroupChannelStatuses);
        this.groupStatuses.put(defaultGroup.getId(), defaultGroupStatus);
        HashSet<String> visitedChannelIds = new HashSet<String>();
        HashSet<String> remainingChannelIds = new HashSet<String>(this.channelStatuses.keySet());
        for (ChannelGroup group : channelGroups) {
            ArrayList<ChannelStatus> channelStatuses = new ArrayList<ChannelStatus>();
            for (Channel channel : group.getChannels()) {
                if (visitedChannelIds.contains(channel.getId())) continue;
                ChannelStatus channelStatus = this.channelStatuses.get(channel.getId());
                if (channelStatus != null) {
                    channelStatuses.add(channelStatus);
                }
                visitedChannelIds.add(channel.getId());
                remainingChannelIds.remove(channel.getId());
            }
            this.groupStatuses.put(group.getId(), new ChannelGroupStatus(group, channelStatuses));
        }
        for (String channelId : remainingChannelIds) {
            defaultGroup.getChannels().add(new Channel(channelId));
            defaultGroupChannelStatuses.add(this.channelStatuses.get(channelId));
        }
    }

    private void updateChannelMetadata(Map<String, ChannelMetadata> metadataMap) {
        if (metadataMap != null) {
            for (ChannelStatus status : this.channelStatuses.values()) {
                Channel channel = status.getChannel();
                channel.getExportData().setMetadata(metadataMap.get(channel.getId()));
                if (!(channel instanceof InvalidChannel)) continue;
                channel.getExportData().getMetadata().setEnabled(false);
            }
        }
    }

    public void clearChannelCache() {
        this.channelStatuses = new LinkedHashMap<String, ChannelStatus>();
        this.groupStatuses = new LinkedHashMap<String, ChannelGroupStatus>();
    }

    private String getMissingExtensions(InvalidChannel channel) {
        HashSet<String> missingConnectors = new HashSet<String>();
        HashSet<String> missingDataTypes = new HashSet<String>();
        try {
            DonkeyElement channelElement = new DonkeyElement(channel.getChannelXml());
            this.checkConnectorForMissingExtensions(channelElement.getChildElement("sourceConnector"), true, missingConnectors, missingDataTypes);
            DonkeyElement destinationConnectors = channelElement.getChildElement("destinationConnectors");
            if (destinationConnectors != null) {
                for (DonkeyElement destinationConnector : destinationConnectors.getChildElements()) {
                    this.checkConnectorForMissingExtensions(destinationConnector, false, missingConnectors, missingDataTypes);
                }
            }
        }
        catch (DonkeyElement.DonkeyElementException channelElement) {
            // empty catch block
        }
        StringBuilder builder = new StringBuilder();
        if (!missingConnectors.isEmpty()) {
            builder.append("\n\nYour BridgeLink installation is missing required connectors for this channel:\n     ");
            builder.append(StringUtils.join((Object[])missingConnectors.toArray(), (String)"\n     "));
            builder.append("\n\n");
        }
        if (!missingDataTypes.isEmpty()) {
            if (missingConnectors.isEmpty()) {
                builder.append("\n\n");
            }
            builder.append("Your BridgeLink installation is missing required data types for this channel:\n     ");
            builder.append(StringUtils.join((Object[])missingDataTypes.toArray(), (String)"\n     "));
            builder.append("\n\n");
        }
        return builder.toString();
    }

    private void checkConnectorForMissingExtensions(DonkeyElement connector, boolean source, Set<String> missingConnectors, Set<String> missingDataTypes) {
        if (connector != null) {
            DonkeyElement transportName = connector.getChildElement("transportName");
            transportName.setTextContent(ImportConverter3_0_0.convertTransportName((String)transportName.getTextContent()));
            if (transportName != null) {
                if (source && !LoadedExtensions.getInstance().getSourceConnectors().containsKey(transportName.getTextContent())) {
                    missingConnectors.add(transportName.getTextContent());
                } else if (!source && !LoadedExtensions.getInstance().getDestinationConnectors().containsKey(transportName.getTextContent())) {
                    missingConnectors.add(transportName.getTextContent());
                }
            }
            this.checkTransformerForMissingExtensions(connector.getChildElement("transformer"), missingDataTypes);
            if (!source) {
                this.checkTransformerForMissingExtensions(connector.getChildElement("responseTransformer"), missingDataTypes);
            }
        }
    }

    private void checkTransformerForMissingExtensions(DonkeyElement transformer, Set<String> missingDataTypes) {
        if (transformer != null) {
            DonkeyElement outboundDataType;
            missingDataTypes.addAll(ImportConverter3_0_0.getMissingDataTypes((DonkeyElement)transformer, LoadedExtensions.getInstance().getDataTypePlugins().keySet()));
            DonkeyElement inboundDataType = transformer.getChildElement("inboundDataType");
            if (inboundDataType != null && !LoadedExtensions.getInstance().getDataTypePlugins().containsKey(inboundDataType.getTextContent())) {
                missingDataTypes.add(inboundDataType.getTextContent());
            }
            if ((outboundDataType = transformer.getChildElement("outboundDataType")) != null && !LoadedExtensions.getInstance().getDataTypePlugins().containsKey(outboundDataType.getTextContent())) {
                missingDataTypes.add(outboundDataType.getTextContent());
            }
        }
    }

    public void initPanelPlugins() {
        this.loadPanelPlugins();
        this.switchBottomPane();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                int index = sourceTabbedPane.getSelectedIndex();
                ChannelPanel.this.loadPanelPlugin(sourceTabbedPane.getTitleAt(index));
            }
        };
        this.tabPane.addChangeListener(changeListener);
    }

    private void switchBottomPane() {
        if (LoadedExtensions.getInstance().getChannelPanelPlugins().size() > 0) {
            this.splitPane.setBottomComponent(this.tabPane);
            this.splitPane.setDividerSize(6);
            this.splitPane.setDividerLocation(3 * this.userPreferences.getInt("height", 650) / 5);
            this.splitPane.setResizeWeight(0.5);
        } else {
            this.splitPane.setBottomComponent(null);
            this.splitPane.setDividerSize(0);
        }
    }

    private void loadPanelPlugins() {
        if (LoadedExtensions.getInstance().getChannelPanelPlugins().size() > 0) {
            for (ChannelPanelPlugin plugin : LoadedExtensions.getInstance().getChannelPanelPlugins().values()) {
                if (plugin.getComponent() == null) continue;
                this.tabPane.addTab(plugin.getPluginPointName(), plugin.getComponent());
            }
        }
    }

    private void loadPanelPlugin(String pluginName) {
        final ChannelPanelPlugin plugin = LoadedExtensions.getInstance().getChannelPanelPlugins().get(pluginName);
        if (plugin != null) {
            final List<Channel> selectedChannels = this.getSelectedChannels();
            QueuingSwingWorkerTask<Void, Void> task = new QueuingSwingWorkerTask<Void, Void>(pluginName, "Updating " + pluginName + " channel panel plugin..."){

                @Override
                public Void doInBackground() {
                    try {
                        if (selectedChannels.size() > 0) {
                            plugin.prepareData(selectedChannels);
                        } else {
                            plugin.prepareData();
                        }
                    }
                    catch (ClientException e) {
                        ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), e);
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (selectedChannels.size() > 0) {
                        plugin.update(selectedChannels);
                    } else {
                        plugin.update();
                    }
                }
            };
            new QueuingSwingWorker<Void, Void>(task, true).executeDelegate();
        }
    }

    private synchronized void updateCurrentPluginPanel() {
        if (LoadedExtensions.getInstance().getChannelPanelPlugins().size() > 0) {
            this.loadPanelPlugin(this.tabPane.getTitleAt(this.tabPane.getSelectedIndex()));
        }
    }

    private synchronized void updateModel(TableState tableState) {
        int n;
        ArrayList<ChannelStatus> filteredChannelStatuses = new ArrayList<ChannelStatus>(this.channelStatuses.values());
        ArrayList<String> activeFilters = new ArrayList<String>();
        String filterText = this.tagField.getTags();
        if (StringUtils.isNotBlank((CharSequence)filterText)) {
            for (SearchFilter filter : SearchFilterParser.parse((String)filterText, this.getCachedChannelTags())) {
                activeFilters.add(filter.toDisplayString());
                filter.filterChannelStatuses(filteredChannelStatuses);
            }
        }
        int totalChannelCount = this.channelStatuses.size();
        int visibleChannelCount = filteredChannelStatuses.size();
        ArrayList<Channel> filteredChannels = new ArrayList<Channel>();
        HashSet<String> filteredChannelIds = new HashSet<String>();
        for (ChannelStatus channelStatus : filteredChannelStatuses) {
            filteredChannels.add(channelStatus.getChannel());
            filteredChannelIds.add(channelStatus.getChannel().getId());
        }
        ArrayList<ChannelGroupStatus> filteredGroupStatuses = new ArrayList<ChannelGroupStatus>();
        for (ChannelGroupStatus groupStatus : this.groupStatuses.values()) {
            filteredGroupStatuses.add(new ChannelGroupStatus(groupStatus));
        }
        int visibleGroupCount = n = filteredGroupStatuses.size();
        Iterator groupStatusIterator = filteredGroupStatuses.iterator();
        while (groupStatusIterator.hasNext()) {
            ChannelGroupStatus groupStatus = (ChannelGroupStatus)groupStatusIterator.next();
            Iterator<ChannelStatus> channelStatusIterator = groupStatus.getChannelStatuses().iterator();
            while (channelStatusIterator.hasNext()) {
                ChannelStatus channelStatus = channelStatusIterator.next();
                boolean found = false;
                for (ChannelStatus filteredChannelStatus : filteredChannelStatuses) {
                    if (!filteredChannelStatus.getChannel().getId().equals(channelStatus.getChannel().getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                channelStatusIterator.remove();
            }
            if (totalChannelCount == visibleChannelCount || !groupStatus.getChannelStatuses().isEmpty()) continue;
            groupStatusIterator.remove();
            --visibleGroupCount;
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        StringBuilder builder = new StringBuilder();
        if (model.isGroupModeEnabled()) {
            if (n == visibleGroupCount) {
                builder.append(n);
            } else {
                builder.append(visibleGroupCount).append(" of ").append(n);
            }
            builder.append(" Group");
            if (n != 1) {
                builder.append('s');
            }
            builder.append(", ");
        }
        if (totalChannelCount == visibleChannelCount) {
            builder.append(totalChannelCount);
        } else {
            builder.append(visibleChannelCount).append(" of ").append(totalChannelCount);
        }
        builder.append(" Channel");
        if (totalChannelCount != 1) {
            builder.append('s');
        }
        int totalEnabledChannels = 0;
        int visibleEnabledChannel = 0;
        for (Map.Entry<String, ChannelStatus> entry : this.channelStatuses.entrySet()) {
            if (!entry.getValue().getChannel().getExportData().getMetadata().isEnabled()) continue;
            if (filteredChannelIds.contains(entry.getKey())) {
                ++visibleEnabledChannel;
            }
            ++totalEnabledChannels;
        }
        builder.append(", ");
        if (totalEnabledChannels == visibleEnabledChannel) {
            builder.append(totalEnabledChannels);
        } else {
            builder.append(visibleEnabledChannel).append(" of ").append(totalEnabledChannels);
        }
        builder.append(" Enabled");
        if (this.tagField.isFilterEnabled()) {
            builder.append(" (");
            Iterator it = activeFilters.iterator();
            while (it.hasNext()) {
                builder.append((String)it.next());
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(')');
        }
        this.tagsLabel.setText(builder.toString());
        this.tagsLabel.setToolTipText(this.tagsLabel.getText());
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            plugin.tableUpdate(filteredChannels);
        }
        model.update(filteredGroupStatuses);
        this.restoreTableState(tableState);
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.channelTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                if (!this.channelTable.isRowSelected(row)) {
                    this.channelTable.setRowSelectionInterval(row, row);
                }
                if (((AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent())).isGroupNode()) {
                    this.groupPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.channelPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            } else {
                this.channelPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void channelListSelected(ListSelectionEvent evt) {
        this.updateTasks();
        int[] rows = this.channelTable.getSelectedModelRows();
        if (rows.length > 0) {
            for (TaskPlugin plugin : LoadedExtensions.getInstance().getTaskPlugins().values()) {
                plugin.onRowSelected(this.channelTable);
            }
            this.updateCurrentPluginPanel();
        }
    }

    public boolean isGroupSelected() {
        for (int row : this.channelTable.getSelectedModelRows()) {
            AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
            if (!node.isGroupNode()) continue;
            return true;
        }
        return false;
    }

    public boolean isChannelSelected() {
        for (int row : this.channelTable.getSelectedModelRows()) {
            AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
            if (node.isGroupNode()) continue;
            return true;
        }
        return false;
    }

    public List<Channel> getSelectedChannels() {
        ArrayList<Channel> selectedChannels = new ArrayList<Channel>();
        for (int row : this.channelTable.getSelectedModelRows()) {
            AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(row).getLastPathComponent());
            if (node.isGroupNode()) {
                Enumeration channelNodes = node.children();
                while (channelNodes.hasMoreElements()) {
                    selectedChannels.add(((AbstractChannelTableNode)((Object)channelNodes.nextElement())).getChannelStatus().getChannel());
                }
                continue;
            }
            selectedChannels.add(node.getChannelStatus().getChannel());
        }
        return selectedChannels;
    }

    private void deselectRows() {
        this.channelTable.clearSelection();
        this.updateTasks();
        for (TaskPlugin plugin : LoadedExtensions.getInstance().getTaskPlugins().values()) {
            plugin.onRowDeselected();
        }
        this.updateCurrentPluginPanel();
    }

    private boolean checkChannelId(String id) {
        for (ChannelStatus channelStatus : this.channelStatuses.values()) {
            if (!channelStatus.getChannel().getId().equalsIgnoreCase(id)) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.setOneTouchExpandable(true);
        this.topPanel = new JPanel();
        ArrayList<String> columns = new ArrayList<String>();
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            columns.add(plugin.getColumnHeader());
        }
        columns.addAll(Arrays.asList(DEFAULT_COLUMNS));
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            columns.add(plugin.getColumnHeader());
        }
        this.channelTable = new MirthTreeTable("channelPanel", new LinkedHashSet<String>(columns));
        this.channelTable.setColumnFactory(new ChannelTableColumnFactory());
        ChannelTreeTableModel model = new ChannelTreeTableModel();
        model.setColumnIdentifiers(columns);
        model.setNodeFactory(new DefaultChannelTableNodeFactory());
        this.channelTable.setTreeTableModel((TreeTableModel)model);
        this.channelTable.setDoubleBuffered(true);
        this.channelTable.setSelectionMode(2);
        this.channelTable.getTreeSelectionModel().setSelectionMode(4);
        this.channelTable.setHorizontalScrollEnabled(true);
        this.channelTable.packTable(10);
        this.channelTable.setRowHeight(20);
        this.channelTable.setOpaque(true);
        this.channelTable.setRowSelectionAllowed(true);
        this.channelTable.setSortable(true);
        this.channelTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.channelTable.setAutoCreateColumnsFromModel(false);
        this.channelTable.setShowGrid(true, true);
        this.channelTable.restoreColumnPreferences();
        this.channelTable.setMirthColumnControlEnabled(true);
        this.channelTable.setDragEnabled(true);
        this.channelTable.setDropMode(DropMode.ON);
        this.channelTable.setTransferHandler(new ChannelTableTransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && ChannelPanel.this.isSaveEnabled()) {
                    return false;
                }
                return super.canImport(support);
            }

            @Override
            public void importFile(final File file, final boolean showAlerts) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            block8: {
                                String fileString = StringUtils.trim((String)ChannelPanel.this.parent.readFileToString(file));
                                try {
                                    ChannelGroup group = (ChannelGroup)ObjectXMLSerializer.getInstance().deserialize(fileString, ChannelGroup.class);
                                    if (group != null && (!((ChannelTreeTableModel)ChannelPanel.this.channelTable.getTreeTableModel()).isGroupModeEnabled() || ChannelPanel.this.tagField.isFilterEnabled())) {
                                        return;
                                    }
                                }
                                catch (Exception group) {
                                    // empty catch block
                                }
                                if (showAlerts && !ChannelPanel.this.parent.promptObjectMigration(fileString, "channel or group")) {
                                    return;
                                }
                                try {
                                    ChannelPanel.this.importChannel((Channel)ObjectXMLSerializer.getInstance().deserialize(fileString, Channel.class), showAlerts);
                                }
                                catch (Exception e) {
                                    try {
                                        ChannelPanel.this.importGroup((ChannelGroup)ObjectXMLSerializer.getInstance().deserialize(fileString, ChannelGroup.class), showAlerts, !showAlerts);
                                    }
                                    catch (Exception e2) {
                                        if (!showAlerts) break block8;
                                        ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), (Throwable)e, "Invalid channel or group file:\n" + e.getMessage());
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean canMoveChannels(List<Channel> channels, int row) {
                AbstractChannelTableNode node;
                TreePath path;
                if (row >= 0 && (path = ChannelPanel.this.channelTable.getPathForRow(row)) != null && (node = (AbstractChannelTableNode)((Object)path.getLastPathComponent())).isGroupNode()) {
                    HashSet<String> currentChannelIds = new HashSet<String>();
                    Enumeration channelNodes = node.children();
                    while (channelNodes.hasMoreElements()) {
                        currentChannelIds.add(((AbstractChannelTableNode)((Object)channelNodes.nextElement())).getChannelStatus().getChannel().getId());
                    }
                    Iterator<Channel> it = channels.iterator();
                    while (it.hasNext()) {
                        if (!currentChannelIds.contains(it.next().getId())) continue;
                        it.remove();
                    }
                    return !channels.isEmpty();
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean moveChannels(List<Channel> channels, int row) {
                AbstractChannelTableNode node;
                TreePath path;
                if (row >= 0 && (path = ChannelPanel.this.channelTable.getPathForRow(row)) != null && (node = (AbstractChannelTableNode)((Object)path.getLastPathComponent())).isGroupNode()) {
                    HashSet<String> currentChannelIds = new HashSet<String>();
                    Enumeration channelNodes = node.children();
                    while (channelNodes.hasMoreElements()) {
                        currentChannelIds.add(((AbstractChannelTableNode)((Object)channelNodes.nextElement())).getChannelStatus().getChannel().getId());
                    }
                    Iterator<Channel> it = channels.iterator();
                    while (it.hasNext()) {
                        if (!currentChannelIds.contains(it.next().getId())) continue;
                        it.remove();
                    }
                    if (!channels.isEmpty()) {
                        ListSelectionListener[] listeners;
                        for (ListSelectionListener listener : listeners = ((DefaultListSelectionModel)ChannelPanel.this.channelTable.getSelectionModel()).getListSelectionListeners()) {
                            ChannelPanel.this.channelTable.getSelectionModel().removeListSelectionListener(listener);
                        }
                        try {
                            ChannelTreeTableModel model = (ChannelTreeTableModel)ChannelPanel.this.channelTable.getTreeTableModel();
                            HashSet<String> channelIds = new HashSet<String>();
                            for (Channel channel : channels) {
                                model.addChannelToGroup(node, channel.getId());
                                channelIds.add(channel.getId());
                            }
                            ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
                            Enumeration channelNodes2 = node.children();
                            while (channelNodes2.hasMoreElements()) {
                                AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)channelNodes2.nextElement());
                                if (!channelIds.contains(channelNode.getChannelStatus().getChannel().getId())) continue;
                                selectionPaths.add(new TreePath(new Object[]{model.getRoot(), node, channelNode}));
                            }
                            ChannelPanel.this.parent.setSaveEnabled(true);
                            ChannelPanel.this.channelTable.expandPath(new TreePath(new Object[]{ChannelPanel.this.channelTable.getTreeTableModel().getRoot(), node}));
                            ChannelPanel.this.channelTable.getTreeSelectionModel().setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            for (ListSelectionListener listener : listeners) {
                                ChannelPanel.this.channelTable.getSelectionModel().addListSelectionListener(listener);
                            }
                        }
                    }
                }
                return false;
            }
        });
        this.channelTable.setTreeCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                TreePath path = ChannelPanel.this.channelTable.getPathForRow(row);
                if (path != null && ((AbstractChannelTableNode)((Object)path.getLastPathComponent())).isGroupNode()) {
                    this.setIcon(UIConstants.ICON_GROUP);
                }
                return label;
            }
        });
        this.channelTable.setLeafIcon(UIConstants.ICON_CHANNEL);
        this.channelTable.setOpenIcon(UIConstants.ICON_GROUP);
        this.channelTable.setClosedIcon(UIConstants.ICON_GROUP);
        this.channelTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ChannelPanel.this.channelListSelected(evt);
            }
        });
        this.channelTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ChannelPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelPanel.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int row = ChannelPanel.this.channelTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (row == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2 && ChannelPanel.this.channelTable.getSelectedRowCount() == 1 && ChannelPanel.this.channelTable.getSelectedRow() == row) {
                    AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)ChannelPanel.this.channelTable.getPathForRow(row).getLastPathComponent());
                    if (node.isGroupNode()) {
                        ChannelPanel.this.doEditGroupDetails();
                    } else {
                        ChannelPanel.this.doEditChannel();
                    }
                }
            }
        });
        this.channelTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 127) {
                    if (ChannelPanel.this.channelTable.getSelectedModelRows().length == 0) {
                        return;
                    }
                    boolean allGroups = true;
                    boolean allChannels = true;
                    for (int row : ChannelPanel.this.channelTable.getSelectedModelRows()) {
                        AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)ChannelPanel.this.channelTable.getPathForRow(row).getLastPathComponent());
                        if (node.isGroupNode()) {
                            allChannels = false;
                            continue;
                        }
                        allGroups = false;
                    }
                    if (allChannels) {
                        ChannelPanel.this.doDeleteChannel();
                    } else if (allGroups) {
                        ChannelPanel.this.doDeleteGroup();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.channelTable.setHighlighters(new Highlighter[0]);
        if (this.userPreferences.getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.channelTable.addHighlighter(highlighter);
        }
        HighlightPredicate revisionDeltaHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (adapter.column == ChannelPanel.this.channelTable.convertColumnIndexToView(ChannelPanel.this.channelTable.getColumnExt(ChannelPanel.DEPLOYED_REVISION_DELTA_COLUMN_NAME).getModelIndex())) {
                    String channelId;
                    ChannelStatus status;
                    if (ChannelPanel.this.channelTable.getValueAt(adapter.row, adapter.column) != null && (Integer)ChannelPanel.this.channelTable.getValueAt(adapter.row, adapter.column) > 0) {
                        return true;
                    }
                    if (ChannelPanel.this.channelStatuses != null && (status = ChannelPanel.this.channelStatuses.get(channelId = (String)ChannelPanel.this.channelTable.getModel().getValueAt(ChannelPanel.this.channelTable.convertRowIndexToModel(adapter.row), 3))) != null && status.isCodeTemplatesChanged()) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.channelTable.addHighlighter((Highlighter)new ColorHighlighter(revisionDeltaHighlighterPredicate, new Color(255, 204, 0), Color.BLACK, new Color(255, 204, 0), Color.BLACK));
        HighlightPredicate lastDeployedHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (adapter.column == ChannelPanel.this.channelTable.convertColumnIndexToView(ChannelPanel.this.channelTable.getColumnExt(ChannelPanel.LAST_DEPLOYED_COLUMN_NAME).getModelIndex())) {
                    Calendar checkAfter = Calendar.getInstance();
                    checkAfter.add(12, -2);
                    if (ChannelPanel.this.channelTable.getValueAt(adapter.row, adapter.column) != null && ((Calendar)ChannelPanel.this.channelTable.getValueAt(adapter.row, adapter.column)).after(checkAfter)) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.channelTable.addHighlighter((Highlighter)new ColorHighlighter(lastDeployedHighlighterPredicate, new Color(240, 230, 140), Color.BLACK, new Color(240, 230, 140), Color.BLACK));
        this.channelScrollPane = new JScrollPane((Component)((Object)this.channelTable));
        this.channelScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.filterPanel = new JPanel();
        this.filterPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(164, 164, 164)));
        this.filterLabel = new JLabel("Filter:");
        HashSet<FilterCompletion> tags = new HashSet<FilterCompletion>();
        for (ChannelTag tag : this.getCachedChannelTags()) {
            tags.add(new TagFilterCompletion(tag));
        }
        this.tagField = new MirthTagField("Channels", false, tags);
        this.tagField.addUpdateSearchListener(new SearchFilterListener(){

            @Override
            public void doSearch(String filterString) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPanel.this.updateModel(ChannelPanel.this.getCurrentTableState());
                        ChannelPanel.this.updateTasks();
                    }
                });
            }

            @Override
            public void doDelete(String filterString) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPanel.this.updateModel(ChannelPanel.this.getCurrentTableState());
                        ChannelPanel.this.updateTasks();
                    }
                });
            }
        });
        this.tagsLabel = new JLabel();
        this.tagModeTextButton = new IconToggleButton(UIConstants.ICON_TEXT);
        this.tagModeTextButton.setToolTipText("Display tags as names.");
        this.tagModeTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelPanel.this.updateTagButtons(!ChannelPanel.this.tagTextModeSelected, true, true);
                ChannelPanel.this.channelTable.updateUI();
            }
        });
        this.tagModeIconButton = new IconToggleButton(UIConstants.ICON_TAG);
        this.tagModeIconButton.setToolTipText("Display tags as icons.");
        this.tagModeIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelPanel.this.updateTagButtons(!ChannelPanel.this.tagIconModeSelected, false, true);
                ChannelPanel.this.channelTable.updateUI();
            }
        });
        ButtonGroup tableModeButtonGroup = new ButtonGroup();
        this.tableModeGroupsButton = new IconToggleButton(UIConstants.ICON_GROUP);
        this.tableModeGroupsButton.setToolTipText("Groups");
        this.tableModeGroupsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!ChannelPanel.this.switchTableMode(true)) {
                    ChannelPanel.this.tableModeChannelsButton.setSelected(true);
                }
            }
        });
        tableModeButtonGroup.add(this.tableModeGroupsButton);
        this.tableModeChannelsButton = new IconToggleButton(UIConstants.ICON_CHANNEL);
        this.tableModeChannelsButton.setToolTipText("Channels");
        this.tableModeChannelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!ChannelPanel.this.switchTableMode(false)) {
                    ChannelPanel.this.tableModeGroupsButton.setSelected(true);
                }
            }
        });
        tableModeButtonGroup.add(this.tableModeChannelsButton);
        this.tabPane = new JTabbedPane();
        this.splitPane.setTopComponent(this.topPanel);
        this.splitPane.setBottomComponent(this.tabPane);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0"));
        this.topPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0"));
        this.topPanel.add((Component)this.channelScrollPane, "grow, push");
        this.filterPanel.setLayout((LayoutManager)new MigLayout("insets 0 12 3 12, novisualpadding, hidemode 3, fill", "[][][grow][]"));
        this.filterPanel.add(this.filterLabel);
        this.filterPanel.add((Component)this.tagField, "gapleft 4, w 195:500:500");
        this.filterPanel.add((Component)this.tagsLabel, "gapleft 4, gaptop 2, growx, pushx, w 100:200");
        this.filterPanel.add((Component)this.tagModeTextButton, "right, push, split 5, gapafter 0");
        this.filterPanel.add(this.tagModeIconButton);
        this.filterPanel.add((Component)new JSeparator(1), "right, h 18!, gapbefore 12, gapafter 12");
        this.filterPanel.add((Component)this.tableModeGroupsButton, "gapafter 0");
        this.filterPanel.add(this.tableModeChannelsButton);
        this.topPanel.add((Component)this.filterPanel, "newline, growx");
        this.add((Component)this.splitPane, "grow, push");
    }

    private boolean switchTableMode(boolean groupModeEnabled) {
        return this.switchTableMode(groupModeEnabled, true);
    }

    private boolean switchTableMode(boolean groupModeEnabled, boolean promptSave) {
        ChannelTreeTableModel model;
        if (!this.canViewChannelGroups) {
            groupModeEnabled = false;
        }
        if ((model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel()).isGroupModeEnabled() != groupModeEnabled) {
            if (promptSave && this.isSaveEnabled() && !this.promptSave(true)) {
                return false;
            }
            this.userPreferences.putBoolean("channelGroupViewEnabled", groupModeEnabled);
            ArrayList<JXTaskPane> taskPanes = new ArrayList<JXTaskPane>();
            taskPanes.add(this.channelTasks);
            if (groupModeEnabled) {
                this.tableModeChannelsButton.setContentFilled(false);
                taskPanes.add(this.groupTasks);
            } else {
                this.tableModeGroupsButton.setContentFilled(false);
            }
            for (TaskPlugin plugin : LoadedExtensions.getInstance().getTaskPlugins().values()) {
                JXTaskPane taskPane = plugin.getTaskPane();
                if (taskPane == null) continue;
                taskPanes.add(taskPane);
            }
            this.parent.setFocus(taskPanes.toArray(new JXTaskPane[taskPanes.size()]), true, true);
            TableState tableState = this.getCurrentTableState();
            model.setGroupModeEnabled(groupModeEnabled);
            this.updateModel(tableState);
            this.updateTasks();
        }
        return true;
    }

    private TableState getCurrentTableState() {
        MutableTreeTableNode root;
        ArrayList<String> selectedIds = new ArrayList<String>();
        ArrayList<String> expandedGroupIds = null;
        int[] selectedRows = this.channelTable.getSelectedModelRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            AbstractChannelTableNode node = (AbstractChannelTableNode)((Object)this.channelTable.getPathForRow(selectedRows[i]).getLastPathComponent());
            if (node.isGroupNode()) {
                selectedIds.add(node.getGroupStatus().getGroup().getId());
                continue;
            }
            selectedIds.add(node.getChannelStatus().getChannel().getId());
        }
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        if (model.isGroupModeEnabled() && (root = (MutableTreeTableNode)model.getRoot()) != null && root.getChildCount() > 0) {
            expandedGroupIds = new ArrayList<String>();
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                if (!this.channelTable.isExpanded(new TreePath(new Object[]{root, groupNode})) && groupNode.getChildCount() != 0) continue;
                expandedGroupIds.add(groupNode.getGroupStatus().getGroup().getId());
            }
        }
        return new TableState(selectedIds, expandedGroupIds);
    }

    private void restoreTableState(TableState tableState) {
        ChannelTreeTableModel model = (ChannelTreeTableModel)this.channelTable.getTreeTableModel();
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (model.isGroupModeEnabled()) {
            if (tableState.getExpandedGroupIds() != null && root != null) {
                this.channelTable.collapseAll();
                Enumeration groupNodes = root.children();
                while (groupNodes.hasMoreElements()) {
                    AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                    if (!tableState.getExpandedGroupIds().contains(groupNode.getGroupStatus().getGroup().getId())) continue;
                    this.channelTable.expandPath(new TreePath(new Object[]{root, groupNode}));
                }
            } else {
                this.channelTable.expandAll();
            }
        }
        final ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            AbstractChannelTableNode child = (AbstractChannelTableNode)((Object)children.nextElement());
            if (child.isGroupNode() && tableState.getSelectedIds().contains(child.getGroupStatus().getGroup().getId()) || !child.isGroupNode() && tableState.getSelectedIds().contains(child.getChannelStatus().getChannel().getId())) {
                TreePath path = new TreePath(new Object[]{root, child});
                selectionPaths.add(path);
            }
            if (!model.isGroupModeEnabled()) continue;
            Enumeration channelNodes = child.children();
            while (channelNodes.hasMoreElements()) {
                AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)channelNodes.nextElement());
                if (!tableState.getSelectedIds().contains(channelNode.getChannelStatus().getChannel().getId())) continue;
                TreePath path = new TreePath(new Object[]{root, child, channelNode});
                selectionPaths.add(path);
            }
        }
        if (CollectionUtils.isNotEmpty(selectionPaths)) {
            this.channelTable.getTreeSelectionModel().addSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelPanel.this.channelTable.getTreeSelectionModel().addSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
            }
        });
    }

    private class TableState {
        private List<String> selectedIds = new ArrayList<String>();
        private List<String> expandedGroupIds = new ArrayList<String>();

        public TableState(List<String> selectedIds, List<String> expandedGroupIds) {
            this.selectedIds = selectedIds;
            this.expandedGroupIds = expandedGroupIds;
        }

        public List<String> getSelectedIds() {
            return this.selectedIds;
        }

        public List<String> getExpandedGroupIds() {
            return this.expandedGroupIds;
        }
    }

    public class UpdateSwingWorker
    extends SwingWorker<Boolean, Void> {
        private Set<ChannelGroup> channelGroups;
        private Set<String> removedChannelGroupIds;
        private boolean override;
        private String workingId;

        public UpdateSwingWorker(Set<ChannelGroup> channelGroups, Set<String> removedChannelGroupIds, boolean override) {
            this.channelGroups = channelGroups;
            this.removedChannelGroupIds = removedChannelGroupIds;
            this.override = override;
            this.workingId = ChannelPanel.this.parent.startWorking("Saving channel groups...");
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return ChannelPanel.this.updateGroups(this.channelGroups, this.removedChannelGroupIds, this.override);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            boolean tryAgain = false;
            try {
                Boolean result = (Boolean)this.get();
                if (result.booleanValue()) {
                    ChannelPanel.this.afterUpdate();
                } else if (!this.override) {
                    if (ChannelPanel.this.parent.alertOption((Component)((Object)ChannelPanel.this.parent), "One or more channel groups have been modified since you last refreshed.\nDo you want to overwrite the changes?")) {
                        tryAgain = true;
                    }
                } else {
                    ChannelPanel.this.parent.alertError((Component)((Object)ChannelPanel.this.parent), "Unable to save channel groups.");
                }
            }
            catch (Exception e) {
                Throwable cause = e;
                if (cause instanceof ExecutionException) {
                    cause = e.getCause();
                }
                ChannelPanel.this.parent.alertThrowable((Component)((Object)ChannelPanel.this.parent), cause, "Unable to save channel groups: " + cause.getMessage());
            }
            finally {
                ChannelPanel.this.parent.stopWorking(this.workingId);
                if (tryAgain && !this.override) {
                    new UpdateSwingWorker(this.channelGroups, this.removedChannelGroupIds, true).execute();
                }
            }
        }
    }

    private class GroupDetailsDialog
    extends MirthDialog {
        private boolean saved;
        private boolean newGroup;
        private JPanel containerPanel;
        private JLabel groupNameLabel;
        private JTextField groupNameField;
        private JLabel groupDescriptionLabel;
        private MirthRTextScrollPane groupDescriptionScrollPane;
        private JSeparator separator;
        private JButton okButton;
        private JButton cancelButton;

        public GroupDetailsDialog(boolean newGroup) {
            super((Window)((Object)ChannelPanel.this.parent), true);
            this.saved = false;
            this.newGroup = newGroup;
            this.initComponents();
            this.initLayout();
            if (newGroup) {
                String name;
                int index = 1;
                while (!ChannelPanel.this.checkGroupName(name = "Group " + index++)) {
                }
                this.groupNameField.setText(name);
                this.groupNameField.requestFocus();
                this.groupNameField.selectAll();
            } else {
                AbstractChannelTableNode selectedNode = (AbstractChannelTableNode)((Object)ChannelPanel.this.channelTable.getPathForRow(ChannelPanel.this.channelTable.getSelectedRow()).getLastPathComponent());
                this.groupNameField.setText(selectedNode.getGroupStatus().getGroup().getName());
                this.groupDescriptionScrollPane.setText(selectedNode.getGroupStatus().getGroup().getDescription());
                this.groupNameField.requestFocus();
                this.groupNameField.setCaretPosition(this.groupNameField.getDocument().getLength());
            }
            this.setPreferredSize(new Dimension(600, 375));
            this.setDefaultCloseOperation(2);
            this.setTitle("Channel Group Details");
            this.pack();
            this.setLocationRelativeTo((Component)((Object)ChannelPanel.this.parent));
            this.setVisible(true);
        }

        public boolean wasSaved() {
            return this.saved;
        }

        public String getGroupName() {
            return this.groupNameField.getText();
        }

        public String getGroupDescription() {
            return this.groupDescriptionScrollPane.getText();
        }

        private void initComponents() {
            this.setBackground(UIConstants.BACKGROUND_COLOR);
            this.getContentPane().setBackground(this.getBackground());
            this.containerPanel = new JPanel();
            this.containerPanel.setBackground(this.getBackground());
            this.containerPanel.setBorder(BorderFactory.createTitledBorder("Group Settings"));
            this.groupNameLabel = new JLabel("Name:");
            this.groupNameField = new JTextField();
            this.groupDescriptionLabel = new JLabel("Description:");
            this.groupDescriptionScrollPane = new MirthRTextScrollPane(null, false, "text/plain", false);
            this.groupDescriptionScrollPane.setSaveEnabled(false);
            this.separator = new JSeparator(0);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = GroupDetailsDialog.this.groupNameField.getText();
                    if (StringUtils.isBlank((CharSequence)name)) {
                        GroupDetailsDialog.this.groupNameField.setBackground(UIConstants.INVALID_COLOR);
                        ChannelPanel.this.parent.alertError(GroupDetailsDialog.this, "Group name cannot be blank.");
                        return;
                    }
                    if (!ChannelPanel.this.checkGroupName(name, GroupDetailsDialog.this.newGroup)) {
                        GroupDetailsDialog.this.groupNameField.setBackground(UIConstants.INVALID_COLOR);
                        ChannelPanel.this.parent.alertError(GroupDetailsDialog.this, "Group name is already in use.");
                        return;
                    }
                    GroupDetailsDialog.this.saved = true;
                    GroupDetailsDialog.this.dispose();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupDetailsDialog.this.dispose();
                }
            });
        }

        private void initLayout() {
            this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
            this.containerPanel.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill, gap 12 6"));
            this.containerPanel.add((Component)this.groupNameLabel, "right");
            this.containerPanel.add((Component)this.groupNameField, "w 200!");
            this.containerPanel.add((Component)this.groupDescriptionLabel, "newline, top, right");
            this.containerPanel.add((Component)((Object)this.groupDescriptionScrollPane), "grow, push");
            this.add((Component)this.containerPanel, "grow, push");
            this.add((Component)this.separator, "newline, growx");
            this.add((Component)this.okButton, "newline, w 51!, right, split 2");
            this.add((Component)this.cancelButton, "w 51!");
        }
    }

    private class GroupAssignmentDialog
    extends MirthDialog {
        private boolean saved;
        private JComboBox<Pair<String, String>> groupComboBox;
        private JSeparator separator;
        private JButton okButton;
        private JButton cancelButton;

        public GroupAssignmentDialog() {
            super((Window)((Object)ChannelPanel.this.parent), true);
            this.saved = false;
            this.initComponents();
            this.initLayout();
            this.setPreferredSize(new Dimension(337, 118));
            this.setDefaultCloseOperation(2);
            this.setTitle("Channel Group Assignment");
            this.pack();
            this.setLocationRelativeTo((Component)((Object)ChannelPanel.this.parent));
            this.setVisible(true);
        }

        public boolean wasSaved() {
            return this.saved;
        }

        public String getSelectedGroupId() {
            return (String)((Pair)this.groupComboBox.getSelectedItem()).getLeft();
        }

        private void initComponents() {
            this.setBackground(UIConstants.BACKGROUND_COLOR);
            this.getContentPane().setBackground(this.getBackground());
            this.groupComboBox = new JComboBox();
            ArrayList<1> groups = new ArrayList<1>();
            Enumeration groupNodes = ((MutableTreeTableNode)ChannelPanel.this.channelTable.getTreeTableModel().getRoot()).children();
            while (groupNodes.hasMoreElements()) {
                ChannelGroup group = ((AbstractChannelTableNode)((Object)groupNodes.nextElement())).getGroupStatus().getGroup();
                groups.add(new MutablePair<String, String>(group.getId(), group.getName()){

                    public String toString() {
                        return (String)this.getRight();
                    }
                });
            }
            this.groupComboBox.setModel(new DefaultComboBoxModel<Pair>(groups.toArray(new Pair[groups.size()])));
            this.groupComboBox.setSelectedIndex(0);
            this.separator = new JSeparator(0);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupAssignmentDialog.this.saved = true;
                    GroupAssignmentDialog.this.dispose();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupAssignmentDialog.this.dispose();
                }
            });
        }

        private void initLayout() {
            this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
            this.add(new JLabel("Choose the group to assign the selected channel(s) to."));
            this.add(this.groupComboBox, "newline, growx");
            this.add((Component)this.separator, "newline, growx");
            this.add((Component)this.okButton, "newline, w 51!, right, split 2");
            this.add((Component)this.cancelButton, "w 51!");
        }
    }

    private static class DefaultChannelTableNodeFactory
    implements ChannelTableNodeFactory {
        private DefaultChannelTableNodeFactory() {
        }

        @Override
        public AbstractChannelTableNode createNode(ChannelGroupStatus groupStatus) {
            return new ChannelTableNode(groupStatus);
        }

        @Override
        public AbstractChannelTableNode createNode(ChannelStatus channelStatus) {
            return new ChannelTableNode(channelStatus);
        }
    }
}

