/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.ChannelPanel;
import com.mirth.connect.client.ui.DateCellRenderer;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.NumberCellRenderer;
import com.mirth.connect.plugins.ChannelColumnPlugin;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class ChannelTableColumnFactory
extends ColumnFactory {
    private int colOffset;
    private Map<Integer, ChannelColumnPlugin> plugins = new HashMap<Integer, ChannelColumnPlugin>();

    public ChannelTableColumnFactory() {
        int i = 0;
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            this.plugins.put(i++, plugin);
        }
        this.colOffset = i;
        i += ChannelPanel.getNumberOfDefaultColumns();
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.plugins.put(i++, plugin);
        }
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column = super.createAndConfigureTableColumn(model, modelIndex);
        int index = modelIndex - this.colOffset;
        switch (index) {
            case 0: {
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setCellRenderer((TableCellRenderer)new ImageCellRenderer());
                column.setToolTipText("<html><body>The status of this channel. Possible values are enabled and disabled.<br>Only enabled channels can be deployed.</body></html>");
                break;
            }
            case 1: {
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The inbound data type of this channel's source connector.</body></html>");
                break;
            }
            case 2: {
                column.setMinWidth(150);
                column.setToolTipText("<html><body>The name of this channel.</body></html>");
                break;
            }
            case 3: {
                column.setMinWidth(215);
                column.setMaxWidth(215);
                column.setToolTipText("<html><body>The unique id of this channel.</body></html>");
                break;
            }
            case 4: {
                column.setMinWidth(60);
                column.setMaxWidth(60);
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer(0, false));
                column.setToolTipText("<html><body>The local id of this channel used as part of the names for the message tables.</body></html>");
                break;
            }
            case 5: {
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The description of this channel.</body></html>");
                break;
            }
            case 6: {
                column.setMaxWidth(50);
                column.setMinWidth(50);
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer(0, false));
                column.setResizable(false);
                column.setToolTipText("<html><body>The number of times this channel was saved since it was deployed.<br>Rev \u0394 = Channel Revision - Deployed Revision<br>This value will be highlighted if it is greater than 0,<br/><b>or</b> if any code templates linked to this channel have changed.</body></html>");
                break;
            }
            case 7: {
                column.setMinWidth(95);
                column.setMaxWidth(95);
                column.setCellRenderer((TableCellRenderer)new DateCellRenderer());
                column.setResizable(false);
                column.setToolTipText("<html><body>The time this channel was last deployed.<br>This value will be highlighted if it is within the last two minutes.</body></html>");
                break;
            }
            case 8: {
                column.setMinWidth(95);
                column.setMaxWidth(95);
                column.setCellRenderer((TableCellRenderer)new DateCellRenderer());
                column.setResizable(false);
                column.setToolTipText("<html><body>The time this channel was last modified.</body></html>");
                break;
            }
            default: {
                ChannelColumnPlugin plugin = this.plugins.get(modelIndex);
                if (plugin == null) break;
                column.setCellRenderer(plugin.getCellRenderer());
                column.setMaxWidth(plugin.getMaxWidth());
                column.setMinWidth(plugin.getMinWidth());
            }
        }
        return column;
    }
}

