/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.MirthHeadingPanel;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.Channel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class ChannelWizard
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private final String DEFAULT_COMBOBOX_VALUE = "Select Channel Wizard";
    private JButton cancelButton;
    private JPanel channelOverview;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextPane descriptionTextPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private MirthHeadingPanel mirthHeadingPanel1;
    private JButton runWizardButton;
    private JButton skipWizardButton;
    private JComboBox wizardComboBox;
    private JLabel wizardLabel;

    public ChannelWizard() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.initComponents();
        if (LoadedExtensions.getInstance().getChannelWizardPlugins().size() == 0) {
            this.skipWizardButtonActionPerformed(null);
            return;
        }
        String[] loadedWizardPluginNames = new String[LoadedExtensions.getInstance().getChannelWizardPlugins().size() + 1];
        loadedWizardPluginNames[0] = "Select Channel Wizard";
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(LoadedExtensions.getInstance().getChannelWizardPlugins().keySet());
        int index = 1;
        Iterator iterator = sortedKeys.iterator();
        while (iterator.hasNext()) {
            String key;
            loadedWizardPluginNames[index] = key = (String)iterator.next();
            ++index;
        }
        this.wizardComboBox.setModel(new DefaultComboBoxModel<String>(loadedWizardPluginNames));
        this.wizardComboBoxActionPerformed(null);
        this.jLabel2.setText("New Channel");
        this.jLabel2.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.setModal(true);
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        DisplayUtil.setResizable(this, false);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        this.channelOverview = new JPanel();
        this.runWizardButton = new JButton();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mirthHeadingPanel1 = new MirthHeadingPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.wizardLabel = new JLabel();
        this.wizardComboBox = new JComboBox();
        this.descriptionLabel = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextPane = new JTextPane();
        this.skipWizardButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Channel");
        this.channelOverview.setBackground(new Color(255, 255, 255));
        this.channelOverview.setName("");
        this.runWizardButton.setText("Run Wizard");
        this.runWizardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWizard.this.runWizardButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWizard.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 18));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("New Channel");
        GroupLayout mirthHeadingPanel1Layout = new GroupLayout(this.mirthHeadingPanel1);
        this.mirthHeadingPanel1.setLayout(mirthHeadingPanel1Layout);
        mirthHeadingPanel1Layout.setHorizontalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 359, Short.MAX_VALUE).addContainerGap()));
        mirthHeadingPanel1Layout.setVerticalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, 29, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Select a channel wizard...");
        this.wizardLabel.setText("Wizard:");
        this.wizardComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWizard.this.wizardComboBoxActionPerformed(evt);
            }
        });
        this.descriptionLabel.setText("Description:");
        this.descriptionTextPane.setEditable(false);
        this.descriptionScrollPane.setViewportView(this.descriptionTextPane);
        this.skipWizardButton.setText("Skip Wizard");
        this.skipWizardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWizard.this.skipWizardButtonActionPerformed(evt);
            }
        });
        GroupLayout channelOverviewLayout = new GroupLayout(this.channelOverview);
        this.channelOverview.setLayout(channelOverviewLayout);
        channelOverviewLayout.setHorizontalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap().addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wizardLabel, GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wizardComboBox, 0, 288, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -1, 288, Short.MAX_VALUE)).addGap(20, 20, 20)).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(228, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 359, Short.MAX_VALUE).addContainerGap()).addComponent(this.mirthHeadingPanel1, -1, 379, Short.MAX_VALUE).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap(96, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runWizardButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skipWizardButton).addContainerGap()));
        channelOverviewLayout.linkSize(0, this.cancelButton, this.runWizardButton);
        channelOverviewLayout.setVerticalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel1, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wizardLabel).addComponent(this.wizardComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addComponent(this.descriptionScrollPane, -1, 122, Short.MAX_VALUE)).addGap(20, 20, 20).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.runWizardButton).addComponent(this.skipWizardButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void skipWizardButtonActionPerformed(ActionEvent evt) {
        this.parent.channelPanel.createNewChannel();
        this.dispose();
    }

    private void wizardComboBoxActionPerformed(ActionEvent evt) {
        String wizard = (String)this.wizardComboBox.getSelectedItem();
        if (wizard.equals("Select Channel Wizard")) {
            this.runWizardButton.setEnabled(false);
            this.descriptionTextPane.setText("Select a channel wizard or press \"Skip Wizard\" to continue...");
        } else {
            this.runWizardButton.setEnabled(true);
            this.descriptionTextPane.setText(this.parent.getPluginMetaData().get(this.wizardComboBox.getSelectedItem()).getDescription());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void runWizardButtonActionPerformed(ActionEvent evt) {
        final String wizard = (String)this.wizardComboBox.getSelectedItem();
        final String workingId = this.parent.startWorking("Running " + wizard + " wizard...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            Channel channel = null;

            @Override
            public Void doInBackground() {
                this.channel = LoadedExtensions.getInstance().getChannelWizardPlugins().get(wizard).runWizard();
                return null;
            }

            @Override
            public void done() {
                if (this.channel != null) {
                    ChannelWizard.this.parent.editChannel(this.channel);
                    ChannelWizard.this.parent.setSaveEnabled(true);
                }
                ChannelWizard.this.parent.stopWorking(workingId);
            }
        };
        worker.execute();
        this.dispose();
    }
}

