/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.ConnectorTypeData;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class ConnectorTypeCellRenderer
extends DefaultTableCellRenderer {
    private Set<Color> highlightColors = new HashSet<Color>();

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, int row, final int column) {
        ConnectorTypeDecoration connectorTypeDecoration;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ConnectorTypeData connectorTypeData = (ConnectorTypeData)value;
        this.setIcon(null);
        if (connectorTypeData != null && (connectorTypeDecoration = connectorTypeData.getDecoration()) != null) {
            this.setIcon(connectorTypeDecoration.getIcon());
            this.setToolTipText(connectorTypeDecoration.getIconToolTipText());
            final Color highlightColor = connectorTypeDecoration.getHighlightColor();
            if (highlightColor != null && !this.highlightColors.contains(highlightColor)) {
                HighlightPredicate highlighterPredicate = new HighlightPredicate(){

                    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                        ConnectorTypeData connectorTypeData;
                        return adapter.column == column && (connectorTypeData = (ConnectorTypeData)table.getValueAt(adapter.row, column)).getDecoration() != null && highlightColor.equals(connectorTypeData.getDecoration().getHighlightColor());
                    }
                };
                ((JXTable)table).addHighlighter((Highlighter)new ColorHighlighter(highlighterPredicate, highlightColor, Color.BLACK, highlightColor, Color.BLACK));
                this.highlightColors.add(highlightColor);
            }
        }
        return component;
    }
}

