/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractDashboardTableNode;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.DashboardPanel;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class DashboardTableNode
extends AbstractDashboardTableNode {
    private String channelId;
    private Object[] row;
    private ChannelGroupStatus groupStatus;
    private DashboardStatus dashboardStatus;
    private boolean showLifetimeStats = false;
    private Map<String, AbstractDashboardTableNode> channelNodes = new HashMap<String, AbstractDashboardTableNode>();

    public DashboardTableNode(ChannelGroupStatus groupStatus) {
        this.row = new Object[DashboardPanel.getNumberOfDefaultColumns() + LoadedExtensions.getInstance().getDashboardColumnPlugins().size()];
        this.setGroupStatus(groupStatus);
    }

    public DashboardTableNode(String channelId, DashboardStatus dashboardStatus) {
        this.channelId = channelId;
        this.row = new Object[DashboardPanel.getNumberOfDefaultColumns() + LoadedExtensions.getInstance().getDashboardColumnPlugins().size()];
        this.setSortable(false);
        this.setDashboardStatus(dashboardStatus);
    }

    @Override
    public boolean isGroupNode() {
        return this.groupStatus != null;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public ChannelGroupStatus getGroupStatus() {
        return this.groupStatus;
    }

    @Override
    public void setGroupStatus(ChannelGroupStatus groupStatus) {
        this.groupStatus = groupStatus;
        int i = 0;
        for (DashboardColumnPlugin dashboardColumnPlugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!dashboardColumnPlugin.isDisplayFirst()) continue;
            this.row[i++] = dashboardColumnPlugin.getTableData(groupStatus.getGroup());
        }
        int colOffset = i;
        this.row[i++] = new CellData(null, null);
        i += DashboardPanel.getNumberOfDefaultColumns() - 1;
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(groupStatus.getGroup());
        }
        List<DashboardStatus> list = this.getChildDashboardStatuses();
        this.updateGroupStatusRow(list, colOffset);
        this.row[colOffset + 1] = groupStatus.getGroup().getName();
        Long queued = 0L;
        for (DashboardStatus dashboardStatus : list) {
            queued = queued + dashboardStatus.getQueued();
        }
        this.row[colOffset + 6] = queued;
        this.setStatistics(list, colOffset);
    }

    private void updateGroupStatusRow(List<DashboardStatus> childDashboardStatuses, int colOffset) {
        DeployedState state = null;
        HashSet<DeployedState> states = new HashSet<DeployedState>();
        for (DashboardStatus dashboardStatus : childDashboardStatuses) {
            states.add(dashboardStatus.getState());
        }
        if (states.size() == 1) {
            state = (DeployedState)states.iterator().next();
        } else if (states.size() == 2) {
            if (states.contains(DeployedState.STARTED) && states.contains(DeployedState.STARTING)) {
                state = DeployedState.STARTING;
            } else if (states.contains(DeployedState.STOPPED) && states.contains(DeployedState.STOPPING)) {
                state = DeployedState.STOPPING;
            } else if (states.contains(DeployedState.PAUSED) && states.contains(DeployedState.PAUSING)) {
                state = DeployedState.PAUSING;
            }
        }
        if (state != null) {
            switch (state) {
                case DEPLOYING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Deploying");
                    break;
                }
                case UNDEPLOYING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Undeploying");
                    break;
                }
                case STARTING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Starting");
                    break;
                }
                case STARTED: {
                    boolean started = true;
                    for (DashboardStatus dashboardStatus : childDashboardStatuses) {
                        if (this.isStarted(dashboardStatus.getChildStatuses())) continue;
                        started = false;
                    }
                    if (started) {
                        this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_GREEN, "Started");
                        break;
                    }
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Started");
                    break;
                }
                case STOPPING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Stopping");
                    break;
                }
                case STOPPED: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_RED, "Stopped");
                    break;
                }
                case PAUSING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Pausing");
                    break;
                }
                case PAUSED: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_YELLOW, "Paused");
                    break;
                }
                case SYNCING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Syncing");
                    break;
                }
                case UNKNOWN: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_BLACK, "Unknown");
                }
            }
        } else {
            this.row[colOffset] = states.isEmpty() ? new CellData(UIConstants.ICON_BULLET_BLACK, "N/A") : new CellData(UIConstants.ICON_BULLET_ORANGE, "Mixed");
        }
    }

    @Override
    public DashboardStatus getDashboardStatus() {
        return this.dashboardStatus;
    }

    @Override
    public void setDashboardStatus(DashboardStatus status) {
        if (!status.getChannelId().equals(this.channelId)) {
            throw new RuntimeException("Supplied status is for the wrong channel, this node is associated with channel ID " + this.channelId);
        }
        this.dashboardStatus = status;
        int i = 0;
        for (DashboardColumnPlugin dashboardColumnPlugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!dashboardColumnPlugin.isDisplayFirst()) continue;
            this.row[i++] = dashboardColumnPlugin.getTableData(this.channelId, status.getMetaDataId());
        }
        int colOffset = i;
        this.row[i++] = new CellData(null, null);
        i += DashboardPanel.getNumberOfDefaultColumns() - 1;
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(this.channelId, status.getMetaDataId());
        }
        DeployedState deployedState = status.getState();
        if (deployedState != null) {
            switch (deployedState) {
                case DEPLOYING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Deploying");
                    break;
                }
                case UNDEPLOYING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Undeploying");
                    break;
                }
                case STARTING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Starting");
                    break;
                }
                case STARTED: {
                    if (this.isStarted(status.getChildStatuses())) {
                        this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_GREEN, "Started");
                        break;
                    }
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Started");
                    break;
                }
                case STOPPING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Stopping");
                    break;
                }
                case STOPPED: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_RED, "Stopped");
                    break;
                }
                case PAUSING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Pausing");
                    break;
                }
                case PAUSED: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_YELLOW, "Paused");
                    break;
                }
                case SYNCING: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_ORANGE, "Syncing");
                    break;
                }
                case UNKNOWN: {
                    this.row[colOffset] = new CellData(UIConstants.ICON_BULLET_BLACK, "Unknown");
                }
            }
        }
        this.row[colOffset + 1] = status.getName();
        this.row[colOffset + 2] = status.getDeployedRevisionDelta();
        this.row[colOffset + 3] = status.getDeployedDate();
        this.row[colOffset + 6] = status.getQueued();
        this.setStatistics(Collections.singletonList(this.dashboardStatus), colOffset);
    }

    private void setStatistics(List<DashboardStatus> dashboardStatuses, int colOffset) {
        HashMap<Status, Long> statistics = new HashMap<Status, Long>();
        statistics.put(Status.RECEIVED, 0L);
        statistics.put(Status.FILTERED, 0L);
        statistics.put(Status.SENT, 0L);
        statistics.put(Status.ERROR, 0L);
        for (DashboardStatus dashboardStatus : dashboardStatuses) {
            Map dashboardStatusStatistics = this.showLifetimeStats ? dashboardStatus.getLifetimeStatistics() : dashboardStatus.getStatistics();
            statistics.put(Status.RECEIVED, (Long)statistics.get(Status.RECEIVED) + (dashboardStatusStatistics.get(Status.RECEIVED) == null ? 0L : (Long)dashboardStatusStatistics.get(Status.RECEIVED)));
            statistics.put(Status.FILTERED, (Long)statistics.get(Status.FILTERED) + (dashboardStatusStatistics.get(Status.FILTERED) == null ? 0L : (Long)dashboardStatusStatistics.get(Status.FILTERED)));
            statistics.put(Status.SENT, (Long)statistics.get(Status.SENT) + (dashboardStatusStatistics.get(Status.SENT) == null ? 0L : (Long)dashboardStatusStatistics.get(Status.SENT)));
            statistics.put(Status.ERROR, (Long)statistics.get(Status.ERROR) + (dashboardStatusStatistics.get(Status.ERROR) == null ? 0L : (Long)dashboardStatusStatistics.get(Status.ERROR)));
        }
        this.setStatistics(statistics, colOffset);
    }

    private void setStatistics(Map<Status, Long> statistics, int colOffset) {
        this.row[colOffset + 4] = statistics.get(Status.RECEIVED);
        this.row[colOffset + 5] = statistics.get(Status.FILTERED);
        this.row[colOffset + 7] = statistics.get(Status.SENT);
        this.row[colOffset + 8] = statistics.get(Status.ERROR);
    }

    public boolean isShowLifetimeStats() {
        return this.showLifetimeStats;
    }

    @Override
    public void setShowLifetimeStats(boolean showLifetimeStats) {
        this.showLifetimeStats = showLifetimeStats;
        int colOffset = this.getColumnOffset();
        if (this.isGroupNode()) {
            this.updateGroupStatistics(this.getChildDashboardStatuses(), colOffset);
        } else {
            this.setStatistics(Collections.singletonList(this.dashboardStatus), colOffset);
        }
    }

    private boolean isStarted(List<DashboardStatus> statuses) {
        for (DashboardStatus status : statuses) {
            DeployedState state = status.getState();
            if (state != null && state == DeployedState.STARTED && this.isStarted(status.getChildStatuses())) continue;
            return false;
        }
        return true;
    }

    public void insert(MutableTreeTableNode child, int index) {
        AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)child;
        this.channelNodes.put(channelNode.getChannelId(), channelNode);
        super.insert(child, index);
    }

    public void remove(int index) {
        AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)this.getChildAt(index);
        this.channelNodes.remove(channelNode.getChannelId());
        super.remove(index);
    }

    public void remove(MutableTreeTableNode node) {
        AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)node;
        this.channelNodes.remove(channelNode.getChannelId());
        super.remove(node);
    }

    @Override
    public AbstractDashboardTableNode getChannelNode(String channelId) {
        return this.channelNodes.get(channelId);
    }

    @Override
    public void updateGroupNode() {
        List<DashboardStatus> childDashboardStatuses = this.getChildDashboardStatuses();
        int colOffset = this.getColumnOffset();
        this.updateGroupStatusRow(childDashboardStatuses, colOffset);
        this.updateGroupStatistics(childDashboardStatuses, colOffset);
    }

    private void updateGroupStatistics(List<DashboardStatus> childDashboardStatuses, int colOffset) {
        Long queued = 0L;
        for (DashboardStatus dashboardStatus : childDashboardStatuses) {
            queued = queued + dashboardStatus.getQueued();
        }
        this.row[colOffset + 6] = queued;
        this.setStatistics(childDashboardStatuses, colOffset);
    }

    public int getColumnCount() {
        return this.row.length;
    }

    public Object getValueAt(int i) {
        return this.row[i];
    }

    public void setValueAt(int i, Object value) {
        this.row[i] = value;
    }

    public String toString() {
        if (this.isGroupNode()) {
            return this.groupStatus.getGroup().getName();
        }
        return this.dashboardStatus.getName();
    }

    private int getColumnOffset() {
        int i = 0;
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            ++i;
        }
        return i;
    }

    private List<DashboardStatus> getChildDashboardStatuses() {
        ArrayList<DashboardStatus> childDashboardStatuses = new ArrayList<DashboardStatus>();
        Enumeration channelNodes = this.children();
        while (channelNodes.hasMoreElements()) {
            childDashboardStatuses.add(((AbstractDashboardTableNode)((Object)channelNodes.nextElement())).getDashboardStatus());
        }
        return childDashboardStatuses;
    }
}

