/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.DataTypePropertiesContainer;
import com.mirth.connect.client.ui.DataTypePropertiesTableNode;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.TransformerType;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.datatype.DataTypePropertiesGroup;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class DataTypePropertiesTableModel
extends SortableTreeTableModel {
    private AbstractSortableTreeTableNode root = new AbstractSortableTreeTableNode(){

        public Object getValueAt(int column) {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }
    };

    public DataTypePropertiesTableModel() {
        this.setRoot((TreeTableNode)this.root);
    }

    public int getHierarchicalColumn() {
        return 0;
    }

    public Class<?> getColumnClass(int column) {
        return null;
    }

    public boolean isCellEditable(Object node, int column) {
        if (node instanceof DataTypePropertiesTableNode) {
            return ((DataTypePropertiesTableNode)((Object)node)).isEditable(column);
        }
        return false;
    }

    public void addProperties(boolean inbound, List<DataTypePropertiesContainer> propertiesContainers, DataTypeProperties defaultProperties) {
        if (propertiesContainers != null) {
            ArrayList<DataTypePropertiesGroup> serializationProperties = new ArrayList<DataTypePropertiesGroup>();
            ArrayList<DataTypePropertiesGroup> deserializationProperties = new ArrayList<DataTypePropertiesGroup>();
            ArrayList<DataTypePropertiesGroup> batchProperties = new ArrayList<DataTypePropertiesGroup>();
            ArrayList<DataTypePropertiesGroup> responseGenerationProperties = new ArrayList<DataTypePropertiesGroup>();
            ArrayList<DataTypePropertiesGroup> responseValidationProperties = new ArrayList<DataTypePropertiesGroup>();
            for (DataTypePropertiesContainer dataTypePropertiesContainer : propertiesContainers) {
                DataTypeProperties dataTypeProperties = dataTypePropertiesContainer.getProperties();
                if (dataTypeProperties.getSerializationProperties() != null) {
                    serializationProperties.add((DataTypePropertiesGroup)dataTypeProperties.getSerializationProperties());
                }
                if (dataTypeProperties.getDeserializationProperties() != null) {
                    deserializationProperties.add((DataTypePropertiesGroup)dataTypeProperties.getDeserializationProperties());
                }
                if (dataTypeProperties.getBatchProperties() != null && dataTypePropertiesContainer.getType() == TransformerType.SOURCE) {
                    batchProperties.add((DataTypePropertiesGroup)dataTypeProperties.getBatchProperties());
                }
                if (dataTypeProperties.getResponseGenerationProperties() != null && dataTypePropertiesContainer.getType() == TransformerType.SOURCE) {
                    responseGenerationProperties.add((DataTypePropertiesGroup)dataTypeProperties.getResponseGenerationProperties());
                }
                if (dataTypeProperties.getResponseValidationProperties() == null || dataTypePropertiesContainer.getType() != TransformerType.RESPONSE) continue;
                responseValidationProperties.add((DataTypePropertiesGroup)dataTypeProperties.getResponseValidationProperties());
            }
            if (inbound) {
                if (!serializationProperties.isEmpty()) {
                    this.createAndInsertNode("Serialization", "These properties are used to convert the inbound message to XML.", serializationProperties, (DataTypePropertiesGroup)defaultProperties.getSerializationProperties());
                }
            } else {
                if (!deserializationProperties.isEmpty()) {
                    this.createAndInsertNode("Deserialization", "These properties are used to convert the transformed XML message into the specified data type", deserializationProperties, (DataTypePropertiesGroup)defaultProperties.getDeserializationProperties());
                }
                if (!serializationProperties.isEmpty()) {
                    this.createAndInsertNode("Template Serialization", "These properties are used to convert the outbound message template to XML.", serializationProperties, (DataTypePropertiesGroup)defaultProperties.getSerializationProperties());
                }
            }
            if (!batchProperties.isEmpty() && inbound) {
                this.createAndInsertNode("Batch", "These properties are used when reading in batch files and have no effect unless Process Batch is enabled in the source connector.", batchProperties, (DataTypePropertiesGroup)defaultProperties.getBatchProperties());
            }
            if (!responseGenerationProperties.isEmpty() && inbound) {
                this.createAndInsertNode("Response Generation", "These properties are used when responses are automatically generated.", responseGenerationProperties, (DataTypePropertiesGroup)defaultProperties.getResponseGenerationProperties());
            }
            if (!responseValidationProperties.isEmpty() && inbound) {
                this.createAndInsertNode("Response Validation", "These properties are used to validate the response received by a destination connector and have no effect unless Validate Response is enabled in the destination connector.", responseValidationProperties, (DataTypePropertiesGroup)defaultProperties.getResponseValidationProperties());
            }
            if (this.root.getChildCount() == 0) {
                this.insertNodeInto((MutableTreeTableNode)new DataTypePropertiesTableNode(" This data type has no properties.", ""), (MutableTreeTableNode)this.root);
            }
        }
    }

    private void createAndInsertNode(String groupName, String groupDescription, List<DataTypePropertiesGroup> propertiesGroups, DataTypePropertiesGroup defaultPropertiesGroup) {
        DataTypePropertiesTableNode groupNode = new DataTypePropertiesTableNode(groupName, groupDescription);
        this.insertNodeInto((MutableTreeTableNode)groupNode, (MutableTreeTableNode)this.root);
        for (String key : propertiesGroups.get(0).getPropertyDescriptors().keySet()) {
            this.insertNodeInto((MutableTreeTableNode)new DataTypePropertiesTableNode(key, propertiesGroups, defaultPropertiesGroup), (MutableTreeTableNode)groupNode);
        }
    }

    public void clear() {
        int childCount = this.root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.removeNodeFromParent((MutableTreeTableNode)this.root.getChildAt(0));
        }
    }

    public void resetToDefault(TreeTableNode node) {
        if (node == null) {
            node = this.root;
        }
        if (node instanceof DataTypePropertiesTableNode) {
            DataTypePropertiesTableNode tableNode = (DataTypePropertiesTableNode)((Object)node);
            tableNode.resetToDefault();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.resetToDefault(node.getChildAt(i));
        }
    }

    public boolean isDefaultProperties(TreeTableNode node) {
        DataTypePropertiesTableNode tableNode;
        if (node == null) {
            node = this.root;
        }
        if (node instanceof DataTypePropertiesTableNode && !(tableNode = (DataTypePropertiesTableNode)((Object)node)).isDefaultProperty()) {
            return false;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (this.isDefaultProperties(node.getChildAt(i))) continue;
            return false;
        }
        return true;
    }
}

